/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util.system;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.AbstractApplication;
import de.oliver_matuschin.base.util.system.RegistryUtil;
import de.oliver_matuschin.system.Platform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class AutostartUtil {
    private static final String AUTOSTART_REGISTRY_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Run";
    private static final String MAC_SCRIPT_ENGINE = "AppleScriptEngine";
    private static final Logger logger = Logger.getLogger(AutostartUtil.class.getName());

    private AutostartUtil() {
    }

    public static boolean setAutostartEnabled(boolean bl) {
        boolean bl2 = AutostartUtil.isAutostartEnabled() == bl;
        for (int i = 0; i < 5 && AutostartUtil.isAutostartEnabled() != bl; ++i) {
            bl2 = AutostartUtil.setAutostartEnabledInternal(bl);
            try {
                Thread.sleep(100 * (i + 1));
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (!bl2) {
            logger.log(Level.FINE, "Failed to {0} application autostart!", bl ? "enable" : "disable");
        }
        return bl2;
    }

    private static boolean setAutostartEnabledInternal(boolean bl) {
        String string;
        File file;
        if (AbstractApplication.isDebug()) {
            return false;
        }
        if (bl) {
            AutostartUtil.setAutostartEnabledInternal(false);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        if ((file = AutostartUtil.getApplicationPath()) == null) {
            return false;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Failed to determine canonical path of application path!", iOException);
            return false;
        }
        boolean bl2 = AutostartUtil.isAutostartEnabled();
        logger.log(Level.FINE, "Autostart check result: " + bl2 + ", should be enabled: " + bl);
        switch (Starter.getApplication().getPlatform()) {
            case MACOS: {
                if (bl && !bl2) {
                    try {
                        logger.log(Level.FINE, "Adding AutoLaunchedApplicationDictionary key ({0}) ...", string);
                        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(MAC_SCRIPT_ENGINE);
                        String string2 = "on setLoginItem(applicationPath)\ntell application \"System Events\" to make login item at end with properties {path: applicationPath, hidden: false}\nend setLoginItem\n";
                        ScriptContext scriptContext = scriptEngine.getContext();
                        Bindings bindings = scriptContext.getBindings(100);
                        bindings.put("javax_script_function", (Object)"setLoginItem");
                        bindings.put("javax.script.argv", (Object)string);
                        String string3 = (String)scriptEngine.eval(string2);
                        logger.log(Level.FINE, "Result: {0}", string3);
                        break;
                    }
                    catch (ScriptException scriptException) {
                        logger.log(Level.WARNING, "Failed to write AutoLaunchedApplicationDictionary!", scriptException);
                        return false;
                    }
                }
                if (bl || !bl2) break;
                try {
                    logger.log(Level.FINE, "Deleting AutoLaunchedApplicationDictionary key ...");
                    ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                    ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(MAC_SCRIPT_ENGINE);
                    String string4 = "tell application \"System Events\" to delete login item \"" + Starter.getApplication().getApplicationName() + "\"";
                    String string5 = (String)scriptEngine.eval(string4);
                    logger.log(Level.FINE, "Result: {0}", string5);
                    break;
                }
                catch (ScriptException scriptException) {
                    logger.log(Level.WARNING, "Failed to delete AutoLaunchedApplicationDictionary key!", scriptException);
                    return false;
                }
            }
            case WINDOWS: {
                if (bl) {
                    if (bl2) {
                        AutostartUtil.setAutostartEnabled(false);
                    }
                    try {
                        logger.log(Level.FINE, "Adding registry key for autostart ...");
                        RegistryUtil.createKey(-2147483647, AUTOSTART_REGISTRY_KEY);
                        RegistryUtil.writeStringValue(-2147483647, AUTOSTART_REGISTRY_KEY, Starter.getApplication().getApplicationName(), string);
                        break;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        logger.log(Level.WARNING, "Failed to write registry key for autostart!", exception);
                        return false;
                    }
                }
                if (bl || !bl2) break;
                try {
                    logger.log(Level.FINE, "Deleting registry key for autostart ...");
                    RegistryUtil.deleteValue(-2147483647, AUTOSTART_REGISTRY_KEY, Starter.getApplication().getApplicationName());
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    logger.log(Level.WARNING, "Failed to delete registry key for autostart!", exception);
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static boolean isAutostartEnabled() {
        if (AbstractApplication.isDebug()) {
            return false;
        }
        logger.log(Level.FINE, "Checking whether autostart is already enabled...");
        switch (Starter.getApplication().getPlatform()) {
            case MACOS: {
                try {
                    ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                    ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(MAC_SCRIPT_ENGINE);
                    if (scriptEngine == null) {
                        logger.log(Level.FINE, "No AppleScript engine available!");
                        return false;
                    }
                    String string = "tell application \"System Events\" to get properties of login item \"" + Starter.getApplication().getApplicationName() + "\"";
                    String string2 = (String)scriptEngine.eval(string);
                    logger.log(Level.FINE, "Result: {0}", string2);
                    return string2.indexOf("\"" + Starter.getApplication().getApplicationName() + "\"") != -1 && string2.indexOf("'ppth'") != -1;
                }
                catch (ScriptException scriptException) {
                    logger.log(Level.WARNING, "Failed to read AutoLaunchedApplicationDictionary!", scriptException);
                    break;
                }
            }
            case WINDOWS: {
                try {
                    Map<String, String> map = RegistryUtil.valuesForPath(-2147483647, AUTOSTART_REGISTRY_KEY);
                    if (map != null && map.containsKey(Starter.getApplication().getApplicationName())) {
                        return true;
                    }
                }
                catch (IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    logger.log(Level.WARNING, "Failed to read registry key for autostart!", exception);
                }
                break;
            }
        }
        return false;
    }

    private static File getApplicationPath() {
        try {
            File file = null;
            if (Starter.getApplication().getPlatform() == Platform.WINDOWS && System.getProperty("launch4j.exedir") != null) {
                file = new File(System.getProperty("launch4j.exedir") + File.separator + Starter.getApplication().getApplicationName() + ".exe");
            } else if (Starter.getApplication().getPlatform() == Platform.MACOS && Starter.getApplication().getClass().getProtectionDomain().getCodeSource() != null) {
                File file2 = new File(Starter.getApplication().getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
                String string = file2.getCanonicalPath();
                int n = string.indexOf(File.separator + Starter.getApplication().getApplicationName() + ".app" + File.separator);
                if (n != -1) {
                    file = new File(string.substring(0, n + Starter.getApplication().getApplicationName().length() + 5));
                } else {
                    logger.log(Level.WARNING, "JAR path does not contain application name: {0}", string);
                }
            }
            if (file != null) {
                logger.log(Level.FINE, "Determined application path: {0}", file);
                if (!file.exists()) {
                    file = null;
                    logger.log(Level.FINE, "Discarding application path because the file does not exist.");
                }
            } else {
                logger.log(Level.WARNING, "Failed to determine application path. Either launch4j.exedir does not exist, or code source cannot be determined!");
            }
            return file;
        }
        catch (IOException | URISyntaxException exception) {
            logger.log(Level.WARNING, "Failed to determine application path!", exception);
            return null;
        }
    }
}

