/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util.net;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.AbstractApplication;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.system.Platform;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class NetworkHandler {
    private static final int CLIENT_VERSION = 1;
    private static String buildNumber = "-";

    public static String getLatestApplicationDownloadName() throws MalformedURLException, IOException, ParserConfigurationException {
        String[] stringArray = NetworkHandler.getApplicationDownloadInformation();
        if (stringArray != null && stringArray.length > 1) {
            return stringArray[1];
        }
        return null;
    }

    public static String getLatestApplicationVersionHistory() throws MalformedURLException, IOException, ParserConfigurationException {
        String[] stringArray = NetworkHandler.getApplicationDownloadInformation();
        if (stringArray != null && stringArray.length > 2) {
            return stringArray[2];
        }
        return null;
    }

    public static Double getLatestApplicationVersion() throws MalformedURLException, IOException, ParserConfigurationException {
        String[] stringArray = NetworkHandler.getApplicationDownloadInformation();
        if (stringArray != null && stringArray.length > 0) {
            return Double.valueOf(stringArray[0]);
        }
        return null;
    }

    public static String getAnonymousKey() {
        String string = null;
        try {
            string = Starter.getApplication().getGlobalPreferences().get("logKey", null);
            if (string == null) {
                string = UUID.randomUUID().toString();
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (string != null) {
                Starter.getApplication().getGlobalPreferences().put("logKey", string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result doServerLog(String string) throws MalformedURLException, IOException, ParserConfigurationException {
        UIManager uIManager = Starter.getApplication().getUIManager();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Starter.getApplication().getApplicationName()).append(";").append(String.valueOf(Starter.getApplication().getApplicationVersion())).append(";");
        if (Starter.getApplication().getApplicationVersionType() != AbstractApplication.VersionType.FINAL) {
            stringBuilder.append(Starter.getApplication().getApplicationVersionType().toString()).append(";");
        }
        stringBuilder.append(buildNumber).append(";").append(Starter.getApplication().getPreferences().getInt("applicationStartupCount", 0)).append(";").append(Starter.getApplication().getLocalizedString("language")).append(";").append(Starter.getApplication().getPlatform()).append(";").append(System.getProperty("os.version", "Unknown")).append(";").append(System.getProperty("java.version")).append(";").append(Toolkit.getDefaultToolkit().getScreenResolution()).append(";").append(uIManager.getDPIMultiplier()).append(";").append(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("request");
        element.setAttribute("action", "insert");
        element.setAttribute("language_id", Starter.getApplication().getID("language_id"));
        Element element2 = document.createElement("clientLogRecord");
        element2.setAttribute("type", "record");
        Element element3 = document.createElement("logtext");
        element3.setAttribute("type", "string");
        element3.appendChild(document.createTextNode(stringBuilder.toString()));
        Element element4 = document.createElement("client_id");
        element4.setAttribute("type", "string");
        element4.appendChild(document.createTextNode(NetworkHandler.getAnonymousKey()));
        Element element5 = document.createElement("client_version");
        element5.setAttribute("type", "integer");
        element5.appendChild(document.createTextNode("1"));
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        element.appendChild(element2);
        document.appendChild(element);
        URLConnection uRLConnection = NetworkHandler.openConnection();
        OutputStream outputStream = uRLConnection.getOutputStream();
        InputStream inputStream = null;
        try {
            DOMImplementation dOMImplementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0");
            DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
            LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
            LSOutput lSOutput = dOMImplementationLS.createLSOutput();
            lSOutput.setByteStream(outputStream);
            lSSerializer.write(document, lSOutput);
            outputStream.close();
            inputStream = uRLConnection.getInputStream();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document document2 = documentBuilder2.parse(inputStream);
            document2.getDocumentElement().normalize();
            NodeList nodeList = document2.getElementsByTagName("response");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                if (namedNodeMap.getNamedItem("resultCode") == null) continue;
                Result result = new Result(Integer.valueOf(namedNodeMap.getNamedItem("resultCode").getTextContent()), namedNodeMap.getNamedItem("resultDescription").getTextContent());
                return result;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return new Result(-1, "Unknown error occured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result pingServer() throws MalformedURLException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("request");
        element.setAttribute("action", "retrieve");
        element.setAttribute("language_id", Starter.getApplication().getID("language_id"));
        Element element2 = document.createElement("clientPingRecord");
        element2.setAttribute("type", "record");
        element.appendChild(element2);
        document.appendChild(element);
        URLConnection uRLConnection = NetworkHandler.openConnection();
        OutputStream outputStream = uRLConnection.getOutputStream();
        InputStream inputStream = null;
        try {
            DOMImplementation dOMImplementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0");
            DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
            LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
            LSOutput lSOutput = dOMImplementationLS.createLSOutput();
            lSOutput.setByteStream(outputStream);
            lSSerializer.write(document, lSOutput);
            outputStream.close();
            inputStream = uRLConnection.getInputStream();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document document2 = documentBuilder2.parse(inputStream);
            document2.getDocumentElement().normalize();
            NodeList nodeList = document2.getElementsByTagName("response");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                if (namedNodeMap.getNamedItem("resultCode") == null) continue;
                Result result = new Result(Integer.valueOf(namedNodeMap.getNamedItem("resultCode").getTextContent()), namedNodeMap.getNamedItem("resultDescription").getTextContent());
                return result;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return new Result(-1, "Unknown error occured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result postFeedback(int n, String string, String string2, String string3, String string4, boolean bl) throws IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("request");
        element.setAttribute("action", "insert");
        element.setAttribute("language_id", Starter.getApplication().getID("language_id"));
        Element element2 = document.createElement("articleCommentRecord");
        element2.setAttribute("type", "record");
        Element element3 = document.createElement("article_id");
        element3.setAttribute("type", "integer");
        element3.appendChild(document.createTextNode("" + n));
        Element element4 = document.createElement("guest_username");
        element4.setAttribute("type", "string");
        element4.appendChild(document.createTextNode(string));
        Element element5 = document.createElement("guest_email");
        element5.setAttribute("type", "string");
        element5.appendChild(document.createTextNode(string2));
        Element element6 = document.createElement("guest_webpage");
        element6.setAttribute("type", "string");
        element6.appendChild(document.createTextNode(string3));
        Element element7 = document.createElement("article_comment");
        element7.setAttribute("type", "string");
        element7.appendChild(document.createTextNode(string4));
        Element element8 = document.createElement("privacy_policy_accepted");
        element8.setAttribute("type", "boolean");
        element8.appendChild(document.createTextNode(String.valueOf(bl)));
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        element2.appendChild(element6);
        element2.appendChild(element7);
        element2.appendChild(element8);
        element.appendChild(element2);
        document.appendChild(element);
        URLConnection uRLConnection = NetworkHandler.openConnection();
        OutputStream outputStream = uRLConnection.getOutputStream();
        InputStream inputStream = null;
        try {
            DOMImplementation dOMImplementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0");
            DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
            LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
            LSOutput lSOutput = dOMImplementationLS.createLSOutput();
            lSOutput.setByteStream(outputStream);
            lSSerializer.write(document, lSOutput);
            outputStream.close();
            inputStream = uRLConnection.getInputStream();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document document2 = documentBuilder2.parse(inputStream);
            document2.getDocumentElement().normalize();
            NodeList nodeList = document2.getElementsByTagName("response");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                if (namedNodeMap.getNamedItem("resultCode") == null) continue;
                Result result = new Result(Integer.valueOf(namedNodeMap.getNamedItem("resultCode").getTextContent()), namedNodeMap.getNamedItem("resultDescription").getTextContent());
                return result;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return new Result(-1, "Unknown error occured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getApplicationDownloadInformation() throws MalformedURLException, IOException, ParserConfigurationException {
        NetworkHandler.doServerLog("Updatecheck");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("request");
        element.setAttribute("action", "retrieve");
        element.setAttribute("language_id", Starter.getApplication().getID("language_id"));
        Element element2 = document.createElement("downloadList");
        element2.setAttribute("type", "list");
        Element element3 = document.createElement("filterset");
        element3.setAttribute("type", "filterset");
        element3.setAttribute("operator", "and");
        Element element4 = document.createElement("filter");
        element4.setAttribute("type", "filter");
        element4.setAttribute("field", "language_id");
        element4.setAttribute("operator", "equals");
        element4.setAttribute("value", Starter.getApplication().getID("language_id"));
        element4.setAttribute("valuetype", "integer");
        element.appendChild(element2);
        element2.appendChild(element3);
        element3.appendChild(element4);
        document.appendChild(element);
        URLConnection uRLConnection = NetworkHandler.openConnection();
        OutputStream outputStream = uRLConnection.getOutputStream();
        InputStream inputStream = null;
        try {
            DOMImplementation dOMImplementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0");
            DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
            LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
            LSOutput lSOutput = dOMImplementationLS.createLSOutput();
            lSOutput.setByteStream(outputStream);
            lSSerializer.write(document, lSOutput);
            outputStream.close();
            inputStream = uRLConnection.getInputStream();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document document2 = documentBuilder2.parse(inputStream);
            document2.getDocumentElement().normalize();
            NodeList nodeList = document2.getElementsByTagName("version");
            NodeList nodeList2 = document2.getElementsByTagName("download_file_name");
            NodeList nodeList3 = document2.getElementsByTagName("version_history");
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = "";
            if (Starter.getApplication().getPlatform() == Platform.MACOS) {
                string = "mac";
            } else if (Starter.getApplication().getPlatform() == Platform.WINDOWS) {
                string = "win";
            } else if (Starter.getApplication().getPlatform() == Platform.LINUX) {
                string = "linux";
            }
            double d = 0.0;
            boolean bl = false;
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                if (nodeList2.item(i).getTextContent() == null || !nodeList2.item(i).getTextContent().toLowerCase().startsWith(Starter.getApplication().getApplicationName().replaceAll("\\s", "").toLowerCase()) || !nodeList2.item(i).getTextContent().contains("-" + string + ".") || !(Double.valueOf(nodeList.item(i).getTextContent()) > d)) continue;
                d = Double.valueOf(nodeList.item(i).getTextContent());
                arrayList.clear();
                arrayList.add(nodeList.item(i).getTextContent());
                arrayList.add(nodeList2.item(i).getTextContent());
                arrayList.add(nodeList3.item(i).getTextContent());
                bl = true;
            }
            if (bl) {
                String[] stringArray = arrayList.toArray(new String[0]);
                return stringArray;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return null;
    }

    private static URLConnection openConnection() throws MalformedURLException, IOException {
        URLConnection uRLConnection = new URL("https://server.oliver-matuschin.de").openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        return uRLConnection;
    }

    static {
        Properties properties = new Properties();
        try (InputStream inputStream = NetworkHandler.class.getResourceAsStream("/resources/build.number");){
            properties.load(inputStream);
            buildNumber = properties.getProperty("build.number");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static class Result {
        private int resultCode;
        private String resultDescription;

        public Result(int n, String string) {
            this.resultCode = n;
            this.resultDescription = string;
        }

        public int getResultCode() {
            return this.resultCode;
        }

        public String getResultDescription() {
            return this.resultDescription;
        }
    }
}

