/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.constant.AppConstants;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.panel.JImagePanel;
import de.oliver_matuschin.system.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;

public class UIUtil {
    private static final ImageIcon tab_left = ImageBuilder.buildFor("/resources/images/tabs/tab_left.png");
    private static final ImageIcon tab_background = ImageBuilder.buildFor("/resources/images/tabs/tab_background.png");
    private static final ImageIcon tab_right = ImageBuilder.buildFor("/resources/images/tabs/tab_right.png");
    private static final ImageIcon empty = ImageBuilder.buildFor("/resources/images/tabs/empty.png");

    public static JToolBar addToolBar(AbstractApplicationWindow<?> abstractApplicationWindow, Component ... componentArray) {
        JRootPane jRootPane = abstractApplicationWindow.getRootPane();
        jRootPane.putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            jToolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        } else {
            jToolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
            jToolBar.setBackground(Color.WHITE);
        }
        for (Component component : componentArray) {
            if (component == null) {
                jToolBar.addSeparator();
                continue;
            }
            if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                UIUtil.setToolBarButtonProperties(jButton);
                jToolBar.add(jButton);
                continue;
            }
            jToolBar.add(component);
        }
        abstractApplicationWindow.enableMouseDragging(jToolBar);
        if (abstractApplicationWindow.getLayout() instanceof BorderLayout) {
            abstractApplicationWindow.add((Component)jToolBar, "North");
        } else {
            abstractApplicationWindow.add(jToolBar);
        }
        return jToolBar;
    }

    public static JToolBar addTabToolBar(AbstractApplicationWindow<?> abstractApplicationWindow, final JButton ... jButtonArray) {
        JRootPane jRootPane = abstractApplicationWindow.getRootPane();
        jRootPane.putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            jToolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        } else {
            jToolBar.setBackground(AppConstants.TABBAR_BACKGROUND_COLOR);
            jToolBar.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        }
        final HashMap<JButton, JLabel> hashMap = new HashMap<JButton, JLabel>();
        final HashMap<JButton, JImagePanel> hashMap2 = new HashMap<JButton, JImagePanel>();
        final HashMap<JButton, JLabel> hashMap3 = new HashMap<JButton, JLabel>();
        for (final JButton jButton : jButtonArray) {
            if (jButton == null) {
                jToolBar.addSeparator();
                continue;
            }
            JLabel jLabel = new JLabel();
            jLabel.setIcon(tab_left);
            JLabel jLabel2 = new JLabel();
            jLabel2.setIcon(tab_right);
            UIUtil.setTabToolBarButtonProperties(jButton);
            JImagePanel jImagePanel = new JImagePanel(tab_background, true);
            jImagePanel.setBorder(BorderFactory.createEmptyBorder());
            jImagePanel.setOpaque(false);
            jImagePanel.add(jButton);
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5), 0, jButton == jButtonArray[jButtonArray.length - 1] ? Starter.getApplication().getUIManager().getPixelsForDots(5) : 0));
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel.add((Component)jLabel, "West");
            jPanel.add((Component)jImagePanel, "Center");
            jPanel.add((Component)jLabel2, "East");
            jPanel.setMaximumSize(new Dimension(jButton.getMaximumSize().width + Starter.getApplication().getUIManager().getPixelsForDots(30), jPanel.getMaximumSize().height));
            jToolBar.add(jPanel);
            hashMap.put(jButton, jLabel);
            hashMap2.put(jButton, jImagePanel);
            hashMap3.put(jButton, jLabel2);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (JButton jButton2 : jButtonArray) {
                        if (jButton2 == null || jButton2 == jButton) continue;
                        ((JLabel)hashMap.get(jButton2)).setVisible(false);
                        ((JImagePanel)hashMap2.get(jButton2)).setImage(empty);
                        ((JLabel)hashMap3.get(jButton2)).setVisible(false);
                    }
                    ((JLabel)hashMap.get(jButton)).setVisible(true);
                    ((JImagePanel)hashMap2.get(jButton)).setImage(tab_background);
                    ((JLabel)hashMap3.get(jButton)).setVisible(true);
                }
            });
        }
        abstractApplicationWindow.enableMouseDragging(jToolBar);
        if (abstractApplicationWindow.getLayout() instanceof BorderLayout) {
            abstractApplicationWindow.add((Component)jToolBar, "North");
        } else {
            abstractApplicationWindow.add(jToolBar);
        }
        return jToolBar;
    }

    public static JToolBar createMiniToolbar(Component ... componentArray) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBackground(Color.WHITE);
        for (Component component : componentArray) {
            if (component == null) {
                jToolBar.addSeparator();
                continue;
            }
            if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                UIUtil.setMiniToolBarButtonProperties(jButton);
                jToolBar.add(jButton);
                continue;
            }
            jToolBar.add(component);
        }
        return jToolBar;
    }

    public static void makeComponentTransparent(Component component) {
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                UIUtil.makeComponentTransparent(component2);
            }
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
    }

    private static void setToolBarButtonProperties(JButton jButton) {
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.setIconTextGap(5);
        jButton.setOpaque(false);
        jButton.setFocusPainted(false);
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5)));
        jButton.setBorder(BorderFactory.createEmptyBorder(Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5)));
    }

    private static void setMiniToolBarButtonProperties(JButton jButton) {
        jButton.setOpaque(false);
        jButton.setFocusPainted(false);
        jButton.setFocusable(false);
        jButton.setContentAreaFilled(false);
        jButton.setBorder(BorderFactory.createEmptyBorder(Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5), Starter.getApplication().getUIManager().getPixelsForDots(5)));
    }

    private static void setTabToolBarButtonProperties(JButton jButton) {
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.setIconTextGap(5);
        jButton.setOpaque(false);
        jButton.setFocusPainted(false);
        jButton.setFocusable(false);
        jButton.setContentAreaFilled(false);
        jButton.setForeground(Color.BLACK);
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            jButton.setBorder(BorderFactory.createEmptyBorder());
        } else {
            jButton.setBorder(BorderFactory.createEmptyBorder(Starter.getApplication().getUIManager().getPixelsForDots(3), 0, 0, 0));
            jButton.setBorderPainted(false);
        }
    }
}

