/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util;

import de.oliver_matuschin.base.application.AbstractApplication;
import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.util.net.NetworkHandler;
import de.oliver_matuschin.base.util.ui.dialog.FeedbackFrame;
import de.oliver_matuschin.base.util.ui.dialog.UpdateInformationFrame;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JFrame;
import javax.xml.parsers.ParserConfigurationException;

public class ApplicationUtilities {
    private static final Lock updateCheckLock = new ReentrantLock();

    public static void sendFeedback(ApplicationContext<?> applicationContext, int n, boolean bl) {
        UIManager uIManager = applicationContext.getUIManager();
        FeedbackFrame feedbackFrame = uIManager.getLastRegisteredApplicationWindow(FeedbackFrame.class);
        if (feedbackFrame != null) {
            uIManager.showWindow(feedbackFrame);
        } else {
            feedbackFrame = new FeedbackFrame(applicationContext, n, bl);
            uIManager.registerApplicationWindow(feedbackFrame);
            uIManager.showWindow(feedbackFrame);
        }
    }

    public static void checkForUpdates(ApplicationContext<?> applicationContext, boolean bl, Runnable runnable) {
        ApplicationUtilities.checkForUpdates(applicationContext, null, bl, runnable);
    }

    public static void checkForUpdates(ApplicationContext<?> applicationContext, boolean bl) {
        ApplicationUtilities.checkForUpdates(applicationContext, null, bl, null);
    }

    public static void checkForUpdates(ApplicationContext<?> applicationContext, JFrame jFrame, boolean bl) {
        ApplicationUtilities.checkForUpdates(applicationContext, jFrame, bl, null);
    }

    public static void checkForUpdates(final ApplicationContext<?> applicationContext, final JFrame jFrame, final boolean bl, final Runnable runnable) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                applicationContext.getUIManager().disableMenuItem("menu.help.updateCheck");
            }
        });
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block16: {
                    try {
                        block15: {
                            if (!updateCheckLock.tryLock()) {
                                return;
                            }
                            try {
                                final Double d = NetworkHandler.getLatestApplicationVersion();
                                if (d != null && (d > ((AbstractApplication)applicationContext.getApplication()).getApplicationVersion() || ((AbstractApplication)applicationContext.getApplication()).getApplicationVersionType() != AbstractApplication.VersionType.FINAL && d.doubleValue() == ((AbstractApplication)applicationContext.getApplication()).getApplicationVersion())) {
                                    final String string = NetworkHandler.getLatestApplicationVersionHistory();
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            UIManager uIManager = applicationContext.getUIManager();
                                            UpdateInformationFrame<ApplicationContext> updateInformationFrame = uIManager.getLastRegisteredApplicationWindow(UpdateInformationFrame.class);
                                            if (updateInformationFrame != null) {
                                                uIManager.showWindow(updateInformationFrame);
                                            } else {
                                                updateInformationFrame = new UpdateInformationFrame<ApplicationContext>(applicationContext, "" + d, string);
                                                uIManager.registerApplicationWindow(updateInformationFrame);
                                                uIManager.showWindow(updateInformationFrame);
                                            }
                                            applicationContext.getUIManager().enableMenuItem("menu.help.updateCheck");
                                        }
                                    });
                                } else {
                                    if (d == null) {
                                        throw new IOException("Failed to retrieve newest version from server!");
                                    }
                                    if (bl) {
                                        EventQueue.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                JExtendedDialog jExtendedDialog = new JExtendedDialog(applicationContext.getLocalizationProvider().getLocalizedString("dialog.UpdateCheckDialog.title"), applicationContext.getLocalizationProvider().getLocalizedString("dialog.UpdateCheckDialog.message.noUpdatesFound", "" + ((AbstractApplication)applicationContext.getApplication()).getApplicationVersion()), 1);
                                                Object[] objectArray = new Object[]{applicationContext.getLocalizationProvider().getLocalizedString("common.button.ok")};
                                                jExtendedDialog.setOptions(objectArray);
                                                jExtendedDialog.setInitialValue(objectArray[0]);
                                                jExtendedDialog.showDialog(jFrame);
                                                applicationContext.getUIManager().enableMenuItem("menu.help.updateCheck");
                                            }
                                        });
                                    }
                                }
                                if (bl) break block15;
                            }
                            catch (IOException | ParserConfigurationException exception) {
                                block17: {
                                    try {
                                        EventQueue.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (bl) {
                                                    JExtendedDialog jExtendedDialog = new JExtendedDialog(applicationContext.getLocalizationProvider().getLocalizedString("dialog.UpdateCheckDialog.title"), applicationContext.getLocalizationProvider().getLocalizedString("dialog.UpdateCheckDialog.message.failure"), 0);
                                                    Object[] objectArray = new Object[]{applicationContext.getLocalizationProvider().getLocalizedString("common.button.ok")};
                                                    jExtendedDialog.setOptions(objectArray);
                                                    jExtendedDialog.setInitialValue(objectArray[0]);
                                                    jExtendedDialog.showDialog(jFrame);
                                                }
                                                applicationContext.getUIManager().enableMenuItem("menu.help.updateCheck");
                                            }
                                        });
                                        if (bl) break block17;
                                    }
                                    catch (Throwable throwable) {
                                        if (!bl) {
                                            EventQueue.invokeLater(new Runnable(this){
                                                final /* synthetic */ 2 this$0;
                                                {
                                                    this.this$0 = var1_1;
                                                }

                                                @Override
                                                public void run() {
                                                    this.this$0.applicationContext.getUIManager().enableMenuItem("menu.help.updateCheck");
                                                }
                                            });
                                        }
                                        updateCheckLock.unlock();
                                        throw throwable;
                                    }
                                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                }
                                updateCheckLock.unlock();
                                break block16;
                            }
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        updateCheckLock.unlock();
                    }
                    finally {
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                }
            }
        };
        Thread thread = new Thread(runnable2);
        thread.setDaemon(true);
        thread.setName("UpdateCheckThread");
        thread.start();
    }

    public static String getResourceAsString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ApplicationUtilities.class.getResourceAsStream(string), "UTF-8"));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(stringBuilder.length() > 0 ? System.lineSeparator() : "").append(string2);
            }
        }
        catch (IOException iOException) {
            return "Failed to load resource: " + iOException.toString();
        }
        return stringBuilder.toString();
    }
}

