/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.table;

import de.oliver_matuschin.base.ui.table.JExtendedTablePrintable;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.TableModel;

public class JExtendedTable
extends JTable {
    private final JLabel fontLabel = new JLabel();
    private Color background;
    private boolean dropEnabled = false;
    private Timer dropTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JExtendedTable.this.dropEnabled = false;
            JExtendedTable.this.dropTimer.stop();
        }
    });

    public JExtendedTable() {
        this.addListener();
    }

    public JExtendedTable(TableModel tableModel) {
        this(tableModel, (String)null, (Color)null);
    }

    public JExtendedTable(TableModel tableModel, String string, Color color) {
        super(tableModel);
        if (string != null) {
            this.setHint(string);
        }
        if (color != null) {
            this.setHintBackground(color);
        }
        this.addListener();
    }

    public void setHint(String string) {
        this.fontLabel.setText(string);
        this.fontLabel.setSize(this.fontLabel.getPreferredSize());
    }

    public void setHintBackground(Color color) {
        this.background = color;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (!this.dropEnabled) {
            return 10;
        }
        return super.getScrollableUnitIncrement(rectangle, n, n2);
    }

    @Override
    public Printable getPrintable(JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) {
        return new JExtendedTablePrintable(this, printMode, messageFormat, messageFormat2);
    }

    private void addListener() {
        this.addPropertyChangeListener("dropLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (JExtendedTable.this.dropTimer.isRunning()) {
                    JExtendedTable.this.dropTimer.restart();
                } else {
                    JExtendedTable.this.dropTimer.start();
                }
                JExtendedTable.this.dropEnabled = true;
            }
        });
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.fontLabel.getText().equals("") && this.getRowCount() == 0) {
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (this.background != null) {
                graphics.setColor(this.background);
            }
            graphics.fillRoundRect(this.getWidth() / 2 - this.fontLabel.getWidth() / 2 - 10, this.getHeight() / 2 - this.fontLabel.getHeight() / 2 - 10, this.fontLabel.getWidth() + 20, this.fontLabel.getHeight() + 20, 10, 10);
            graphics.setColor(Color.BLACK);
            this.drawCenteredString(graphics, this.fontLabel.getText(), new Rectangle(this.getWidth() / 2 - this.fontLabel.getWidth() / 2, this.getHeight() / 2 - this.fontLabel.getHeight() / 2, this.fontLabel.getWidth(), this.fontLabel.getHeight()), this.fontLabel.getFont());
            graphics.dispose();
        }
    }

    private void drawCenteredString(Graphics graphics, String string, Rectangle rectangle, Font font) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = (rectangle.width - fontMetrics.stringWidth(string)) / 2;
        int n2 = (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        graphics.setFont(font);
        graphics.drawString(string, n + rectangle.x, n2 + rectangle.y);
    }
}

