/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.splitpane;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JExtendedSplitPane
extends JSplitPane {
    private int dividerDragSize = 9;
    private Color dividerColor = UIManager.getColor("controlShadow");
    private int dividerDragOffset = 4;

    public JExtendedSplitPane() {
        this(1);
    }

    public JExtendedSplitPane(int n) {
        super(n);
        this.setContinuousLayout(true);
        this.setDividerSize(1);
    }

    public int getDividerDragSize() {
        return this.dividerDragSize;
    }

    public void setDividerDragSize(int n) {
        this.dividerDragSize = n;
        this.revalidate();
    }

    public int getDividerDragOffset() {
        return this.dividerDragOffset;
    }

    public void setDividerDragOffset(int n) {
        this.dividerDragOffset = n;
        this.revalidate();
    }

    public void setDividerColor(Color color) {
        this.dividerColor = color;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        Rectangle rectangle = basicSplitPaneDivider.getBounds();
        if (this.orientation == 1) {
            rectangle.x -= this.dividerDragOffset;
            rectangle.width = this.dividerDragSize;
        } else {
            rectangle.y -= this.dividerDragOffset;
            rectangle.height = this.dividerDragSize;
        }
        basicSplitPaneDivider.setBounds(rectangle);
    }

    @Override
    public void updateUI() {
        this.setUI(new SplitPaneWithZeroSizeDividerUI());
        this.revalidate();
    }

    private class ZeroSizeDivider
    extends BasicSplitPaneDivider {
        public ZeroSizeDivider(BasicSplitPaneUI basicSplitPaneUI) {
            super(basicSplitPaneUI);
            super.setBorder(null);
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(JExtendedSplitPane.this.dividerColor);
            if (this.orientation == 1) {
                graphics.drawLine(JExtendedSplitPane.this.dividerDragOffset, 0, JExtendedSplitPane.this.dividerDragOffset, this.getHeight());
            } else {
                graphics.drawLine(0, JExtendedSplitPane.this.dividerDragOffset, this.getWidth() - 1, JExtendedSplitPane.this.dividerDragOffset);
            }
        }

        @Override
        protected void dragDividerTo(int n) {
            super.dragDividerTo(n + JExtendedSplitPane.this.dividerDragOffset);
        }

        @Override
        protected void finishDraggingTo(int n) {
            super.finishDraggingTo(n + JExtendedSplitPane.this.dividerDragOffset);
        }
    }

    private class SplitPaneWithZeroSizeDividerUI
    extends BasicSplitPaneUI {
        private SplitPaneWithZeroSizeDividerUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new ZeroSizeDivider(this);
        }
    }
}

