/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.listener;

import de.oliver_matuschin.base.Starter;
import java.awt.Dimension;
import java.awt.PopupMenu;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public class MacOSAdapter
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(MacOSAdapter.class.getName());
    private static final String APPLICATION_CLASS = "com.apple.eawt.Application";
    private static JFrame dummyFrame = null;
    protected Object targetObject;
    protected Method targetMethod;
    protected String proxySignature;
    static Object macOSApplication;

    public static Object getMacOSApplication() {
        if (macOSApplication == null) {
            try {
                Class<?> clazz = Class.forName(APPLICATION_CLASS);
                Class[] classArray = new Class[]{};
                Method method = clazz.getMethod("getApplication", classArray);
                macOSApplication = method.invoke(clazz, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                logger.log(Level.SEVERE, "Failed to instantiate com.apple.eawt.Application!", exception);
            }
        }
        return macOSApplication;
    }

    public static void setQuitHandler(Object object, Method method) {
        MacOSAdapter.setApplicationHandler(new MacOSAdapter("handleQuit", object, method));
    }

    public static void setAboutHandler(Object object, Method method) {
        boolean bl;
        boolean bl2 = bl = object != null && method != null;
        if (bl) {
            MacOSAdapter.setApplicationHandler(new MacOSAdapter("handleAbout", object, method));
        }
        MacOSAdapter.setEnabledAboutMenu(bl);
    }

    public static void setEnabledAboutMenu(boolean bl) {
        try {
            Method method = MacOSAdapter.getMacOSApplication().getClass().getMethod("setEnabledAboutMenu", Boolean.TYPE);
            method.invoke(MacOSAdapter.getMacOSApplication(), bl);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "OSXAdapter could not access the About Menu", exception);
        }
    }

    public static void setPreferencesHandler(Object object, Method method) {
        boolean bl;
        boolean bl2 = bl = object != null && method != null;
        if (bl) {
            MacOSAdapter.setApplicationHandler(new MacOSAdapter("handlePreferences", object, method));
        }
        MacOSAdapter.setEnabledPreferencesMenu(bl);
    }

    public static void setEnabledPreferencesMenu(boolean bl) {
        try {
            Method method = MacOSAdapter.getMacOSApplication().getClass().getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            method.invoke(MacOSAdapter.getMacOSApplication(), bl);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "OSXAdapter could not access the About Menu", exception);
        }
    }

    public static void setSystemAboutToSleepListener(Object object, Method method) {
        MacOSAdapter.setAppEventHandler(new MacOSAdapter("systemAboutToSleep", object, method));
    }

    public static void setSystemAwokeListener(Object object, Method method) {
        MacOSAdapter.setAppEventHandler(new MacOSAdapter("systemAwoke", object, method));
    }

    public static void setScreenAboutToSleepListener(Object object, Method method) {
        MacOSAdapter.setAppEventHandler(new MacOSAdapter("screenAboutToSleep", object, method));
    }

    public static void setScreenAwokeListener(Object object, Method method) {
        MacOSAdapter.setAppEventHandler(new MacOSAdapter("screenAwoke", object, method));
    }

    public static void setUserSessionActivatedListener(Object object, Method method) {
        MacOSAdapter.setAppEventHandler(new MacOSAdapter("userSessionActivated", object, method));
    }

    public static void setUserSessionDeactivatedListener(Object object, Method method) {
        MacOSAdapter.setAppEventHandler(new MacOSAdapter("userSessionDeactivated", object, method));
    }

    public static void setAppReOpenedHandler(Object object, Method method) {
        MacOSAdapter.setAppEventHandler(new MacOSAdapter("appReOpened", object, method));
    }

    public static void setAppMovedToBackgroundHandler(Object object, Method method) {
        MacOSAdapter.setAppEventHandler(new MacOSAdapter("appMovedToBackground", object, method));
    }

    public static void setAppRaisedToForegroundHandler(Object object, Method method) {
        MacOSAdapter.setAppEventHandler(new MacOSAdapter("appRaisedToForeground", object, method));
    }

    public static void setFileHandler(Object object, Method method) {
        MacOSAdapter.setApplicationHandler(new MacOSAdapter("handleOpenFile", object, method){

            @Override
            public boolean callTarget(Object object) {
                if (object != null) {
                    try {
                        Method method = object.getClass().getMethod("getFilename", null);
                        String string = (String)method.invoke(object, (Object[])null);
                        this.targetMethod.invoke(this.targetObject, string);
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "Unable to get filename to open!", exception);
                    }
                }
                return true;
            }
        });
    }

    public static void setDefaultMenuBar(JMenuBar jMenuBar) {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Setting default menu bar...");
            }
            Class<?> clazz = Class.forName(APPLICATION_CLASS);
            Method method = clazz.getMethod("setDefaultMenuBar", JMenuBar.class);
            method.invoke(MacOSAdapter.getMacOSApplication(), jMenuBar);
            logger.log(Level.FINEST, "Default menu bar set");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.WARNING, "This operating system does not support the Apple EAWT. ApplicationEvent handling has been disabled (" + classNotFoundException + ")", classNotFoundException);
            MacOSAdapter.setDummyMenuBar(jMenuBar);
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "OS X adapter could not talk to EAWT!", exception);
            }
            MacOSAdapter.setDummyMenuBar(jMenuBar);
        }
    }

    public static void requestForeground() {
        block2: {
            try {
                Class<?> clazz = Class.forName(APPLICATION_CLASS);
                Method method = clazz.getMethod("requestForeground", Boolean.TYPE);
                method.invoke(MacOSAdapter.getMacOSApplication(), true);
                logger.log(Level.FINEST, "Foreground requested.");
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "OS X adapter could not talk to EAWT!", exception);
            }
        }
    }

    public static void setDockMenu(PopupMenu popupMenu) {
        block2: {
            try {
                Class<?> clazz = Class.forName(APPLICATION_CLASS);
                Method method = clazz.getMethod("setDockMenu", PopupMenu.class);
                method.invoke(MacOSAdapter.getMacOSApplication(), popupMenu);
                logger.log(Level.FINEST, "Dock menu set.");
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "OS X adapter could not talk to EAWT!", exception);
            }
        }
    }

    private static void setDummyMenuBar(JMenuBar jMenuBar) {
        if (dummyFrame == null) {
            dummyFrame = new JFrame();
            dummyFrame.setPreferredSize(new Dimension(0, 0));
            dummyFrame.setSize(new Dimension(0, 0));
            dummyFrame.setLocation(10000, 10000);
            dummyFrame.setDefaultCloseOperation(0);
            dummyFrame.setUndecorated(true);
            dummyFrame.setResizable(false);
            dummyFrame.setVisible(true);
            dummyFrame.setTitle(Starter.getApplication().getApplicationName());
        }
        dummyFrame.setJMenuBar(jMenuBar);
    }

    public static void setAppEventHandler(MacOSAdapter macOSAdapter) {
        try {
            Class<?> clazz = Class.forName(APPLICATION_CLASS);
            Class<?> clazz2 = Class.forName("com.apple.eawt.AppEventListener");
            Method method = clazz.getMethod("addAppEventListener", clazz2);
            Object object = Proxy.newProxyInstance(MacOSAdapter.class.getClassLoader(), new Class[]{Class.forName("com.apple.eawt.AppForegroundListener")}, (InvocationHandler)macOSAdapter);
            method.invoke(MacOSAdapter.getMacOSApplication(), object);
            object = Proxy.newProxyInstance(MacOSAdapter.class.getClassLoader(), new Class[]{Class.forName("com.apple.eawt.AppReOpenedListener")}, (InvocationHandler)macOSAdapter);
            method.invoke(MacOSAdapter.getMacOSApplication(), object);
            object = Proxy.newProxyInstance(MacOSAdapter.class.getClassLoader(), new Class[]{Class.forName("com.apple.eawt.ScreenSleepListener")}, (InvocationHandler)macOSAdapter);
            method.invoke(MacOSAdapter.getMacOSApplication(), object);
            object = Proxy.newProxyInstance(MacOSAdapter.class.getClassLoader(), new Class[]{Class.forName("com.apple.eawt.SystemSleepListener")}, (InvocationHandler)macOSAdapter);
            method.invoke(MacOSAdapter.getMacOSApplication(), object);
            object = Proxy.newProxyInstance(MacOSAdapter.class.getClassLoader(), new Class[]{Class.forName("com.apple.eawt.UserSessionListener")}, (InvocationHandler)macOSAdapter);
            method.invoke(MacOSAdapter.getMacOSApplication(), object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.WARNING, "This version of Mac OS X does not support the Apple EAWT. ApplicationEvent handling has been disabled (" + classNotFoundException + ")", classNotFoundException);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Mac OS X Adapter could not talk to EAWT:", exception);
        }
    }

    public static void setApplicationHandler(MacOSAdapter macOSAdapter) {
        try {
            Class<?> clazz = Class.forName(APPLICATION_CLASS);
            Class<?> clazz2 = Class.forName("com.apple.eawt.ApplicationListener");
            Method method = clazz.getMethod("addApplicationListener", clazz2);
            Object object = Proxy.newProxyInstance(MacOSAdapter.class.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)macOSAdapter);
            method.invoke(MacOSAdapter.getMacOSApplication(), object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.WARNING, "This version of Mac OS X does not support the Apple EAWT. ApplicationEvent handling has been disabled (" + classNotFoundException + ")", classNotFoundException);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Mac OS X Adapter could not talk to EAWT:", exception);
        }
    }

    protected MacOSAdapter(String string, Object object, Method method) {
        this.proxySignature = string;
        this.targetObject = object;
        this.targetMethod = method;
    }

    public boolean callTarget(Object object) throws InvocationTargetException, IllegalAccessException {
        Object object2 = this.targetMethod.invoke(this.targetObject, (Object[])null);
        if (object2 == null) {
            return true;
        }
        return Boolean.valueOf(object2.toString());
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.isCorrectMethod(method, objectArray)) {
            boolean bl = this.callTarget(objectArray[0]);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Invoked method of class " + method.getDeclaringClass().getName());
            }
            if (method.getDeclaringClass().getName().equals("com.apple.eawt.ApplicationListener")) {
                this.setApplicationEventHandled(objectArray[0], bl);
            }
        }
        return null;
    }

    protected boolean isCorrectMethod(Method method, Object[] objectArray) {
        return this.targetMethod != null && this.proxySignature.equals(method.getName()) && objectArray.length == 1;
    }

    protected void setApplicationEventHandled(Object object, boolean bl) {
        if (object != null) {
            try {
                Method method = object.getClass().getMethod("setHandled", Boolean.TYPE);
                method.invoke(object, bl);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "OSXAdapter was unable to handle an ApplicationEvent: " + object, exception);
            }
        }
    }
}

