/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.listener;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.AbstractApplication;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.menu.JWindowMenuCheckBoxMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;

public class DefaultMenuItemActionListener
implements ActionListener {
    private final Logger logger = Logger.getLogger(DefaultMenuItemActionListener.class.getName());

    public boolean handleAbout() {
        return this.handleEvent("menu.application.about");
    }

    public boolean handlePreferences() {
        return this.handleEvent("menu.application.preferences");
    }

    public boolean handleQuit() {
        return this.handleEvent("menu.application.quit");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem;
        AbstractApplicationWindow<?> abstractApplicationWindow;
        if (actionEvent.getSource() instanceof JWindowMenuCheckBoxMenuItem && (abstractApplicationWindow = ((JWindowMenuCheckBoxMenuItem)(jMenuItem = (JWindowMenuCheckBoxMenuItem)actionEvent.getSource())).getWindow()) != null) {
            Starter.getApplication().getUIManager().showWindow(abstractApplicationWindow);
            return;
        }
        jMenuItem = (JMenuItem)actionEvent.getSource();
        this.handleEvent(jMenuItem.getName());
    }

    private boolean handleEvent(String string) {
        AbstractApplication<?> abstractApplication = Starter.getApplication();
        UIManager uIManager = abstractApplication.getUIManager();
        String string2 = uIManager.getHandlerClassForMenuByID(string);
        String string3 = uIManager.getHandlerMethodForMenuByID(string);
        String string4 = uIManager.getDataForMenuByID(string);
        boolean bl = false;
        AbstractApplicationWindow<?> abstractApplicationWindow = this.determineWindowForHandlerClass(string2);
        boolean bl2 = false;
        if (abstractApplicationWindow != null) {
            if (string2 != null) {
                uIManager.showWindow(abstractApplicationWindow);
                if (string3 != null) {
                    try {
                        bl = this.invokeHandlerMethod(abstractApplicationWindow, string3, string, string4);
                        bl2 = true;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        this.logger.log(Level.SEVERE, "Failed to invoke method " + string3 + " on class " + abstractApplicationWindow.getClass().getCanonicalName() + "!", noSuchMethodException);
                    }
                }
            } else {
                Method[] methodArray;
                for (Method method : methodArray = abstractApplicationWindow.getClass().getMethods()) {
                    if (!method.getName().equals(string3) || method.getParameterCount() >= 3 || !this.allParametersAreStrings(method.getParameterTypes())) continue;
                    try {
                        bl = this.invokeHandlerMethod(abstractApplicationWindow, string3, string, string4);
                        bl2 = true;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        this.logger.log(Level.WARNING, "Method name " + string3 + " of class " + abstractApplicationWindow.getClass().getCanonicalName() + " looks like a matching action handler but isn't!");
                    }
                }
            }
        }
        if (!bl2 && string3 != null) {
            if (string2 == null) {
                try {
                    bl = this.invokeHandlerMethod(abstractApplication, string3, string, string4);
                    bl2 = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (!bl2) {
                try {
                    bl = this.invokeHandlerMethod(abstractApplication, "handleFallbackMenuAction", string, string4);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.logger.log(Level.WARNING, "Failed to invoke method " + string3 + " on application and no handleFallbackMenuAction is available!", noSuchMethodException);
                }
            }
        }
        return bl;
    }

    private AbstractApplicationWindow<?> determineWindowForHandlerClass(String string) {
        AbstractApplication<?> abstractApplication = Starter.getApplication();
        UIManager uIManager = abstractApplication.getUIManager();
        AbstractApplicationWindow<?> abstractApplicationWindow = uIManager.getFrontmostWindow();
        AbstractApplicationWindow<?> abstractApplicationWindow2 = null;
        try {
            abstractApplicationWindow2 = !(string == null || abstractApplicationWindow != null && Class.forName(string).isAssignableFrom(abstractApplicationWindow.getClass())) ? uIManager.getLastRegisteredApplicationWindow(Class.forName(string)) : abstractApplicationWindow;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(Level.FINE, "Failed to load class for name " + string + ".");
        }
        return abstractApplicationWindow2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean invokeHandlerMethod(Object object, String string, String string2, String string3) throws NoSuchMethodException {
        boolean bl = false;
        try {
            if (string != null) {
                void var9_18;
                Method[] methodArray;
                Method method = null;
                int n = 0;
                for (Method method2 : methodArray = object.getClass().getMethods()) {
                    Class<?>[] classArray;
                    if (!method2.getName().equals(string) || (classArray = method2.getParameterTypes()).length < n || classArray.length >= 3 || !this.allParametersAreStrings(classArray)) continue;
                    method = method2;
                    n = classArray.length;
                }
                if (method == null) {
                    throw new NoSuchMethodException("Method does not exist: " + string);
                }
                Object var9_14 = null;
                if (method.getParameterTypes().length == 2) {
                    Object object2 = method.invoke(object, string2, string3);
                } else if (method.getParameterTypes().length == 1) {
                    Object object3 = method.invoke(object, string2);
                } else {
                    Object object4 = method.invoke(object, new Object[0]);
                }
                if (var9_18 == null) {
                    bl = true;
                } else if (var9_18 instanceof Boolean) {
                    bl = (Boolean)var9_18;
                } else {
                    this.logger.log(Level.WARNING, "Return types of action handlers are expected to be of type void or boolean.");
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return bl;
    }

    private boolean allParametersAreStrings(Class<?>[] classArray) {
        for (Class<?> clazz : classArray) {
            if (clazz == String.class) continue;
            return false;
        }
        return true;
    }
}

