/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSeparator;

public class VerticalFlowLayout
implements LayoutManager {
    private int vgap;
    private boolean spanWidth;
    private List<Component> layoutComponents = new ArrayList<Component>();

    public VerticalFlowLayout() {
        this(0, true);
    }

    public VerticalFlowLayout(int n) {
        this(n, true);
    }

    public VerticalFlowLayout(boolean bl) {
        this(0, bl);
    }

    public VerticalFlowLayout(int n, boolean bl) {
        this.vgap = n < 0 ? 0 : n;
        this.spanWidth = bl;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.layoutComponents.add(component);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().width - insets.left - insets.right;
        int n2 = container.getComponentCount();
        if (n2 == 0) {
            return;
        }
        int n3 = insets.top;
        int n4 = insets.left;
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            if (this.spanWidth || component instanceof JSeparator || this.layoutComponents.contains(component)) {
                component.setBounds(n4, n3, n, dimension.height);
            } else {
                if (dimension.getWidth() > (double)n) {
                    component.setSize(n, (dimension.height + this.vgap) * (dimension.width / n));
                } else {
                    component.setSize(dimension.width, dimension.height);
                }
                component.setLocation(n4, n3);
            }
            n3 += dimension.height + this.vgap;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getMinimumSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom + this.vgap * n3);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom + this.vgap * n3);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.layoutComponents.remove(component);
    }
}

