/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.frame;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.AbstractApplication;
import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.frame.MenuContainer;
import de.oliver_matuschin.system.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class AbstractApplicationWindow<T extends ApplicationContext<?>>
extends JFrame
implements MenuContainer {
    private boolean isMacFullScreen = false;
    private boolean fullScreenEnabled = false;
    private boolean allowEscape = false;
    private T applicationContext;
    private Object fullScreenListenerProxy = null;

    public AbstractApplicationWindow(T t) {
        this.setDefaultCloseOperation(2);
        this.applicationContext = t;
        if (this.getApplication().getPlatform() == Platform.WINDOWS) {
            ArrayList<Image> arrayList = new ArrayList<Image>();
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_window_icon_win_128x128.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_window_icon_win_64x64.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_window_icon_win_32x32.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_window_icon_win_16x16.png")));
            this.setIconImages(arrayList);
        }
    }

    public T getApplicationContext() {
        return this.applicationContext;
    }

    public AbstractApplication<?> getApplication() {
        return this.applicationContext.getApplication();
    }

    public UIManager getUIManager() {
        return this.applicationContext.getUIManager();
    }

    public Platform getPlatform() {
        return this.applicationContext.getPlatform();
    }

    public Preferences getPreferences() {
        return ((AbstractApplication)this.applicationContext.getApplication()).getPreferences();
    }

    public String getLocalizedString(String string) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string);
    }

    public String getLocalizedString(String string, Object ... objectArray) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string, objectArray);
    }

    public void setAllowEscapeToCloseWindow(boolean bl) {
        this.setAllowEscapeToExecuteAction(bl, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractApplicationWindow.this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(AbstractApplicationWindow.this, 201));
            }
        });
    }

    public void setAllowEscapeToExecuteAction(boolean bl, Action action) {
        if (!bl) {
            if (this.allowEscape) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
                this.rootPane.getInputMap(2).put(keyStroke, null);
                this.rootPane.getActionMap().put("escape", null);
            }
        } else if (!this.allowEscape) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            InputMap inputMap = this.rootPane.getInputMap(2);
            inputMap.put(keyStroke, "escape");
            ActionMap actionMap = this.rootPane.getActionMap();
            actionMap.put("escape", action);
        }
        this.allowEscape = bl;
    }

    public void setWindowCanFullScreen(boolean bl) {
        if (this.getApplication().getPlatform() == Platform.MACOS) {
            if (!this.getApplication().isAgent() && bl && !this.fullScreenEnabled) {
                this.fullScreenEnabled = true;
                try {
                    Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
                    Class[] classArray = new Class[]{Window.class, Boolean.TYPE};
                    Method method = clazz.getMethod("setWindowCanFullScreen", classArray);
                    method.invoke(clazz, this, bl);
                    Class<?> clazz2 = Class.forName("com.apple.eawt.FullScreenListener");
                    this.fullScreenListenerProxy = Proxy.newProxyInstance(AbstractApplicationWindow.class.getClassLoader(), new Class[]{clazz2}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                            if (method.getName().equals("windowEnteredFullScreen")) {
                                AbstractApplicationWindow.this.getApplication().getUIManager().saveWindowState(AbstractApplicationWindow.this);
                            }
                            if (method.getName().equals("windowExitedFullScreen")) {
                                AbstractApplicationWindow.this.isMacFullScreen = false;
                                AbstractApplicationWindow.this.getApplication().getUIManager().saveWindowState(AbstractApplicationWindow.this);
                            }
                            if (method.getName().equals("windowEnteringFullScreen") && !AbstractApplicationWindow.this.isMacFullScreen) {
                                AbstractApplicationWindow.this.getApplication().getUIManager().saveWindowState(AbstractApplicationWindow.this);
                                AbstractApplicationWindow.this.isMacFullScreen = true;
                            }
                            return null;
                        }
                    });
                    Class<?> clazz3 = Class.forName("com.apple.eawt.FullScreenUtilities");
                    Method method2 = clazz3.getMethod("addFullScreenListenerTo", Window.class, clazz2);
                    method2.invoke(clazz3, this, this.fullScreenListenerProxy);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Exception exception) {}
            } else if (!bl && this.fullScreenEnabled) {
                this.fullScreenEnabled = false;
                try {
                    Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
                    Class[] classArray = new Class[]{Window.class, Boolean.TYPE};
                    Method method = clazz.getMethod("setWindowCanFullScreen", classArray);
                    method.invoke(clazz, this, bl);
                    Class<?> clazz4 = Class.forName("com.apple.eawt.FullScreenUtilities");
                    Class<?> clazz5 = Class.forName("com.apple.eawt.FullScreenListener");
                    Method method3 = clazz4.getMethod("removeFullScreenListenerFrom", Window.class, clazz5);
                    method3.invoke(clazz4, this, this.fullScreenListenerProxy);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Exception exception) {}
            }
        } else {
            this.fullScreenEnabled = bl;
        }
    }

    public boolean isWindowFullScreen() {
        if (this.getApplication().getPlatform() == Platform.MACOS) {
            return this.isMacFullScreen && this.fullScreenEnabled;
        }
        return this.getExtendedState() == 6;
    }

    public void toggleFullScreen() {
        if (this.fullScreenEnabled) {
            if (this.getApplication().getPlatform() == Platform.MACOS) {
                if (!this.getApplication().isAgent()) {
                    try {
                        Class<?> clazz = Class.forName("com.apple.eawt.Application");
                        Class[] classArray = new Class[]{};
                        Method method = clazz.getMethod("getApplication", classArray);
                        Object object = method.invoke(clazz, new Object[0]);
                        Method method2 = object.getClass().getMethod("requestToggleFullScreen", Window.class);
                        method2.invoke(object, this);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.setExtendedState(6);
            }
        }
    }

    public void enableMouseDragging(final Component component) {
        class Coordinates {
            private int x = 0;
            private int y = 0;

            Coordinates() {
            }

            public int getX() {
                return this.x;
            }

            public void setX(int n) {
                this.x = n;
            }

            public int getY() {
                return this.y;
            }

            public void setY(int n) {
                this.y = n;
            }
        }
        final Coordinates coordinates = new Coordinates();
        component.addMouseListener(new MouseAdapter(){
            {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = new Point(mouseEvent.getPoint());
                SwingUtilities.convertPointToScreen(point, component);
                coordinates.setX(point.x - AbstractApplicationWindow.this.getX());
                coordinates.setY(point.y - AbstractApplicationWindow.this.getY());
            }
        });
        component.addMouseMotionListener(new MouseMotionAdapter(){
            {
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = new Point(mouseEvent.getPoint());
                SwingUtilities.convertPointToScreen(point, component);
                AbstractApplicationWindow.this.setLocation(point.x - coordinates.getX(), point.y - coordinates.getY());
            }
        });
    }

    @Override
    public void dispose() {
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            ComponentPeer componentPeer = this.getPeer();
            super.dispose();
            if (componentPeer != null) {
                try {
                    Class<?> clazz = Class.forName("sun.lwawt.LWComponentPeer");
                    Field field = clazz.getDeclaredField("target");
                    field.setAccessible(true);
                    field.set(componentPeer, null);
                    Field field2 = componentPeer.getClass().getDeclaredField("platformWindow");
                    field2.setAccessible(true);
                    Object object = field2.get(componentPeer);
                    field = object.getClass().getDeclaredField("target");
                    field.setAccessible(true);
                    field.set(object, null);
                    Field field3 = clazz.getDeclaredField("platformComponent");
                    field3.setAccessible(true);
                    Object object2 = field3.get(componentPeer);
                    field = object2.getClass().getDeclaredField("platformWindow");
                    field.setAccessible(true);
                    field.set(object2, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            super.dispose();
        }
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(this.getApplication().getUIManager().getPixelsForDots(n), this.getApplication().getUIManager().getPixelsForDots(n2));
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(this.getApplication().getUIManager().getPixelsForDots(dimension));
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        super.setMinimumSize(this.getApplication().getUIManager().getPixelsForDots(dimension));
    }
}

