/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.dialog;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.system.Platform;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class JExtendedSaveDialog {
    private File file = null;
    private String title = null;
    private boolean isSheetEnabled = true;

    public JExtendedSaveDialog(String string) {
        this.title = string;
    }

    public boolean isSheetEnabled() {
        return this.isSheetEnabled;
    }

    public void setSheetEnabled(boolean bl) {
        this.isSheetEnabled = bl;
    }

    public File showSaveDialog(Component component) {
        return this.showSaveDialog(component, null);
    }

    public File showSaveDialog(Component component, String string) {
        return this.showSaveDialog(component, null, string);
    }

    public File showSaveDialog(Component component, JComponent jComponent, String string) {
        return this.showSaveDialog(component, jComponent, string, null);
    }

    public File showSaveDialog(Component component, JComponent jComponent, String string, String string2) {
        return this.showSaveDialog(component, jComponent, null, string, string2);
    }

    public File showSaveDialog(Component component, JComponent jComponent, String string, String string3, final String string4) {
        if (component != null && !(component instanceof Frame) && !(component instanceof Dialog)) {
            component = SwingUtilities.getWindowAncestor(component);
        }
        if (jComponent == null && component != null && (component instanceof Frame || component instanceof Dialog)) {
            FileDialog fileDialog = component instanceof Frame ? new FileDialog((Frame)component) : new FileDialog((Dialog)component);
            fileDialog.setMode(1);
            fileDialog.setDirectory(string3);
            if (string != null) {
                fileDialog.setFile(string);
            }
            fileDialog.setTitle(this.title);
            this.setDefaultDialogIcon(fileDialog);
            if (string4 != null) {
                if (Starter.getApplication().getPlatform() != Platform.MACOS && string == null) {
                    fileDialog.setFile("*" + string4);
                }
                fileDialog.setFilenameFilter((file, string2) -> string2 != null && string2.endsWith(string4));
            }
            fileDialog.setVisible(true);
            if (fileDialog.getFiles() != null && fileDialog.getFiles().length > 0) {
                this.file = fileDialog.getFiles()[0];
            }
        } else {
            boolean bl;
            do {
                int n;
                bl = false;
                JFileChooser jFileChooser = new JFileChooser(string3);
                jFileChooser.setDialogTitle(this.title);
                jFileChooser.setFileHidingEnabled(true);
                if (string != null) {
                    jFileChooser.setSelectedFile(new File(string));
                }
                if (string4 != null) {
                    jFileChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file != null && file.getName().endsWith(string4);
                        }

                        @Override
                        public String getDescription() {
                            return null;
                        }
                    });
                }
                if (jComponent != null) {
                    jFileChooser.setAccessory(jComponent);
                }
                if ((n = jFileChooser.showSaveDialog(component)) != 0) continue;
                this.file = jFileChooser.getSelectedFile();
                if (this.file == null || !this.file.exists()) continue;
                JExtendedDialog jExtendedDialog = new JExtendedDialog(Starter.getApplication().getLocalizedString("dialog.FileExistsDialog.title"), Starter.getApplication().getLocalizedString("dialog.FileExistsDialog.message"), 2);
                Object[] objectArray = new Object[]{Starter.getApplication().getLocalizedString("common.button.ok"), Starter.getApplication().getLocalizedString("common.button.cancel")};
                jExtendedDialog.setOptions(objectArray);
                jExtendedDialog.setInitialValue(objectArray[1]);
                Object object = jExtendedDialog.showDialog();
                if (object != null && object.equals(Starter.getApplication().getLocalizedString("common.button.ok"))) continue;
                bl = true;
            } while (bl);
        }
        return this.file;
    }

    private void setDefaultDialogIcon(FileDialog fileDialog) {
        if (Starter.getApplication().getPlatform() == Platform.WINDOWS) {
            ArrayList<Image> arrayList = new ArrayList<Image>();
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_128x128.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_64x64.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_32x32.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_16x16.png")));
            fileDialog.setIconImages(arrayList);
        }
    }
}

