/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.dialog;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.system.Platform;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class JExtendedOpenDialog {
    private File[] files = null;
    private String title = null;
    private int fileSelectionMode = 0;
    private boolean isSheetEnabled = true;

    public JExtendedOpenDialog(String string) {
        this.title = string;
    }

    public boolean isSheetEnabled() {
        return this.isSheetEnabled;
    }

    public void setSheetEnabled(boolean bl) {
        this.isSheetEnabled = bl;
    }

    public void setFileSelectionMode(int n) {
        this.fileSelectionMode = n;
    }

    public File[] showOpenDialog(Component component, boolean bl) {
        return this.showOpenDialog(component, null, bl);
    }

    public File showOpenDialog(Component component) {
        return this.showOpenDialog(component, null);
    }

    public File[] showOpenDialog(String string, boolean bl) {
        return this.showOpenDialog(null, string, bl);
    }

    public File showOpenDialog(String string) {
        return this.showOpenDialog(null, string);
    }

    public File[] showOpenDialog(Component component, String string, boolean bl) {
        return this.showOpenDialog(component, null, string, bl);
    }

    public File showOpenDialog(Component component, String string) {
        return this.showOpenDialog(component, null, string);
    }

    public File showOpenDialog(Component component, JComponent jComponent, String string) {
        File[] fileArray = this.showOpenDialog(component, jComponent, string, false);
        if (fileArray != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    public File[] showOpenDialog(Component component, JComponent jComponent, String string, boolean bl) {
        return this.showOpenDialog(component, jComponent, string, null, bl);
    }

    public File[] showOpenDialog(Component component, JComponent jComponent, String string, final String string3, boolean bl) {
        this.files = null;
        if (component != null && !(component instanceof Frame) && !(component instanceof Dialog)) {
            component = SwingUtilities.getWindowAncestor(component);
        }
        if (jComponent == null && (this.fileSelectionMode == 0 || this.fileSelectionMode == 1 && Starter.getApplication().getPlatform() == Platform.MACOS) && component != null && (component instanceof Frame || component instanceof Dialog)) {
            FileDialog fileDialog = component instanceof Frame ? new FileDialog((Frame)component) : new FileDialog((Dialog)component);
            fileDialog.setMode(0);
            fileDialog.setDirectory(string);
            fileDialog.setTitle(this.title);
            fileDialog.setMultipleMode(bl);
            this.setDefaultDialogIcon(fileDialog);
            if (string3 != null) {
                if (Starter.getApplication().getPlatform() != Platform.MACOS) {
                    fileDialog.setFile("*" + string3);
                }
                fileDialog.setFilenameFilter((file, string2) -> string2 != null && string2.endsWith(string3));
            }
            if (this.fileSelectionMode == 1) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
            }
            fileDialog.setVisible(true);
            this.files = fileDialog.getFiles();
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
        } else {
            int n;
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setDialogTitle(this.title);
            jFileChooser.setMultiSelectionEnabled(bl);
            jFileChooser.setFileSelectionMode(this.fileSelectionMode);
            jFileChooser.setFileHidingEnabled(true);
            if (string3 != null) {
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file != null && file.getName().endsWith(string3);
                    }

                    @Override
                    public String getDescription() {
                        return null;
                    }
                });
            }
            if (jComponent != null) {
                jFileChooser.setAccessory(jComponent);
            }
            if ((n = jFileChooser.showOpenDialog(component)) == 0) {
                this.files = jFileChooser.getSelectedFiles();
                if (this.files.length == 0) {
                    this.files = new File[]{jFileChooser.getSelectedFile()};
                }
            }
        }
        return this.files;
    }

    private void setDefaultDialogIcon(FileDialog fileDialog) {
        if (Starter.getApplication().getPlatform() == Platform.WINDOWS) {
            ArrayList<Image> arrayList = new ArrayList<Image>();
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_128x128.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_64x64.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_32x32.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_16x16.png")));
            fileDialog.setIconImages(arrayList);
        }
    }
}

