/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.dialog;

import de.oliver_matuschin.base.application.AbstractApplication;
import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.system.Platform;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class AbstractApplicationDialog<T extends ApplicationContext<?>>
extends JDialog {
    private boolean allowEscape = false;
    private T applicationContext;

    public AbstractApplicationDialog(T t, Window window, Dialog.ModalityType modalityType) {
        super(window, modalityType);
        this.applicationContext = t;
        if (this.getApplication().getPlatform() == Platform.WINDOWS) {
            ArrayList<Image> arrayList = new ArrayList<Image>();
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_128x128.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_64x64.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_32x32.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/default_dialog_icon_win_16x16.png")));
            this.setIconImages(arrayList);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public T getApplicationContext() {
        return this.applicationContext;
    }

    public AbstractApplication<?> getApplication() {
        return this.applicationContext.getApplication();
    }

    public UIManager getUIManager() {
        return this.applicationContext.getUIManager();
    }

    public Platform getPlatform() {
        return this.applicationContext.getPlatform();
    }

    public String getLocalizedString(String string) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string);
    }

    public String getLocalizedString(String string, Object ... objectArray) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string, objectArray);
    }

    public void setAllowEscapeToCloseDialog(boolean bl) {
        this.setAllowEscapeToExecuteAction(bl, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractApplicationDialog.this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(AbstractApplicationDialog.this, 201));
            }
        });
    }

    public void setAllowEscapeToExecuteAction(boolean bl, Action action) {
        if (!bl) {
            if (this.allowEscape) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
                this.rootPane.getInputMap(2).put(keyStroke, null);
                this.rootPane.getActionMap().put("escape", null);
            }
        } else if (!this.allowEscape) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            InputMap inputMap = this.rootPane.getInputMap(2);
            inputMap.put(keyStroke, "escape");
            ActionMap actionMap = this.rootPane.getActionMap();
            actionMap.put("escape", action);
        }
        this.allowEscape = bl;
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(this.getApplication().getUIManager().getPixelsForDots(n), this.getApplication().getUIManager().getPixelsForDots(n2));
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(this.getApplication().getUIManager().getPixelsForDots(dimension));
    }

    @Override
    public final void setMinimumSize(Dimension dimension) {
        super.setMinimumSize(dimension);
    }
}

