/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui.basic;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class MultiLineLabelUI
extends BasicLabelUI {
    private int vgap = 0;
    static final int LEADING = 10;
    static final int TRAILING = 11;
    static final int LEFT = 2;
    static final int RIGHT = 4;
    static final int TOP = 1;
    static final int CENTER = 0;
    protected String str;
    protected String[] strs;

    public MultiLineLabelUI() {
        this(0);
    }

    public MultiLineLabelUI(int n) {
        this.vgap = n;
    }

    @Override
    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        String string2 = MultiLineLabelUI.layoutCompoundLabel(jLabel, fontMetrics, this.splitStringByLines(string), icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap(), this.vgap);
        if (string2.equals("")) {
            return string;
        }
        return string2;
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String[] stringArray, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5, int n6) {
        boolean bl = true;
        int n7 = n2;
        int n8 = n4;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n2) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        switch (n4) {
            case 10: {
                n8 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n8 = bl ? 4 : 2;
            }
        }
        return MultiLineLabelUI.layoutCompoundLabel(fontMetrics, stringArray, icon, n, n7, n3, n8, rectangle, rectangle2, rectangle3, n5, n6);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String[] stringArray, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = stringArray == null || stringArray.length == 0 || stringArray.length == 1 && (stringArray[0] == null || stringArray[0].equals(""));
        String string = "";
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
        } else {
            Dimension dimension = MultiLineLabelUI.computeMultiLineDimension(fontMetrics, stringArray, n6);
            rectangle3.width = dimension.width;
            rectangle3.height = dimension.height;
        }
        int n11 = n10 = bl || icon == null ? 0 : n5;
        if (!bl && rectangle3.width > (n9 = n4 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n10)) && stringArray.length == 1) {
            String string2 = "...";
            n8 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n7 = 0; n7 < stringArray[0].length() && (n8 += fontMetrics.charWidth(stringArray[0].charAt(n7))) <= n9; ++n7) {
            }
            string = stringArray[0].substring(0, n7) + string2;
            rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        rectangle3.y = n3 == 1 ? (n4 != 0 ? 0 : -(rectangle3.height + n10)) : (n3 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n4 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n10));
        rectangle3.x = n4 == 2 ? -(rectangle3.width + n10) : (n4 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n10);
        n9 = Math.min(rectangle2.x, rectangle3.x);
        int n12 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n9;
        n8 = Math.min(rectangle2.y, rectangle3.y);
        n7 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n8;
        int n13 = n == 1 ? rectangle.y - n8 : (n == 0 ? rectangle.y + rectangle.height / 2 - (n8 + n7 / 2) : rectangle.y + rectangle.height - (n8 + n7));
        int n14 = n2 == 2 ? rectangle.x - n9 : (n2 == 4 ? rectangle.x + rectangle.width - (n9 + n12) : rectangle.x + rectangle.width / 2 - (n9 + n12 / 2));
        rectangle3.x += n14;
        rectangle3.y += n13;
        rectangle2.x += n14;
        rectangle2.y += n13;
        return string;
    }

    @Override
    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonic();
        graphics.setColor(jLabel.getForeground());
        this.drawString(graphics, string, n3, n, n2);
    }

    @Override
    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonic();
        graphics.setColor(jLabel.getBackground());
        this.drawString(graphics, string, n3, n, n2);
    }

    protected void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        if (string.indexOf(10) == -1) {
            BasicGraphicsUtils.drawString(graphics, string, n, n2, n3);
        } else {
            String[] stringArray = this.splitStringByLines(string);
            int n4 = graphics.getFontMetrics().getHeight();
            BasicGraphicsUtils.drawString(graphics, stringArray[0], n, n2, n3);
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                graphics.drawString(stringArray[i], n2, n3 + (n4 * i + this.vgap * i));
            }
        }
    }

    public static Dimension computeMultiLineDimension(FontMetrics fontMetrics, String[] stringArray, int n) {
        int n2 = 0;
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            n2 = Math.max(n2, SwingUtilities.computeStringWidth(fontMetrics, stringArray[i]));
        }
        return new Dimension(n2, fontMetrics.getHeight() * stringArray.length + n * stringArray.length);
    }

    public String[] splitStringByLines(String string) {
        if (string.equals(this.str)) {
            return this.strs;
        }
        this.str = string;
        this.strs = string.split("\n");
        return this.strs;
    }

    static {
        labelUI = new MultiLineLabelUI(0);
    }
}

