/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.ui;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.configuration.menuConfig.MenuConfiguration;
import de.oliver_matuschin.base.configuration.menuConfig.jaxb.model.Entry;
import de.oliver_matuschin.base.configuration.menuConfig.jaxb.model.EntryType;
import de.oliver_matuschin.base.configuration.menuConfig.jaxb.model.Menu;
import de.oliver_matuschin.base.configuration.menuConfig.jaxb.model.MenuBar;
import de.oliver_matuschin.base.configuration.menuConfig.jaxb.model.MenuType;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.frame.MenuContainer;
import de.oliver_matuschin.base.ui.frame.NamedApplicationWindow;
import de.oliver_matuschin.base.ui.listener.DefaultMenuItemActionListener;
import de.oliver_matuschin.base.ui.listener.DefaultWindowListener;
import de.oliver_matuschin.base.ui.listener.DefaultWindowStateListener;
import de.oliver_matuschin.base.ui.listener.MacOSAdapter;
import de.oliver_matuschin.base.ui.menu.JExtendedMenu;
import de.oliver_matuschin.base.ui.menu.JWindowMenuCheckBoxMenuItem;
import de.oliver_matuschin.system.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class UIManager
implements MenuContainer {
    private final Logger logger = Logger.getLogger(UIManager.class.getName());
    private boolean specialMenuBarHandlersRegistered = false;
    private List<AbstractApplicationWindow<?>> applicationWindows = new ArrayList();
    private Map<MenuContainer, JMenuBar> applicationMenus = new HashMap<MenuContainer, JMenuBar>();
    private Map<MenuContainer, Map<String, Boolean>> menuItemStates = new HashMap<MenuContainer, Map<String, Boolean>>();
    private Map<MenuContainer, Map<String, Boolean>> checkBoxMenuItemStates = new HashMap<MenuContainer, Map<String, Boolean>>();
    private int uiBlocked = 1;
    public static final String ABOUT_MENUITEM_ID = "menu.application.about";
    public static final String PREFERENCES_MENUITEM_ID = "menu.application.preferences";
    public static final String QUIT_MENUITEM_ID = "menu.application.quit";
    public static final float HIDPI_THRESHOLD = 1.5f;
    private Float dpiMultiplier;
    private ActionListener menuItemActionListener = new DefaultMenuItemActionListener();
    private WindowListener defaultWindowListener = new DefaultWindowListener();
    private WindowStateListener defaultWindowStateListener = new DefaultWindowStateListener();
    private MenuConfiguration menuConfiguration = null;
    private static JLabel fontLabel;

    public UIManager(MenuConfiguration menuConfiguration) {
        this.menuConfiguration = menuConfiguration;
        switch (Starter.getApplication().getPlatform()) {
            case MACOS: {
                if (!Starter.getApplication().isAgent()) {
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                    System.setProperty("com.apple.mrj.application.apple.menu.about.name", Starter.getApplication().getApplicationName());
                }
                try {
                    javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    this.logger.log(Level.WARNING, "Unable to set look and feel!", exception);
                }
                if (Starter.getApplication().isAgent()) break;
                this.initDefaultMenuBar();
                break;
            }
            case WINDOWS: {
                try {
                    javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
                    String string = "fontDefaults" + (this.getDPIMultiplier() == 2.0f ? "@2x" : "");
                    String string2 = "insetDefaults" + (this.getDPIMultiplier() == 2.0f ? "@2x" : "");
                    Properties properties = new Properties();
                    Object object = this.getClass().getResourceAsStream("/resources/ui/" + string);
                    Enumeration enumeration = null;
                    try {
                        properties.load((InputStream)object);
                    }
                    catch (Throwable throwable) {
                        enumeration = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object != null) {
                            if (enumeration != null) {
                                try {
                                    ((InputStream)object).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)((Object)enumeration)).addSuppressed(throwable);
                                }
                            } else {
                                ((InputStream)object).close();
                            }
                        }
                    }
                    object = new Properties();
                    enumeration = this.getClass().getResourceAsStream("/resources/ui/" + string2);
                    Throwable throwable = null;
                    try {
                        ((Properties)object).load((InputStream)((Object)enumeration));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (enumeration != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)((Object)enumeration)).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((InputStream)((Object)enumeration)).close();
                            }
                        }
                    }
                    enumeration = javax.swing.UIManager.getDefaults().keys();
                    while (enumeration.hasMoreElements()) {
                        String[] stringArray;
                        throwable = enumeration.nextElement();
                        if (throwable == null || !(throwable instanceof String)) continue;
                        String string3 = (String)((Object)throwable);
                        if (properties.containsKey(string3)) {
                            stringArray = properties.getProperty(string3).split(",");
                            javax.swing.UIManager.put(string3, new FontUIResource(new Font(stringArray[0], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[1]))));
                            continue;
                        }
                        if (!((Properties)object).containsKey(string3)) continue;
                        stringArray = ((Properties)object).getProperty(string3).split(",");
                        javax.swing.UIManager.put(string3, new InsetsUIResource(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
                    }
                    break;
                }
                catch (Exception exception) {
                    this.logger.log(Level.SEVERE, "Unable to set native look and feel!", exception);
                    break;
                }
            }
            default: {
                try {
                    javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
                    break;
                }
                catch (Exception exception) {
                    this.logger.log(Level.SEVERE, "Unable to set native look and feel!", exception);
                }
            }
        }
        javax.swing.UIManager.getDefaults().remove("Table.scrollPaneBorder");
        javax.swing.UIManager.getDefaults().put("Slider.focus", javax.swing.UIManager.getDefaults().get("Slider.background"));
        fontLabel = new JLabel();
    }

    public float getDPIMultiplier() {
        if (this.dpiMultiplier == null) {
            this.dpiMultiplier = Float.valueOf(1.0f);
            if (System.getProperty("dpiScalingSimulation") != null) {
                this.dpiMultiplier = Float.valueOf(System.getProperty("dpiScalingSimulation"));
            } else if (Starter.getApplication().getPlatform() == Platform.WINDOWS) {
                this.dpiMultiplier = Float.valueOf((float)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0f);
            }
            this.dpiMultiplier = this.dpiMultiplier.floatValue() > 1.5f ? Float.valueOf(2.0f) : Float.valueOf(1.0f);
        }
        return this.dpiMultiplier.floatValue();
    }

    public void setUiBlocked(boolean bl) {
        this.uiBlocked += bl ? 1 : -1;
        this.updateAllMenus();
        if (this.uiBlocked == 0) {
            this.refreshDefaultMenuBar();
        }
    }

    public boolean isUiBlocked() {
        return this.uiBlocked > 0;
    }

    public Dimension getPixelsForDots(Dimension dimension) {
        Dimension dimension2 = new Dimension();
        dimension2.setSize(this.getPixelsForDots(dimension.getWidth()), this.getPixelsForDots(dimension.getHeight()));
        return dimension2;
    }

    public float getPixelsForDots(float f) {
        return f * this.getDPIMultiplier();
    }

    public double getPixelsForDots(double d) {
        return d * (double)this.getDPIMultiplier();
    }

    public int getPixelsForDots(int n) {
        return (int)((float)n * this.getDPIMultiplier());
    }

    private void initDefaultMenuBar() {
        JMenuBar jMenuBar = this.createJMenuBar();
        MacOSAdapter.setDefaultMenuBar(jMenuBar);
        this.applicationMenus.put(this, jMenuBar);
        this.updateWindowMenus();
        this.updateMenuItemStates(this);
    }

    public void refreshDefaultMenuBar() {
        JMenuBar jMenuBar = this.applicationMenus.get(this);
        if (jMenuBar != null) {
            this.applicationMenus.remove(this);
            jMenuBar = this.createJMenuBar();
            MacOSAdapter.setDefaultMenuBar(jMenuBar);
            this.applicationMenus.put(this, jMenuBar);
            this.updateWindowMenus();
            this.updateMenuItemStates(this);
        }
    }

    public void registerApplicationWindow(AbstractApplicationWindow<?> abstractApplicationWindow) {
        if (!this.applicationWindows.contains(abstractApplicationWindow)) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Registered application window: " + abstractApplicationWindow.getTitle());
            }
            this.applicationWindows.add(abstractApplicationWindow);
            switch (Starter.getApplication().getPlatform()) {
                case MACOS: {
                    if (Starter.getApplication().isAgent()) break;
                    JMenuBar jMenuBar = this.createJMenuBar();
                    abstractApplicationWindow.setJMenuBar(jMenuBar);
                    this.applicationMenus.put(abstractApplicationWindow, jMenuBar);
                    break;
                }
                default: {
                    if (this.getMenuConfiguration().getMenuBarConfiguration().getMainClass() == null) break;
                    try {
                        if (!Class.forName(this.getMenuConfiguration().getMenuBarConfiguration().getMainClass()).isAssignableFrom(abstractApplicationWindow.getClass())) break;
                        JMenuBar jMenuBar = this.createJMenuBar();
                        abstractApplicationWindow.setJMenuBar(jMenuBar);
                        this.applicationMenus.put(abstractApplicationWindow, jMenuBar);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                }
            }
            this.addDefaultWindowListener(abstractApplicationWindow);
            this.updateMenuItemStates(abstractApplicationWindow);
        }
    }

    public boolean isRegisteredApplicationWindow(AbstractApplicationWindow<?> abstractApplicationWindow) {
        return this.applicationWindows.contains(abstractApplicationWindow);
    }

    public <T extends AbstractApplicationWindow<?>> T getLastRegisteredApplicationWindow(Class<T> clazz) {
        List<T> list = this.getRegisteredApplicationWindows(clazz);
        int n = list.size();
        if (n > 0) {
            return (T)((AbstractApplicationWindow)list.get(n - 1));
        }
        return null;
    }

    public <T extends AbstractApplicationWindow<?>> List<T> getRegisteredApplicationWindows(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (AbstractApplicationWindow<?> abstractApplicationWindow : this.applicationWindows) {
            if (abstractApplicationWindow.getClass() != clazz) continue;
            arrayList.add(clazz.cast(abstractApplicationWindow));
        }
        return arrayList;
    }

    public List<AbstractApplicationWindow<?>> getRegisteredApplicationWindows() {
        return new ArrayList(this.applicationWindows);
    }

    public boolean hasRegisteredApplicationWindow(Class<? extends AbstractApplicationWindow<?>> clazz) {
        return this.getLastRegisteredApplicationWindow(clazz) != null;
    }

    public void updateWindowMenus() {
        this.logger.log(Level.FINEST, "Updating window menus...");
        List<JExtendedMenu> list = this.getWindowMenus();
        List<Entry> list2 = this.getMenuConfiguration().getEntriesForMenuType(MenuType.WINDOW);
        for (JExtendedMenu object : list) {
            object.removeAll();
            this.populateMenu(object, list2);
        }
        for (MenuContainer menuContainer : this.applicationMenus.keySet()) {
            this.updateMenuItemStates(menuContainer);
        }
    }

    public void updateAllMenus() {
        this.logger.log(Level.FINEST, "Updating all menus...");
        Collection<JMenuBar> collection = this.applicationMenus.values();
        for (JMenuBar object : collection) {
            this.updateJMenuBar(object);
        }
        for (MenuContainer menuContainer : this.applicationMenus.keySet()) {
            this.updateMenuItemStates(menuContainer);
        }
        this.logger.log(Level.FINEST, "Done updating all menus.");
    }

    public void updateMenuItemStates(MenuContainer menuContainer) {
        if (this.logger.isLoggable(Level.FINEST)) {
            if (menuContainer != null) {
                if (menuContainer instanceof AbstractApplicationWindow) {
                    this.logger.log(Level.FINEST, "Updating menu item states for window: " + ((AbstractApplicationWindow)menuContainer).getTitle());
                } else if (menuContainer == this) {
                    this.logger.log(Level.FINEST, "Updating menu item states for application.");
                } else {
                    this.logger.log(Level.WARNING, "Updating menu item states for undefined target type (" + menuContainer.getClass().getCanonicalName() + ")!");
                }
            } else {
                this.logger.log(Level.WARNING, "Updating menu item states for undefined target!");
            }
        }
        MenuBar menuBar = this.getMenuConfiguration().getMenuBarConfiguration();
        List<Menu> list = menuBar.getMenu();
        for (Menu menu : list) {
            if (menu.getType() == MenuType.APPLICATION && Starter.getApplication().getPlatform() == Platform.MACOS) continue;
            List<Entry> list2 = menu.getEntry();
            this.updateMenuItemStatesForEntries(menuContainer, list2);
        }
        boolean bl = !this.isUiBlocked() && menuContainer instanceof AbstractApplicationWindow;
        this.setMenuItemEnabled(menuContainer, "menu.file.closeWindow", bl, false);
        this.setMenuItemEnabled(menuContainer, "menu.file.closeAllWindows", bl, false);
        this.setMenuItemEnabled(menuContainer, "menu.window.minimizeWindow", bl, false);
        this.setMenuItemEnabled(menuContainer, "menu.window.zoomWindow", bl ? ((AbstractApplicationWindow)menuContainer).isResizable() : false, false);
        this.setMenuItemEnabled(menuContainer, "menu.window.nextWindow", bl, false);
    }

    private void updateMenuItemStatesForEntries(MenuContainer menuContainer, List<Entry> list) {
        for (Entry entry : list) {
            if (EntryType.SUBMENU.equals((Object)entry.getType())) {
                this.updateMenuItemStatesForEntries(menuContainer, entry.getEntry());
            }
            if (entry.getId() == null) continue;
            if (!EntryType.WINDOW.equals((Object)entry.getType())) {
                if (this.isUiBlocked()) {
                    this.setMenuItemEnabled(menuContainer, entry.getId(), false, false);
                } else if (this.hasCustomMenuItemState(menuContainer, entry.getId())) {
                    this.setMenuItemEnabled(menuContainer, entry.getId(), this.getCustomMenuItemState(menuContainer, entry.getId(), false), false);
                } else {
                    this.setMenuItemEnabled(menuContainer, entry.getId(), entry.isEnabled() != null ? entry.isEnabled() : false, false);
                }
                if (!EntryType.CHECKBOX.equals((Object)entry.getType())) continue;
                this.setMenuItemChecked(menuContainer, entry.getId(), this.getCustomCheckBoxMenuItemState(menuContainer, entry.getId(), false), false);
                continue;
            }
            this.setMenuItemEnabled(menuContainer, entry.getId(), !this.isUiBlocked(), false);
        }
    }

    private boolean getCustomCheckBoxMenuItemState(Object object, String string, boolean bl) {
        if (this.checkBoxMenuItemStates.containsKey(this) && this.checkBoxMenuItemStates.get(this).containsKey(string)) {
            return this.checkBoxMenuItemStates.get(this).get(string);
        }
        if (object != null && this.checkBoxMenuItemStates.containsKey(object) && this.checkBoxMenuItemStates.get(object).containsKey(string)) {
            return this.checkBoxMenuItemStates.get(object).get(string);
        }
        return bl;
    }

    private boolean hasCustomMenuItemState(Object object, String string) {
        if (this.menuItemStates.containsKey(this) && this.menuItemStates.get(this).containsKey(string)) {
            return true;
        }
        return object != null && this.menuItemStates.containsKey(object) && this.menuItemStates.get(object).containsKey(string);
    }

    private boolean getCustomMenuItemState(Object object, String string, boolean bl) {
        if (this.menuItemStates.containsKey(this) && this.menuItemStates.get(this).containsKey(string)) {
            return this.menuItemStates.get(this).get(string);
        }
        if (object != null && this.menuItemStates.containsKey(object) && this.menuItemStates.get(object).containsKey(string)) {
            return this.menuItemStates.get(object).get(string);
        }
        return bl;
    }

    public AbstractApplicationWindow<?> getFrontmostWindow() {
        for (AbstractApplicationWindow<?> abstractApplicationWindow : this.applicationWindows) {
            if (!abstractApplicationWindow.isVisible() || !abstractApplicationWindow.isActive()) continue;
            return abstractApplicationWindow;
        }
        return null;
    }

    private List<JExtendedMenu> getWindowMenus() {
        ArrayList<JExtendedMenu> arrayList = new ArrayList<JExtendedMenu>();
        Collection<JMenuBar> collection = this.applicationMenus.values();
        for (JMenuBar jMenuBar : collection) {
            int n = jMenuBar.getMenuCount();
            for (int i = 0; i < n; ++i) {
                JExtendedMenu jExtendedMenu;
                JMenu jMenu = jMenuBar.getMenu(i);
                if (!(jMenu instanceof JExtendedMenu) || (jExtendedMenu = (JExtendedMenu)jMenu).getMenuType() == null || !jExtendedMenu.getMenuType().toString().equals(JExtendedMenu.MenuType.WINDOW.toString())) continue;
                arrayList.add(jExtendedMenu);
            }
        }
        return arrayList;
    }

    public void unregisterApplicationWindow(AbstractApplicationWindow<?> abstractApplicationWindow) {
        if (this.applicationWindows.contains(abstractApplicationWindow)) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Unregistered application window: " + abstractApplicationWindow.getTitle());
            }
            abstractApplicationWindow.setJMenuBar(null);
            abstractApplicationWindow.setMenuBar(null);
            abstractApplicationWindow.setWindowCanFullScreen(false);
            this.applicationMenus.remove(abstractApplicationWindow);
            this.applicationWindows.remove(abstractApplicationWindow);
            this.menuItemStates.remove(abstractApplicationWindow);
            this.checkBoxMenuItemStates.remove(abstractApplicationWindow);
            abstractApplicationWindow.removeWindowListener(this.defaultWindowListener);
            abstractApplicationWindow.removeWindowStateListener(this.defaultWindowStateListener);
            this.updateWindowMenus();
            this.updateMenuItemStates(this);
        }
    }

    private void addDefaultWindowListener(AbstractApplicationWindow<?> abstractApplicationWindow) {
        if (this.logger.isLoggable(Level.WARNING) && !EventQueue.isDispatchThread()) {
            this.logger.log(Level.WARNING, "addDefaultWindowListener(window) called outside of the EDT!");
        }
        abstractApplicationWindow.addWindowListener(this.defaultWindowListener);
        abstractApplicationWindow.addWindowStateListener(this.defaultWindowStateListener);
    }

    public void saveWindowPositions() {
        if (this.logger.isLoggable(Level.WARNING) && !EventQueue.isDispatchThread()) {
            this.logger.log(Level.WARNING, "saveWindowPositions() called outside of the EDT!");
        }
        for (AbstractApplicationWindow<?> abstractApplicationWindow : this.applicationWindows) {
            this.saveWindowState(abstractApplicationWindow);
        }
    }

    public void saveWindowState(AbstractApplicationWindow<?> abstractApplicationWindow) {
        if (this.logger.isLoggable(Level.WARNING) && !EventQueue.isDispatchThread()) {
            this.logger.log(Level.WARNING, "saveWindowPositions(window) called outside of the EDT!");
        }
        Preferences preferences = Starter.getApplication().getPreferences();
        String string = abstractApplicationWindow instanceof NamedApplicationWindow ? "window." + ((NamedApplicationWindow)((Object)abstractApplicationWindow)).getUniqueName() : "window." + abstractApplicationWindow.getClass().getSimpleName();
        if (!abstractApplicationWindow.isWindowFullScreen()) {
            float f = this.getDPIMultiplier();
            preferences.putInt(string + "_x", (int)((float)abstractApplicationWindow.getX() / f));
            preferences.putInt(string + "_y", (int)((float)abstractApplicationWindow.getY() / f));
            preferences.putInt(string + "_w", (int)((float)abstractApplicationWindow.getSize().width / f));
            preferences.putInt(string + "_h", (int)((float)abstractApplicationWindow.getSize().height / f));
        } else {
            preferences.putInt(string + "_x", Integer.MIN_VALUE);
            preferences.putInt(string + "_y", Integer.MIN_VALUE);
            preferences.putInt(string + "_w", Integer.MIN_VALUE);
            preferences.putInt(string + "_h", Integer.MIN_VALUE);
        }
        preferences.putBoolean(string + "_fullscreen", abstractApplicationWindow.isWindowFullScreen());
        preferences.put(string + "_device", abstractApplicationWindow.getGraphicsConfiguration().getDevice().getIDstring());
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Saved window \"" + abstractApplicationWindow.getTitle() + "\" position and state: x=" + abstractApplicationWindow.getX() + " y=" + abstractApplicationWindow.getY() + " w=" + abstractApplicationWindow.getSize().width + " h=" + abstractApplicationWindow.getSize().height + " state=" + abstractApplicationWindow.getExtendedState() + " fullscreen=" + abstractApplicationWindow.isWindowFullScreen() + " device=" + abstractApplicationWindow.getGraphicsConfiguration().getDevice().getIDstring());
        }
    }

    public void restoreSavedWindowState(AbstractApplicationWindow<?> abstractApplicationWindow) {
        if (this.logger.isLoggable(Level.WARNING) && !EventQueue.isDispatchThread()) {
            this.logger.log(Level.WARNING, "restoreSavedWindowState(window) called outside of the EDT!");
        }
        if (abstractApplicationWindow.getClass().getCanonicalName() == null) {
            return;
        }
        Preferences preferences = Starter.getApplication().getPreferences();
        String string = abstractApplicationWindow instanceof NamedApplicationWindow ? "window." + ((NamedApplicationWindow)((Object)abstractApplicationWindow)).getUniqueName() : "window." + abstractApplicationWindow.getClass().getCanonicalName().substring(abstractApplicationWindow.getClass().getCanonicalName().lastIndexOf(46) + 1);
        float f = this.getDPIMultiplier();
        int n = preferences.getInt(string + "_x", Integer.MIN_VALUE);
        int n2 = preferences.getInt(string + "_y", Integer.MIN_VALUE);
        int n3 = preferences.getInt(string + "_w", Integer.MIN_VALUE);
        int n4 = preferences.getInt(string + "_h", Integer.MIN_VALUE);
        boolean bl = preferences.getBoolean(string + "_fullscreen", Boolean.FALSE);
        String string2 = preferences.get(string + "_device", null);
        if (n != Integer.MIN_VALUE || n2 != Integer.MIN_VALUE) {
            abstractApplicationWindow.setLocation((int)((float)n * f), (int)((float)n2 * f));
        } else if (n == Integer.MIN_VALUE && n2 == Integer.MIN_VALUE && n3 == Integer.MIN_VALUE && n4 == Integer.MIN_VALUE) {
            abstractApplicationWindow.setLocationRelativeTo(null);
        }
        if (abstractApplicationWindow.isResizable()) {
            if (n3 != Integer.MIN_VALUE || n4 != Integer.MIN_VALUE) {
                abstractApplicationWindow.setSize(n3, n4);
            }
            if (bl && !Starter.getApplication().isAgent()) {
                abstractApplicationWindow.setVisible(true);
                abstractApplicationWindow.setWindowCanFullScreen(true);
                if (string2 != null) {
                    GraphicsDevice[] graphicsDeviceArray;
                    for (GraphicsDevice graphicsDevice : graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                        if (!string2.equals(graphicsDevice.getIDstring())) continue;
                        abstractApplicationWindow.setLocation(graphicsDevice.getDefaultConfiguration().getBounds().x + abstractApplicationWindow.getX(), graphicsDevice.getDefaultConfiguration().getBounds().y + abstractApplicationWindow.getY());
                        break;
                    }
                }
                abstractApplicationWindow.toggleFullScreen();
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Restored window \"" + abstractApplicationWindow.getTitle() + "\" position and state: x=" + abstractApplicationWindow.getX() + " y=" + abstractApplicationWindow.getY() + " w=" + abstractApplicationWindow.getSize().width + " h=" + abstractApplicationWindow.getSize().height + " state=" + abstractApplicationWindow.getExtendedState() + " fullscreen=" + bl + " device=" + string2);
        }
    }

    public void removeStoredWindowState(String string) {
        Preferences preferences = Starter.getApplication().getPreferences();
        String string2 = "window." + string;
        preferences.remove(string2 + "_multiplier");
        preferences.remove(string2 + "_x");
        preferences.remove(string2 + "_y");
        preferences.remove(string2 + "_w");
        preferences.remove(string2 + "_h");
        preferences.remove(string2 + "_fullscreen");
        preferences.remove(string2 + "_device");
    }

    public void removeStoredWindowState(AbstractApplicationWindow<?> abstractApplicationWindow) {
        String string = abstractApplicationWindow instanceof NamedApplicationWindow ? ((NamedApplicationWindow)((Object)abstractApplicationWindow)).getUniqueName() : abstractApplicationWindow.getClass().getCanonicalName().substring(abstractApplicationWindow.getClass().getCanonicalName().lastIndexOf(46) + 1);
        this.removeStoredWindowState(string);
    }

    public boolean isStoredWindowStateAvailable(String string) {
        String string2;
        Preferences preferences = Starter.getApplication().getPreferences();
        return preferences.get((string2 = "window." + string) + "_x", null) != null;
    }

    public boolean isStoredWindowStateAvailable(AbstractApplicationWindow<?> abstractApplicationWindow) {
        String string = abstractApplicationWindow instanceof NamedApplicationWindow ? ((NamedApplicationWindow)((Object)abstractApplicationWindow)).getUniqueName() : abstractApplicationWindow.getClass().getSimpleName();
        return this.isStoredWindowStateAvailable(string);
    }

    private void updateJMenuBar(JMenuBar jMenuBar) {
        List<Menu> list = this.getMenuConfiguration().getMenuBarConfiguration().getMenu();
        int n = 0;
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            for (Menu menu : list) {
                if (menu.getType() != MenuType.APPLICATION) continue;
                ++n;
            }
        }
        if (jMenuBar.getMenuCount() != list.size() - n) {
            jMenuBar.removeAll();
        }
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getType() == MenuType.APPLICATION) {
                ++n2;
                continue;
            }
            jMenuBar.getMenu(i - n2).removeAll();
            this.populateMenu((JExtendedMenu)jMenuBar.getMenu(i - n2), list.get(i).getEntry());
        }
    }

    private JMenuBar createJMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.populateMenuBar(jMenuBar);
        return jMenuBar;
    }

    private void populateMenuBar(JMenuBar jMenuBar) {
        List<Menu> list = this.getMenuConfiguration().getMenuBarConfiguration().getMenu();
        block5: for (Menu menu : list) {
            JExtendedMenu jExtendedMenu = new JExtendedMenu();
            jExtendedMenu.setName(menu.getId());
            if (menu.getType() != null) {
                switch (menu.getType()) {
                    case APPLICATION: {
                        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
                            this.registerSpecialMenuHandlers(menu);
                            continue block5;
                        }
                        jExtendedMenu.setMenuType(JExtendedMenu.MenuType.APPLICATION);
                        break;
                    }
                    case HELP: {
                        jExtendedMenu.setMenuType(JExtendedMenu.MenuType.HELP);
                        break;
                    }
                    case WINDOW: {
                        jExtendedMenu.setMenuType(JExtendedMenu.MenuType.WINDOW);
                        break;
                    }
                    default: {
                        jExtendedMenu.setMenuType(JExtendedMenu.MenuType.DEFAULT);
                    }
                }
            }
            jExtendedMenu.setText(Starter.getApplication().getLocalizedString(menu.getLabel()));
            List<Entry> list2 = menu.getEntry();
            this.populateMenu(jExtendedMenu, list2);
            jMenuBar.add(jExtendedMenu);
        }
    }

    private void populateMenu(JExtendedMenu jExtendedMenu, List<Entry> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Entry entry : list) {
            Object object;
            String string = entry.getLabel() != null ? Starter.getApplication().getLocalizedString(entry.getLabel()) : (entry.getText() != null ? entry.getText() : null);
            if (EntryType.SEPARATOR.equals((Object)entry.getType())) {
                jExtendedMenu.addSeparator();
                continue;
            }
            if (EntryType.CHECKBOX.equals((Object)entry.getType())) {
                object = new JCheckBoxMenuItem(string);
            } else if (EntryType.WINDOW.equals((Object)entry.getType())) {
                object = new JWindowMenuCheckBoxMenuItem(string);
                if (entry.getHandlerClass() != null) {
                    arrayList.add(entry.getHandlerClass());
                    for (AbstractApplicationWindow abstractApplicationWindow : this.applicationWindows) {
                        if (!abstractApplicationWindow.getClass().getCanonicalName().equals(entry.getHandlerClass())) continue;
                        this.setWindowMenuItemText((JMenuItem)object, abstractApplicationWindow);
                        break;
                    }
                }
            } else if (EntryType.SUBMENU.equals((Object)entry.getType())) {
                AbstractApplicationWindow<?> abstractApplicationWindow = new JExtendedMenu(string);
                abstractApplicationWindow.setName(entry.getId());
                ((JExtendedMenu)((Object)abstractApplicationWindow)).setMenuType(JExtendedMenu.MenuType.SUBMENU);
                this.populateMenu((JExtendedMenu)((Object)abstractApplicationWindow), entry.getEntry());
                object = abstractApplicationWindow;
            } else {
                object = new JMenuItem(string);
            }
            ((Component)object).setName(entry.getId());
            ((AbstractButton)object).addActionListener(this.menuItemActionListener);
            jExtendedMenu.add((JMenuItem)object);
            if (entry.getAccelerator() == null) continue;
            this.setAcceleratorForMenuItem((JMenuItem)object, entry.getAccelerator());
        }
        if (jExtendedMenu.getMenuType().toString().equals(JExtendedMenu.MenuType.WINDOW.toString())) {
            boolean bl = true;
            for (AbstractApplicationWindow<?> abstractApplicationWindow : this.applicationWindows) {
                if (arrayList.contains(abstractApplicationWindow.getClass().getCanonicalName())) continue;
                if (bl && jExtendedMenu.getItemCount() > 0) {
                    jExtendedMenu.addSeparator();
                    bl = false;
                }
                JWindowMenuCheckBoxMenuItem jWindowMenuCheckBoxMenuItem = new JWindowMenuCheckBoxMenuItem(abstractApplicationWindow.getTitle());
                jWindowMenuCheckBoxMenuItem.setWindow(abstractApplicationWindow);
                jWindowMenuCheckBoxMenuItem.addActionListener(this.menuItemActionListener);
                jExtendedMenu.add(jWindowMenuCheckBoxMenuItem);
                this.setWindowMenuItemText(jWindowMenuCheckBoxMenuItem, abstractApplicationWindow);
            }
        }
    }

    private void setAcceleratorForMenuItem(JMenuItem jMenuItem, String string) {
        string = string.trim();
        try {
            int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            if (string.startsWith("\"") && string.endsWith("\"")) {
                if (string.length() > 2) {
                    jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)string.charAt(1), n));
                }
            } else {
                if (string.indexOf("+") != -1) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split("\\+")) {
                        if ((string2 = string2.toUpperCase()).equals("SHIFT")) {
                            n |= 1;
                            continue;
                        }
                        if (string2.equals("CTRL")) {
                            n |= 2;
                            continue;
                        }
                        if (string2.equals("ALT")) {
                            n |= 8;
                            continue;
                        }
                        string = string2;
                    }
                }
                int n2 = (Integer)KeyEvent.class.getField(string).get(Integer.class);
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, n));
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private void registerSpecialMenuHandlers(Menu menu) {
        if (this.specialMenuBarHandlersRegistered) {
            return;
        }
        this.specialMenuBarHandlersRegistered = true;
        List<Entry> list = menu.getEntry();
        for (Entry entry : list) {
            if (entry.getType() == EntryType.SEPARATOR) continue;
            try {
                if (!Starter.getApplication().isAgent()) {
                    if (ABOUT_MENUITEM_ID.equals(entry.getId())) {
                        MacOSAdapter.setAboutHandler(this.menuItemActionListener, this.menuItemActionListener.getClass().getMethod("handleAbout", null));
                    } else if (PREFERENCES_MENUITEM_ID.equals(entry.getId())) {
                        MacOSAdapter.setPreferencesHandler(this.menuItemActionListener, this.menuItemActionListener.getClass().getMethod("handlePreferences", null));
                    }
                }
                if (!QUIT_MENUITEM_ID.equals(entry.getId())) continue;
                MacOSAdapter.setQuitHandler(this.menuItemActionListener, this.menuItemActionListener.getClass().getMethod("handleQuit", null));
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
    }

    private void setWindowMenuItemText(JMenuItem jMenuItem, AbstractApplicationWindow<?> abstractApplicationWindow) {
        jMenuItem.setSelected(abstractApplicationWindow.isActive() && abstractApplicationWindow.isVisible());
        if ((abstractApplicationWindow.getExtendedState() & 1) > 0) {
            jMenuItem.setText("\u25c6 " + jMenuItem.getText());
        }
    }

    public void showWindow(AbstractApplicationWindow<?> abstractApplicationWindow) {
        this.showWindow(abstractApplicationWindow, !abstractApplicationWindow.isVisible());
    }

    public void showWindow(AbstractApplicationWindow<?> abstractApplicationWindow, boolean bl) {
        if (bl) {
            this.restoreSavedWindowState(abstractApplicationWindow);
        }
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            MacOSAdapter.requestForeground();
        }
        boolean bl2 = abstractApplicationWindow.isAlwaysOnTop();
        abstractApplicationWindow.setVisible(true);
        abstractApplicationWindow.setAlwaysOnTop(true);
        abstractApplicationWindow.toFront();
        abstractApplicationWindow.requestFocus();
        abstractApplicationWindow.setAlwaysOnTop(bl2);
        this.updateWindowMenus();
    }

    public boolean isMenuItemEnabled(String string) {
        return this.isMenuItemEnabled(null, string);
    }

    public boolean isMenuItemEnabled(Object object, String string) {
        boolean bl = false;
        if (this.hasCustomMenuItemState(object, string)) {
            return this.getCustomMenuItemState(object, string, false);
        }
        Entry entry = this.getMenuConfiguration().getEntryByID(string);
        if (entry != null) {
            return entry.isEnabled();
        }
        return bl;
    }

    public boolean isMenuItemChecked(Object object, String string) {
        return this.getCustomCheckBoxMenuItemState(object, string, false);
    }

    public void setMenuItemChecked(String string, boolean bl) {
        this.setMenuItemChecked(null, string, bl);
    }

    public void setMenuItemChecked(MenuContainer menuContainer, String string, boolean bl) {
        this.setMenuItemChecked(menuContainer, string, bl, true);
    }

    private void setMenuItemChecked(MenuContainer menuContainer, String string, boolean bl, boolean bl2) {
        List<JMenuItem> list = null;
        if (this.getMenuConfiguration().getEntryByID(string) != null) {
            if (bl2) {
                Object object = menuContainer;
                if (object == null) {
                    object = this;
                }
                if (!this.checkBoxMenuItemStates.containsKey(object)) {
                    this.checkBoxMenuItemStates.put((MenuContainer)object, new HashMap());
                }
                this.checkBoxMenuItemStates.get(object).put(string, bl);
            }
            list = this.getJMenuItemsByID(menuContainer, string);
            for (JMenuItem jMenuItem : list) {
                jMenuItem.setSelected(bl);
            }
        } else if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "No menu item found with id=\"" + string + "\"");
        }
    }

    public void enableMenuItem(String string) {
        this.setMenuItemEnabled(null, string, true);
    }

    public void enableMenuItem(MenuContainer menuContainer, String string) {
        this.setMenuItemEnabled(menuContainer, string, true);
    }

    public void disableMenuItem(String string) {
        this.setMenuItemEnabled(null, string, false);
    }

    public void disableMenuItem(MenuContainer menuContainer, String string) {
        this.setMenuItemEnabled(menuContainer, string, false);
    }

    public void setMenuItemEnabled(String string, boolean bl) {
        this.setMenuItemEnabled(null, string, bl);
    }

    public void setMenuItemEnabled(MenuContainer menuContainer, String string, boolean bl) {
        this.setMenuItemEnabled(menuContainer, string, bl, true);
    }

    private void setMenuItemEnabled(MenuContainer menuContainer, String string, boolean bl, boolean bl2) {
        List<JMenuItem> list = null;
        if (this.getMenuConfiguration().getEntryByID(string) != null) {
            if (bl2) {
                Object object = menuContainer;
                if (object == null) {
                    object = this;
                }
                if (!this.menuItemStates.containsKey(object)) {
                    this.menuItemStates.put((MenuContainer)object, new HashMap());
                }
                this.menuItemStates.get(object).put(string, bl);
            }
            list = this.getJMenuItemsByID(menuContainer, string);
            for (JMenuItem jMenuItem : list) {
                jMenuItem.setEnabled(bl);
            }
        } else if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "No menu item found with id=\"" + string + "\"");
        }
    }

    private List<JMenuItem> getJMenuItemsByID(Object object, String string) {
        Collection<JMenuBar> collection;
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        if (object == null) {
            collection = this.applicationMenus.values();
        } else {
            collection = new ArrayList<JMenuBar>();
            JMenuBar jMenuBar = this.applicationMenus.get(object);
            if (jMenuBar == null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Could not get menu items by id (\"" + string + "\") because the specified target has no menu.");
                }
                return arrayList;
            }
            collection.add(jMenuBar);
        }
        for (JMenuBar jMenuBar : collection) {
            int n = jMenuBar.getMenuCount();
            for (int i = 0; i < n; ++i) {
                JMenu jMenu = jMenuBar.getMenu(i);
                arrayList.addAll(this.findJMenuItemsByIDInJMenu(string, jMenu));
            }
        }
        if (this.logger.isLoggable(Level.WARNING) && arrayList.isEmpty() && this.getMenuConfiguration().getEntryByID(string) == null) {
            this.logger.log(Level.WARNING, "No menu item found with id=\"" + string + "\"");
        }
        return arrayList;
    }

    private List<JMenuItem> findJMenuItemsByIDInJMenu(String string, JMenu jMenu) {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            if (jMenuItem instanceof JMenu) {
                arrayList.addAll(this.findJMenuItemsByIDInJMenu(string, (JMenu)jMenuItem));
            }
            if (!string.equals(jMenuItem.getName())) continue;
            arrayList.add(jMenuItem);
        }
        return arrayList;
    }

    public String getHandlerClassForMenuByID(String string) {
        Entry entry = this.getMenuConfiguration().getEntryByID(string);
        if (entry != null) {
            return entry.getHandlerClass();
        }
        return null;
    }

    public String getHandlerMethodForMenuByID(String string) {
        Entry entry = this.getMenuConfiguration().getEntryByID(string);
        if (entry != null) {
            return entry.getHandlerMethod();
        }
        return null;
    }

    public String getDataForMenuByID(String string) {
        Entry entry = this.getMenuConfiguration().getEntryByID(string);
        if (entry != null) {
            return entry.getData();
        }
        return null;
    }

    public void closeWindows() {
        for (AbstractApplicationWindow<?> abstractApplicationWindow : this.applicationWindows) {
            abstractApplicationWindow.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(abstractApplicationWindow, 201));
        }
    }

    public void closeCurrentWindow() {
        AbstractApplicationWindow<?> abstractApplicationWindow = this.getFrontmostWindow();
        if (abstractApplicationWindow != null) {
            abstractApplicationWindow.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(abstractApplicationWindow, 201));
        }
    }

    public void minimizeCurrentWindow() {
        for (AbstractApplicationWindow<?> abstractApplicationWindow : this.applicationWindows) {
            if (!abstractApplicationWindow.isVisible() || !abstractApplicationWindow.isActive()) continue;
            abstractApplicationWindow.setExtendedState(abstractApplicationWindow.getExtendedState() | 1);
            break;
        }
    }

    public void zoomCurrentWindow() {
        for (AbstractApplicationWindow<?> abstractApplicationWindow : this.applicationWindows) {
            if (!abstractApplicationWindow.isVisible() || !abstractApplicationWindow.isActive()) continue;
            abstractApplicationWindow.setExtendedState(abstractApplicationWindow.getExtendedState() | 6);
            break;
        }
    }

    public void showNextWindow() {
        AbstractApplicationWindow<?> abstractApplicationWindow = null;
        for (AbstractApplicationWindow<?> abstractApplicationWindow2 : this.applicationWindows) {
            if (abstractApplicationWindow != null) {
                this.showWindow(abstractApplicationWindow2, false);
                return;
            }
            if (!abstractApplicationWindow2.isVisible() || !abstractApplicationWindow2.isActive()) continue;
            abstractApplicationWindow = abstractApplicationWindow2;
        }
        if (abstractApplicationWindow != null) {
            this.showWindow(this.applicationWindows.get(0), false);
        }
    }

    public MenuConfiguration getMenuConfiguration() {
        return this.menuConfiguration;
    }

    public Font getFont(FontSize fontSize) {
        return this.getFont(fontSize, 0);
    }

    public Font getFont(FontSize fontSize, int n) {
        switch (fontSize) {
            case LARGE: {
                return new Font(fontLabel.getFont().getName(), n, fontLabel.getFont().getSize() + 2);
            }
            case DEFAULT: {
                return new Font(fontLabel.getFont().getName(), n, fontLabel.getFont().getSize());
            }
            case MEDIUM: {
                if (Starter.getApplication().getPlatform() == Platform.MACOS) {
                    return new Font(fontLabel.getFont().getName(), n, fontLabel.getFont().getSize() - 2);
                }
                return new Font(fontLabel.getFont().getName(), n, fontLabel.getFont().getSize());
            }
            case SMALL: {
                return new Font(fontLabel.getFont().getName(), n, fontLabel.getFont().getSize() - 2);
            }
        }
        return fontLabel.getFont();
    }

    public static enum FontSize {
        LARGE,
        DEFAULT,
        MEDIUM,
        SMALL;

    }
}

