/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.extension;

import de.oliver_matuschin.base.classloader.JarClassLoader;
import de.oliver_matuschin.base.extension.Extension;
import de.oliver_matuschin.base.extension.ExtensionManager;
import de.oliver_matuschin.base.extension.exception.ExtensionLoadException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultExtensionManager
implements ExtensionManager {
    private final Logger logger = Logger.getLogger(DefaultExtensionManager.class.getName());
    private JarClassLoader classLoader;
    private Set<Path> loadedExtensions;
    private Map<Class<?>, Set<Class<?>>> cachedClasses;
    private Object mutex = new Object();

    public DefaultExtensionManager() {
        this.classLoader = new JarClassLoader(new URL[0], this.getClass().getClassLoader());
        this.loadedExtensions = new HashSet<Path>();
        this.cachedClasses = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadExtension(Path path) throws ExtensionLoadException {
        try {
            Object object = this.mutex;
            synchronized (object) {
                if (this.loadedExtensions.add(path)) {
                    this.classLoader.addURL(path.toUri().toURL());
                    this.extractLibrariesFromJar(path);
                    this.cachedClasses.clear();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new ExtensionLoadException(MessageFormat.format("Failed to load extension \"{0}\".", path), malformedURLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Path> getLoadedExtensions() {
        Object object = this.mutex;
        synchronized (object) {
            return new HashSet<Path>(this.loadedExtensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> get(Class<T> clazz, Object ... objectArray) {
        Set<Class<?>> set;
        ArrayList<T> arrayList = this.mutex;
        synchronized (arrayList) {
            if (!this.cachedClasses.containsKey(clazz)) {
                this.cachedClasses.put(clazz, this.findClassesImplementing(clazz));
            }
            set = this.cachedClasses.get(clazz);
        }
        arrayList = new ArrayList<T>();
        if (set != null && !set.isEmpty()) {
            for (Class<?> clazz2 : set) {
                try {
                    arrayList.add(this.instantiateClass(clazz2, objectArray));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                    this.logger.log(Level.WARNING, MessageFormat.format("Failed to instantiate extension \"{0}\".", clazz.getCanonicalName()), reflectiveOperationException);
                }
            }
        }
        this.sortInstances(arrayList);
        return arrayList;
    }

    private <T> T instantiateClass(Class<?> clazz, Object ... objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
            if (constructor.getParameterCount() != objectArray.length) continue;
            boolean bl = true;
            Class<?>[] classArray = constructor.getParameterTypes();
            for (int i = 0; i < objectArray.length; ++i) {
                if (classArray[i].isAssignableFrom(objectArray[i].getClass())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return (T)constructor.newInstance(objectArray);
        }
        throw new InstantiationException("No constructor exists with parameters " + objectArray);
    }

    private <T> void sortInstances(List<T> list) {
        Collections.sort(list, (object, object2) -> {
            int n = 0;
            Extension extension = object.getClass().getAnnotation(Extension.class);
            Extension extension2 = object2.getClass().getAnnotation(Extension.class);
            if (extension != null && extension2 != null) {
                n = Integer.compare(extension.priority(), extension2.priority()) * -1;
            } else if (extension == null && extension2 != null) {
                n = 1;
            } else if (extension != null && extension2 == null) {
                n = -1;
            }
            if (n == 0) {
                n = object.getClass().getSimpleName().compareTo(object2.getClass().getSimpleName());
            }
            return n;
        });
    }

    private Set<Class<?>> findClassesImplementing(Class<?> clazz) {
        HashSet hashSet = new HashSet();
        for (Path path : this.loadedExtensions) {
            List<String> list = this.collectClassNamesFromJar(path);
            for (String string : list) {
                try {
                    Class<?> clazz2 = this.classLoader.loadClass(string);
                    if (clazz2.isInterface() || clazz2.isSynthetic() || clazz2.isAnonymousClass() || Modifier.isAbstract(clazz2.getModifiers()) || !clazz.isAssignableFrom(clazz2)) continue;
                    hashSet.add(clazz2);
                    if (((Extension[])clazz2.getAnnotationsByType(Extension.class)).length != 0) continue;
                    this.logger.log(Level.WARNING, "Using class \"{0}\" as extension without appropriate annotation.", clazz2.getCanonicalName());
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                    this.logger.log(Level.WARNING, MessageFormat.format("Failed to load extension class \"{0}\".", clazz.getCanonicalName()), throwable);
                }
            }
        }
        return hashSet;
    }

    private List<String> collectClassNamesFromJar(Path path) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().getName();
                if (!string.endsWith(".class")) continue;
                string = string.replaceAll("/", ".").replaceAll("\\\\", ".").substring(0, string.lastIndexOf(46));
                arrayList.add(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    private void extractLibrariesFromJar(Path path) {
        File file = path.getParent() != null ? path.getParent().resolve("temp").toFile() : Paths.get("temp", new String[0]).toFile();
        if (file.mkdirs() || file.exists() && file.isDirectory()) {
            try (JarFile jarFile = new JarFile(path.toFile());){
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".jar")) continue;
                    String string = jarEntry.getName().indexOf(47) != -1 ? jarEntry.getName().substring(jarEntry.getName().lastIndexOf(47) + 1) : jarEntry.getName();
                    File file2 = new File(file.getPath() + File.separator + string);
                    if (!file2.exists()) {
                        try (InputStream inputStream = jarFile.getInputStream(jarEntry);
                             FileOutputStream fileOutputStream = new FileOutputStream(file2);
                             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                            while (inputStream.available() > 0) {
                                bufferedOutputStream.write(inputStream.read());
                            }
                        }
                    }
                    this.classLoader.addURL(file2.toURI().toURL());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

