/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.configuration.menuConfig;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.configuration.menuConfig.jaxb.model.Entry;
import de.oliver_matuschin.base.configuration.menuConfig.jaxb.model.Menu;
import de.oliver_matuschin.base.configuration.menuConfig.jaxb.model.MenuBar;
import de.oliver_matuschin.base.configuration.menuConfig.jaxb.model.MenuType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class MenuConfiguration {
    private final Logger logger = Logger.getLogger(MenuConfiguration.class.getName());
    private MenuBar menuBarConfiguration = null;
    private Entry lastEntry = null;
    private String lastId = null;

    public MenuBar getMenuBarConfiguration() {
        if (this.menuBarConfiguration == null) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Reading menu bar configuration...");
            }
            this.menuBarConfiguration = this.readMenuBarConfiguration();
        }
        return this.menuBarConfiguration;
    }

    private MenuBar readMenuBarConfiguration() {
        MenuBar menuBar = null;
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{MenuBar.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            try (InputStream inputStream = this.getClass().getResourceAsStream("/resources/config/MenuConfig_" + Starter.getApplication().getPlatform() + ".xml");){
                menuBar = (MenuBar)unmarshaller.unmarshal((Source)new StreamSource(inputStream), MenuBar.class).getValue();
            }
        }
        catch (IOException | JAXBException throwable) {
            this.logger.log(Level.SEVERE, "Unable to load menu configuration!", throwable);
            System.exit(1);
        }
        return menuBar;
    }

    public List<Entry> getEntriesForMenuWithID(String string) {
        List<Menu> list = this.getMenuBarConfiguration().getMenu();
        for (Menu menu : list) {
            if (!string.equals(menu.getId())) continue;
            return menu.getEntry();
        }
        return new ArrayList<Entry>();
    }

    public List<Entry> getEntriesForMenuType(MenuType menuType) {
        List<Menu> list = this.getMenuBarConfiguration().getMenu();
        for (Menu menu : list) {
            if (menu.getType() != menuType) continue;
            return menu.getEntry();
        }
        return new ArrayList<Entry>();
    }

    public Entry getEntryByID(String string) {
        if (string.equals(this.lastId)) {
            return this.lastEntry;
        }
        List<Menu> list = this.getMenuBarConfiguration().getMenu();
        for (Menu menu : list) {
            List<Entry> list2 = menu.getEntry();
            Entry entry = this.getEntryByID(list2, string);
            if (entry == null) continue;
            this.lastId = string;
            this.lastEntry = entry;
            return entry;
        }
        return null;
    }

    private Entry getEntryByID(List<Entry> list, String string) {
        if (list != null) {
            for (Entry entry : list) {
                if (string.equals(entry.getId())) {
                    return entry;
                }
                Entry entry2 = this.getEntryByID(entry.getEntry(), string);
                if (entry2 == null) continue;
                return entry2;
            }
        }
        return null;
    }
}

