/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.application;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.configuration.menuConfig.MenuConfiguration;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.listener.MacOSAdapter;
import de.oliver_matuschin.base.util.ApplicationUtilities;
import de.oliver_matuschin.system.Platform;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.text.DefaultEditorKit;

public abstract class AbstractApplication<T extends ApplicationContext<?>>
implements Runnable,
LocalizationProvider {
    private final Logger logger = Logger.getLogger(AbstractApplication.class.getName());
    private ResourceBundle baseLabelResources = null;
    private ResourceBundle labelResources = null;
    private ResourceBundle idResources = null;
    private Platform platform = Platform.UNDEFINED;
    private UIManager uiManager = null;
    private PageFormat pageFormat = null;
    private boolean defaultMenuBarVisible = false;

    public UIManager getUIManager() {
        return this.uiManager;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public abstract boolean isAgent();

    @Override
    public boolean existsLocalizedString(String string) {
        return this.labelResources.containsKey(string);
    }

    @Override
    public String getLocalizedString(String string) {
        return this.getLocalizedString(string, (Object[])null);
    }

    @Override
    public String getLocalizedString(String string, Object ... objectArray) {
        if (this.baseLabelResources.containsKey(string)) {
            return this.getLocalizedString(this.baseLabelResources, string, objectArray);
        }
        return this.getLocalizedString(this.labelResources, string, objectArray);
    }

    public String getLocalizedString(ResourceBundle resourceBundle, String string, Object ... objectArray) {
        try {
            String string2 = "_win";
            if (this.platform == Platform.MACOS) {
                string2 = "_mac";
            }
            String string3 = resourceBundle.containsKey(string + string2) ? resourceBundle.getString(string + string2) : resourceBundle.getString(string);
            string3 = objectArray != null ? MessageFormat.format(string3, objectArray) : MessageFormat.format(string3, "");
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "#" + string + "#";
        }
    }

    public String getID(String string) {
        return this.idResources.getString(string);
    }

    public Preferences getPreferences() {
        return Preferences.userRoot().node("de/oliver_matuschin/" + this.getApplicationName().replaceAll("\\s", ""));
    }

    public Preferences getGlobalPreferences() {
        return Preferences.userRoot().node("de/oliver_matuschin/application");
    }

    public boolean openURL(String string) throws IOException {
        if (Desktop.isDesktopSupported()) {
            try {
                if (string.startsWith("mailto:")) {
                    Desktop.getDesktop().mail(new URL(string).toURI());
                }
                Desktop.getDesktop().browse(new URL(string).toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                this.logger.log(Level.INFO, "Could not open url \"" + string + "\"!", uRISyntaxException);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public abstract String getApplicationName();

    public abstract double getApplicationVersion();

    public abstract VersionType getApplicationVersionType();

    public abstract T getApplicationContext();

    public int getApplicationStartupCount() {
        return this.getPreferences().getInt("applicationStartupCount", 0);
    }

    public static boolean isDebug() {
        return System.getProperty("de.oliver_matuschin.base.application.Application.isDebug", "false").equalsIgnoreCase("true");
    }

    public void init() {
        try {
            this.baseLabelResources = ResourceBundle.getBundle("resources.localized.BaseLocalizedStrings");
            this.labelResources = ResourceBundle.getBundle("resources.localized.LocalizedStrings");
            this.idResources = ResourceBundle.getBundle("resources.localized.IDs");
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (AbstractApplication.this.uiManager == null) {
                        AbstractApplication.this.uiManager = new UIManager(new MenuConfiguration());
                    }
                    if (AbstractApplication.this.getPlatform() == Platform.MACOS) {
                        try {
                            MacOSAdapter.setAppReOpenedHandler(AbstractApplication.this, AbstractApplication.class.getMethod("handleAppReOpen", new Class[0]));
                            MacOSAdapter.setAppMovedToBackgroundHandler(AbstractApplication.this, AbstractApplication.class.getMethod("handleAppMovedToBackground", new Class[0]));
                            MacOSAdapter.setAppRaisedToForegroundHandler(AbstractApplication.this, AbstractApplication.class.getMethod("handleAppRaisedToForeground", new Class[0]));
                            MacOSAdapter.setFileHandler(AbstractApplication.this, AbstractApplication.class.getMethod("handleOpenFile", String.class));
                        }
                        catch (SecurityException securityException) {
                            securityException.printStackTrace();
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            noSuchMethodException.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Logger logger = Logger.getLogger(AbstractApplication.class.getName());
            logger.fine("Shutdown process initiated by shutdown hook.");
            this.processShutdown();
        }));
    }

    @Override
    public void run() {
        this.run(new String[0]);
    }

    public abstract void run(String[] var1);

    public abstract void handleAbout();

    protected abstract void processShutdown();

    protected void manageExtensions(Path path, String string) {
        Path path2;
        if (path.toFile().exists() && path.toFile().isDirectory() && (path2 = path.resolve("install")).toFile().exists() && path2.toFile().isDirectory()) {
            Path path3;
            boolean bl = false;
            bl |= this.installNewExtensions(path, string, path2);
            if ((bl |= this.removeObsoleteExtensions(path, string)) && (path3 = path.resolve("temp")).toFile().exists() && path3.toFile().isDirectory()) {
                this.removeTemporaryExtensionFiles(path3);
            }
        }
    }

    private boolean installNewExtensions(Path path2, String string, Path path3) {
        boolean bl = false;
        try (Stream<Path> stream = Files.list(path3);){
            List list = stream.filter(path -> path.toFile().isFile() && path.getFileName().toString().endsWith(string)).collect(Collectors.toList());
            for (Path path4 : list) {
                this.moveExtension(path4, path2);
            }
            bl = !list.isEmpty();
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "Failed to read uninstalled extensions.", iOException);
        }
        return bl;
    }

    private boolean removeObsoleteExtensions(Path path, String string) {
        int n = this.getPreferences().getInt("removeExtensionCount" + string, 0);
        for (int i = 0; i < n; ++i) {
            String string2 = this.getPreferences().get("removeExtension" + string + "." + i, null);
            Path path2 = path.resolve(string2);
            if (!path2.toFile().exists() || !path2.toFile().isFile()) continue;
            try {
                Files.delete(path2);
                continue;
            }
            catch (IOException iOException) {
                this.logger.log(Level.WARNING, MessageFormat.format("Failed to remove extension \"{0}\".", path2.getFileName()), iOException);
            }
        }
        this.getPreferences().putInt("removeExtensionCount" + string, 0);
        return n > 0;
    }

    private void removeTemporaryExtensionFiles(Path path2) {
        try (Stream<Path> stream = Files.list(path2);){
            List list = stream.filter(path -> path.toFile().isFile() && path.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
            for (Path path3 : list) {
                path3.toFile().delete();
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "Failed to delete temporary files.", iOException);
        }
    }

    private void moveExtension(Path path, Path path2) {
        try {
            Files.move(path, path2.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, MessageFormat.format("Failed to move extension \"{0}\".", path.getFileName()), iOException);
        }
    }

    public abstract boolean handleQuit();

    public void handleAppReOpen() {
    }

    public void handleOpenFile(String string) {
    }

    public void handleAppRaisedToForeground() {
        if (!this.defaultMenuBarVisible) {
            this.defaultMenuBarVisible = true;
            EventQueue.invokeLater(() -> this.getUIManager().refreshDefaultMenuBar());
        }
    }

    public void handleAppMovedToBackground() {
    }

    public void handleFallbackMenuAction(String string, String string2) {
        this.logger.log(Level.WARNING, "No available methods found to handle action of the menu item with id \"{0}\" and fallback handling has not been implemented.", string);
    }

    public void handleUpdateCheck() {
        ApplicationUtilities.checkForUpdates(this.getApplicationContext(), true);
    }

    public void handleCut() {
        new DefaultEditorKit.CutAction().actionPerformed(null);
    }

    public void handleCopy() {
        new DefaultEditorKit.CopyAction().actionPerformed(null);
    }

    public void handlePaste() {
        new DefaultEditorKit.PasteAction().actionPerformed(null);
    }

    public void handleSelectAll() {
        Action[] actionArray;
        DefaultEditorKit defaultEditorKit = new DefaultEditorKit();
        for (Action action : actionArray = defaultEditorKit.getActions()) {
            if (!"select-all".equals(action.getValue("Name"))) continue;
            action.actionPerformed(null);
            return;
        }
    }

    public void handleWindowClose() {
        this.uiManager.closeCurrentWindow();
    }

    public void handleCloseAllWindows() {
        this.uiManager.closeWindows();
    }

    public void handleMinimizeWindow() {
        this.uiManager.minimizeCurrentWindow();
    }

    public void handleZoomWindow() {
        this.uiManager.zoomCurrentWindow();
    }

    public void handleShowNextWindow() {
        this.uiManager.showNextWindow();
    }

    public void handlePageSetup() {
        AbstractApplicationWindow<?> abstractApplicationWindow = this.uiManager.getFrontmostWindow();
        if (!(abstractApplicationWindow != null && abstractApplicationWindow.isVisible() && abstractApplicationWindow.isActive() && abstractApplicationWindow.isFocused())) {
            abstractApplicationWindow = null;
        }
        this.setPageFormat(PrinterJob.getPrinterJob().pageDialog(this.getPageFormat()));
        if (abstractApplicationWindow != null) {
            this.uiManager.showWindow(abstractApplicationWindow);
        }
    }

    public PageFormat getPageFormat() {
        if (this.pageFormat == null) {
            this.pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public void flushPreferences() {
        try {
            this.getPreferences().flush();
            this.getGlobalPreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {
            this.logger.log(Level.WARNING, "Could not save preferences!", backingStoreException);
        }
    }

    public static enum VersionType {
        FINAL,
        BETA,
        ALPHA;

    }
}

