/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base;

import com.github.markusbernhardt.proxy.ProxySearch;
import de.oliver_matuschin.base.application.AbstractApplication;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;

public abstract class Starter {
    private static AbstractApplication<?> appInstance;

    protected Starter() {
    }

    public static void startApplication(AbstractApplication<?> abstractApplication, String[] stringArray) {
        Starter.initLogger();
        Logger logger = Logger.getLogger(Starter.class.getName());
        appInstance = abstractApplication;
        if (abstractApplication.getPlatform() == Platform.MACOS) {
            int[] nArray = SystemUtil.getMajorMinor();
            if (nArray != null) {
                int n = nArray[0];
                int n2 = nArray[1];
                if (n == 10 && n2 < 8) {
                    logger.log(Level.SEVERE, "Cannot run on this macOS version: " + System.getProperty("os.version") + "! Minimum required is 10.8.5.");
                    System.exit(1);
                }
            } else {
                logger.log(Level.SEVERE, "Cannot determine macOS version.");
                System.exit(1);
            }
        }
        if (System.getProperty("resetDefaults", "false").equalsIgnoreCase("true")) {
            try {
                logger.log(Level.INFO, "Resetting defaults...");
                abstractApplication.getPreferences().clear();
            }
            catch (BackingStoreException backingStoreException) {
                logger.log(Level.WARNING, "Resetting defaults failed!", backingStoreException);
            }
        }
        int n = abstractApplication.getPreferences().getInt("applicationStartupCount", 0) + 1;
        abstractApplication.getPreferences().putInt("applicationStartupCount", n);
        Thread thread = new Thread(() -> {
            try {
                ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
                ProxySelector proxySelector = proxySearch.getProxySelector();
                ProxySelector.setDefault(proxySelector);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Failed to initialize proxy settings!", exception);
            }
        }, "ProxyDetection");
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        abstractApplication.init();
        abstractApplication.run(stringArray);
    }

    private static void initLogger() {
        if (new File("logging.properties").exists()) {
            try (FileInputStream fileInputStream = new FileInputStream("logging.properties");){
                LogManager.getLogManager().readConfiguration(fileInputStream);
            }
            catch (IOException iOException) {
                Logger.getLogger(Starter.class.getName()).log(Level.SEVERE, "Unable to load logging.properties!", iOException);
            }
        }
    }

    @Deprecated
    public static AbstractApplication<?> getApplication() {
        return appInstance;
    }

    static {
        System.setProperty("java.util.logging.manager", NonterminatingLogManager.class.getName());
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    public static class NonterminatingLogManager
    extends LogManager {
        static NonterminatingLogManager instance;

        public NonterminatingLogManager() {
            instance = this;
        }

        @Override
        public void reset() {
        }

        private void reset0() {
            super.reset();
        }

        public static void resetFinally() {
            instance.reset0();
        }
    }
}

