/*
 * Decompiled with CFR 0.152.
 */
package com.talkweb.svnlog.core;

import com.talkweb.svnlog.core.Log;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnLogExport {
    private static SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Map<Long, Object> cacheMap = new HashMap<Long, Object>();
    private static SVNRepository repository;

    public List<Log> readLog(String url, String name, String password, String author, String msg, String fromDate, String toDate) throws Exception {
        Vector<Log> list = new Vector<Log>();
        DAVRepositoryFactory.setup();
        long startRevision = 0L;
        long endRevision = -1L;
        try {
            repository = SVNRepositoryFactory.create(SVNURL.parseURIEncoded(url));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(name, password.toCharArray());
            repository.setAuthenticationManager(authManager);
            long lastVer = repository.getLatestRevision();
            System.out.println("SvnLog:\u5f53\u524d\u670d\u52a1\u5668\u6700\u65b0\u7248\u672c\u4e3a[" + lastVer + "]");
            Collection logEntries = null;
            if (cacheMap.get(lastVer) == null) {
                logEntries = repository.log(new String[]{""}, null, startRevision, endRevision, true, true);
                cacheMap.put(lastVer, logEntries);
            } else {
                logEntries = (Collection)cacheMap.get(lastVer);
            }
            int i = 1;
            for (SVNLogEntry logEntry : logEntries) {
                if (logEntry.getChangedPaths().size() <= 0) continue;
                Set<String> changedPathsSet = logEntry.getChangedPaths().keySet();
                Iterator<String> changedPaths = changedPathsSet.iterator();
                while (changedPaths.hasNext()) {
                    SVNLogEntryPath entryPath = logEntry.getChangedPaths().get(changedPaths.next());
                    Log log = new Log();
                    log.setId(String.valueOf(i));
                    log.setAuthor(logEntry.getAuthor());
                    log.setMessage(logEntry.getMessage());
                    log.setOpType(String.valueOf(entryPath.getType()));
                    log.setPath(entryPath.getPath());
                    log.setDate(sf.format(logEntry.getDate()));
                    log.setDate1(logEntry.getDate());
                    String[] arr = author.split(",");
                    if ("".equals(author) && fromDate.equals("") && toDate.equals("") && "".equals(msg)) {
                        list.add(log);
                    }
                    if (!"".equals(author) && "".equals(fromDate) && "".equals(toDate) && "".equals(msg) && this.isFitAuthor(log.getAuthor(), arr, arr.length - 1)) {
                        list.add(log);
                    }
                    if ("".equals(author) && !"".equals(fromDate) && !"".equals(toDate) && "".equals(msg) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), fromDate) >= 0 && SvnLogExport.compare_date(sf.format(logEntry.getDate()), toDate) <= 0) {
                        list.add(log);
                    }
                    if (!"".equals(author) && !"".equals(fromDate) && !"".equals(toDate) && "".equals(msg) && this.isFitAuthor(log.getAuthor(), arr, arr.length - 1) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), fromDate) >= 0 && SvnLogExport.compare_date(sf.format(logEntry.getDate()), toDate) <= 0) {
                        list.add(log);
                    }
                    if (!"".equals(author) && !"".equals(fromDate) && "".equals(toDate) && "".equals(msg) && this.isFitAuthor(log.getAuthor(), arr, arr.length - 1) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), fromDate) >= 0) {
                        list.add(log);
                    }
                    if (!"".equals(author) && !"".equals(toDate) && "".equals(fromDate) && "".equals(msg) && this.isFitAuthor(log.getAuthor(), arr, arr.length - 1) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), toDate) <= 0) {
                        list.add(log);
                    }
                    if ("".equals(author) && !"".equals(fromDate) && "".equals(toDate) && "".equals(msg) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), fromDate) >= 0) {
                        list.add(log);
                    }
                    if ("".equals(author) && !"".equals(toDate) && "".equals(fromDate) && "".equals(msg) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), toDate) <= 0) {
                        list.add(log);
                    }
                    if ("".equals(author) && fromDate.equals("") && toDate.equals("") && !"".equals(msg) && log.getMessage().contains(msg.trim())) {
                        list.add(log);
                    }
                    if (!"".equals(author) && "".equals(fromDate) && "".equals(toDate) && !"".equals(msg) && this.isFitAuthor(log.getAuthor(), arr, arr.length - 1) && log.getMessage().contains(msg.trim())) {
                        list.add(log);
                    }
                    if ("".equals(author) && !"".equals(fromDate) && !"".equals(toDate) && !"".equals(msg) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), fromDate) >= 0 && SvnLogExport.compare_date(sf.format(logEntry.getDate()), toDate) <= 0 && log.getMessage().contains(msg.trim())) {
                        list.add(log);
                    }
                    if (!"".equals(author) && !"".equals(fromDate) && !"".equals(toDate) && !"".equals(msg) && this.isFitAuthor(log.getAuthor(), arr, arr.length - 1) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), fromDate) >= 0 && SvnLogExport.compare_date(sf.format(logEntry.getDate()), toDate) <= 0 && log.getMessage().contains(msg.trim())) {
                        list.add(log);
                    }
                    if (!"".equals(author) && !"".equals(fromDate) && "".equals(toDate) && !"".equals(msg) && this.isFitAuthor(log.getAuthor(), arr, arr.length - 1) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), fromDate) >= 0 && log.getMessage().contains(msg.trim())) {
                        list.add(log);
                    }
                    if (!"".equals(author) && !"".equals(toDate) && "".equals(fromDate) && !"".equals(msg) && this.isFitAuthor(log.getAuthor(), arr, arr.length - 1) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), toDate) <= 0 && log.getMessage().contains(msg.trim())) {
                        list.add(log);
                    }
                    if ("".equals(author) && !"".equals(fromDate) && "".equals(toDate) && !"".equals(msg) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), fromDate) >= 0 && log.getMessage().contains(msg.trim())) {
                        list.add(log);
                    }
                    if ("".equals(author) && !"".equals(toDate) && "".equals(fromDate) && !"".equals(msg) && SvnLogExport.compare_date(sf.format(logEntry.getDate()), toDate) <= 0 && log.getMessage().contains(msg.trim())) {
                        list.add(log);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception();
        }
        Collections.reverse(list);
        return list;
    }

    public boolean isFitAuthor(String author, String[] arr, int index) {
        if (index == 0) {
            return author.contains(arr[index]);
        }
        return author.contains(arr[index]) || this.isFitAuthor(author, arr, index - 1);
    }

    public static int compare_date(String now, String date) {
        Date dt2;
        Date dt1;
        block4: {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                dt1 = df.parse(now);
                dt2 = df.parse(date);
                if (dt1.getTime() <= dt2.getTime()) break block4;
                return 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }
        if (dt1.getTime() < dt2.getTime()) {
            return -1;
        }
        return 0;
    }

    public static void closeConnction() {
        System.out.println("SvnLog:\u6e05\u7a7a\u7f13\u5b58cacheMap[" + Arrays.toString(cacheMap.keySet().toArray()) + "]");
        cacheMap.clear();
        repository.closeSession();
        System.out.println("SvnLog:\u5173\u95ed\u5f53\u524d[" + repository.getLocation() + "]\u8fde\u63a5");
    }
}

