/*
 * Decompiled with CFR 0.152.
 */
package com.talkweb.svnlog.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class Config {
    private ResourceBundle resBundle;
    private String filepath;

    public Config(String filepath) {
        this.filepath = filepath;
        try {
            this.resBundle = ResourceBundle.getBundle(filepath);
        }
        catch (Exception e) {
            this.createProperties(filepath);
        }
    }

    public Config() {
    }

    public String getProperValue(String keyName) {
        String configValue = null;
        if (configValue == null) {
            try {
                configValue = this.resBundle.getString(keyName);
            }
            catch (Exception e) {
                configValue = null;
            }
        }
        return configValue;
    }

    public void createProperties(String path) {
        OutputStream out = null;
        try {
            try {
                out = new FileOutputStream("." + File.separator + this.filepath + ".properties");
                out.flush();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setProperValue(Map<String, String> valueMap) {
        String url = valueMap.get("url");
        String id = url.substring(url.lastIndexOf("/") + 1);
        File f = new File("./config_" + id + ".properties");
        if (!f.exists()) {
            this.filepath = "config_" + id;
            this.createProperties(this.filepath);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream("." + File.separator + this.filepath + ".properties");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        InputStream in = this.getResourceAsStream(String.valueOf(this.filepath) + ".properties", this.getClassLoaders(null));
        Properties prop = new Properties();
        try {
            try {
                prop.load(in);
                in.close();
                for (String key : valueMap.keySet()) {
                    prop.setProperty(key, valueMap.get(key));
                }
                prop.store(out, "modify");
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public InputStream getResourceAsStream(String resource, ClassLoader[] classLoader) {
        ClassLoader[] classLoaderArray = classLoader;
        int n = classLoader.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader cl = classLoaderArray[n2];
            if (cl != null) {
                InputStream returnValue = cl.getResourceAsStream(resource);
                if (returnValue == null) {
                    returnValue = cl.getResourceAsStream("/" + resource);
                }
                if (returnValue != null) {
                    return returnValue;
                }
            }
            ++n2;
        }
        return null;
    }

    public ClassLoader[] getClassLoaders(ClassLoader classLoader) {
        return new ClassLoader[]{classLoader, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader(), ClassLoader.getSystemClassLoader()};
    }

    public ResourceBundle getResBundle() {
        return this.resBundle;
    }
}

