local AddonName, AddonTable = ...
local Name, Title, Description = GetAddOnInfo(AddonName)
local Version = GetAddOnMetadata(AddonName, "Version")
local SoundPack = SuperDuperSoundPackEngine.Register(Name, Title, Description, Version)
if not SoundPack then return end
local SOUND = "Interface\\AddOns\\"..AddonName.."\\Sounds\\"
local MUSIC = "Interface\\AddOns\\"..AddonName.."\\Music\\"

-- All variables that do not require a number may be a file location string, a table of file location strings or nil

SoundPack.start_up = SOUND.."sm64_memario.ogg"

SoundPack.enter_or_leave_pve_instance = SOUND.."nsmb_pipe.ogg"

SoundPack.enter_pvp_instance = SOUND.."smb3_stagestart.ogg"

SoundPack.full_combo_points_or_rage = SOUND.."smb3_pmeter.ogg"
SoundPack.full_combo_points_or_rage_repeat_time = 0.8

SoundPack.toggle_game_or_options_menu = SOUND.."nsmb_pause.ogg"

SoundPack.slash_command_or_option_save = SOUND.."smw_message.ogg"

SoundPack.mount = SOUND.."smw_yoshi.ogg"

SoundPack.dismount = SOUND.."yoshihit.ogg"

SoundPack.kill_shot = SOUND.."smb_stomp.ogg"

SoundPack.shape_shift = SOUND.."smw_transform.ogg"

SoundPack.buff_on_self = SOUND.."smb3_powerup.ogg"

SoundPack.debuff_on_self = SOUND.."smw_powerdown.ogg"

SoundPack.target_spell_damage_from_self = SOUND.."nsmb_fireball.ogg"

SoundPack.target_swing_damage_from_self = SOUND.."smb3_tail.ogg"

SoundPack.target_range_damage_from_self = SOUND.."smw_kick.ogg"

SoundPack.honor_or_xp_gained = SOUND.."smb3_coin.ogg"

SoundPack.skill_increase = SOUND.."smw_1-up.ogg"

SoundPack.level_up_ding = SOUND.."smb3_1-up.ogg"

SoundPack.level_up_chime = SOUND.."Win_smb3king.mp3"
SoundPack.level_up_chime_play_time = 7.5
SoundPack.level_up_chime_delay_time = 2

SoundPack.targeted_boss_reached_low_health = SOUND.."smb_warning.ogg"
SoundPack.targeted_boss_reached_low_health_play_time = 3

SoundPack.swim = SOUND.."smw_swim.ogg"
SoundPack.swim_repeat_time = 0.6

SoundPack.jump_max_repeat_time = 0.6
SoundPack.regular_jump = SOUND.."smb3_jump.ogg"
SoundPack.mounted_jump = SOUND.."smw_jump.ogg"
SoundPack.gnome_jump = SOUND.."smb_jumpsmall.ogg"
SoundPack.elf_jump = {
	SOUND.."smb3_jump.ogg",
	SOUND.."smb3_jump.ogg",
	SOUND.."smw_spinjump.ogg",
}

SoundPack.immunity_buff_on_self = SOUND.."star.mp3"
SoundPack.immunity_buff_on_self_repeat_time = 3.15

SoundPack.group_wipe = SOUND.."smb_gameover.ogg"
SoundPack.group_wipe_play_time = 3.5
SoundPack.group_wipe_delay_time = 0

SoundPack.boss_died = SOUND.."Flag_Super_Mario_Bros.mp3"
SoundPack.boss_died_play_time = 6
SoundPack.boss_died_delay_time = 3

SoundPack.helped_kill_a_player = SOUND.."sm64_thank_you.ogg"
SoundPack.helped_kill_a_player_play_time = 2.5
SoundPack.helped_kill_a_player_delay_time = 1

SoundPack.self_died = SOUND.."nsmb_death.ogg"
SoundPack.self_died_play_time = 3
SoundPack.self_died_delay_time = 0

SoundPack.arena_victory = SOUND.."smw_course_clear_2.mp3"
SoundPack.arena_victory_play_time = 10
SoundPack.arena_victory_delay_time = 0

SoundPack.battleground_victory = SOUND.."smb3_victory.mp3"
SoundPack.battleground_victory_play_time = 5
SoundPack.battleground_victory_delay_time = 0

SoundPack.lost_battleground = SOUND.."smw_gameover.mp3"
SoundPack.lost_battleground_play_time = 7
SoundPack.lost_battleground_delay_time = 0

SoundPack.achievement_earned = SOUND.."smas-smb3_goal.ogg"
SoundPack.achievement_earned_play_time = 3
SoundPack.achievement_earned_delay_time = 0



SoundPack.reset_multi_track_music_delay_time = 300

SoundPack.music_targeted_boss_with_low_health = {
	MUSIC.."Speed_Mario_2.mp3",
	MUSIC.."Speed_Mario_Techno_Remix.mp3",
	MUSIC.."Speed_smb.mp3",
}

SoundPack.music_swimming = MUSIC.."Underwater.mp3"

SoundPack.music_flying = MUSIC.."Coin_Heaven_1.mp3"

SoundPack.music_in_vehicle = MUSIC.."Kart_Circuit.mp3"

SoundPack.music_pve_instance = {
	MUSIC.."Dungeon_1.mp3",
	MUSIC.."Dungeon_Underworld_SMB3.mp3",
	MUSIC.."Dungeon_undworld_funk_sm3.mp3",
}

SoundPack.music_pve_instance_in_combat = {
	MUSIC.."Castle_1.mp3",
	MUSIC.."Castle_king_coopa.mp3",
	MUSIC.."Castle_Remix_SMB.mp3",
	MUSIC.."Castle_supermario.mp3",
}

SoundPack.music_in_combat = MUSIC.."Battle_mb.mp3"

SoundPack.music_resting = {
	MUSIC.."sm64_title.mp3",
	MUSIC.."smas_selectgame.mp3",
}

SoundPack.music_mounted = MUSIC.."Mounted_smw_ovr1_2.mp3"

SoundPack.music_regular = {
	MUSIC.."Overworld_da_smb3.mp3",
	MUSIC.."Overworld_Remix_SMB.mp3",
	MUSIC.."Overworld_smb.mp3",
	MUSIC.."Overworld_Super_Mario_Brothers_Tropical_Mix.mp3",
}
