Scriptname CUYC_TorchBashScript extends activemagiceffect

Actor Victim

Actor Property PlayerREF Auto

ObjectReference Property BurnSource Auto hidden
ObjectReference Property HeatSource Auto hidden

Faction Property BanditFaction Auto
Faction Property WarlockFaction Auto
Faction Property DraugrFaction Auto
Faction Property VampireFaction Auto
Faction Property HagravenFaction Auto
Faction Property GiantFaction Auto
Faction Property DragonFaction Auto
Faction Property MammothFaction Auto

GlobalVariable Property CUYC_HeatSourcePlacedGlobal Auto
GlobalVariable Property CUYC_BurnSourcePlacedGlobal Auto
GlobalVariable Property CUYC_ModActiveGlobal Auto
GlobalVariable Property CUYC_HelpMessagesActiveGlobal Auto
GlobalVariable Property CUYC_IsBurningGlobal Auto
GlobalVariable Property CUYC_VampireActive Auto
GlobalVariable Property CUYC_MoneyCountGlobal Auto

Spell Property HazardFireSpell Auto

EffectShader Property FireFXTrapShader Auto
EffectShader Property FireCloakFXShader Auto
EffectShader Property FireFXShader Auto
EffectShader Property EnchFireFXShader Auto
EffectShader Property EnchArmorFireFXS Auto

Hazard Property FireBarrierHazard Auto

Potion Property CUYC_BrandAccelerator Auto

Ingredient Property vampireDust Auto
Ingredient Property BoneMeal Auto

Light Property LightCampFire01 Auto

Activator Property CUYC_BurnTrigger Auto

Container Property CUYC_BurnedBody05 Auto

Keyword Property ActorTypeAnimal Auto
Keyword Property ActorTypeCreature Auto
Keyword Property ActorTypeDwarven Auto
Keyword Property vampire Auto

FormList Property CUYC_GiantRaceFormlist Auto
FormList Property CUYC_LargeRaceFormlist Auto
FormList Property CUYC_MediumRaceFormlist Auto
FormList Property CUYC_SmallRaceFormlist Auto
FormList Property CUYC_DeathHoundFormlist Auto

Sound Property CUYC_VampireBurningStandUp Auto

Event OnEffectStart(Actor Target, Actor Caster)

	If CUYC_ModActiveGlobal.GetValueInt() == 1					; is the mod activated via MCM?

		Victim = Target								; make target available in other event/function sections
	
		;=====Start of the 'check for dead' Block 

		If Target.IsDead() && !Target.HasKeyWord(ActorTypeDwarven)

		;======applie CUYC burn corpse  effect once aka if activation is not blocked=====
		
			If !Target.IsActivationBlocked()

				Target.BlockActivation(PlayerREF)
				FireOnCorpseEffect()

			ElseIf Target.IsActivationBlocked()

				;Do nothing!

			EndIf

		;=====applie vanilla torch bash damage=====

		ElseIf Target.IsDead() && Target.HasKeyword(ActorTypeDwarven)
			
			If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
				Debug.Messagebox("You're not a Forge!")
			ElseIf CUYC_HelpMessagesActiveGlobal .GetValueInt() == 0
			EndIf
	
		ElseIf !Target.IsDead()

			;Do nothing!

		EndIf

	ElseIf CUYC_ModActiveGlobal.GetValueInt() == 0

		;Do nothing!

	EndIf

EndEvent

Function FireOnCorpseEffect()

	CUYC_IsBurningGlobal.SetValue(1)			; failsafe so you can't manipulate dead body while burning

	;=====fire effect shader block, also applying fire hazard=====

	Int BurnLength = Victim.GetItemCount(CUYC_BrandAccelerator) * 30 as Int		; check for numbers of brand accelerators + 30 (seconds), normal burn length without brandacc = 30 seconds
	FireFXTrapShader.Play(Victim, BurnLength)
	FireCloakFXShader.Play(Victim, BurnLength)
	FireFXShader.Play(Victim, BurnLength)
	EnchFireFXShader.Play(Victim, BurnLength)
	EnchArmorFireFXS.Play(Victim, BurnLength)
	Victim.PlaceAtMe(FireBarrierHazard)

	;=====burn source block, applying extra damage buff when brand accelerator used=====

	Int BurnSourceActive = CUYC_BurnSourcePlacedGlobal.GetValueInt()		; extra buff on fire damage when brand accelerator applied

	If Victim.GetItemCount(CUYC_BrandAccelerator) >= 1
		If BurnSourceActive == 0
			BurnSource = Victim.PlaceAtMe(CUYC_BurnTrigger)
			CUYC_BurnSourcePlacedGlobal.SetValue(1)							; fail safe so that buffing hazard won't get placed again and thus causing persistance bug 
		ElseIf BurnSourceActive == 1
		EndIf
	EndIf

	;=====heat source block, applying Frostfall compatibility heat source=====

	Int HeatSourceActive = CUYC_HeatSourcePlacedGlobal.GetValueInt()		; bug fix to remove persistent light sources

	If HeatSourceActive == 0
		HeatSource = Victim.PlaceAtMe(LightCampfire01)
		CUYC_HeatSourcePlacedGlobal.SetValue(1)
	ElseIf HeatSourceActive == 1
	EndIf

	;=====special block to make Vampires stand up and run around in panic unti lburned to ashes=====

	If CUYC_VampireActive.GetValueInt() == 1 && Victim.HasKeyword(vampire)

		Debug.SendAnimationEvent(Victim, "GetUpBegin")
		CUYC_VampireBurningStandUp.Play(Victim)
		Utility.Wait(3.5)
		CUYC_VampireBurningStandUp.Play(Victim)
		Utility.Wait(3.0)
		Debug.SendAnimationEvent(Victim, "IdleKneeling")
		Utility.Wait(1.0)
		CUYC_VampireBurningStandUp.Play(Victim)
		Utility.Wait(1)
		Victim.Resurrect()
		Utility.Wait(0.1)
		Victim.SetAV("Confidence", 0)
		PlayerREF.PushActorAway(Victim, 0.0)
		Victim.ApplyHavokImpulse(0.0, 0.0, 5.0, 500.0)
		Utility.Wait(1.5)
		CUYC_VampireBurningStandUp.Play(Victim)
		Victim.KillSilent()
		Utility.Wait(BurnLength - 10.1)

	ElseIf CUYC_VampireActive.GetValueInt() == 0 || !Victim.HasKeyword(vampire)

		Utility.Wait(BurnLength)

	EndIf


	;=====remove corpse from world block after fire shader finished=====

	Victim.SetDontMove()
	Victim.EnableAI(false)
	Victim.KillSilent()
	Victim.SetCriticalStage(Victim.CritStage_DisintegrateEnd)
	Victim.EnableAI()		; fail safe so that respawning actors won't freeze

	;=====Go to actor type recognition section=====

	DefineActorType()

EndFunction

Function DefineActorType()

	;=====Vampire and Human Actors====

	If !Victim.HasKeyword(vampire) && !Victim.HasKeyword(ActorTypeAnimal) && !Victim.HasKeyword(ActorTypeCreature)

		Victim.AttachAshPile(CUYC_BurnedBody05)										; places barbecue burned body for Human actor
		Victim.RemoveAllItems()															; make sure there's nothing left in the burned body

	ElseIf Victim.HasKeyword(vampire)

		Victim.AttachAshPile()															; places ash pile for Vampire actor
		Victim.RemoveAllItems()
		Victim.AddItem(vampireDust, 1)													; burned Vampire = vampire dust, makes sense, doesn't it?

	ElseIf Victim.HasKeyword(ActorTypeAnimal) || Victim.HasKeyword(ActorTypeCreature)

		If CUYC_GiantRaceFormlist.HasForm(Victim.GetRace())
			Victim.AttachAshPile()
			Victim.RemoveAllItems()
			Victim.AddItem(Bonemeal, 6, true)
		ElseIf CUYC_LargeRaceFormlist.HasForm(Victim.GetRace())
			Victim.AttachAshPile()
			Victim.RemoveAllItems()
			Victim.AddItem(Bonemeal, 4, true)
		ElseIf CUYC_MediumRaceFormlist.HasForm(Victim.GetRace())
			Victim.AttachAshPile()
			Victim.RemoveAllItems()
			Victim.AddItem(Bonemeal, 2, true)
		ElseIf CUYC_SmallRaceFormlist.HasForm(Victim.GetRace())
			Victim.AttachAshPile()
			Victim.RemoveAllItems()
			Victim.AddItem(Bonemeal, 1, true)
		ElseIf CUYC_DeathHoundFormlist.HasForm(Victim.GetRace())
			Victim.AttachAshPile()
			Victim.RemoveAllItems()
			Victim.AddItem(VampireDust, 1, true)
		EndIf

	EndIf

	;=====final block, removing activation block, heat source and burn source, also setting globals back to 0=====

	Victim.BlockActivation(false)
	HeatSource.Disable()
	HeatSource.Delete()
	BurnSource.Disable()
	BurnSource.Delete()	
	CUYC_HeatSourcePlacedGlobal.SetValue(0)
	CUYC_BurnSourcePlacedGlobal.SetValue(0)
	CUYC_IsBurningGlobal.SetValue(0)

	If Victim.IsInFaction(BanditFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 10)
		Debug.Notification("10 Gold added to reward!")
	ElseIf Victim.IsInFaction(WarlockFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 15)
		Debug.Notification("15 Gold added to reward!")
	ElseIf Victim.IsInFaction(DraugrFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 25)
		Debug.Notification("25 Gold added to reward!")
	ElseIf Victim.IsInFaction(VampireFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 50)
		Debug.Notification("50 Gold added to reward!")
	ElseIf Victim.HasKeyword(ActorTypeAnimal) && !Victim.IsInFaction(MammothFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 5)
		Debug.Notification("5 Gold added to reward!")
	ElseIf Victim.IsInFaction(HagravenFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 25)
		Debug.Notification("25 Gold added to reward!")
	ElseIf Victim.IsInFaction(MammothFaction) || Victim.IsInFaction(GiantFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 50)
		Debug.Notification("50 Gold added to reward!")
	ElseIf Victim.IsInFaction(DragonFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 100)
		Debug.Notification("100 Gold added to reward!")
	Else
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 1)
		Debug.Notification("1 Gold added to reward!")
	EndIf

EndFunction