Scriptname CUYC_TombstoneReplacementScirpt extends ObjectReference

String TombstoneText

String Property CUYC_CorpseName  Auto  
String Property CUYC_CorpseDoD Auto 
CUYC_TombStoneStringVarsScript Property TombStoneQuest Auto 
Actor Property CUYC_DeadActor  Auto
Actor Property PlayerREF Auto
Activator Property CUYC_TombStone2 Auto
Activator Property CUYC_TombStone3 Auto
Activator Property CUYC_TombStone4 Auto
Activator Property CUYC_TombStone5 Auto
Book Property CUYC_TombstoneNote1 Auto
Book Property CUYC_TombstoneNote2 Auto
Book Property CUYC_TombstoneNote3 Auto
Book Property CUYC_TombstoneNote4 Auto
Message Property CUYC_ChangeTombStoneInitMessage Auto
Message Property CUYC_ChangeTombStoneProcessMessage Auto
Message Property CUYC_RewriteTombStoneMessage Auto
GlobalVariable Property CUYC_TombStoneReplaceAllowed Auto
GlobalVariable Property CUYC_IsInPlacement Auto
Sound Property CUYC_CartArrive Auto
Sound Property CUYC_CartExit Auto
Sound Property CUYC_ShovelDigSD Auto

Event OnInit()
	If (!CUYC_CorpseName)
		CUYC_CorpseName = TombStoneQuest.CUYC_CorpseName
		CUYC_CorpseDoD = TombStoneQuest.CUYC_CorpseDoD
		CUYC_DeadActor = TombStoneQuest.CUYC_DeadActor 
	EndIf
EndEvent

Event OnActivate(ObjectReference akActionRef)

	If CUYC_IsInPlacement.GetValueInt() == 1
	ElseIf CUYC_IsInPlacement.GetValueInt() == 0
		If akActionRef == PlayerREF
			If PlayerREF.GetItemCount(CUYC_TombstoneNote1) >= 1 || PlayerREF.GetItemCount(CUYC_TombstoneNote2) >= 1 || PlayerREF.GetItemCount(CUYC_TombstoneNote3) >= 1 || PlayerREF.GetItemCount(CUYC_TombstoneNote4) >= 1
				Int ButtonTomb = CUYC_ChangeTombStoneInitMessage.show() as Int
				If ButtonTomb == 0
					If CUYC_TombStoneReplaceAllowed.GetValueInt() == 0
						Debug.Messagebox("This tombstone stands here since ages. You can't replace it!")
					ElseIf CUYC_TombStoneReplaceAllowed.GetValueInt() == 1
						HandleReplacement()
					EndIf
				ElseIf ButtonTomb == 1
					HandleReview()
				ElseIf ButtonTomb == 2
					HandleRewrite()
				EndIf				
			Else
				Int ButtonTomb2 = CUYC_RewriteTombStoneMessage.show() as Int
				If ButtonTomb2 == 0
					HandleReview()
				ElseIf ButtonTomb2 == 1
					HandleRewrite()
				EndIf
			EndIf
		EndIf
	EndIf

EndEvent

Function HandleReview()
	Int Index1 = StringUtil.Find(CUYC_CorpseDoD, " ")
	String Burried = StringUtil.Substring(CUYC_CorpseDoD, 0, Index1) 
	;Debug.MessageBox("Here Rests in Peace, our beloved " + CUYC_CorpseName + "\n\nBurried at " + Burried + "\n\n may you find your haven in Sovengard")
	Debug.MessageBox(CUYC_CorpseName + " + " + Burried + " + " + "\n\n" + TombstoneText)
EndFunction

Function HandleReplacement()
	Int ButtonReplacement =  CUYC_ChangeTombStoneProcessMessage.show() as Int
	If ButtonReplacement == 0
		If PlayerREF.GetItemCount(CUYC_TombstoneNote1) >= 1
			Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
			Game.FadeOutGame(false, true, 17.0, 5.0)
			CUYC_CartArrive.play(PlayerREF)
			Utility.Wait(3.5)
			CUYC_CartExit.play(PlayerREF)
			Utility.Wait(3.5)
			int instanceID = CUYC_ShovelDigSD.play(PlayerREF)
			Self.Disable()
			Self.Delete()
			Self.PlaceAtMe(CUYC_Tombstone2)
			PlayerREF.RemoveItem(CUYC_TombstoneNote1, 1, true)
			Utility.Wait(2)
			Sound.StopInstance(instanceID)
			Game.EnablePlayerControls()
		ElseIf PlayerREF.GetItemCount(CUYC_TombstoneNote1) < 1
			Debug.Messagebox("You don't own a license for this tombstone variant!")
		EndIf
	ElseIf ButtonReplacement == 1
		If PlayerREF.GetItemCount(CUYC_TombstoneNote2) >= 1
			Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
			Game.FadeOutGame(false, true, 17.0, 5.0)
			CUYC_CartArrive.play(PlayerREF)
			Utility.Wait(3.5)
			CUYC_CartExit.play(PlayerREF)
			Utility.Wait(3.5)
			int instanceID = CUYC_ShovelDigSD.play(PlayerREF)
			Self.Disable()
			Self.Delete()
			Self.PlaceAtMe(CUYC_Tombstone3)
			PlayerREF.RemoveItem(CUYC_TombstoneNote2, 1, true)
			Utility.Wait(2)
			Sound.StopInstance(instanceID)
			Game.EnablePlayerControls()
		ElseIf PlayerREF.GetItemCount(CUYC_TombstoneNote2) < 1
			Debug.Messagebox("You don't own a license for this tombstone variant!")
		EndIf
	ElseIf ButtonReplacement == 2
		If PlayerREF.GetItemCount(CUYC_TombstoneNote3) >= 1
			Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
			Game.FadeOutGame(false, true, 17.0, 5.0)
			CUYC_CartArrive.play(PlayerREF)
			Utility.Wait(3.5)
			CUYC_CartExit.play(PlayerREF)
			Utility.Wait(3.5)
			int instanceID = CUYC_ShovelDigSD.play(PlayerREF)
			Self.Disable()
			Self.Delete()
			Self.PlaceAtMe(CUYC_Tombstone4)
			PlayerREF.RemoveItem(CUYC_TombstoneNote3, 1, true)
			Utility.Wait(2)
			Sound.StopInstance(instanceID)
			Game.EnablePlayerControls()
		ElseIf PlayerREF.GetItemCount(CUYC_TombstoneNote3) < 1
			Debug.Messagebox("You don't own a license for this tombstone variant!")
		EndIf
	ElseIf ButtonReplacement == 3
		If PlayerREF.GetItemCount(CUYC_TombstoneNote4) >= 1
			Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
			Game.FadeOutGame(false, true, 17.0, 5.0)
			CUYC_CartArrive.play(PlayerREF)
			Utility.Wait(3.5)
			CUYC_CartExit.play(PlayerREF)
			Utility.Wait(3.5)
			int instanceID = CUYC_ShovelDigSD.play(PlayerREF)
			Self.Disable()
			Self.Delete()
			Self.PlaceAtMe(CUYC_Tombstone5)
			PlayerREF.RemoveItem(CUYC_TombstoneNote4, 1, true)
			Utility.Wait(2)
			Sound.StopInstance(instanceID)
			Game.EnablePlayerControls()
		ElseIf PlayerREF.GetItemCount(CUYC_TombstoneNote4) < 1
			Debug.Messagebox("You don't own a license for this tombstone variant!")
		EndIf
	EndIf
EndFunction

Function HandleRewrite()

	TombstoneText = ((Self as Form) as UILIB_1).ShowTextInput("Enter your Tombstone Text", "...") as String
	If TombstoneText != ""
		Int Index1 = StringUtil.Find(CUYC_CorpseDoD, " ")
		String Burried = StringUtil.Substring(CUYC_CorpseDoD, 0, Index1) 
	EndIf

EndFunction