Scriptname CUYC_ShovelScript extends activemagiceffect

Activator Property CUYC_TombStone Auto
Activator Property CUYC_Heap Auto
Actor Property PlayerREF Auto
CUYC_TombStoneStringVarsScript Property TombStoneQuest Auto
Faction Property BanditFaction Auto
Faction Property WarlockFaction Auto
Faction Property DraugrFaction Auto
Faction Property VampireFaction Auto
Faction Property HagravenFaction Auto
Faction Property GiantFaction Auto
Faction Property DragonFaction Auto
Faction Property MammothFaction Auto
GlobalVariable Property CUYC_ModActiveGlobal Auto
GlobalVariable Property CUYC_IsBurningGlobal Auto
GlobalVariable Property CUYC_HelpMessagesActiveGlobal Auto
GlobalVariable Property CUYC_TombStoneReplaceAllowed Auto
GlobalVariable Property CUYC_MoneyCountGlobal Auto
Keyword Property ActorTypeNPC Auto
Keyword Property ActorTypeAnimal Auto
Keyword Property ActorTypeCreature Auto
Keyword Property ActorTypeDwarven Auto
ObjectReference CUYC_TombStonePosition
Sound Property CUYC_ShovelDigSD Auto
MiscObject Property BYOHMaterialClay Auto

Actor Victim

Event OnEffectStart(Actor akTarget, Actor akCaster)

	If CUYC_ModActiveGlobal.GetValueInt() == 1			; is the mod active?

		Victim = akTarget			; transport to all functions

		;=====Human NPC & Vampires=====

		If akTarget.IsDead() && akTarget.HasKeyword(ActorTypeNPC)

			If CUYC_IsBurningGlobal.GetValueInt() == 1

				If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
					Debug.Messagebox("This corpse is burning, you can't bury it!")
				ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
				EndIf

			ElseIf CUYC_IsBurningGlobal.GetValueInt() == 0
				If Victim.GetItemCount(BYOHMaterialClay) >= 1
					HandleHumanHeap()
				ElseIf Victim.GetItemCount(BYOHMaterialClay) <= 0
					HandleHuman()
				EndIf
			EndIf
		EndIf

		;=====Creatures&Animals=====

		If akTarget.IsDead() && (akTarget.HasKeyword(ActorTypeAnimal) || akTarget.HasKeyword(ActorTypeCreature) || akTarget.HasKeyword(ActorTypeDwarven))

			If CUYC_IsBurningGlobal.GetValueInt() == 1

				If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
					Debug.Messagebox("This Carcass is burning, you can't bury it!")
				ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
				EndIf

			ElseIf CUYC_IsBurningGlobal.GetValueInt() == 0
				HandleCreature()
			EndIf

		EndIf

	ElseIf CUYC_ModActiveGlobal.GetValueInt() == 0

		;Do nothing!

	EndIf

EndEvent

Function HandleHuman()

	Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
	Game.FadeOutGame(false, true, 3.0, 5.0)
	int instanceID = CUYC_ShovelDigSD.play(PlayerREF)
	Victim.SetCriticalStage(Victim.CritStage_DisintegrateEnd)
	String ActorName = Victim.GetBaseObject().GetName()
	TombStoneQuest.CUYC_CorpseName = ActorName
	TombStoneQuest.CUYC_CorpseDoD = Utility.GameTimeToString(math.Ceiling(Utility.GetCurrentGameTime()) + 31)
	TombStoneQuest.CUYC_DeadActor = Victim
	TombStoneQuest.CUYC_DeadActorWeapon = Victim.GetEquippedWeapon()
	CUYC_TombStonePosition = Victim.PlaceAtMe(CUYC_TombStone)
	CUYC_TombStonePosition.SetPosition(CUYC_TombStonePosition.GetPositionX(), CUYC_TombStonePosition.GetPositionY(), CUYC_TombStonePosition.GetPositionZ())
	CUYC_TombStonePosition.SetAngle(Utility.RandomInt(-5, 5), Utility.RandomInt(-5, 5), CUYC_TombStonePosition.GetAngleZ())
	Utility.Wait(2)
	Sound.StopInstance(instanceID)
	Game.EnablePlayerControls()
	PlayerREF.DrawWeapon()
	CUYC_TombStoneReplaceAllowed.SetValueInt(1)
	Utility.Wait(10)
	CUYC_TombStoneReplaceAllowed.SetValueInt(0)

	If Victim.IsInFaction(BanditFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 10)
		Debug.Notification("10 Gold added to reward!")
	ElseIf Victim.IsInFaction(WarlockFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 15)
		Debug.Notification("15 Gold added to reward!")
	ElseIf Victim.IsInFaction(DraugrFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 25)
		Debug.Notification("25 Gold added to reward!")
	ElseIf Victim.IsInFaction(VampireFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 50)
		Debug.Notification("50 Gold added to reward!")
	Else
		;CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 5)
		;Debug.Notification("5 Gold added to reward!")
	EndIf

EndFunction

Function HandleHumanHeap()

	Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
	Game.FadeOutGame(false, true, 3.0, 5.0)
	int instanceID = CUYC_ShovelDigSD.play(PlayerREF)
	Victim.SetCriticalStage(Victim.CritStage_DisintegrateEnd)
	TombStoneQuest.CUYC_DeadActor = Victim
	TombStoneQuest.CUYC_DeadActorWeapon = Victim.GetEquippedWeapon()
	Victim.PlaceAtMe(CUYC_Heap)
	Utility.Wait(2)
	Sound.StopInstance(instanceID)
	Game.EnablePlayerControls()
	PlayerREF.DrawWeapon()

	If Victim.IsInFaction(BanditFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 10)
		Debug.Notification("10 Gold added to reward!")
	ElseIf Victim.IsInFaction(WarlockFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 15)
		Debug.Notification("15 Gold added to reward!")
	ElseIf Victim.IsInFaction(DraugrFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 25)
		Debug.Notification("25 Gold added to reward!")
	ElseIf Victim.IsInFaction(VampireFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 50)
		Debug.Notification("50 Gold added to reward!")
	Else
		;CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 5)
		;Debug.Notification("5 Gold added to reward!")
	EndIf

EndFunction

Function HandleCreature()

	Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
	Game.FadeOutGame(false, true, 3.0, 5.0)
	int instanceID = CUYC_ShovelDigSD.play(PlayerREF)
	Victim.SetCriticalStage(Victim.CritStage_DisintegrateEnd)
	TombStoneQuest.CUYC_DeadActor = Victim
	TombStoneQuest.CUYC_DeadActorWeapon = Victim.GetEquippedWeapon()
	Victim.PlaceAtMe(CUYC_Heap)
	Utility.Wait(2)
	Sound.StopInstance(instanceID)
	Game.EnablePlayerControls()
	PlayerREF.DrawWeapon()

	If Victim.HasKeyword(ActorTypeAnimal) && !Victim.IsInFaction(MammothFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 5)
		Debug.Notification("5 Gold added to reward!")
	ElseIf Victim.IsInFaction(HagravenFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 25)
		Debug.Notification("25 Gold added to reward!")
	ElseIf Victim.IsInFaction(MammothFaction) || Victim.IsInFaction(GiantFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 50)
		Debug.Notification("50 Gold added to reward!")
	ElseIf Victim.IsInFaction(DragonFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 100)
		Debug.Notification("100 Gold added to reward!")
	Else
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 1)
		Debug.Notification("1 Gold added to reward!")
	EndIf

EndFunction