Scriptname CUYC_SawScript extends activemagiceffect

Actor Property PlayerREF Auto

GlobalVariable Property CUYC_ModActiveGlobal Auto
GlobalVariable Property CUYC_IsBurningGlobal Auto
GlobalVariable Property CUYC_HelpMessagesActiveGlobal Auto

Ingredient Property HumanFlesh Auto
Ingredient Property HumanHeart Auto

Keyword Property ActorTypeNPC Auto
Keyword Property vampire Auto

Sound Property FXMeleeClawMediumVsFlesh Auto

Form Property BoneHumanBloodySkull Auto
Form Property BoneHumanBloodyArm Auto
Form Property BoneHumanBloodyBone Auto
Form Property BoneHumanBloodyHand Auto
Form Property BoneHumanBloodyLeg Auto
Form Property BoneHumanBloodyRibcage Auto
Form Property BoneHumanBloodyShoulder Auto
Form Property LargeRainBarrel_Blood_Puddle01 Auto

TextureSet Property DecalBloodSprayGroundLarge Auto

Actor Victim

Event OnEffectStart(Actor akTarget, Actor akCaster)

	If CUYC_ModActiveGlobal.GetValueInt() == 1			; is the mod active?

		Victim = akTarget			; transport to all functions

		;=====Human NPC & Vampires=====

		If akTarget.IsDead() && (akTarget.HasKeyword(ActorTypeNPC) && !akTarget.HasKeyword(vampire))

			If CUYC_IsBurningGlobal.GetValueInt() == 1

				If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
					Debug.Messagebox("This corpse is burning, you can't bury it!")
				ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
				EndIf

			ElseIf CUYC_IsBurningGlobal.GetValueInt() == 0
				HandleHuman()
			EndIf
		EndIf

	ElseIf CUYC_ModActiveGlobal.GetValueInt() == 0

		;Do nothing!

	EndIf

EndEvent

Function HandleHuman()

	Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
	Game.FadeOutGame(false, true, 5.0, 7.0)
	int instanceID = FXMeleeClawMediumVsFlesh.play(PlayerREF)
	Utility.Wait(0.5)
	int instanceID2 = FXMeleeClawMediumVsFlesh.play(PlayerREF)
	Utility.Wait(0.5)
	Victim.PlaceAtMe(DecalBloodSprayGroundLarge)
	Victim.PlaceAtMe(HumanFlesh, 4)
	Victim.PlaceAtMe(HumanHeart, 1)
	Victim.PlaceAtMe(BoneHumanBloodySkull)
	Victim.PlaceAtMe(BoneHumanBloodyArm, 2)
	Victim.PlaceAtMe(BoneHumanBloodyBone, 4)
	Victim.PlaceAtMe(BoneHumanBloodyHand, 2)
	Victim.PlaceAtMe(BoneHumanBloodyLeg, 2)
	Victim.PlaceAtMe(BoneHumanBloodyRibcage)
	Victim.PlaceAtMe(BoneHumanBloodyShoulder, 2)
	Victim.PlaceAtMe(LargeRainBarrel_Blood_Puddle01)
	int instanceID3 = FXMeleeClawMediumVsFlesh.play(PlayerREF)
	Utility.Wait(0.5)
	Victim.SetCriticalStage(Victim.CritStage_DisintegrateEnd)
	int instanceID4 = FXMeleeClawMediumVsFlesh.play(PlayerREF)
	Utility.Wait(0.5)
	int instanceID5 = FXMeleeClawMediumVsFlesh.play(PlayerREF)
	Utility.Wait(0.5)
	Game.EnablePlayerControls()
	PlayerREF.DrawWeapon()

EndFunction