Scriptname CUYC_PreservedCorpseScript extends ObjectReference

; #SUMMARY# =====================================================================================================================
; Name ...................: CUYC_PreservedCorpseScript, partially based on _DE_Visualize script made by @Chesko
; Attached To (EditorID)..: CUYC_Mummyfication
; Description ............: Placement visualization code. Drives mumyfier placement logic. Handles Mummyfier interaction as well.
; Author .................: Chesko && Mofakin
; Last Approved (version) : 1.0
; Status .................: Final
; Remarks ................: original made by Chesko @Frostfall Mod
; ===============================================================================================================================

;replace FormList with one that checks for all valid waystones?

import utility
import math
import debug

String TombstoneText

String Property CUYC_CorpseName  Auto  
String Property CUYC_CorpseDoD Auto 
CUYC_TombStoneStringVarsScript Property TombStoneQuest Auto 
Actor Property CUYC_DeadActor  Auto
Actor Property PlayerREF Auto

GlobalVariable Property CUYC_CementPlacement Auto
GlobalVariable Property CUYC_IsInPlacement Auto
GlobalVariable Property CUYC_ZTestValA Auto
GlobalVariable Property CUYC_ZTestValB Auto
GlobalVariable Property CUYC_ZTestValC Auto
Message Property CUYC_PromptMessage Auto
Message Property CUYC_RewriteTombStoneMessage Auto
ObjectReference Property CUYC_PlacementActivationTriggerREF Auto
ObjectReference Property CUYC_PlacementXmarkerREF002 Auto
ObjectReference Property CUYC_ZTestShooterREF Auto
ObjectReference Property CUYC_ZTestReceiverREF Auto
Spell Property CUYC_ZTestSpellA Auto
Spell Property CUYC_ZTestSpellB Auto
Spell Property CUYC_ZTestSpellC Auto

Event OnInit()

	self.BlockActivation()
	If (!CUYC_CorpseName)
		CUYC_CorpseName = TombStoneQuest.CUYC_CorpseName
		CUYC_CorpseDoD = TombStoneQuest.CUYC_CorpseDoD
		CUYC_DeadActor = TombStoneQuest.CUYC_DeadActor 
	EndIf
	StartPlacement()

EndEvent

Event OnActivate(ObjectReference akActionRef)

	If CUYC_IsInPlacement.GetValueInt() == 1
	ElseIf CUYC_IsInPlacement.GetValueInt() == 0
		If akActionRef == PlayerREF
			Int ButtonTomb = CUYC_RewriteTombStoneMessage.show() as Int
			If ButtonTomb == 0
				HandleReview()
			ElseIf ButtonTomb == 1
				HandleRewrite()
			EndIf
		EndIf
	EndIf

EndEvent

Function HandleReview()

	Int Index1 = StringUtil.Find(CUYC_CorpseDoD, " ")
	String Burried = StringUtil.Substring(CUYC_CorpseDoD, 0, Index1) 
	;Debug.MessageBox("Here Rests in Peace, our beloved " + CUYC_CorpseName + "\n\nBurried at " + Burried + "\n\n may you find your haven in Sovengard")
	Debug.MessageBox(CUYC_CorpseName + " + " + Burried + " + " + "\n\n" + TombstoneText)

EndFunction

Function HandleRewrite()

	TombstoneText = ((Self as Form) as UILIB_1).ShowTextInput("Enter your Tombstone Text", "...") as String
	If TombstoneText != ""
		Int Index1 = StringUtil.Find(CUYC_CorpseDoD, " ")
		String Burried = StringUtil.Substring(CUYC_CorpseDoD, 0, Index1) 
	EndIf

EndFunction

Function StartPlacement()
	
	self.BlockActivation()
	self.SetAngle(0.0, 0.0, 0.0)
	CUYC_PlacementActivationTriggerREF.MoveTo(PlayerRef)
	RegisterForSingleUpdate(0.5)

EndFunction

Event OnUpdate()

	If CUYC_CementPlacement.GetValueInt() == 0
		PerformPlacement(300.0)
	ElseIf CUYC_CementPlacement.GetValueInt() == 1
		CementPlacement()
	EndIf	
	
EndEvent

Function PerformPlacement(float fDistance, float fHeight = 1.0, float fRot = 0.0, bool bLockToPlayer = false)
	
	float myX = PlayerREF.GetPositionX()
	float myY = PlayerREF.GetPositionY()
	float myZ = PlayerREF.GetPositionZ()
	
	float[] myCenterPoint = new float[2]
	myCenterPoint = GetTerrainAngleData(fDistance)
	
	float[] myRot = new float[3]
	myRot = GetTerrainRotation(CUYC_ZTestValA.GetValue(), CUYC_ZTestValB.GetValue(), CUYC_ZTestValC.GetValue())
		
	if self.IsDisabled()
		self.Enable()
	endif
	while !self.Is3DLoaded()
		wait(0.1)
	endWhile
		
	if (myZ - myRot[2] > 300.0) || (myZ - myRot[2] < -300.0)
		myRot[2] = myZ
	endif
		
	if bLockToPlayer
		self.TranslateTo(myX + myCenterPoint[0], myY + myCenterPoint[1], myZ + fHeight, 0.0, 0.0, PlayerRef.GetAngleZ() + fRot, 5000.0, 0.0)
	else
		self.TranslateTo(myX + myCenterPoint[0], myY + myCenterPoint[1], myRot[2] + fHeight, myRot[0], myRot[1], PlayerRef.GetAngleZ() + fRot, 5000.0, 0.0)
	endif
	
	if CUYC_PlacementActivationTriggerREF.GetPositionX() != myX || CUYC_PlacementActivationTriggerREF.GetPositionY() != myY || CUYC_PlacementActivationTriggerREF.GetPositionZ() != myZ
		CUYC_PlacementActivationTriggerREF.MoveTo(PlayerRef)
	endif
		
	RegisterForSingleUpdate(0.5)
	CUYC_IsInPlacement.SetValueInt(1)
	
EndFunction

Function CementPlacement()	

	If CUYC_IsInPlacement.GetValueInt() == 1
		Int iButton = CUYC_PromptMessage.Show() as Int
		If iButton == 0
			self.MoveTo(self)
			StopPlacement()
		ElseIf iButton == 1
			CUYC_CementPlacement.SetValueInt(0)
			RegisterForSingleUpdate(0.5)		
		EndIf
	EndIf	
	
EndFunction

Function StopPlacement()
	CUYC_CementPlacement.SetValueInt(0)
	CUYC_IsInPlacement.SetValueInt(0)
	CUYC_PlacementActivationTriggerREF.MoveTo(CUYC_PlacementXmarkerREF002)
	CUYC_ZTestShooterREF.MoveTo(CUYC_PlacementXmarkerREF002)
	CUYC_ZTestReceiverREF.MoveTo(CUYC_PlacementXmarkerREF002)
	self.BlockActivation(false)
EndFunction

float[] function GetTerrainAngleData(float afDistance)
	float[] t1_posA = new float[2]
	float[] t1_posB = new float[2]
	float[] t1_posC = new float[2]
	float[] myCenterPoint = new float[2]
		
	myCenterPoint = GetOffsets(PlayerRef, afDistance)
	
	t1_posA[0] = myCenterPoint[0]
	t1_posA[1] = myCenterPoint[1] - 43.3				
	t1_posB[0] = myCenterPoint[0] - 50.0
	t1_posB[1] = myCenterPoint[1] + 43.3
	t1_posC[0] = myCenterPoint[0] + 50.0
	t1_posC[1] = myCenterPoint[1] + 43.3

	CUYC_ZTestShooterREF.MoveTo(PlayerRef, t1_posA[0], t1_posA[1], 175.0)
	CUYC_ZTestReceiverREF.MoveTo(PlayerRef, t1_posA[0], t1_posA[1], -300.0)
	CUYC_ZTestSpellA.Cast(CUYC_ZTestShooterREF, CUYC_ZTestReceiverREF)
	CUYC_ZTestShooterREF.MoveTo(PlayerRef, t1_posB[0], t1_posB[1], 175.0)
	CUYC_ZTestReceiverREF.MoveTo(PlayerRef, t1_posB[0], t1_posB[1], -300.0)
	CUYC_ZTestSpellB.Cast(CUYC_ZTestShooterREF, CUYC_ZTestReceiverREF)
	CUYC_ZTestShooterREF.MoveTo(PlayerRef, t1_posC[0], t1_posC[1], 175.0)
	CUYC_ZTestReceiverREF.MoveTo(PlayerRef, t1_posC[0], t1_posC[1], -300.0)
	CUYC_ZTestSpellC.Cast(CUYC_ZTestShooterREF, CUYC_ZTestReceiverREF)

	return myCenterPoint
	
endFunction

Float[] function GetTerrainRotation(float t1_zA, float t1_zB, float t1_zC)

	int YRot = 0
	int XRot = 0
	float ZPos
	float t1_sideX = 100
	float t2_angB
	float t2_sideA
	float t2_sideB
	float t2_sideC = 100.0
	float t2_midpoint
	float t3_angB
	float t3_sideA
	float t3_sideB
	float t3_sideC = 86.6

	if t1_zB > t1_zC
		YRot = -1				;Roll right
		t2_sideB = t1_zB - t1_zC
		t2_midpoint = t1_zB - ((t1_zB - t1_zC) / 2)
	elseif t1_zC > t1_zB
		YRot = 1				;Roll left
		t2_sideB = t1_zC - t1_zB
		t2_midpoint = t1_zC - ((t1_zC - t1_zB) / 2)
	elseif t1_zC == t1_zB
		YRot = 0				;No roll
		t2_sideB = 0
		t2_midpoint = t1_zB
	endif
	
	if t2_sideB != 0
		t2_sideA = pow(t2_sideB, 2) + pow(t2_sideC, 2)
		t2_sideA = sqrt(t2_sideA)
	
		float t2_sinangB = t2_sideB / t2_sideA
		t2_angB = asin(t2_sinangB)
	else
		t2_angB = 0
	endif

	if t1_zA > t2_midpoint
		t3_sideB = t1_zA - t2_midpoint
		ZPos = (t3_sideB/2) + t2_midpoint
		XRot = 1
	elseif t1_zA < t2_midpoint
		t3_sideB = t2_midpoint - t1_zA
		ZPos = (t3_sideB/2) + t1_zA
		XRot = -1
	elseif t1_zA == t2_midpoint
		t3_sideB = 0
		ZPos = t1_zA
		XRot = 0
	endif

	if t3_sideB != 0
		t3_sideA = pow(t3_sideB, 2) + pow(t3_sideC, 2)
		t3_sideA = sqrt(t3_sideA)
		float t3_sinangB = t3_sideB / t3_sideA
		t3_angB = asin(t3_sinangB)
	else
		t3_angB = 0
	endif

	float[] myReturnValues = new float[3]
	
	if t3_angB * XRot > 25.0
		myReturnValues[0] = 25.0
	elseif t3_angB * XRot < -25.0
		myReturnValues[0] = -25.0
	else
		myReturnValues[0] = t3_angB * XRot
	endif
	
	if t2_angB * YRot > 25.0
		myReturnValues[1] = 25.0
	elseif t2_angB * YRot < -25.0
		myReturnValues[1] = -25.0
	else
		myReturnValues[1] = t2_angB * YRot
	endif
	
	myReturnValues[2] = ZPos 
	
	return myReturnValues
	
endFunction

float[] function GetOffsets(Actor akSource, Float afDistance = 100.0, float afOffset = 0.0)
	Float A = akSource.GetAngleZ() + afOffset
	Float YDist = Sin(A)
	Float XDist = Cos(A)

	XDist *= afDistance
	YDist *= afDistance

	Float[] Offsets = New Float[2]
	Offsets[0] = YDist
	Offsets[1] = XDist
	Return Offsets
EndFunction