Scriptname CUYC_MummyfierScript extends activemagiceffect

Actor Property PlayerREF Auto

CUYC_TombStoneStringVarsScript Property TombStoneQuest Auto

Faction Property BanditFaction Auto
Faction Property WarlockFaction Auto
Faction Property DraugrFaction Auto
Faction Property VampireFaction Auto
GlobalVariable Property CUYC_ModActiveGlobal Auto
GlobalVariable Property CUYC_IsBurningGlobal Auto
GlobalVariable Property CUYC_HelpMessagesActiveGlobal Auto
GlobalVariable Property CUYC_MoneyCountGlobal Auto

Keyword Property ActorTypeNPC Auto

Activator Property CUYC_Mummyfication Auto

ObjectReference CUYC_TombStonePosition

Sound Property CUYC_ScalpelCutSD Auto

Actor Victim

Event OnEffectStart(Actor akTarget, Actor akCaster)

	If CUYC_ModActiveGlobal.GetValueInt() == 1			; is the mod active?

		Victim = akTarget			; transport to all functions

		;=====Human NPC & Vampires=====

		If akTarget.IsDead() && akTarget.HasKeyword(ActorTypeNPC)

			If CUYC_IsBurningGlobal.GetValueInt() == 1

				If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
					Debug.Messagebox("This corpse is burning, you can't bury it!")
				ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
				EndIf

			ElseIf CUYC_IsBurningGlobal.GetValueInt() == 0
				HandleHuman()
			EndIf
		EndIf

	ElseIf CUYC_ModActiveGlobal.GetValueInt() == 0

		;Do nothing!

	EndIf

EndEvent

Function HandleHuman()

	Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
	Game.FadeOutGame(false, true, 7.0, 9.0)
	Victim.SetCriticalStage(Victim.CritStage_DisintegrateEnd)
	int instanceID = CUYC_ScalpelCutSD.play(PlayerREF)
	String ActorName = Victim.GetBaseObject().GetName()
	TombStoneQuest.CUYC_CorpseName = ActorName
	TombStoneQuest.CUYC_CorpseDoD = Utility.GameTimeToString(math.Ceiling(Utility.GetCurrentGameTime()) + 31)
	TombStoneQuest.CUYC_DeadActor = Victim
	CUYC_TombStonePosition = Victim.PlaceAtMe(CUYC_Mummyfication)
	CUYC_TombStonePosition.SetPosition(CUYC_TombStonePosition.GetPositionX(), CUYC_TombStonePosition.GetPositionY(), CUYC_TombStonePosition.GetPositionZ() - 15)
	CUYC_TombStonePosition.SetAngle(Utility.RandomInt(-5, 5), Utility.RandomInt(-5, 5), CUYC_TombStonePosition.GetAngleZ())
	Utility.Wait(2)
	Game.EnablePlayerControls()
	PlayerREF.DrawWeapon()

	If Victim.IsInFaction(BanditFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 10)
		Debug.Notification("10 Gold added to reward!")
	ElseIf Victim.IsInFaction(WarlockFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 15)
		Debug.Notification("15 Gold added to reward!")
	ElseIf Victim.IsInFaction(DraugrFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 25)
		Debug.Notification("25 Gold added to reward!")
	ElseIf Victim.IsInFaction(VampireFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 50)
		Debug.Notification("50 Gold added to reward!")
	Else
		;CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 5)
		;Debug.Notification("5 Gold added to reward!")
	EndIf

EndFunction