Scriptname CUYC_MCMQuestScript extends SKI_ConfigBase

Perk Property CUYC_MeltCorpsePerk Auto
Perk Property CUYC_VampireCorpsePerk Auto
Actor Property PlayerREF Auto
GlobalVariable Property CUYC_ModActiveGlobal Auto
GlobalVariable Property CUYC_HelpMessagesActiveGlobal Auto
GlobalVariable Property CUYC_VampireActive Auto
GlobalVariable Property CUYC_MenuClutterGlobal Auto
GlobalVariable Property CUYC_CorpseCheatGlobal Auto
GlobalVariable Property CUYC_BigGraveplatePrice Auto
GlobalVariable Property CUYC_BigTombstonePrice Auto
GlobalVariable Property CUYC_GraveplatePrice Auto
GlobalVariable Property CUYC_BurialCairnPrice Auto
Weapon Property CUYC_Broom Auto
Weapon Property CUYC_Mummifier Auto
Weapon Property CUYC_Shovel Auto
Weapon Property CUYC_Saw Auto
Weapon Property CUYC_BodyHook Auto
Weapon Property CUYC_Hammer Auto
Weapon Property Axe01 Auto
Light Property Torch01 Auto
MiscObject Property CUYC_HumanCorpseDummy Auto
MiscObject Property CUYC_CreatureCorpseDummy Auto
ReferenceAlias Property CarcassAlias Auto
ReferenceAlias Property CorpseAlias Auto
ReferenceAlias[] Property PyreAlias Auto

Int CUYC_Switch
Int CUYC_Help
Int CUYC_Vampire
Int CUYC_NoWeight
Int CUYC_Pyre
Int CUYC_Menu
Int CUYC_Corpse
Int KeyMap
Int SwitchCUYCHotkey = 0
Int PlatePrice
Int TombPrice
Int BPlatePrice
Int CairnPrice
Int GrabForce
Float PlatePriceSlider = 100.0 
Float TombPriceSlider = 100.0
Float BPlatePriceSlider = 500.0
Float CairnPriceSlider = 250.0
Float GrabForceSlider = 100.0

Bool CUYC_SwitchToggle = false
Bool CUYC_HelpToggle = false
Bool CUYC_VampireToggle = false
Bool CUYC_NoWeightToggle = false
Bool CUYC_PyreToggle = false
Bool CUYC_MenuToggle = false
Bool CUYC_CorpseToggle = false

String CorpseName
Form ActorBaseWeight
Float CorpseWeight
String CarcassName
Form CreatureBaseWeight
Float CarcassWeight

Event OnConfigInit()
	InitKeys()
EndEvent

Event OnGameReload()
	Parent.OnGameReload()
	InitKeys()
EndEvent

Event OnPageReset(string Page)
	If (Page == "Main Page")
		SetCursorFillMode(TOP_TO_BOTTOM)
		SetCursorPosition(0)
		AddHeaderOption("Configuration")
		CUYC_Switch = AddToggleOption("Turn on/off CUYC", CUYC_SwitchToggle)
		CUYC_Help = AddToggleOption("Turn messages on/off", CUYC_HelpToggle)
		CUYC_Vampire = AddToggleOption("Turn Vampire Resurrect on/off", CUYC_VampireToggle)
		CUYC_NoWeight = AddToggleOption("Turn No Weight on/off", CUYC_NoWeightToggle)
		CUYC_Pyre = AddToggleOption("Turn Burial Pyres on/off", CUYC_PyreToggle)
		CUYC_Menu = AddToggleOption("Turn tidy crafting menus on/off", CUYC_MenuToggle)
		CUYC_Corpse = AddToggleOption("Turn Corpse Cheat on/off", CUYC_CorpseToggle)
		AddHeaderOption("Key Mapping")
		KeyMap = AddKeyMapOption("Toggle CUYC", SwitchCUYCHotkey)
		SetCursorPosition(1)
		AddHeaderOption("Settings")
		PlatePrice = AddSliderOption("Graveplate Price", PlatePriceSlider, "{1}")
		TombPrice = AddSliderOption("Big Tombstone Price", TombPriceSlider, "{1}")
		BPlatePrice = AddSliderOption("Big Graveplate Price", BPlatePriceSlider, "{1}")
		CairnPrice = AddSliderOption("Burial Cairn Price", CairnPriceSlider, "{1}")
		GrabForce = AddSliderOption("Grab Force", GrabForceSlider, "{1}")
	EndIf
EndEvent

Event OnOptionHighlight(int Option)
	If (Option == CUYC_Switch)
		SetInfoText("Turn CUYC on or off! - Default off!")
	ElseIf (Option == CUYC_Help)
		SetInfoText("Turn help messages on and off! - Default off!")
	ElseIf (Option == CUYC_Vampire)
		SetInfoText("Turn Vampire resurrection feature on and off! - Default off!")
	ElseIf (Option == CUYC_NoWeight)
		SetInfoText("Turn no weight on tools on and off! - Default off!")
	ElseIf (Option == CUYC_Pyre)
		SetInfoText("Turn burial pyres in towns on and off! - Default off!")
	ElseIf (Option == CUYC_Menu)
		SetInfoText("Turn uncluttered crafting menus on and off! - Default off!")
	ElseIf (Option == CUYC_Corpse)
		SetInfoText("Turn storing items inside carried corpses 'cheat' on and off! - Default off!")
	ElseIf (Option == KeyMap)
		SetInfoText("Set a hotkey to turn on/off CUYC on the fly! Default off!")
	ElseIf (Option == PlatePrice)
		SetInfoText("Define Price of the Graveplate Replacer!")
	ElseIf (Option == TombPrice)
		SetInfoText("Define Price of the Big Tombstone Replacer!")
	ElseIf (Option == BPlatePrice)
		SetInfoText("Define Price of the Big Graveplate Replacer!")
	ElseIf (Option == CairnPrice)
		SetInfoText("Define Price of the Burial Cairn Replacer!")
	ElseIf (Option == GrabForce)
		SetInfoText("Adjust Maximum Grab Force!")		
	EndIf
EndEvent

Event OnOptionSelect(int Option)
	If (Option == CUYC_Switch)
		CUYC_SwitchToggle = !CUYC_SwitchToggle
		SetToggleOptionValue(CUYC_Switch, CUYC_SwitchToggle)
		CUYC_ModActiveGlobal.SetValue(1)
		PlayerREF.AddPerk(CUYC_MeltCorpsePerk)
		PlayerREF.AddPerk(CUYC_VampireCorpsePerk)
		If !CUYC_SwitchToggle
			CUYC_ModActiveGlobal.SetValue(0)
			PlayerREF.RemovePerk(CUYC_MeltCorpsePerk)
			PlayerREF.RemovePerk(CUYC_VampireCorpsePerk)
		EndIf
	ElseIf (Option == CUYC_Help)
		CUYC_HelpToggle = !CUYC_HelpToggle
		SetToggleOptionValue(CUYC_Help, CUYC_HelpToggle)
			CUYC_HelpMessagesActiveGlobal.SetValue(1)
		If !CUYC_HelpToggle	
			CUYC_HelpMessagesActiveGlobal.SetValue(0)
		EndIf
	ElseIf (Option == CUYC_Vampire)
		CUYC_VampireToggle = !CUYC_VampireToggle
		SetToggleOptionValue(CUYC_Vampire, CUYC_VampireToggle)
			CUYC_VampireActive.SetValue(1)
		If !CUYC_VampireToggle	
			CUYC_VampireActive.SetValue(0)
		EndIf
	ElseIf (Option == CUYC_NoWeight)
		CUYC_NoWeightToggle = !CUYC_NoWeightToggle
		SetToggleOptionValue(CUYC_NoWeight, CUYC_NoWeightToggle)
			Axe01.SetWeight(0.0000)
			CUYC_Broom.SetWeight(0.0000)
			CUYC_Mummifier.SetWeight(0.0000)
			CUYC_Shovel.SetWeight(0.0000)
			CUYC_Saw.SetWeight(0.0000)
			CUYC_BodyHook.SetWeight(0.0000)
 			CUYC_Hammer.SetWeight(0.0000)
			Torch01.SetWeight(0.0000)
		If !CUYC_NoWeightToggle	
			Axe01.SetWeight(3.0000)
			CUYC_Broom.SetWeight(1.0000)
			CUYC_Mummifier.SetWeight(0.2000)
			CUYC_Shovel.SetWeight(1.0000)
			CUYC_Saw.SetWeight(0.3000)
			CUYC_BodyHook.SetWeight(0.5000)
 			CUYC_Hammer.SetWeight(0.7500)
			Torch01.SetWeight(0.5000)
		EndIf
	ElseIf (Option == CUYC_Pyre)
		CUYC_PyreToggle = !CUYC_PyreToggle
		SetToggleOptionValue(CUYC_Pyre, CUYC_PyreToggle)
			PyreAlias[0].GetReference().Enable()
			PyreAlias[1].GetReference().Enable()
			PyreAlias[2].GetReference().Enable()
			PyreAlias[3].GetReference().Enable()
			PyreAlias[4].GetReference().Enable()
			PyreAlias[5].GetReference().Enable()
			PyreAlias[6].GetReference().Enable()
			PyreAlias[7].GetReference().Enable()
			PyreAlias[8].GetReference().Enable()
			PyreAlias[9].GetReference().Enable()
			PyreAlias[10].GetReference().Enable()
			PyreAlias[11].GetReference().Enable()
			PyreAlias[12].GetReference().Enable()
			PyreAlias[13].GetReference().Enable()
		If !CUYC_PyreToggle
			PyreAlias[0].GetReference().Disable()
			PyreAlias[1].GetReference().Disable()
			PyreAlias[2].GetReference().Disable()
			PyreAlias[3].GetReference().Disable()
			PyreAlias[4].GetReference().Disable()
			PyreAlias[5].GetReference().Disable()
			PyreAlias[6].GetReference().Disable()
			PyreAlias[7].GetReference().Disable()
			PyreAlias[8].GetReference().Disable()
			PyreAlias[9].GetReference().Disable()
			PyreAlias[10].GetReference().Disable()
			PyreAlias[11].GetReference().Disable()
			PyreAlias[12].GetReference().Disable()
			PyreAlias[13].GetReference().Disable()
		EndIf
	ElseIf (Option == CUYC_Menu)
		CUYC_MenuToggle = !CUYC_MenuToggle
		SetToggleOptionValue(CUYC_Menu, CUYC_MenuToggle)
			CUYC_MenuClutterGlobal.SetValue(1)
		If !CUYC_MenuToggle	
			CUYC_MenuClutterGlobal.SetValue(0)
		EndIf
	ElseIf (Option == CUYC_Corpse)
		CUYC_CorpseToggle = !CUYC_CorpseToggle
		SetToggleOptionValue(CUYC_Corpse, CUYC_CorpseToggle)
			CUYC_CorpseCheatGlobal.SetValue(1)
		If !CUYC_CorpseToggle	
			CUYC_CorpseCheatGlobal.SetValue(0)		
		EndIf
	EndIf
EndEvent

Event OnOptionSliderOpen(int Option)
	If (Option == PlatePrice)
		Int PricePlate = CUYC_GraveplatePrice.GetValue() as Int
		SetSliderDialogStartValue(PlatePriceSlider)
		SetSliderDialogDefaultValue(PricePlate)
		SetSliderDialogRange(0.00, 5000.00)
		SetSliderDialogInterval(1.00)
	ElseIf (Option == TombPrice)
		Int PriceTomb = CUYC_BigTombstonePrice.GetValue() as Int
		SetSliderDialogStartValue(TombPriceSlider)
		SetSliderDialogDefaultValue(PriceTomb)
		SetSliderDialogRange(0.00, 5000.00)
		SetSliderDialogInterval(1.00)
	ElseIf (Option == BPlatePrice)
		Int PriceBPlate =  CUYC_BigGraveplatePrice.GetValue() as Int
		SetSliderDialogStartValue(BPlatePriceSlider)
		SetSliderDialogDefaultValue(PriceBPlate)
		SetSliderDialogRange(0.00, 5000.00)
		SetSliderDialogInterval(1.00)
	ElseIf (Option == CairnPrice)
		Int PriceCairn = CUYC_BurialCairnPrice.GetValue() as Int
		SetSliderDialogStartValue(CairnPriceSlider)
		SetSliderDialogDefaultValue(PriceCairn)
		SetSliderDialogRange(0.00, 5000.00)
		SetSliderDialogInterval(1.00)
	ElseIf (Option == GrabForce)
		Float GrabForceFloat = Game.GetGameSettingFloat("fZKeyMaxForce") as Float
		SetSliderDialogStartValue(GrabForceSlider)
		SetSliderDialogDefaultValue(GrabForceFloat)
		SetSliderDialogRange(0.00, 5000.00)
		SetSliderDialogInterval(1.00)		
	EndIf
EndEvent

Event OnOptionSliderAccept(int Option, float Value)
	If (Option == PlatePrice)
		PlatePriceSlider = Value
		SetSliderOptionValue(PlatePrice, PlatePriceSlider, "{1}")
		CUYC_GraveplatePrice.SetValue(Value)
	ElseIf (Option == BPlatePrice)
		BPlatePriceSlider = Value
		SetSliderOptionValue(BPlatePrice, BPlatePriceSlider, "{1}")
		CUYC_BigGraveplatePrice.SetValue(Value)
	ElseIf (Option == TombPrice)
		TombPriceSlider = Value
		SetSliderOptionValue(TombPrice, TombPriceSlider, "{1}")
		CUYC_BigTombstonePrice.SetValue(Value)
	ElseIf (Option == CairnPrice)
		CairnPriceSlider = Value
		SetSliderOptionValue(CairnPrice, CairnPriceSlider, "{1}")
		CUYC_BigTombstonePrice.SetValue(Value)
	ElseIf (Option == GrabForce)
		GrabForceSlider = Value
		SetSliderOptionValue(GrabForce, GrabForceSlider, "{1}")
		Game.SetGameSettingFloat("fZKeyMaxForce", Value)		
	EndIf
EndEvent

Function InitKeys(Int aiDXScanCode = 0)
	RegisterForKey(SwitchCUYCHotkey)
	If CUYC_NoWeightToggle == true
		Axe01.SetWeight(0.0000)
		CUYC_Broom.SetWeight(0.0000)
		CUYC_Mummifier.SetWeight(0.0000)
		CUYC_Shovel.SetWeight(0.0000)
		CUYC_Saw.SetWeight(0.0000)
		CUYC_BodyHook.SetWeight(0.0000)
 		CUYC_Hammer.SetWeight(0.0000)
		Torch01.SetWeight(0.0000)
	ElseIf CUYC_NoWeightToggle == false
		Axe01.SetWeight(3.0000)
		CUYC_Broom.SetWeight(1.0000)
		CUYC_Mummifier.SetWeight(0.2000)
		CUYC_Shovel.SetWeight(1.0000)
		CUYC_Saw.SetWeight(0.3000)
		CUYC_BodyHook.SetWeight(0.0000)
 		CUYC_Hammer.SetWeight(0.7500)
		Torch01.SetWeight(0.5000)
	EndIf
	If CorpseAlias.GetActorReference() != none	
		CorpseName = CorpseAlias.GetActorReference().GetBaseObject().GetName()
		ActorBaseWeight = CorpseAlias.GetActorReference().GetBaseObject()
		CorpseWeight = ActorBaseWeight.GetWeight()		
	ElseIf 	CorpseAlias.GetActorReference() == none
	EndIf
	CUYC_HumanCorpseDummy.SetName(CorpseName + "'s" + " Corpse")	
	CUYC_HumanCorpseDummy.SetWeight(CorpseWeight)
	If CarcassAlias.GetActorReference() != none		
		CarcassName = CarcassAlias.GetActorReference().GetBaseObject().GetName()
		CreatureBaseWeight = CarcassAlias.GetActorReference().GetBaseObject()
		CarcassWeight = ActorBaseWeight.GetWeight()
	ElseIf 	CarcassAlias.GetActorReference() == none
	EndIf		
	CUYC_CreatureCorpseDummy.SetName(CarcassName + "'s" + " Corpse")	
	CUYC_CreatureCorpseDummy.SetWeight(CarcassWeight)
	Game.SetGameSettingFloat("fZKeyMaxForce", GrabForceSlider)	
EndFunction

Event OnKeyDown(Int aiKeyCode)
	If CUYC_SwitchToggle == false && !Utility.IsInMenuMode()
		CUYC_ModActiveGlobal.SetValue(1)
		PlayerREF.AddPerk(CUYC_MeltCorpsePerk)
		PlayerREF.AddPerk(CUYC_VampireCorpsePerk)
		CUYC_SwitchToggle = true
		Debug.Notification("CUYC turned on!")
	ElseIf CUYC_SwitchToggle == true && !Utility.IsInMenuMode()
		CUYC_ModActiveGlobal.SetValue(0)
		PlayerREF.RemovePerk(CUYC_MeltCorpsePerk)
		PlayerREF.RemovePerk(CUYC_VampireCorpsePerk)
		CUYC_SwitchToggle = false
		Debug.Notification("CUYC turned off!")
	EndIf
EndEvent

Event OnOptionKeyMapChange(int a_option, int a_keyCode, string a_conflictControl, string a_conflictName)
	If a_option == KeyMap
		bool continue = true
		If (a_conflictControl != "")
			string msg
			If (a_conflictName != "")
				msg = "This key is already mapped to:\n'" + a_conflictControl + "'\n(" + a_conflictName + ")\n\nAre you sure you want to continue?"
			Else
				msg = "This key is already mapped to:\n'" + a_conflictControl + "'\n\nAre you sure you want to continue?"
			EndIf
			continue = ShowMessage(msg, true, "Yes", "No")
		EndIf
		If (continue)
			SwitchCUYCHotkey = a_keyCode
			SetKeymapOptionValue(a_option, a_keyCode)
			RegisterForKey(SwitchCUYCHotkey)			
		EndIf
	EndIf
EndEvent