Scriptname CUYC_HumanCorpseDummyScript extends ObjectReference

Actor Property PlayerREF Auto
MiscObject Property CUYC_HumanCorpseDummy Auto
ReferenceAlias Property CorpseAlias Auto

Event OnContainerChanged(ObjectReference akNewContainer, ObjectReference akOldContainer)
	If akOldContainer && !akNewContainer
		self.Disable()
		self.Delete()
		Actor DeadBodyRef = CorpseAlias.GetActorReference()
		DeadBodyRef.MoveTo(PlayerREF)
		CorpseAlias.Clear()
	EndIf
	If akOldContainer && akNewContainer
		String CorpseName = CorpseAlias.GetActorReference().GetBaseObject().GetName()
		Form ActorBaseWeight = CorpseAlias.GetActorReference().GetBaseObject()
		Float CorpseWeight = ActorBaseWeight.GetWeight()
		akNewContainer.RemoveItem(CUYC_HumanCorpseDummy, 1, true)
		PlayerREF.Additem(CUYC_HumanCorpseDummy, 1, true)
		CUYC_HumanCorpseDummy.SetName(CorpseName + "'s" + " Corpse")	
		CUYC_HumanCorpseDummy.SetWeight(CorpseWeight)
		Debug.Messagebox("You're not allowed to place corpses inside containers!")
	EndIf
EndEvent