Scriptname CUYC_CreatureCorpseDummyScript extends ObjectReference

Actor Property PlayerREF Auto
MiscObject Property CUYC_CreatureCorpseDummy Auto
ReferenceAlias Property CarcassAlias Auto

Event OnContainerChanged(ObjectReference akNewContainer, ObjectReference akOldContainer)
	If akOldContainer && !akNewContainer
		CUYC_CreatureCorpseDummy.SetGoldValue(0)
		self.Disable()
		self.Delete()
		Actor DeadBodyRef = CarcassAlias.GetActorReference()
		DeadBodyRef.MoveTo(PlayerREF)
		CarcassAlias.Clear()
	EndIf
	If akOldContainer && akNewContainer
		String CarcassName = CarcassAlias.GetActorReference().GetBaseObject().GetName()
		Form ActorBaseWeight = CarcassAlias.GetActorReference().GetBaseObject()
		Float CarcassWeight = ActorBaseWeight.GetWeight()
		akNewContainer.RemoveItem(CUYC_CreatureCorpseDummy, 1, true)
		PlayerREF.Additem(CUYC_CreatureCorpseDummy, 1, true)
		CUYC_CreatureCorpseDummy.SetName(CarcassName + "'s" + " Corpse")	
		CUYC_CreatureCorpseDummy.SetWeight(CarcassWeight)
		Debug.Messagebox("You're not allowed to place carcasses inside containers!")
	EndIf
EndEvent