Scriptname CUYC_BurialPyreScript extends ObjectReference

Actor Property PlayerREF Auto
MiscObject Property CUYC_HumanCorpseDummy Auto
ReferenceAlias Property CorpseAlias Auto
Container Property TreasDraugrAmbushCorpseWrapped02 Auto
Container Property CUYC_BurnedBody05 Auto
Potion Property CUYC_GhostPotion Auto
Hazard Property FireBarrierHazard Auto
Activator Property CUYC_GiantFireActivator Auto
Activator Property CUYC_PortalActivator Auto
Sound Property CUYC_PortalOpenSoundSD Auto
Sound Property CUYC_PortalSoundSD Auto
Sound Property NPCHumanCombatTorchBashPower Auto
Explosion Property defaultGhostDeathExplosion Auto

ObjectReference Mummy
Bool DoOnce

Event OnActivate(ObjectReference akActionRef)
	If akActionRef == PlayerREF && PlayerREF.GetItemCount(CUYC_HumanCorpseDummy) >= 1 && DoOnce == false ; only activate if is player activating first time and has corpse dummy in inventory

		;==========start fire block, shortly disables player controls and enabling DoOnce==========

		DoOnce = true
		Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
		Game.FadeOutGame(false, true, 3.0, 4.0)
		NPCHumanCombatTorchBashPower.Play(self)
		Utility.Wait(0.5)

		ObjectReference GiantFire = self.PlaceAtMe(CUYC_GiantFireActivator)
		GiantFire.SetScale(0.35)

		ObjectReference BurnSource1 = self.PlaceAtMe(FireBarrierHazard)
		ObjectReference BurnSource2 = self.PlaceAtMe(FireBarrierHazard)
		ObjectReference BurnSource3 = self.PlaceAtMe(FireBarrierHazard)
		ObjectReference BurnSource4 = self.PlaceAtMe(FireBarrierHazard)
		ObjectReference BurnSource5 = self.PlaceAtMe(FireBarrierHazard)

		BurnSource2.MoveTo(self, afXOffset = 75.0, afYOffset = 0.0, afZOffset = 0.0)
		BurnSource3.MoveTo(self, afXOffset = -75.0, afYOffset = 0.0, afZOffset = 0.0)
		BurnSource4.MoveTo(self, afXOffset = 0.0, afYOffset = 75.0, afZOffset = 0.0)
		BurnSource5.MoveTo(self, afXOffset = 0.0, afYOffset = -75.0, afZOffset = 0.0)

		;==========start Mummy block, puts mummy in replacement of dead actor==========

		Mummy = self.PlaceAtMe(TreasDraugrAmbushCorpseWrapped02)
		Mummy.SetPosition(self.GetPositionX(), self.GetPositionY(), self.GetPositionZ() + 90.0)
		Mummy.SetAngle(self.GetAngleX(), self.GetAngleY(), self.GetAngleZ() + 90.0)
		Mummy.PlaceAtMe(FireBarrierHazard)
		Mummy.BlockActivation()

		;==========start dead actor block, puts dead actor on the side pyre as ghost, watching his own funeral==========

		PlayerREF.RemoveItem(CUYC_HumanCorpseDummy, 1, true)
		Actor DeadBodyRef = CorpseAlias.GetActorReference() as Actor
		DeadBodyRef.MoveTo(self, afXOffset = 200.0)
		DeadBodyRef.Resurrect()
		DeadBodyRef.Disable()								; failsafe so actor won't spawn naked
		DeadBodyRef.Enable()
		DeadBodyRef.AddItem(CUYC_GhostPotion, 1, true)
		DeadBodyRef.EquipItem(CUYC_GhostPotion, false, true)
		DeadBodyRef.SetLookAt(Mummy, true)
		Utility.Wait(2.5)
		DeadBodyRef.SetDontMove()
		DeadBodyRef.BlockActivation()
		DeadBodyRef.EvaluatePackage()
		Utility.Wait(1)
		Game.EnablePlayerControls()
		Utility.Wait(25)

		;==========replace embalmed corpse with burned corpse block==========

		Mummy.Disable()
		Mummy.Delete()
		ObjectReference BurnedBody = self.PlaceAtMe(CUYC_BurnedBody05)
		BurnedBody.SetPosition(self.GetPositionX(), self.GetPositionY(), self.GetPositionZ() + 90.0)
		BurnedBody.SetAngle(self.GetAngleX(), self.GetAngleY(), self.GetAngleZ() + 90.0)
		BurnedBody.BlockActivation()

		;==========second start fire block==========

		ObjectReference BurnSource6 = self.PlaceAtMe(FireBarrierHazard)
		ObjectReference BurnSource7 = self.PlaceAtMe(FireBarrierHazard)
		ObjectReference BurnSource8 = self.PlaceAtMe(FireBarrierHazard)
		ObjectReference BurnSource9 = self.PlaceAtMe(FireBarrierHazard)

		BurnSource6.MoveTo(self, afXOffset = 75.0, afYOffset = 0.0, afZOffset = 0.0)
		BurnSource7.MoveTo(self, afXOffset = -75.0, afYOffset = 0.0, afZOffset = 0.0)
		BurnSource8.MoveTo(self, afXOffset = 0.0, afYOffset = 75.0, afZOffset = 0.0)
		BurnSource9.MoveTo(self, afXOffset = 0.0, afYOffset = -75.0, afZOffset = 0.0)

		;==========start dead actor going to Sovengard block========

		CUYC_PortalOpenSoundSD.Play(self)
		Utility.Wait(0.5)
		ObjectReference Portal = self.PlaceAtMe(CUYC_PortalActivator)
		Portal.MoveTo(self, afXOffset = 0.0, afYOffset = 0.0, afZOffset = 150.0)
		Utility.Wait(0.5)
		int PortalSound = CUYC_PortalSoundSD.Play(self)
		Debug.SendAnimationEvent(DeadBodyRef, "IdleNocturnalEnter")
		Utility.Wait(1)
		Debug.SendAnimationEvent(DeadBodyRef, "IdleNocturnal_IdleA")
		Utility.Wait(5)
		DeadBodyRef.TranslateToRef(Portal, 100.0)
		Utility.Wait(5)
		DeadBodyRef.StopTranslation()
		Utility.Wait(5)
		DeadBodyRef.PlaceAtMe(defaultGhostDeathExplosion)
		DeadBodyRef.SetCriticalStage(DeadBodyRef.CritStage_DisintegrateEnd)
		
		;==========reset dead actors behaviour for failsafe if not unique actor used==========

		DeadBodyRef.ClearLookAt()
		DeadBodyRef.SetDontMove(false)
		DeadBodyRef.BlockActivation(false)
		CorpseAlias.Clear()
		DeadBodyRef.EvaluatePackage()

		;==========remove portal block==========

		Portal.Disable()
		Portal.Delete()
		Sound.StopInstance(PortalSound)

		Utility.Wait(14)

		;==========remove remnants of fire, corpse and everything else and set DoOnce to false==========

		GiantFire.Disable()
		GiantFire.Delete()
		Utility.Wait(30)
		BurnedBody.Disable()
		BurnedBody.Delete()
		DoOnce = false

	ElseIf akActionRef == PlayerREF && PlayerREF.GetItemCount(CUYC_HumanCorpseDummy) < 1 && DoOnce == false
		Debug.Messagebox("You don't carry anyone to burn!")
	ElseIf akActionRef == PlayerREF && DoOnce == true && (PlayerREF.GetItemCount(CUYC_HumanCorpseDummy) < 1 || PlayerREF.GetItemCount(CUYC_HumanCorpseDummy) >= 1)
		Debug.Messagebox("You already burn someone!")
	EndIf
EndEvent