Scriptname CUYC_BodyHookScript extends activemagiceffect

Actor Property PlayerREF Auto
Actor Property CUYC_TrashPinDummyREF Auto

MiscObject Property CUYC_HumanCorpseDummy Auto
MiscObject Property CUYC_CreatureCorpseDummy Auto

GlobalVariable Property CUYC_ModActiveGlobal Auto
GlobalVariable Property CUYC_HelpMessagesActiveGlobal Auto
GlobalVariable Property CUYC_IsBurningGlobal Auto
GlobalVariable Property CUYC_VampireActive Auto
GlobalVariable Property CUYC_CorpseCheatGlobal Auto

ReferenceAlias Property CorpseAlias Auto
ReferenceAlias Property CarcassAlias Auto

Keyword Property ActorTypeNPC Auto
Keyword Property vampire Auto
Keyword Property ActorTypeAnimal Auto
Keyword Property ActorTypeCreature Auto
Keyword Property ActorTypeDwarven Auto

FormList Property CUYC_GiantRaceFormlist Auto

Ingredient Property Garlic Auto
Ingredient Property vampireDust Auto

Sound Property MAGVampireTransform01 Auto
Sound Property DRScBodyOpen Auto

VisualEffect Property DA10ReanimateTargetFX Auto

Actor Victim

Event OnEffectStart(Actor akTarget, Actor akCaster)

	If CUYC_ModActiveGlobal.GetValueInt() == 1			; is the mod active?

		Victim = akTarget			; transport to all functions

		;=====check Race blocks and see if a corpse/charcass alias is free, then go to corresponding function

		;=====Human NPC=====

		If akTarget.IsDead() && (akTarget.HasKeyword(ActorTypeNPC) && !akTarget.HasKeyword(vampire))

			If PlayerREF.GetItemCount(CUYC_HumanCorpseDummy) >= 1

				If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
					Debug.Messagebox("You already have a corpse in your inventory, you can't carry anymore!")
				ElseIf CUYC_HelpMessagesActiveGlobal .GetValueInt() == 0
					;Do nothing!
				EndIf

			ElseIf PlayerREF.GetItemCount(CUYC_HumanCorpseDummy) < 1

				If CUYC_IsBurningGlobal.GetValueInt() == 1

					If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
						Debug.Messagebox("This corpse is burning, you can't take it!")
					ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
					EndIf

				ElseIf CUYC_IsBurningGlobal.GetValueInt() == 0
				HandleHuman()
				EndIf
			EndIf

		EndIf

		;=====Vampire NPC=====

		If akTarget.IsDead() && akTarget.HasKeyword(vampire)

			If PlayerREF.GetItemCount(CUYC_HumanCorpseDummy) >= 1

				If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
					Debug.Messagebox("You already have a corpse in your inventory, you can't carry anymore!")
				ElseIf CUYC_HelpMessagesActiveGlobal .GetValueInt() == 0
					;Do nothing!
				EndIf

			ElseIf PlayerREF.GetItemCount(CUYC_HumanCorpseDummy) < 1

				If akTarget.GetItemCount(garlic) >= 1 && CUYC_IsBurningGlobal.GetValueInt() == 0			; checks for garlic so Vampire won't resurrect
					HandleVampire()
				ElseIf akTarget.GetItemCount(garlic) >= 1 && CUYC_IsBurningGlobal.GetValueInt() == 1

					If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
						Debug.Messagebox("This corpse is burning, you can't take it!")
					ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
					EndIf

				ElseIf akTarget.GetItemCount(garlic) < 1 && CUYC_IsBurningGlobal.GetValueInt() == 0

					If CUYC_VampireActive.GetValueInt() == 1

						If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
							Debug.Messagebox("You've disturbed the Vampires sleep!")
						ElseIf CUYC_HelpMessagesActiveGlobal .GetValueInt() == 0
							;Do nothing!
						EndIf
						HandleVampireGarlic()

					ElseIf CUYC_VampireActive.GetValueInt() == 0
						;Do nothing!
					EndIf
				
				ElseIf akTarget.GetItemCount(garlic) < 1 && CUYC_IsBurningGlobal.GetValueInt() == 1

					If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
						Debug.Messagebox("This corpse is burning, you can't take it!")
					ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
					EndIf


				EndIf

			EndIf

		EndIf

		;=====Creatures&Animals=====

		If akTarget.IsDead() && (akTarget.HasKeyword(ActorTypeAnimal) || akTarget.HasKeyword(ActorTypeCreature) || akTarget.HasKeyword(ActorTypeDwarven))

			If !CUYC_GiantRaceFormlist.HasForm(akTarget.GetRace())

				If PlayerREF.GetItemCount(CUYC_CreatureCorpseDummy) >= 1

					If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
						Debug.Messagebox("You already have a Carcass in your inventory, you can't carry anymore!")
					ElseIf CUYC_HelpMessagesActiveGlobal .GetValueInt() == 0
						;Do nothing!
					EndIf

				ElseIf PlayerREF.GetItemCount(CUYC_CreatureCorpseDummy) < 1

					If CUYC_IsBurningGlobal.GetValueInt() == 1

						If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
							Debug.Messagebox("This corpse is burning, you can't take it!")
						ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
						EndIf

					ElseIf CUYC_IsBurningGlobal.GetValueInt() == 0
					HandleCreature()
					EndIf
				EndIf

			ElseIf CUYC_GiantRaceFormlist.HasForm(akTarget.GetRace())

				If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
					Debug.Messagebox("You can't carry a carcass of that size!")
				ElseIf CUYC_HelpMessagesActiveGlobal .GetValueInt() == 0
					;Do nothing!
				EndIf

			EndIf
	
		EndIf

	ElseIf CUYC_ModActiveGlobal.GetValueInt() == 0

		;Do nothing!

	EndIf

EndEvent

Function HandleHuman()

	; get name and weight of dead actor and put on corpse dummy

	String CorpseName = Victim.GetActorBase().GetName()
	ActorBase ActorBaseWeight = Victim.GetActorBase()
	Float CorpseWeight = ActorBaseWeight.GetWeight()

	PlayerREF.AddItem(CUYC_HumanCorpseDummy, 1, true)						; add corpse dummy to player inventory
	int instanceID = DRScBodyOpen.play(PlayerREF)
	CUYC_HumanCorpseDummy.SetName(CorpseName + "'s" + " Corpse")			; set name of dummy to the one of actor
	CUYC_HumanCorpseDummy.SetWeight(CorpseWeight)						; set weight of dummy to the one of actor
	If CUYC_CorpseCheatGlobal.GetValueInt() == 0
	ElseIf CUYC_CorpseCheatGlobal.GetValueInt() == 1
		Victim.RemoveAllItems()
	EndIf
	Victim.MoveTo(CUYC_TrashPinDummyREF)									; move dead actor to invisible cell
	CorpseAlias.ForceRefTo(Victim)												; force dead actor to alias for recall when dropped from player inventory

EndFunction

Function HandleVampire()

	String CorpseName = Victim.GetActorBase().GetName()
	ActorBase ActorBaseWeight = Victim.GetActorBase()
	Float CorpseWeight = ActorBaseWeight.GetWeight()

	Victim.RemoveItem(vampireDust)
	PlayerREF.AddItem(CUYC_HumanCorpseDummy, 1, true)
	int instanceID = DRScBodyOpen.play(PlayerREF)
	CUYC_HumanCorpseDummy.SetName(CorpseName + "'s" + " Corpse")
	CUYC_HumanCorpseDummy.SetWeight(CorpseWeight)
	If CUYC_CorpseCheatGlobal.GetValueInt() == 0
	ElseIf CUYC_CorpseCheatGlobal.GetValueInt() == 1
		Victim.RemoveAllItems()
	EndIf
	Victim.MoveTo(CUYC_TrashPinDummyREF)
	CorpseAlias.ForceRefTo(Victim)

EndFunction

Function HandleVampireGarlic()

	;=====nice template for general Vampire resurrection function=====

	Victim.BlockActivation(PlayerREF)							; make sure that player can't activate resurrecting Vampire
	Debug.SendAnimationEvent(Victim, "GetUpBegin")			; use resurrection animation on dead Vampire taking 7 secs
	DA10ReanimateTargetFX.Play(Victim, 7)						; play resurrecting visual effect for 7 secs 
	int instanceID = MAGVampireTransform01.play(PlayerREF)	; play resurrecting sound effect for 7 secs
	Utility.Wait(7)												; wait 7 secs
	Victim.Resurrect()											; actual resurrect AFTER animation is done
	Victim.BlockActivation(false)									; unblock activation via player

EndFunction

Function HandleCreature()

	; get name and weight of dead actor and put on carcass dummy

	String CharcassName = Victim.GetActorBase().GetName()
	ActorBase ActorCharcassWeight = Victim.GetActorBase()
	Float CharcassWeight = ActorCharcassWeight.GetWeight()

	PlayerREF.AddItem(CUYC_CreatureCorpseDummy, 1, true)
	int instanceID = DRScBodyOpen.play(PlayerREF)
	CUYC_CreatureCorpseDummy.SetName(CharcassName + " Carcass")
	CUYC_CreatureCorpseDummy.SetWeight(CharcassWeight)
	If CUYC_CorpseCheatGlobal.GetValueInt() == 0
	ElseIf CUYC_CorpseCheatGlobal.GetValueInt() == 1
		Victim.RemoveAllItems()
	EndIf
	Victim.MoveTo(CUYC_TrashPinDummyREF)
	CarcassAlias.ForceRefTo(Victim)

EndFunction