Scriptname CUYC_AxeScript extends activemagiceffect

Activator Property CUYC_PoleArm Auto
Actor Property PlayerREF Auto
CUYC_TombStoneStringVarsScript Property TombStoneQuest Auto
Faction Property BanditFaction Auto
Faction Property WarlockFaction Auto
Faction Property DraugrFaction Auto
Faction Property VampireFaction Auto
Faction Property HagravenFaction Auto
Faction Property GiantFaction Auto
Faction Property DragonFaction Auto
Faction Property MammothFaction Auto
GlobalVariable Property CUYC_ModActiveGlobal Auto
GlobalVariable Property CUYC_IsBurningGlobal Auto
GlobalVariable Property CUYC_HelpMessagesActiveGlobal Auto
GlobalVariable Property CUYC_HeatSourcePlacedGlobal Auto
GlobalVariable Property CUYC_MoneyCountGlobal Auto
Hazard Property FireBarrierHazard Auto
Keyword Property ActorTypeNPC Auto
Keyword Property ActorTypeCreature Auto
Keyword Property ActorTypeAnimal Auto
Light Property LightCampFire01 Auto
ObjectReference CUYC_TombStonePosition
ObjectReference Property HeatSource Auto hidden
Sound Property WPNImpactBluntVsWood Auto
Sound Property WPNImpactAxeVsFlesh Auto

Actor Victim

Event OnEffectStart(Actor akTarget, Actor akCaster)

	If CUYC_ModActiveGlobal.GetValueInt() == 1			; is the mod active?

		Victim = akTarget			; transport to all functions

		;=====Human NPC & Vampires=====

		If akTarget.IsDead() && akTarget.HasKeyword(ActorTypeNPC)

			If CUYC_IsBurningGlobal.GetValueInt() == 1

				If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
					Debug.Messagebox("This corpse is burning, you can't bury it!")
				ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
				EndIf

			ElseIf CUYC_IsBurningGlobal.GetValueInt() == 0
				
				If !PlayerREF.GetEquippedItemType(0) == 11
					HandleHuman()
				ElseIf PlayerREF.GetEquippedItemType(0) == 11
					HandleHumanTorch()
				Else
					HandleHuman()
				EndIf
		
			EndIf

		;=====creature & animals=====

		ElseIf akTarget.IsDead() && akTarget.HasKeyword(ActorTypeCreature)

			If CUYC_IsBurningGlobal.GetValueInt() == 1

				If CUYC_HelpMessagesActiveGlobal.GetValueInt() == 1
					Debug.Messagebox("This carcass is burning, you can't bury it!")
				ElseIf CUYC_HelpMessagesActiveGlobal.GetValueInt() == 0
				EndIf

			ElseIf CUYC_IsBurningGlobal.GetValueInt() == 0
				
				HandleCreature()
		
			EndIf

		EndIf

	ElseIf CUYC_ModActiveGlobal.GetValueInt() == 0

		;Do nothing!

	EndIf

EndEvent

Function HandleHuman()

	Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
	Game.FadeOutGame(false, true, 6.0, 8.0)
	Victim.SetCriticalStage(Victim.CritStage_DisintegrateEnd)
	String ActorName = Victim.GetBaseObject().GetName()
	TombStoneQuest.CUYC_CorpseName = ActorName
	TombStoneQuest.CUYC_CorpseDoD = Utility.GameTimeToString(math.Ceiling(Utility.GetCurrentGameTime()) + 31)
	TombStoneQuest.CUYC_DeadActor = Victim
	CUYC_TombStonePosition = Victim.PlaceAtMe(CUYC_PoleArm)
	CUYC_TombStonePosition.SetPosition(CUYC_TombStonePosition.GetPositionX(), CUYC_TombStonePosition.GetPositionY(), CUYC_TombStonePosition.GetPositionZ() - 15)
	CUYC_TombStonePosition.SetAngle(Utility.RandomInt(-5, 5), Utility.RandomInt(-5, 5), CUYC_TombStonePosition.GetAngleZ())
	int instanceID = WPNImpactBluntVsWood.play(PlayerREF)
	Utility.Wait(1)
	int instanceID2 = WPNImpactBluntVsWood.play(PlayerREF)
	Utility.Wait(1)
	int instanceID3 = WPNImpactBluntVsWood.play(PlayerREF)
	Utility.Wait(1)
	int instanceID4 = WPNImpactBluntVsWood.play(PlayerREF)
	Utility.Wait(1)
	Game.EnablePlayerControls()
	PlayerREF.DrawWeapon()
	
	If Victim.IsInFaction(BanditFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 10)
		Debug.Notification("10 Gold added to reward!")
	ElseIf Victim.IsInFaction(WarlockFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 15)
		Debug.Notification("15 Gold added to reward!")
	ElseIf Victim.IsInFaction(DraugrFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 25)
		Debug.Notification("25 Gold added to reward!")
	ElseIf Victim.IsInFaction(VampireFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 50)
		Debug.Notification("50 Gold added to reward!")
	Else
		;CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 1)
		;Debug.Notification("5 Gold added to reward!")
	EndIf

EndFunction

Function HandleHumanTorch()

	Int HeatSourceActive = CUYC_HeatSourcePlacedGlobal.GetValueInt()

	Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
	Game.FadeOutGame(false, true, 6.0, 8.0)
	Victim.SetCriticalStage(Victim.CritStage_DisintegrateEnd)
	String ActorName = Victim.GetBaseObject().GetName()
	TombStoneQuest.CUYC_CorpseName = ActorName
	TombStoneQuest.CUYC_CorpseDoD = Utility.GameTimeToString(math.Ceiling(Utility.GetCurrentGameTime()) + 31)
	TombStoneQuest.CUYC_DeadActor = Victim
	CUYC_TombStonePosition = Victim.PlaceAtMe(CUYC_PoleArm)

	If HeatSourceActive == 0
		HeatSource = Victim.PlaceAtMe(LightCampfire01)
		CUYC_HeatSourcePlacedGlobal.SetValue(1)
	ElseIf HeatSourceActive == 1
	EndIf

	CUYC_TombStonePosition.SetPosition(CUYC_TombStonePosition.GetPositionX(), CUYC_TombStonePosition.GetPositionY(), CUYC_TombStonePosition.GetPositionZ() - 15)
	CUYC_TombStonePosition.SetAngle(Utility.RandomInt(-5, 5), Utility.RandomInt(-5, 5), CUYC_TombStonePosition.GetAngleZ())
	Victim.PlaceAtMe(FireBarrierHazard)
	int instanceID = WPNImpactBluntVsWood.play(PlayerREF)
	Utility.Wait(1)
	int instanceID2 = WPNImpactBluntVsWood.play(PlayerREF)
	Utility.Wait(1)
	int instanceID3 = WPNImpactBluntVsWood.play(PlayerREF)
	Utility.Wait(1)
	int instanceID4 = WPNImpactBluntVsWood.play(PlayerREF)
	Utility.Wait(1)
	Game.EnablePlayerControls()
	Utility.Wait(26)
	HeatSource.Disable()
	HeatSource.Delete()
	CUYC_HeatSourcePlacedGlobal.SetValue(0)
	PlayerREF.DrawWeapon()
	
	If Victim.IsInFaction(BanditFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 10)
		Debug.Notification("10 Gold added to reward!")
	ElseIf Victim.IsInFaction(WarlockFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 15)
		Debug.Notification("15 Gold added to reward!")
	ElseIf Victim.IsInFaction(DraugrFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 25)
		Debug.Notification("25 Gold added to reward!")
	ElseIf Victim.IsInFaction(VampireFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 50)
		Debug.Notification("50 Gold added to reward!")
	Else
		;CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 5)
		;Debug.Notification("5 Gold added to reward!")
	EndIf	

EndFunction

Function HandleCreature()

	Game.DisablePlayerControls(true, true, true, true, true, true, true, true)
	Game.FadeOutGame(false, true, 6.0, 8.0)
	Victim.SetCriticalStage(Victim.CritStage_DisintegrateEnd)
	int instanceID = WPNImpactAxeVsFlesh.play(PlayerREF)
	Utility.Wait(1)
	int instanceID2 = WPNImpactAxeVsFlesh.play(PlayerREF)
	Utility.Wait(1)
	int instanceID3 = WPNImpactAxeVsFlesh.play(PlayerREF)
	Utility.Wait(1)
	int instanceID4 = WPNImpactAxeVsFlesh.play(PlayerREF)
	Utility.Wait(1)
	Game.EnablePlayerControls()
	PlayerREF.DrawWeapon()

	If Victim.HasKeyword(ActorTypeAnimal) && !Victim.IsInFaction(MammothFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 5)
		Debug.Notification("5 Gold added to reward!")
	ElseIf Victim.IsInFaction(HagravenFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 25)
		Debug.Notification("25 Gold added to reward!")
	ElseIf Victim.IsInFaction(MammothFaction) || Victim.IsInFaction(GiantFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 50)
		Debug.Notification("50 Gold added to reward!")
	ElseIf Victim.IsInFaction(DragonFaction)
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 100)
		Debug.Notification("100 Gold added to reward!")
	Else
		CUYC_MoneyCountGlobal.SetValueInt(CUYC_MoneyCountGlobal.GetValueInt() + 1)
		Debug.Notification("1 Gold added to reward!")
	EndIf

EndFunction