﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.Net;
using System.IO;
using System.Threading;

namespace SinaPic
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                textBox1.Text = ofd.FileNames[0];
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog sfd = new FolderBrowserDialog();
            if (sfd.ShowDialog() == DialogResult.OK)
            {
                textBox2.Text = sfd.SelectedPath;
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //解析xml
            XmlDocument doc = new XmlDocument();
            doc.Load(textBox1.Text);


            XmlNode node = doc.SelectSingleNode("PhotoList");
            XmlNodeList childs = node.ChildNodes;
            foreach (XmlNode child in childs)
            {
                string pathdir = textBox2.Text +"\\"+ child.Name;
                if (!Directory.Exists(pathdir))
                {
                    Directory.CreateDirectory(pathdir);
                }
                XmlNodeList piclist = child.ChildNodes;
                foreach (XmlNode picone in piclist)
                {
                    Thread.Sleep(500);
                    string url = picone.FirstChild.Value;
                    string name = GenUnid(20) + ".jpg";
                    string filepath = pathdir + "\\" + name;
                    Thread mythread = new Thread(() => downloadpic(url, filepath));
                    mythread.Start();
                }
            }

        }


        public static string GenUnid(int txt_len)
        {
            StringBuilder sb = new StringBuilder();
            string cLISTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            int len = 0;
            int pos = 0;
            DateTime dt = DateTime.Now;
            len = cLISTCHARS.Length;
            Random rd = new Random();
            sb.Append(dt.ToFileTime());
            if (sb.Length == 18)
                sb.Append("N");
            for (int i = 0; i < 1; i++)
            {
                pos = rd.Next(1, len);
                string add = cLISTCHARS.Substring(pos - 1, 1);
                sb.Append(add);
            }


            return sb.ToString();

        }
        public void downloadpic(string url,string path)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(new Uri(url));
            WebResponse response = null;
            FileStream writer = new FileStream(path, FileMode.OpenOrCreate, FileAccess.Write);
            long lStartPos = writer.Length; ;//当前文件大小
            long currentLength = 0;
            long totalLength = 0;//总大小


            response = request.GetResponse();
            totalLength = response.ContentLength;


            Stream reader = response.GetResponseStream();

            byte[] buff = new byte[1024];
            int c = 0; //实际读取的字节数

            while ((c = reader.Read(buff, 0, buff.Length)) > 0)
            {
                currentLength += c;
                writer.Write(buff, 0, c);
                writer.Flush();
            }
            if (reader != null)
            {
                reader.Close();
                reader.Dispose();
                response.Close();
                writer.Close();
            }
        }
    }
}
