/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagElement;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class LayoutFormPanel
implements HTMLTagElement,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7299636405173131600L;
    private Vector list = new Vector();
    private int cols;
    transient PropertyChangeSupport changes_;
    transient VetoableChangeSupport vetos_;
    transient Vector elementListeners_;

    public void addElement(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        this.list.addElement(hTMLTagElement);
        this.fireElementEvent(0);
    }

    public void addElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ == null) {
            this.elementListeners_ = new Vector();
        }
        this.elementListeners_.addElement(elementListener);
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    HTMLTagElement getElement(int n) {
        return (HTMLTagElement)this.list.elementAt(n);
    }

    public int getSize() {
        return this.list.size();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeElement(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        if (this.list.removeElement(hTMLTagElement)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ != null) {
            this.elementListeners_.removeElement(elementListener);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

