/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import com.ibm.as400.util.html.HTMLTree;
import com.ibm.as400.util.html.HTMLVector;
import com.ibm.as400.util.html.ResourceBundleLoader_h;
import com.ibm.as400.util.html.URLEncoder;
import com.ibm.as400.util.html.URLParser;
import com.ibm.as400.util.servlet.ServletHyperlink;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Collator;
import java.util.Properties;
import java.util.Vector;

public class HTMLTreeElement
implements HTMLTagElement,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static final long serialVersionUID = -2067619739727758210L;
    private HTMLVector branches_;
    private boolean expanded_ = false;
    private HTMLHyperlink textUrl_ = null;
    private HTMLHyperlink iconUrl_ = null;
    private HTMLTagElement elementData_ = null;
    private boolean sort_ = true;
    private transient Collator collator_;
    private static String expandedGif_ = null;
    private static String collapsedGif_ = null;
    private static String docGif_ = null;
    private static final String std = new String("<td>\n");
    private static final String etd = new String("</td>\n");
    transient PropertyChangeSupport changes_;
    private transient Vector elementListeners_;

    public HTMLTreeElement() {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception exception) {
            this.collator_ = null;
        }
        this.branches_ = new HTMLVector();
    }

    public HTMLTreeElement(String string) {
        this();
        this.setText(string);
    }

    public HTMLTreeElement(HTMLTagElement hTMLTagElement) {
        this();
        this.setText(hTMLTagElement);
    }

    public HTMLTreeElement(HTMLHyperlink hTMLHyperlink) {
        this();
        this.setTextUrl(hTMLHyperlink);
    }

    public void addElement(HTMLTreeElement hTMLTreeElement) {
        if (hTMLTreeElement == null) {
            throw new NullPointerException("element");
        }
        this.branches_.addElement(hTMLTreeElement);
        if (this.elementListeners_ != null) {
            this.fireElementEvent(0);
        }
    }

    public void addElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ == null) {
            this.elementListeners_ = new Vector();
        }
        this.elementListeners_.addElement(elementListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    private void fireElementEvent(int n) {
        Vector vector = (Vector)this.elementListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getCollapsedGif() {
        return collapsedGif_;
    }

    public String getDocGif() {
        return docGif_;
    }

    public String getExpandedGif() {
        return expandedGif_;
    }

    public HTMLHyperlink getIconUrl() {
        return this.iconUrl_;
    }

    public HTMLTagElement getText() {
        return this.elementData_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLTreeElement was here -->";
    }

    public String getTag() {
        if (this.iconUrl_ == null) {
            throw new ExtendedIllegalStateException("iconUrl", 4);
        }
        this.setIconUrl(this.iconUrl_);
        if (this.elementData_ == null) {
            throw new ExtendedIllegalStateException("text", 4);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr>\n");
        if (this.isLeaf()) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Element is a leaf.");
            }
            stringBuffer.append(std);
            if (docGif_ != null) {
                stringBuffer.append("<img src=\"");
                stringBuffer.append(docGif_);
                stringBuffer.append("\" border=\"0\" width=\"9\" height=\"14\" vspace=\"3\" alt=\"");
                stringBuffer.append(ResourceBundleLoader_h.getText("PROP_NAME_WORK"));
                stringBuffer.append("\" />\n");
            } else {
                stringBuffer.append(">");
            }
            stringBuffer.append(etd);
            stringBuffer.append(std);
            stringBuffer.append(this.elementData_.getTag());
            stringBuffer.append("\n");
            stringBuffer.append(etd);
            stringBuffer.append("</tr>\n");
        } else {
            Object[] objectArray;
            String string = URLEncoder.encode(Integer.toString(this.hashCode()));
            stringBuffer.append(std);
            StringBuffer stringBuffer2 = new StringBuffer();
            if (this.isExpanded()) {
                if (expandedGif_ != null) {
                    stringBuffer2.append("<img src=\"");
                    stringBuffer2.append(expandedGif_);
                    stringBuffer2.append("\" border=\"0\" width=\"9\" height=\"14\" vspace=\"3\" alt=\"");
                    stringBuffer2.append(ResourceBundleLoader_h.getText("PROP_NAME_COMPRESS"));
                    stringBuffer2.append("\" />");
                } else {
                    stringBuffer2.append("-");
                }
            } else if (collapsedGif_ != null) {
                stringBuffer2.append("<img src=\"");
                stringBuffer2.append(collapsedGif_);
                stringBuffer2.append("\" border=\"0\" width=\"9\" height=\"14\" vspace=\"3\" alt=\"");
                stringBuffer2.append(ResourceBundleLoader_h.getText("PROP_NAME_EXPAND"));
                stringBuffer2.append("\" />");
            } else {
                stringBuffer2.append("+");
            }
            if (this.iconUrl_ != null) {
                try {
                    this.iconUrl_.setName(string);
                    Properties properties = this.iconUrl_.getProperties();
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.put("hashcode", string);
                    if (this.expanded_) {
                        properties.put("action", "contract");
                    } else {
                        properties.put("action", "expand");
                    }
                    this.iconUrl_.setProperties(properties);
                    objectArray = new URLParser(this.iconUrl_.getLink());
                    this.iconUrl_.setLink(objectArray.getURI());
                    this.iconUrl_.setText(stringBuffer2.toString());
                    this.iconUrl_.setLocation(string);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                stringBuffer.append(this.iconUrl_.getTag());
            } else {
                stringBuffer.append(stringBuffer2);
            }
            stringBuffer.append("\n");
            stringBuffer.append(etd);
            stringBuffer.append(std);
            if (this.textUrl_ != null) {
                try {
                    if (this.textUrl_.getText() == null) {
                        this.textUrl_.setText(this.elementData_.getTag() + "\n");
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                stringBuffer.append(this.textUrl_.getTag());
            } else {
                stringBuffer.append(this.elementData_.getTag());
                stringBuffer.append("\n");
            }
            stringBuffer.append(etd);
            stringBuffer.append("</tr>\n");
            if (this.isExpanded()) {
                stringBuffer.append("<tr><td>&nbsp;</td><td>\n<table cellpadding=\"0\" cellspacing=\"3\">\n");
                if (this.sort_) {
                    HTMLTree.sort(this.collator_, this.branches_);
                }
                int n = this.branches_.getCount();
                objectArray = this.branches_.getData();
                for (int i = 0; i < n; ++i) {
                    HTMLTreeElement hTMLTreeElement = (HTMLTreeElement)objectArray[i];
                    stringBuffer.append(hTMLTreeElement.getTag());
                }
                stringBuffer.append("</table>\n</tr>\n");
            }
        }
        return stringBuffer.toString();
    }

    public HTMLHyperlink getTextUrl() {
        return this.textUrl_;
    }

    public boolean isExpanded() {
        return this.expanded_;
    }

    public boolean isLeaf() {
        return this.branches_.isEmpty();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception exception) {
            this.collator_ = null;
        }
        objectInputStream.defaultReadObject();
    }

    public void removeElement(HTMLTreeElement hTMLTreeElement) {
        if (hTMLTreeElement == null) {
            throw new NullPointerException("element");
        }
        if (this.branches_.removeElement(hTMLTreeElement) && this.elementListeners_ != null) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ != null) {
            this.elementListeners_.removeElement(elementListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void selected(int n) {
        if (!this.isLeaf()) {
            if (this.hashCode() == n) {
                boolean bl = this.expanded_;
                boolean bl2 = this.expanded_ = !this.expanded_;
                if (this.changes_ != null) {
                    this.changes_.firePropertyChange("selected", new Boolean(bl), new Boolean(this.expanded_));
                }
            } else {
                int n2 = this.branches_.getCount();
                Object[] objectArray = this.branches_.getData();
                for (int i = 0; i < n2; ++i) {
                    HTMLTreeElement hTMLTreeElement = (HTMLTreeElement)objectArray[i];
                    hTMLTreeElement.selected(n);
                }
            }
        }
    }

    public static void setCollapsedGif(String string) {
        if (string == null) {
            throw new NullPointerException("gifUrl");
        }
        collapsedGif_ = string;
    }

    public static void setDocGif(String string) {
        if (string == null) {
            throw new NullPointerException("gifUrl");
        }
        docGif_ = string;
    }

    public static void setExpandedGif(String string) {
        if (string == null) {
            throw new NullPointerException("gifUrl");
        }
        expandedGif_ = string;
    }

    public void setExpanded(boolean bl) {
        boolean bl2 = this.expanded_;
        this.expanded_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("expanded", new Boolean(bl2), new Boolean(this.expanded_));
        }
    }

    public void setIconUrl(HTMLHyperlink hTMLHyperlink) {
        if (hTMLHyperlink == null) {
            throw new NullPointerException("iconUrl");
        }
        HTMLHyperlink hTMLHyperlink2 = this.iconUrl_;
        this.iconUrl_ = hTMLHyperlink;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("url", hTMLHyperlink2, hTMLHyperlink);
        }
        int n = this.branches_.getCount();
        Object[] objectArray = this.branches_.getData();
        for (int i = 0; i < n; ++i) {
            HTMLHyperlink hTMLHyperlink3 = null;
            HTMLTreeElement hTMLTreeElement = (HTMLTreeElement)objectArray[i];
            hTMLHyperlink3 = hTMLHyperlink instanceof ServletHyperlink ? (ServletHyperlink)hTMLHyperlink.clone() : (HTMLHyperlink)hTMLHyperlink.clone();
            hTMLTreeElement.setIconUrl(hTMLHyperlink3);
        }
    }

    public void setText(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        HTMLTagElement hTMLTagElement2 = this.elementData_;
        this.elementData_ = hTMLTagElement;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("element", hTMLTagElement2, this.elementData_);
        }
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        HTMLTagElement hTMLTagElement = this.elementData_;
        this.elementData_ = new HTMLText(string);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", hTMLTagElement, this.elementData_);
        }
    }

    public void setTextUrl(HTMLHyperlink hTMLHyperlink) {
        if (hTMLHyperlink == null) {
            throw new NullPointerException("textUrl");
        }
        HTMLHyperlink hTMLHyperlink2 = this.textUrl_;
        this.textUrl_ = hTMLHyperlink;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("url", hTMLHyperlink2, hTMLHyperlink);
        }
        this.setText(hTMLHyperlink);
    }

    public void sort(boolean bl) {
        this.sort_ = bl;
    }
}

