/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLTableRow
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -3968067893063774982L;
    private Vector row_ = new Vector();
    private String hAlign_;
    private String vAlign_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private int borderWidth_ = 1;
    private int cellPadding_ = 1;
    private transient Vector columnListeners_;
    private transient VetoableChangeSupport vetos_;

    public HTMLTableRow() {
    }

    public HTMLTableRow(HTMLTableCell[] hTMLTableCellArray) {
        this();
        if (hTMLTableCellArray == null) {
            throw new NullPointerException("cells");
        }
        for (int i = 0; i < hTMLTableCellArray.length; ++i) {
            this.row_.addElement(hTMLTableCellArray[i]);
        }
    }

    public void addColumn(HTMLTableCell hTMLTableCell) {
        if (hTMLTableCell == null) {
            throw new NullPointerException("cell");
        }
        this.row_.addElement(hTMLTableCell);
        this.fireAdded();
    }

    public void addColumnListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.columnListeners_ == null) {
            this.columnListeners_ = new Vector();
        }
        this.columnListeners_.addElement(elementListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private void fireAdded() {
        if (this.columnListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.columnListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, 0);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            elementListener.elementAdded(elementEvent);
        }
    }

    private void fireChanged() {
        if (this.columnListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.columnListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, 1);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            elementListener.elementChanged(elementEvent);
        }
    }

    private void fireRemoved() {
        if (this.columnListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.columnListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, 2);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            elementListener.elementRemoved(elementEvent);
        }
    }

    public HTMLTableCell getColumn(int n) {
        if (n < 0 || n >= this.row_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        return (HTMLTableCell)this.row_.elementAt(n);
    }

    public int getColumnCount() {
        return this.row_.size();
    }

    public int getColumnIndex(HTMLTableCell hTMLTableCell) {
        if (hTMLTableCell == null) {
            throw new NullPointerException("cell");
        }
        return this.row_.indexOf(hTMLTableCell);
    }

    public int getColumnIndex(HTMLTableCell hTMLTableCell, int n) {
        if (hTMLTableCell == null) {
            throw new NullPointerException("cell");
        }
        if (n >= this.row_.size() || n < 0) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return this.row_.indexOf(hTMLTableCell, n);
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public String getHorizontalAlignment() {
        return this.hAlign_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.row_.size() == 0) {
            Trace.log(2, "Attempting to get tag before adding a column to the row.");
            throw new ExtendedIllegalStateException("column", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<tr");
        if (this.hAlign_ != null) {
            stringBuffer.append(" align=\"");
            stringBuffer.append(this.hAlign_);
            stringBuffer.append("\"");
        }
        if (this.vAlign_ != null) {
            stringBuffer.append(" valign=\"");
            stringBuffer.append(this.vAlign_);
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        for (int i = 0; i < this.row_.size(); ++i) {
            HTMLTableCell hTMLTableCell = (HTMLTableCell)this.row_.elementAt(i);
            stringBuffer.append(hTMLTableCell.getTag());
        }
        stringBuffer.append("</tr>\n");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        boolean bl = this.useFO_;
        this.setUseFO(true);
        int n = this.row_.size();
        if (n == 0) {
            Trace.log(2, "Attempting to get XSL-FO tag before adding a column to the row.");
            throw new ExtendedIllegalStateException("column", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<fo:table-row");
        if (this.hAlign_ != null) {
            stringBuffer.append(" text-align=\"");
            if (this.hAlign_.equalsIgnoreCase("center")) {
                stringBuffer.append("center");
            } else if (this.hAlign_.equalsIgnoreCase("left")) {
                stringBuffer.append("start");
            } else if (this.hAlign_.equalsIgnoreCase("right")) {
                stringBuffer.append("end");
            }
            stringBuffer.append("\"");
        }
        stringBuffer.append(">\n");
        for (int i = 0; i < n; ++i) {
            HTMLTableCell hTMLTableCell = (HTMLTableCell)this.row_.elementAt(i);
            hTMLTableCell.setBorderWidth(this.borderWidth_);
            if (this.cellPadding_ > -1) {
                hTMLTableCell.setCellPadding(this.cellPadding_);
            }
            if (this.dir_ != null && this.dir_.length() > 0) {
                try {
                    hTMLTableCell.setDirection(this.dir_);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            stringBuffer.append(hTMLTableCell.getFOTag());
        }
        stringBuffer.append("</fo:table-row>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public String getVerticalAlignment() {
        return this.vAlign_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeAllColumns() {
        this.row_.removeAllElements();
        this.fireRemoved();
    }

    public void removeColumn(HTMLTableCell hTMLTableCell) {
        if (hTMLTableCell == null) {
            throw new NullPointerException("cell");
        }
        if (this.row_.removeElement(hTMLTableCell)) {
            this.fireRemoved();
        }
    }

    public void removeColumn(int n) {
        if (n < 0 || n >= this.row_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        this.row_.removeElement((HTMLTableCell)this.row_.elementAt(n));
        this.fireRemoved();
    }

    public void removeColumnListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.columnListeners_ != null) {
            this.columnListeners_.removeElement(elementListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setColumn(HTMLTableCell hTMLTableCell, int n) {
        if (hTMLTableCell == null) {
            throw new NullPointerException("cell");
        }
        if (n > this.row_.size() || n < 0) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        if (n == this.row_.size()) {
            this.addColumn(hTMLTableCell);
        } else {
            this.row_.setElementAt(hTMLTableCell, n);
            this.fireChanged();
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setHorizontalAlignment(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        if (string.equalsIgnoreCase("left") || string.equalsIgnoreCase("center") || string.equalsIgnoreCase("right")) {
            String string2 = this.hAlign_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", string2, string);
            }
            this.hAlign_ = string;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", string2, string);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setBorderWidth(int n) {
        Integer n2 = new Integer(this.borderWidth_);
        Integer n3 = new Integer(n);
        this.borderWidth_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("borderWidth", n2, n3);
        }
    }

    public void setCellPadding(int n) {
        Integer n2 = new Integer(this.cellPadding_);
        Integer n3 = new Integer(n);
        this.cellPadding_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellPadding", n2, n3);
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public void setVerticalAlignment(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        if (string.equalsIgnoreCase("top") || string.equalsIgnoreCase("middle") || string.equalsIgnoreCase("bottom") || string.equalsIgnoreCase("baseline")) {
            String string2 = this.vAlign_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", string2, string);
            }
            this.vAlign_ = string;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", string2, string);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

