/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLAlign
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7673670119386729128L;
    private String align_ = "left";
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private Vector list_ = new Vector();
    private transient Vector elementListeners;

    public HTMLAlign() {
    }

    public HTMLAlign(HTMLTagElement hTMLTagElement) {
        this.addItem(hTMLTagElement);
    }

    public HTMLAlign(HTMLTagElement hTMLTagElement, String string) {
        this.addItem(hTMLTagElement);
        this.setAlign(string);
    }

    public void addItem(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("data");
        }
        this.list_.addElement(hTMLTagElement);
        this.fireElementEvent(0);
    }

    public void addItemElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(elementListener);
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getAlign() {
        return this.align_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get tag before adding items to list.");
            throw new ExtendedIllegalStateException("data", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                stringBuffer.append("<div align=\"left\"");
            } else if (this.align_.equals("right")) {
                stringBuffer.append("<div align=\"right\"");
            } else if (this.align_.equals("center")) {
                stringBuffer.append("<div align=\"center\"");
            }
        }
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement hTMLTagElement = (HTMLTagElement)this.list_.elementAt(i);
            stringBuffer.append(hTMLTagElement.getTag());
        }
        stringBuffer.append("\n</div>\n");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        boolean bl = this.useFO_;
        this.setUseFO(true);
        if (this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before adding items to list.");
            throw new ExtendedIllegalStateException("data", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                stringBuffer.append("<fo:block text-align='start'");
            } else if (this.align_.equals("right")) {
                stringBuffer.append("<fo:block text-align='end'");
            } else if (this.align_.equals("center")) {
                stringBuffer.append("<fo:block text-align='center'");
            }
        }
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement hTMLTagElement = (HTMLTagElement)this.list_.elementAt(i);
            stringBuffer.append(hTMLTagElement.getFOTag());
            stringBuffer.append("\n");
        }
        stringBuffer.append("</fo:block>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public void removeItemElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(elementListener);
        }
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeItem(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("data");
        }
        if (this.list_.removeElement(hTMLTagElement)) {
            this.fireElementEvent(2);
        }
    }

    public void setAlign(String string) {
        if (string == null) {
            throw new NullPointerException("align");
        }
        if (!(string.equals("left") || string.equals("right") || string.equals("center"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting alignment for <div>.");
        }
        String string2 = this.align_;
        this.align_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("align", string2, string);
        }
    }

    public void setDirection(String string) {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

