/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.io.IOException;
import java.util.Date;

public class RQueuedMessage
extends Resource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
    private static final String ICON_BASE_NAME_ = "RQueuedMessage";
    private static final String PRESENTATION_KEY_ = "QUEUED_MESSAGE";
    static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "QUEUED_MESSAGE");
    public static final String ALERT_OPTION = "ALERT_OPTION";
    public static final String ALERT_OPTION_DEFER = "*DEFER";
    public static final String ALERT_OPTION_IMMEDIATE = "*IMMED";
    public static final String ALERT_OPTION_NO = "*NO";
    public static final String ALERT_OPTION_UNATTENDED = "*UNATTEND";
    public static final String DATE_SENT = "DATE_SENT";
    public static final String DEFAULT_REPLY = "DEFAULT_REPLY";
    public static final String MESSAGE_FILE = "MESSAGE_FILE";
    public static final String MESSAGE_HELP = "MESSAGE_HELP";
    public static final String MESSAGE_ID = "MESSAGE_ID";
    public static final String MESSAGE_KEY = "MESSAGE_KEY";
    public static final String MESSAGE_QUEUE = "MESSAGE_QUEUE";
    public static final String MESSAGE_SEVERITY = "MESSAGE_SEVERITY";
    public static final String MESSAGE_TEXT = "MESSAGE_TEXT";
    public static final String MESSAGE_TYPE = "MESSAGE_TYPE";
    public static final String REPLY_STATUS = "REPLY_STATUS";
    public static final String REPLY_STATUS_ACCEPTS_SENT = "A";
    public static final String REPLY_STATUS_ACCEPTS_NOT_SENT = "W";
    public static final String REPLY_STATUS_NOT_ACCEPT = "N";
    public static final String SENDER_JOB_NAME = "SENDER_JOB_NAME";
    public static final String SENDER_USER_NAME = "SENDER_USER_NAME";
    public static final String SENDER_JOB_NUMBER = "SENDER_JOB_NUMBER";
    public static final String SENDING_PROGRAM_NAME = "SENDING_PROGRAM_NAME";
    public static final String SUBSTITUTION_DATA = "SUBSTITUTION_DATA";

    public RQueuedMessage() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    static Object computeResourceKey(AS400 aS400, String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RQueuedMessage.class);
        stringBuffer.append(':');
        stringBuffer.append(aS400.getSystemName());
        stringBuffer.append(':');
        stringBuffer.append(aS400.getUserId());
        stringBuffer.append(':');
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(Presentation.bytesToHex(byArray));
        return stringBuffer.toString();
    }

    public void load(int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        block6: {
            AS400 aS400 = this.getSystem();
            String string = null;
            String string2 = null;
            String string3 = this.getAttributeValueAsString(MESSAGE_FILE);
            if (aS400 == null || string3 == null) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "system or path is null in load()");
                }
                return;
            }
            try {
                QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string3);
                string2 = qSYSObjectPathName.getLibraryName();
                string = qSYSObjectPathName.getObjectName();
                String string4 = this.getAttributeValueAsString(MESSAGE_ID);
                byte[] byArray = (byte[])this.getAttributeValueAsObject(SUBSTITUTION_DATA);
                if (string2 == null || string == null || string4 == null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "library, file or ID is null in load()");
                    }
                    return;
                }
                AS400Message aS400Message = null;
                MessageFile messageFile = new MessageFile(aS400, QSYSObjectPathName.toPath(string2, string, "MSGF"));
                messageFile.setHelpTextFormatting(n);
                aS400Message = messageFile.getMessage(string4, byArray);
                this.initializeAttributeValue(MESSAGE_HELP, aS400Message.getHelp());
            }
            catch (Exception exception) {
                if (!Trace.isTraceOn()) break block6;
                Trace.log(2, "Exception getting help from message file in load()", (Throwable)exception);
            }
        }
    }

    private Object getAttributeValueAsObject(Object object) {
        try {
            return this.getAttributeValue(object);
        }
        catch (ResourceException resourceException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error getting attribute value", (Throwable)resourceException);
            }
            return null;
        }
    }

    private String getAttributeValueAsString(Object object) {
        try {
            return (String)this.getAttributeValue(object);
        }
        catch (ResourceException resourceException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error getting attribute value", (Throwable)resourceException);
            }
            return null;
        }
    }

    static {
        attributes_.add(ALERT_OPTION, String.class, true, new String[]{ALERT_OPTION_DEFER, ALERT_OPTION_IMMEDIATE, ALERT_OPTION_NO, ALERT_OPTION_UNATTENDED, ""}, null, true);
        attributes_.add((Object)DATE_SENT, Date.class, true);
        attributes_.add((Object)DEFAULT_REPLY, String.class, true);
        attributes_.add((Object)MESSAGE_FILE, String.class, true);
        attributes_.add((Object)MESSAGE_HELP, String.class, true);
        attributes_.add((Object)MESSAGE_ID, String.class, true);
        attributes_.add((Object)MESSAGE_KEY, byte[].class, true);
        attributes_.add((Object)MESSAGE_QUEUE, String.class, true);
        attributes_.add((Object)MESSAGE_SEVERITY, Integer.class, true);
        attributes_.add((Object)MESSAGE_TEXT, String.class, true);
        attributes_.add(MESSAGE_TYPE, Integer.class, true, new Integer[]{new Integer(1), new Integer(2), new Integer(4), new Integer(5), new Integer(6), new Integer(8), new Integer(10), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(21), new Integer(22), new Integer(23), new Integer(24), new Integer(25)}, null, true);
        attributes_.add(REPLY_STATUS, String.class, true, new String[]{REPLY_STATUS_ACCEPTS_SENT, REPLY_STATUS_ACCEPTS_NOT_SENT, REPLY_STATUS_NOT_ACCEPT}, null, true);
        attributes_.add((Object)SENDER_JOB_NAME, String.class, true);
        attributes_.add((Object)SENDER_USER_NAME, String.class, true);
        attributes_.add((Object)SENDER_JOB_NUMBER, String.class, true);
        attributes_.add((Object)SENDING_PROGRAM_NAME, String.class, true);
        attributes_.add((Object)SUBSTITUTION_DATA, byte[].class, true);
    }
}

