/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;
import java.util.Date;

public class RIFSFile
extends ChangeableResource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
    private static final String ICON_BASE_NAME_ = "RIFSFile";
    private static final String PRESENTATION_KEY_ = "IFSFILE";
    static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "IFSFILE");
    public static final String ABSOLUTE_PATH = "ABSOLUTE_PATH";
    public static final String CANONICAL_PATH = "CANONICAL_PATH";
    public static final String CAN_READ = "CAN_READ";
    public static final String CAN_WRITE = "CAN_WRITE";
    public static final String CCSID = "CCSID";
    public static final String CREATED = "CREATED";
    public static final String EXISTS = "EXISTS";
    public static final String IS_ABSOLUTE = "IS_ABSOLUTE";
    public static final String IS_DIRECTORY = "IS_DIRECTORY";
    public static final String IS_FILE = "IS_FILE";
    public static final String IS_HIDDEN = "IS_HIDDEN";
    public static final String IS_READ_ONLY = "IS_READ_ONLY";
    public static final String LAST_ACCESSED = "LAST_ACCESSED";
    public static final String LAST_MODIFIED = "LAST_MODIFIED";
    public static final String LENGTH = "LENGTH";
    public static final String NAME = "NAME";
    public static final String OWNERID = "OWNERID";
    public static final String PARENT = "PARENT";
    public static final String PATH = "PATH";
    public static final String TYPE = "TYPE";
    public static final String TYPE_DIRECTORY = "*DIRECTORY";
    public static final String TYPE_FILE = "*FILE";
    public static final String TYPE_UNKNOWN = "*UNKNOWN";
    private IFSFile file_ = new IFSFile();
    private String path_ = null;

    public RIFSFile() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    public RIFSFile(AS400 aS400, String string) {
        this();
        try {
            this.setSystem(aS400);
            this.setPath(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    RIFSFile(IFSFile iFSFile) {
        this();
        try {
            this.setSystem(iFSFile.getSystem());
            this.file_ = iFSFile;
            this.path_ = iFSFile.getPath();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void commitAttributeChanges(Object[] objectArray, Object[] objectArray2) throws ResourceException {
        super.commitAttributeChanges(objectArray, objectArray2);
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl = true;
                if (objectArray[i].equals(IS_HIDDEN)) {
                    bl = this.file_.setHidden((Boolean)objectArray2[i]);
                } else if (objectArray[i].equals(LAST_MODIFIED)) {
                    bl = this.file_.setLastModified(((Date)objectArray2[i]).getTime());
                } else if (objectArray[i].equals(IS_READ_ONLY)) {
                    bl = this.file_.setReadOnly((Boolean)objectArray2[i]);
                } else {
                    throw new ExtendedIllegalArgumentException("attributeIDs[" + i + "](" + objectArray[i] + ")", 2);
                }
                if (bl) continue;
                throw new ResourceException(2);
            }
        }
        catch (Exception exception) {
            throw new ResourceException(2, (Throwable)exception);
        }
    }

    static Object computeResourceKey(AS400 aS400, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RIFSFile.class);
        stringBuffer.append(':');
        stringBuffer.append(aS400.getSystemName());
        stringBuffer.append(':');
        stringBuffer.append(aS400.getUserId());
        stringBuffer.append(':');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void delete() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            boolean bl = this.file_.delete();
            if (!bl) {
                throw new ResourceException(4);
            }
        }
        catch (Exception exception) {
            throw new ResourceException(exception);
        }
    }

    protected void establishConnection() throws ResourceException {
        if (this.file_.getPath() == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        super.establishConnection();
    }

    protected void freezeProperties() throws ResourceException {
        if (this.file_.getPath() == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(this.file_.getName());
        presentation.setFullName(this.file_.getPath());
        if (this.getResourceKey() == null) {
            this.setResourceKey(RIFSFile.computeResourceKey(this.getSystem(), this.file_.getPath()));
        }
        super.freezeProperties();
    }

    public Object getAttributeUnchangedValue(Object object) throws ResourceException {
        Object object2 = super.getAttributeUnchangedValue(object);
        if (object2 == null) {
            if (!this.isConnectionEstablished()) {
                this.establishConnection();
            }
            try {
                if (object.equals(ABSOLUTE_PATH)) {
                    return this.file_.getAbsolutePath();
                }
                if (object.equals(CANONICAL_PATH)) {
                    return this.file_.getCanonicalPath();
                }
                if (object.equals(CAN_READ)) {
                    return this.file_.canRead() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (object.equals(CAN_WRITE)) {
                    return this.file_.canWrite() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (object.equals(CCSID)) {
                    return new Integer(this.file_.getCCSID());
                }
                if (object.equals(CREATED)) {
                    return new Date(this.file_.created());
                }
                if (object.equals(EXISTS)) {
                    return this.file_.exists() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (object.equals(IS_ABSOLUTE)) {
                    return this.file_.isAbsolute() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (object.equals(IS_DIRECTORY)) {
                    return this.file_.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (object.equals(IS_FILE)) {
                    return this.file_.isFile() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (object.equals(IS_HIDDEN)) {
                    return this.file_.isHidden() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (object.equals(IS_READ_ONLY)) {
                    return this.file_.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (object.equals(LAST_ACCESSED)) {
                    return new Date(this.file_.lastAccessed());
                }
                if (object.equals(LAST_MODIFIED)) {
                    return new Date(this.file_.lastModified());
                }
                if (object.equals(LENGTH)) {
                    return new Long(this.file_.length());
                }
                if (object.equals(NAME)) {
                    return this.file_.getName();
                }
                if (object.equals(OWNERID)) {
                    return new Integer(this.file_.getOwnerId());
                }
                if (object.equals(PARENT)) {
                    return this.file_.getParent();
                }
                if (object.equals(PATH)) {
                    return this.file_.getPath();
                }
                if (object.equals(TYPE)) {
                    if (this.file_.isDirectory()) {
                        return TYPE_DIRECTORY;
                    }
                    if (this.file_.isFile()) {
                        return TYPE_FILE;
                    }
                    return TYPE_UNKNOWN;
                }
                throw new ExtendedIllegalArgumentException("attributeID(" + object + ")", 2);
            }
            catch (Exception exception) {
                throw new ResourceException(exception);
            }
        }
        return object2;
    }

    public String getPath() {
        return this.path_;
    }

    public void refreshAttributeValues() throws ResourceException {
        super.refreshAttributeValues();
        this.file_.clearCachedAttributes();
    }

    public void setPath(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.file_.getPath();
        try {
            this.path_ = string;
            String string3 = string.replace(IFSJavaFile.separatorChar, '/');
            this.file_.setPath(string3);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.firePropertyChange("path", string2, string);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        super.setSystem(aS400);
        this.file_.setSystem(aS400);
    }

    static {
        attributes_.add((Object)ABSOLUTE_PATH, String.class, true);
        attributes_.add((Object)CANONICAL_PATH, String.class, true);
        attributes_.add((Object)CAN_READ, Boolean.class, true);
        attributes_.add((Object)CAN_WRITE, Boolean.class, true);
        attributes_.add((Object)CCSID, Integer.class, true);
        attributes_.add((Object)CREATED, Date.class, true);
        attributes_.add((Object)EXISTS, Boolean.class, true);
        attributes_.add((Object)IS_ABSOLUTE, Boolean.class, true);
        attributes_.add((Object)IS_DIRECTORY, Boolean.class, true);
        attributes_.add((Object)IS_FILE, Boolean.class, true);
        attributes_.add((Object)IS_HIDDEN, Boolean.class, false);
        attributes_.add((Object)IS_READ_ONLY, Boolean.class, false);
        attributes_.add((Object)LAST_ACCESSED, Date.class, true);
        attributes_.add((Object)LAST_MODIFIED, Date.class, false);
        attributes_.add((Object)LENGTH, Long.class, true);
        attributes_.add((Object)NAME, String.class, true);
        attributes_.add((Object)OWNERID, Integer.class, true);
        attributes_.add((Object)PARENT, String.class, true);
        attributes_.add((Object)PATH, String.class, true);
        attributes_.add(TYPE, String.class, true, new Object[]{TYPE_DIRECTORY, TYPE_FILE, TYPE_UNKNOWN}, null, true);
    }
}

