/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.PersistenceException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.ValidationListAttribute;
import com.ibm.as400.access.ValidationListAttributeInfo;
import com.ibm.as400.access.ValidationListEntry;
import com.ibm.as400.access.ValidationListTranslatedData;
import java.beans.PropertyVetoException;

public class ValidationList {
    private static int LISTBUFFER_LENGTH_INITIAL = 32768;
    private static int LISTBUFFER_LENGTH_NEXT = 524288;
    private AS400 as400_ = null;
    private AS400Structure listInfo_ = null;
    private AS400Structure vlde0100_ = null;
    private QSYSObjectPathName path_ = null;
    private String description_ = null;

    public ValidationList() {
    }

    public ValidationList(AS400 aS400) {
        this();
        this.setAS400(aS400);
    }

    public ValidationList(AS400 aS400, QSYSObjectPathName qSYSObjectPathName) {
        this();
        this.setAS400(aS400);
        this.setPath(qSYSObjectPathName);
    }

    public ValidationList(AS400 aS400, String string, String string2) {
        this();
        this.setAS400(aS400);
        this.setPath(new QSYSObjectPathName(string2, string, "vldl"));
    }

    public void addEntry(ValidationListEntry validationListEntry) throws PersistenceException {
        ProgramCall programCall = new ProgramCall(this.getAS400());
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYADVLE", "PGM"), programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[0] = this.getQualifiedNameParm();
        programParameterArray[1] = new ProgramParameter(validationListEntry.getEntryID().toBytes());
        programParameterArray[2] = new ProgramParameter(validationListEntry.getDataToEncrypt().toBytes());
        programParameterArray[3] = new ProgramParameter(validationListEntry.getUnencryptedData().toBytes());
        programParameterArray[4] = new ProgramParameter(validationListEntry.getAttributeInfo().toBytes());
        programParameterArray[5] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(programCall);
    }

    public void changeEntry(ValidationListEntry validationListEntry) throws PersistenceException {
        ProgramCall programCall = new ProgramCall(this.getAS400());
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYCHVLE", "PGM"), programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[0] = this.getQualifiedNameParm();
        programParameterArray[1] = new ProgramParameter(validationListEntry.getEntryID().toBytes());
        programParameterArray[2] = new ProgramParameter(validationListEntry.getDataToEncrypt().toBytes());
        programParameterArray[3] = new ProgramParameter(validationListEntry.getUnencryptedData().toBytes());
        programParameterArray[4] = new ProgramParameter(validationListEntry.getAttributeInfo().toBytes());
        programParameterArray[5] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(programCall);
    }

    private void closeList(byte[] byArray) throws PersistenceException {
        ProgramCall programCall = new ProgramCall(this.getAS400());
        ProgramParameter[] programParameterArray = new ProgramParameter[2];
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QGY", "QGYCLST", "PGM"), programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[0] = new ProgramParameter(new AS400ByteArray(byArray.length).toBytes(byArray));
        programParameterArray[1] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(programCall);
    }

    public void create() throws PersistenceException {
        String string = this.getPath().getObjectName();
        String string2 = this.getPath().getLibraryName();
        CommandCall commandCall = new CommandCall(this.getAS400(), "CRTVLDL VLDL(" + string2 + "/" + string + ") TEXT('" + this.getDescription() + "')");
        this.runCommand(commandCall);
    }

    public void delete() throws PersistenceException {
        String string = this.getPath().getObjectName();
        String string2 = this.getPath().getLibraryName();
        CommandCall commandCall = new CommandCall(this.getAS400(), "DLTVLDL VLDL(" + string2 + "/" + string + ")");
        this.runCommand(commandCall);
    }

    private void fillStringBuffer(StringBuffer stringBuffer, int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.setCharAt(i + n, string.charAt(i));
        }
    }

    public ValidationListEntry findEntry(String string, int n) throws PersistenceException {
        return this.findEntry(string, n, new ValidationListAttribute[0]);
    }

    public ValidationListEntry findEntry(String string, int n, ValidationListAttribute[] validationListAttributeArray) throws PersistenceException {
        ValidationListEntry validationListEntry = new ValidationListEntry();
        ProgramCall programCall = new ProgramCall(this.getAS400());
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYFDVLE", "PGM"), programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        ValidationListTranslatedData validationListTranslatedData = new ValidationListTranslatedData(string, n, this.getAS400());
        ValidationListAttributeInfo validationListAttributeInfo = new ValidationListAttributeInfo(validationListAttributeArray);
        programParameterArray[0] = this.getQualifiedNameParm();
        programParameterArray[1] = new ProgramParameter(validationListTranslatedData.toBytes());
        programParameterArray[2] = new ProgramParameter(validationListAttributeInfo.toBytes());
        programParameterArray[3] = new ProgramParameter(validationListEntry.getByteLength());
        programParameterArray[4] = new ProgramParameter(validationListAttributeInfo.getByteLength());
        programParameterArray[5] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(programCall);
        validationListEntry.init(programParameterArray[3].getOutputData(), 0);
        validationListAttributeInfo.setAttributesData(programParameterArray[4].getOutputData(), 0);
        validationListEntry.setAttributeInfo(validationListAttributeInfo);
        return validationListEntry;
    }

    public AS400 getAS400() {
        return this.as400_;
    }

    public String getDescription() {
        if (this.description_ != null) {
            return this.description_;
        }
        return "";
    }

    public ValidationListEntry[] getEntries() throws PersistenceException {
        int n;
        ValidationListEntry[] validationListEntryArray = new ValidationListEntry[]{};
        ProgramCall programCall = new ProgramCall(this.getAS400());
        ProgramParameter[] programParameterArray = new ProgramParameter[7];
        int n2 = LISTBUFFER_LENGTH_INITIAL;
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QGY", "QSYOLVLE", "PGM"), programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[0] = new ProgramParameter(n2);
        programParameterArray[1] = new ProgramParameter(new AS400Bin4().toBytes(n2));
        programParameterArray[2] = new ProgramParameter(this.getListInfoStruct().getByteLength());
        programParameterArray[3] = new ProgramParameter(new AS400Bin4().toBytes(-1));
        programParameterArray[4] = new ProgramParameter(new AS400Text(8, this.getAS400()).toBytes("VLDE0100"));
        programParameterArray[5] = this.getQualifiedNameParm();
        programParameterArray[6] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(programCall);
        Object[] objectArray = (Object[])this.getListInfoStruct().toObject(programParameterArray[2].getOutputData());
        validationListEntryArray = new ValidationListEntry[((Integer)objectArray[0]).intValue()];
        byte[] byArray = (byte[])objectArray[2];
        this.parseEntries(validationListEntryArray, 0, programParameterArray[0].getOutputData(), n);
        for (n = ((Integer)objectArray[1]).intValue(); n < validationListEntryArray.length; n += this.getNextEntries(byArray, n, validationListEntryArray)) {
        }
        this.closeList(byArray);
        return validationListEntryArray;
    }

    private AS400Structure getListInfoStruct() {
        if (this.listInfo_ == null) {
            this.listInfo_ = new AS400Structure(new AS400DataType[]{new AS400Bin4(), new AS400Bin4(), new AS400ByteArray(4), new AS400Bin4(), new AS400Text(1, this.as400_), new AS400ByteArray(13), new AS400Text(1, this.as400_), new AS400ByteArray(1), new AS400Bin4(), new AS400Bin4()});
        }
        return this.listInfo_;
    }

    private int getNextEntries(byte[] byArray, int n, ValidationListEntry[] validationListEntryArray) throws PersistenceException {
        int n2 = validationListEntryArray.length - n;
        int n3 = 0;
        if (n2 > 0) {
            ProgramCall programCall = new ProgramCall(this.getAS400());
            ProgramParameter[] programParameterArray = new ProgramParameter[7];
            int n4 = LISTBUFFER_LENGTH_NEXT;
            try {
                programCall.setProgram(QSYSObjectPathName.toPath("QGY", "QGYGTLE", "PGM"), programParameterArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            programParameterArray[0] = new ProgramParameter(n4);
            programParameterArray[1] = new ProgramParameter(new AS400Bin4().toBytes(n4));
            programParameterArray[2] = new ProgramParameter(byArray);
            programParameterArray[3] = new ProgramParameter(this.getListInfoStruct().getByteLength());
            programParameterArray[4] = new ProgramParameter(new AS400Bin4().toBytes(n2));
            programParameterArray[5] = new ProgramParameter(new AS400Bin4().toBytes(n + 1));
            programParameterArray[6] = new ProgramParameter(new AS400Bin4().toBytes(0));
            this.runProgram(programCall);
            Object[] objectArray = (Object[])this.getListInfoStruct().toObject(programParameterArray[3].getOutputData());
            n3 = (Integer)objectArray[1];
            this.parseEntries(validationListEntryArray, n, programParameterArray[0].getOutputData(), n3);
        }
        return n3;
    }

    public int getNumberOfEntries() throws PersistenceException {
        ProgramCall programCall = new ProgramCall(this.getAS400());
        ProgramParameter[] programParameterArray = new ProgramParameter[7];
        int n = 512;
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QGY", "QSYOLVLE", "PGM"), programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[0] = new ProgramParameter(n);
        programParameterArray[1] = new ProgramParameter(new AS400Bin4().toBytes(n));
        programParameterArray[2] = new ProgramParameter(this.getListInfoStruct().getByteLength());
        programParameterArray[3] = new ProgramParameter(new AS400Bin4().toBytes(-1));
        programParameterArray[4] = new ProgramParameter(new AS400Text(8, this.getAS400()).toBytes("VLDE0100"));
        programParameterArray[5] = this.getQualifiedNameParm();
        programParameterArray[6] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(programCall);
        Object[] objectArray = (Object[])this.getListInfoStruct().toObject(programParameterArray[2].getOutputData());
        this.closeList((byte[])objectArray[2]);
        return (Integer)objectArray[0];
    }

    public QSYSObjectPathName getPath() {
        return this.path_;
    }

    protected ProgramParameter getQualifiedNameParm() {
        StringBuffer stringBuffer = new StringBuffer("                    ");
        this.fillStringBuffer(stringBuffer, 0, this.getPath().getObjectName());
        this.fillStringBuffer(stringBuffer, 10, this.getPath().getLibraryName());
        return new ProgramParameter(2, new AS400Text(20, this.getAS400()).toBytes(stringBuffer.toString()));
    }

    private AS400Structure getVlde0100Struct() {
        if (this.vlde0100_ == null) {
            this.vlde0100_ = new AS400Structure(new AS400DataType[]{new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4()});
        }
        return this.vlde0100_;
    }

    private void handleUnexpectedAS400Exception(Throwable throwable) throws PersistenceException {
        throw new PersistenceException(throwable);
    }

    private void handleUnexpectedAS400Messages(AS400Message[] aS400MessageArray) throws PersistenceException {
        throw new PersistenceException(aS400MessageArray);
    }

    private void parseEntries(ValidationListEntry[] validationListEntryArray, int n, byte[] byArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ValidationListEntry validationListEntry;
            validationListEntryArray[n + i] = validationListEntry = new ValidationListEntry();
            Object[] objectArray = (Object[])this.getVlde0100Struct().toObject(byArray, n3);
            int n4 = (Integer)objectArray[0];
            validationListEntry.setEntryID(new ValidationListTranslatedData((Integer)objectArray[3], this.parseEntryData(byArray, n3 + (Integer)objectArray[1], (Integer)objectArray[2])));
            validationListEntry.setEncryptedData(new ValidationListTranslatedData((Integer)objectArray[6], this.parseEntryData(byArray, n3 + (Integer)objectArray[4], (Integer)objectArray[5])));
            validationListEntry.setUnencryptedData(new ValidationListTranslatedData((Integer)objectArray[9], this.parseEntryData(byArray, n3 + (Integer)objectArray[7], (Integer)objectArray[8])));
            n3 += n4;
        }
    }

    private byte[] parseEntryData(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public void removeEntry(ValidationListEntry validationListEntry) throws PersistenceException {
        ProgramCall programCall = new ProgramCall(this.getAS400());
        ProgramParameter[] programParameterArray = new ProgramParameter[3];
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYRMVLE", "PGM"), programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[0] = this.getQualifiedNameParm();
        programParameterArray[1] = new ProgramParameter(validationListEntry.getEntryID().toBytes());
        programParameterArray[2] = new ProgramParameter(new AS400Bin4().toBytes(0));
        this.runProgram(programCall);
    }

    private void runCommand(CommandCall commandCall) throws PersistenceException {
        boolean bl = false;
        try {
            bl = commandCall.run();
        }
        catch (Exception exception) {
            this.handleUnexpectedAS400Exception(exception);
        }
        if (!bl) {
            this.handleUnexpectedAS400Messages(commandCall.getMessageList());
        }
    }

    private void runProgram(ProgramCall programCall) throws PersistenceException {
        PersistenceException persistenceException;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        do {
            try {
                bl = false;
                bl2 = false;
                persistenceException = null;
                try {
                    if (n > 0) {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    bl = programCall.run();
                }
                catch (Exception exception) {
                    this.handleUnexpectedAS400Exception(exception);
                }
                if (bl) continue;
                AS400Message[] aS400MessageArray = programCall.getMessageList();
                if (aS400MessageArray != null) {
                    for (int i = 0; !bl2 && i < aS400MessageArray.length; ++i) {
                        bl2 = "CPF9803".equals(aS400MessageArray[i].getID());
                    }
                }
                this.handleUnexpectedAS400Messages(aS400MessageArray);
            }
            catch (PersistenceException persistenceException2) {
                persistenceException = persistenceException2;
            }
        } while (++n < 5 && bl2);
        if (persistenceException != null) {
            throw persistenceException;
        }
    }

    private void runServiceProgram(ServiceProgramCall serviceProgramCall) throws PersistenceException {
        int n = 0;
        int n2 = 0;
        do {
            try {
                if (n > 0) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.runProgram(serviceProgramCall);
            int n3 = n2 = serviceProgramCall.getReturnValueFormat() == 1 && serviceProgramCall.getIntegerReturnValue() == 0 ? 0 : serviceProgramCall.getErrno();
        } while (++n < 5 && n2 == 3406);
        if (n2 == 0) {
            return;
        }
        PersistenceException persistenceException = new PersistenceException(new StringBuffer("Procedure named ").append(serviceProgramCall.getProcedureName()).append(" failed with errorno ").append(n2).toString());
        throw persistenceException;
    }

    public void setAS400(AS400 aS400) {
        this.as400_ = aS400;
    }

    public void setDescription(String string) {
        this.description_ = string;
    }

    public void setPath(QSYSObjectPathName qSYSObjectPathName) {
        this.path_ = qSYSObjectPathName;
    }

    public boolean verifyEntry(ValidationListEntry validationListEntry) throws PersistenceException {
        int n = validationListEntry.getDataToEncrypt().getBytes().length;
        if (n < 1 || n > 600) {
            return false;
        }
        n = validationListEntry.getEntryID().getBytes().length;
        if (n < 1 || n > 100) {
            return false;
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{this.getQualifiedNameParm(), new ProgramParameter(2, validationListEntry.getEntryID().toBytes()), new ProgramParameter(2, validationListEntry.getDataToEncrypt().toBytes())};
        ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.getAS400());
        try {
            serviceProgramCall.setProgram("/QSYS.LIB/QSYVLDL.SRVPGM", programParameterArray);
            serviceProgramCall.setProcedureName("QsyVerifyValidationLstEntry");
            serviceProgramCall.setReturnValueFormat(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.runServiceProgram(serviceProgramCall);
        return serviceProgramCall.getIntegerReturnValue() == 0;
    }
}

