/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.NativeMethods;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.StringTokenizer;

class RemoteCommandImplNative
extends RemoteCommandImplRemote {
    private static final String CLASSNAME = "com.ibm.as400.access.RemoteCommandImplNative";
    private boolean detectedMissingPTF_ = false;

    RemoteCommandImplNative() {
    }

    protected void open(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Native implementation object open.");
        }
        if (!bl) {
            if (Trace.traceOn_) {
                Trace.log(1, "Sending native open request to super class.");
            }
            super.open(false);
            return;
        }
        if (!this.ccsidIsUserOveride_) {
            this.converter_ = ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_);
        }
        if (AS400.nativeVRM.vrm_ >= 328448) {
            if (AS400.nativeVRM.vrm_ >= 393472) {
                this.serverDataStreamLevel_ = 10;
                this.unicodeConverter_ = ConverterImplRemote.getConverter(1200, this.system_);
            } else {
                this.serverDataStreamLevel_ = 7;
            }
        }
        if (!this.system_.isSkipFurtherSettingOfSecondaryLangLib()) {
            String string = this.retrieveSecondaryLanguageLibName();
            if (string.length() != 0) {
                this.setNlvOnServer(string);
            }
            this.system_.setSecondaryLangLib(string);
        }
    }

    private String retrieveSecondaryLanguageLibName() {
        String string = this.system_.getSecondaryLangLib();
        if (string == null) {
            String string2 = this.system_.getNLV();
            try {
                int n = this.system_.getCcsid();
                ConvTable convTable = ConvTable.getTable(n, null);
                ProgramParameter[] programParameterArray = new ProgramParameter[6];
                int n2 = 118;
                programParameterArray[0] = new ProgramParameter(n2);
                programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
                programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("PRDR0200"));
                byte[] byArray = new byte[36];
                AS400Text aS400Text = new AS400Text(4, n, this.system_);
                AS400Text aS400Text2 = new AS400Text(6, n, this.system_);
                AS400Text aS400Text3 = new AS400Text(7, n, this.system_);
                AS400Text aS400Text4 = new AS400Text(10, n, this.system_);
                aS400Text3.toBytes("*OPSYS", byArray, 0);
                aS400Text2.toBytes("*CUR", byArray, 7);
                aS400Text.toBytes("0000", byArray, 13);
                aS400Text4.toBytes(string2, byArray, 17);
                BinaryConverter.intToByteArray(36, byArray, 28);
                BinaryConverter.intToByteArray(n, byArray, 32);
                programParameterArray[3] = new ProgramParameter(byArray);
                programParameterArray[4] = new ProgramParameter(new byte[4]);
                programParameterArray[5] = new ProgramParameter(convTable.stringToByteArray("PRDI0200"));
                boolean bl = this.runProgram("QSYS", "QSZRTVPR", programParameterArray, true, 0, false);
                if (!bl) {
                    Trace.log(4, "Unable to retrieve secondary language library name for NLV " + string2, (Throwable)new AS400Exception(this.messageList_));
                } else {
                    int n3;
                    byte[] byArray2 = programParameterArray[0].getOutputData();
                    string = convTable.byteArrayToString(byArray2, n3 = BinaryConverter.byteArrayToInt(byArray2, 84), 10).trim();
                    if (string.length() == 0) {
                        Trace.log(4, "Unable to retrieve secondary language library name for NLV " + string2 + ": Blank library name returned.");
                    }
                }
            }
            catch (Throwable throwable) {
                Trace.log(4, "Unable to retrieve secondary language library name for NLV " + string2, throwable);
            }
        }
        return string == null ? "" : string;
    }

    private void setNlvOnServer(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Native implementation object setting national language for messages.");
        }
        try {
            String string2 = "QSYS/CHGSYSLIBL LIB(" + string + ") OPTION(*ADD)";
            boolean bl = this.runCommand(string2, true, 0, false);
            if (!bl) {
                if (this.messageList_.length != 0) {
                    if (this.messageList_[0].getID().equals("CPF2103")) {
                        if (this.system_.getSecondaryLangLib() == null) {
                            this.system_.setSkipFurtherSettingOfSecondaryLangLib();
                        }
                    } else if (this.messageList_[0].getID().equals("CPD0032")) {
                        this.system_.setSkipFurtherSettingOfSecondaryLangLib();
                        Trace.log(4, "Profile " + this.system_.getUserId() + " not authorized to use CHGSYSLIBL to add language library " + string + " to liblist.");
                    } else if (this.messageList_[0].getID().equals("CPF2110")) {
                        this.system_.setSkipFurtherSettingOfSecondaryLangLib();
                        Trace.log(4, "Secondary language library " + string + " was not found.");
                    } else {
                        Trace.log(2, "Unable to add secondary language library " + string + " to library list.", (Throwable)new AS400Exception(this.messageList_));
                    }
                } else {
                    Trace.log(4, "Unable to add secondary language library " + string + " to library list.");
                }
            }
        }
        catch (Throwable throwable) {
            Trace.log(4, "Failed to add secondary language library " + string + " to library list.", throwable);
        }
    }

    public boolean isCommandThreadSafe(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        String string2;
        String string3;
        if (Trace.traceOn_) {
            Trace.log(1, "Native implementation object checking command thread safety.");
        }
        this.open(true);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string4 = stringTokenizer.nextToken().toUpperCase();
        int n = string4.indexOf(47);
        if (n == -1) {
            string3 = "*LIBL";
            string2 = string4;
        } else {
            string3 = string4.substring(0, n);
            string2 = string4.substring(n + 1);
        }
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        this.converter_.stringToByteArray(string2, byArray);
        this.converter_.stringToByteArray(string3, byArray, 10);
        int n2 = AS400.nativeVRM.vrm_ >= 393472 || AS400.nativeVRM.vrm_ >= 328704 && !this.detectedMissingPTF_ ? 6 : 5;
        ProgramParameter[] programParameterArray = new ProgramParameter[n2];
        programParameterArray[0] = new ProgramParameter(350);
        programParameterArray[1] = new ProgramParameter(new byte[]{0, 0, 1, 94});
        programParameterArray[2] = new ProgramParameter(new byte[]{-61, -44, -60, -55, -16, -15, -16, -16});
        programParameterArray[3] = new ProgramParameter(byArray);
        programParameterArray[4] = new ProgramParameter(new byte[8]);
        if (n2 > 5) {
            programParameterArray[5] = new ProgramParameter(new byte[]{-15});
        }
        try {
            boolean bl = this.runProgram("QSYS", "QCDRCMDI", programParameterArray, true, 0);
            if (!bl) {
                ProgramParameter[] programParameterArray2;
                if (n2 > 5 && AS400.nativeVRM.vrm_ < 393472 && AS400.nativeVRM.vrm_ >= 328704 && this.messageList_[this.messageList_.length - 1].getID().equals("MCH0802")) {
                    if (Trace.traceOn_) {
                        Trace.log(4, "PTF SI29629 is not installed: (MCH0802) " + this.messageList_[this.messageList_.length - 1].getText());
                    }
                    this.detectedMissingPTF_ = true;
                    programParameterArray2 = new ProgramParameter[5];
                    System.arraycopy(programParameterArray, 0, programParameterArray2, 0, 5);
                    bl = this.runProgram("QSYS", "QCDRCMDI", programParameterArray2, true, 0);
                }
                if (!bl) {
                    Trace.log(2, "Unable to retrieve command information.");
                    programParameterArray2 = this.messageList_[this.messageList_.length - 1].getID();
                    byte[] byArray2 = this.messageList_[this.messageList_.length - 1].getSubstitutionData();
                    if (programParameterArray2.equals("CPF9801") && string2.equals(this.converter_.byteArrayToString(byArray2, 0, 10).trim()) && string3.equals(this.converter_.byteArrayToString(byArray2, 10, 10).trim()) && "CMD".equals(this.converter_.byteArrayToString(byArray2, 20, 7).trim())) {
                        Trace.log(1, "Command not found.");
                        return false;
                    }
                    if (programParameterArray2.equals("CPF9810") && string3.equals(this.converter_.byteArrayToString(byArray2).trim())) {
                        Trace.log(1, "Command library not found.");
                        return false;
                    }
                    throw new AS400Exception(this.messageList_);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            Trace.log(2, "Unexpected ObjectDoesNotExistException:", (Throwable)objectDoesNotExistException);
            throw new InternalErrorException(10);
        }
        byte[] byArray3 = programParameterArray[0].getOutputData();
        if (Trace.traceOn_) {
            Trace.log(1, "Command information retrieved:", byArray3);
            Trace.log(1, "Multithreaded job action: " + (byArray3[334] & 0xF));
        }
        switch (byArray3[333] & 0xF) {
            case 0: {
                if (Trace.traceOn_) {
                    Trace.log(1, "Command not threadsafe: " + string4);
                }
                return false;
            }
            case 1: {
                if (Trace.traceOn_) {
                    Trace.log(1, "Command threadsafe: " + string4);
                }
                return true;
            }
            case 2: {
                if (Trace.traceOn_) {
                    Trace.log(1, "Conditionally threadsafe: " + string4);
                }
                return false;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(2, "Invalid threadsafe indicator: " + string4);
        }
        return false;
    }

    public boolean runCommand(String string, boolean bl, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        return this.runCommand(string, bl, n, true);
    }

    private boolean runCommand(String string, boolean bl, int n, boolean bl2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Native implementation running command: " + string);
        }
        if (!bl) {
            if (Trace.traceOn_) {
                Trace.log(1, "Sending command to super class.");
            }
            return super.runCommand(string, false, n);
        }
        if (bl2) {
            this.open(true);
        }
        if (AS400.nativeVRM.vrm_ >= 393472) {
            return this.runCommand(this.unicodeConverter_.stringToByteArray(string), n, 1200);
        }
        return this.runCommand(this.converter_.stringToByteArray(string), n, 0);
    }

    public boolean runCommand(byte[] byArray, boolean bl, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Native implementation running command:", byArray);
        }
        if (!bl) {
            if (Trace.traceOn_) {
                Trace.log(1, "Sending command to super class.");
            }
            return super.runCommand(byArray, false, n);
        }
        this.open(true);
        return this.runCommand(byArray, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean runCommand(byte[] byArray, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[12];
        boolean bl = this.system_.swapTo(byArray2, byArray3);
        try {
            byte[] byArray4;
            if (Trace.traceOn_) {
                Trace.log(3, "Invoking native method.");
            }
            if (AS400.nativeVRM.vrm_ < 328448) {
                try {
                    byte[] byArray5 = this.runCommandNative(byArray);
                    if (Trace.traceOn_) {
                        Trace.log(1, "Native reply bytes:", byArray5);
                    }
                    if (byArray5 == null) {
                        byArray5 = new byte[]{};
                    }
                    this.messageList_ = RemoteCommandImplNative.parseMessages(byArray5, this.converter_);
                    boolean bl2 = true;
                    return bl2;
                }
                catch (NativeException nativeException) {
                    boolean bl3;
                    block15: {
                        this.messageList_ = RemoteCommandImplNative.parseMessages(nativeException.data, this.converter_);
                        bl3 = false;
                        if (!bl) break block15;
                        this.system_.swapBack(byArray2, byArray3);
                    }
                    return bl3;
                }
            }
            byte[] byArray6 = byArray4 = AS400.nativeVRM.vrm_ < 393472 ? RemoteCommandImplNative.runCommandNativeV5R3(byArray, n) : NativeMethods.runCommand(byArray, n2, n);
            if (Trace.traceOn_) {
                Trace.log(1, "Native reply bytes:", byArray4);
            }
            this.messageList_ = RemoteCommandImplNative.parseMessagesV5R3(byArray4, this.converter_);
            boolean bl4 = true;
            return bl4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray2, byArray3);
            }
        }
    }

    public boolean runProgram(String string, String string2, ProgramParameter[] programParameterArray, boolean bl, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runProgram(string, string2, programParameterArray, bl, n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runProgram(String string, String string2, ProgramParameter[] programParameterArray, boolean bl, int n, boolean bl2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(3, "Native implementation running program: " + string + "/" + string2);
        }
        if (!bl) {
            if (Trace.traceOn_) {
                Trace.log(1, "Sending program to super class.");
            }
            return super.runProgram(string, string2, programParameterArray, false, n);
        }
        if (bl2) {
            this.open(true);
        }
        if (AS400.nativeVRM.vrm_ < 328448) {
            int n2;
            byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 0, 0, 0, 0};
            this.converter_.stringToByteArray(string2, byArray);
            this.converter_.stringToByteArray(string, byArray, 10);
            BinaryConverter.intToByteArray(programParameterArray.length, byArray, 20);
            byte[] byArray2 = new byte[programParameterArray.length * 10];
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < programParameterArray.length; ++i) {
                n2 = programParameterArray[i].getMaxLength();
                int n5 = programParameterArray[i].getUsage();
                if (n5 == 255) {
                    n5 = 1;
                }
                BinaryConverter.intToByteArray(n2, byArray2, i * 10);
                BinaryConverter.unsignedShortToByteArray(n5, byArray2, i * 10 + 4);
                BinaryConverter.intToByteArray(n4, byArray2, i * 10 + 6);
                n4 += n2;
                n3 += n2;
            }
            byte[] byArray3 = new byte[n3];
            n2 = 0;
            for (n4 = 0; n4 < programParameterArray.length; ++n4) {
                byte[] byArray4 = programParameterArray[n4].getInputData();
                int n6 = programParameterArray[n4].getMaxLength();
                if (byArray4 != null) {
                    System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
                }
                n2 += n6;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Program name bytes:", byArray);
                Trace.log(1, "Program parameter bytes:", byArray2);
                Trace.log(1, "Program parameters:", byArray3);
            }
            byte[] byArray5 = new byte[12];
            byte[] byArray6 = new byte[12];
            boolean bl3 = this.system_.swapTo(byArray5, byArray6);
            try {
                if (Trace.traceOn_) {
                    Trace.log(3, "Invoking native method.");
                }
                byte[] byArray7 = this.runProgramNative(byArray, byArray2, byArray3);
                if (Trace.traceOn_) {
                    Trace.log(1, "Native reply bytes:", byArray7);
                }
                this.messageList_ = new AS400Message[0];
                int n7 = 0;
                for (int i = 0; i < programParameterArray.length; ++i) {
                    int n8 = programParameterArray[i].getMaxLength();
                    int n9 = programParameterArray[i].getOutputDataLength();
                    if (n9 > 0) {
                        byte[] byArray8 = new byte[n9];
                        System.arraycopy(byArray7, n7, byArray8, 0, n9);
                        programParameterArray[i].setOutputData(byArray8);
                    }
                    n7 += n8;
                }
                n7 = 1;
                return n7 != 0;
            }
            catch (NativeException nativeException) {
                this.messageList_ = RemoteCommandImplNative.parseMessages(nativeException.data, this.converter_);
                if (this.messageList_.length == 0) {
                    boolean bl4 = false;
                    return bl4;
                }
                String string3 = this.messageList_[this.messageList_.length - 1].getID();
                if (string3.equals("MCH3401")) {
                    byte[] byArray9 = this.messageList_[this.messageList_.length - 1].getSubstitutionData();
                    if (byArray9[0] == 2 && byArray9[1] == 1 && string2.equals(this.converter_.byteArrayToString(byArray9, 2, 30).trim())) {
                        throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(string, string2, "PGM"), 2);
                    }
                    if (byArray9[0] == 4 && byArray9[1] == 1 && string.equals(this.converter_.byteArrayToString(byArray9, 2, 30).trim())) {
                        throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(string, string2, "PGM"), 1);
                    }
                }
                boolean bl5 = false;
                return bl5;
            }
            finally {
                if (bl3) {
                    this.system_.swapBack(byArray5, byArray6);
                }
            }
        }
        byte[] byArray = this.converter_.stringToByteArray(string2);
        byte[] byArray10 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray10, 0, byArray.length);
        byArray = this.converter_.stringToByteArray(string);
        byte[] byArray11 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray11, 0, byArray.length);
        byte[] byArray12 = new byte[programParameterArray.length * 4];
        int n10 = 0;
        for (int i = 0; i < programParameterArray.length; ++i) {
            if (programParameterArray[i].getUsage() == 255) {
                BinaryConverter.intToByteArray(-1, byArray12, i * 4);
            } else {
                BinaryConverter.intToByteArray(n10, byArray12, i * 4);
            }
            n10 += programParameterArray[i].getMaxLength();
        }
        byte[] byArray13 = new byte[n10];
        int n11 = 0;
        for (int i = 0; i < programParameterArray.length; ++i) {
            byte[] byArray14 = programParameterArray[i].getInputData();
            if (byArray14 != null) {
                System.arraycopy(byArray14, 0, byArray13, n11, byArray14.length);
            }
            n11 += programParameterArray[i].getMaxLength();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Program name bytes:", byArray10);
            Trace.log(1, "Program library bytes:", byArray11);
            Trace.log(1, "Number of parameters:", programParameterArray.length);
            Trace.log(1, "Offset array:", byArray12);
            Trace.log(1, "Program parameters:", byArray13);
        }
        byte[] byArray15 = new byte[12];
        byte[] byArray16 = new byte[12];
        boolean bl6 = this.system_.swapTo(byArray15, byArray16);
        try {
            byte[] byArray17;
            if (Trace.traceOn_) {
                Trace.log(3, "Invoking native method.");
            }
            byte[] byArray18 = byArray17 = AS400.nativeVRM.vrm_ < 393472 ? RemoteCommandImplNative.runProgramNativeV5R3(byArray10, byArray11, programParameterArray.length, byArray12, byArray13, n) : NativeMethods.runProgram(byArray10, byArray11, programParameterArray.length, byArray12, byArray13, n);
            if (Trace.traceOn_) {
                Trace.log(1, "Native reply bytes:", byArray17);
            }
            this.messageList_ = new AS400Message[0];
            int n12 = 0;
            for (int i = 0; i < programParameterArray.length; ++i) {
                int n13 = programParameterArray[i].getOutputDataLength();
                if (n13 > 0) {
                    byte[] byArray19 = new byte[n13];
                    System.arraycopy(byArray17, n12, byArray19, 0, n13);
                    programParameterArray[i].setOutputData(byArray19);
                }
                n12 += programParameterArray[i].getMaxLength();
            }
            n12 = 1;
            return n12 != 0;
        }
        catch (NativeException nativeException) {
            this.messageList_ = RemoteCommandImplNative.parseMessagesV5R3(nativeException.data, this.converter_);
            if (this.messageList_.length == 0) {
                boolean bl7 = false;
                return bl7;
            }
            String string4 = this.messageList_[this.messageList_.length - 1].getID();
            if (string4.equals("MCH3401")) {
                byte[] byArray20 = this.messageList_[this.messageList_.length - 1].getSubstitutionData();
                if (byArray20[0] == 2 && byArray20[1] == 1 && string2.equals(this.converter_.byteArrayToString(byArray20, 2, 30).trim())) {
                    throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(string, string2, "PGM"), 2);
                }
                if (byArray20[0] == 4 && byArray20[1] == 1 && string.equals(this.converter_.byteArrayToString(byArray20, 2, 30).trim())) {
                    throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(string, string2, "PGM"), 1);
                }
            }
            boolean bl8 = false;
            return bl8;
        }
        finally {
            if (bl6) {
                this.system_.swapBack(byArray15, byArray16);
            }
        }
    }

    static AS400Message[] parseMessages(byte[] byArray, ConverterImplRemote converterImplRemote) {
        int n = byArray.length / 10240;
        AS400Message[] aS400MessageArray = new AS400Message[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            aS400MessageArray[i] = new AS400Message();
            aS400MessageArray[i].setID(converterImplRemote.byteArrayToString(byArray, n2 + 12, 7));
            aS400MessageArray[i].setType((byArray[n2 + 19] & 0xF) * 10 + (byArray[n2 + 20] & 0xF));
            aS400MessageArray[i].setSeverity(BinaryConverter.byteArrayToInt(byArray, n2 + 8));
            aS400MessageArray[i].setFileName(converterImplRemote.byteArrayToString(byArray, n2 + 25, 10).trim());
            aS400MessageArray[i].setLibraryName(converterImplRemote.byteArrayToString(byArray, n2 + 45, 10).trim());
            int n3 = BinaryConverter.byteArrayToInt(byArray, n2 + 80);
            int n4 = BinaryConverter.byteArrayToInt(byArray, n2 + 88);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2 + 112, byArray2, 0, n3);
            aS400MessageArray[i].setSubstitutionData(byArray2);
            aS400MessageArray[i].setText(converterImplRemote.byteArrayToString(byArray, n2 + 112 + n3, n4));
            n2 += 10240;
        }
        return aS400MessageArray;
    }

    static AS400Message[] parseMessagesV5R3(byte[] byArray, ConverterImplRemote converterImplRemote) {
        int n = BinaryConverter.byteArrayToInt(byArray, 0);
        AS400Message[] aS400MessageArray = new AS400Message[n];
        int n2 = 4;
        for (int i = 0; i < n; ++i) {
            aS400MessageArray[i] = new AS400Message();
            aS400MessageArray[i].setID(converterImplRemote.byteArrayToString(byArray, n2 + 12, 7));
            aS400MessageArray[i].setType((byArray[n2 + 19] & 0xF) * 10 + (byArray[n2 + 20] & 0xF));
            aS400MessageArray[i].setSeverity(BinaryConverter.byteArrayToInt(byArray, n2 + 8));
            aS400MessageArray[i].setFileName(converterImplRemote.byteArrayToString(byArray, n2 + 25, 10).trim());
            aS400MessageArray[i].setLibraryName(converterImplRemote.byteArrayToString(byArray, n2 + 45, 10).trim());
            int n3 = BinaryConverter.byteArrayToInt(byArray, n2 + 80);
            int n4 = BinaryConverter.byteArrayToInt(byArray, n2 + 88);
            int n5 = BinaryConverter.byteArrayToInt(byArray, n2 + 96);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2 + 112, byArray2, 0, n3);
            aS400MessageArray[i].setSubstitutionData(byArray2);
            aS400MessageArray[i].setText(converterImplRemote.byteArrayToString(byArray, n2 + 112 + n3, n4));
            aS400MessageArray[i].setHelp(converterImplRemote.byteArrayToString(byArray, n2 + 112 + n3 + n4, n5));
            n2 += BinaryConverter.byteArrayToInt(byArray, n2);
            n2 += BinaryConverter.byteArrayToInt(byArray, n2);
        }
        return aS400MessageArray;
    }

    private native byte[] runCommandNative(byte[] var1) throws NativeException;

    private static native byte[] runCommandNativeV5R3(byte[] var0, int var1) throws NativeException;

    private native byte[] runProgramNative(byte[] var1, byte[] var2, byte[] var3) throws NativeException;

    private static native byte[] runProgramNativeV5R3(byte[] var0, byte[] var1, int var2, byte[] var3, byte[] var4, int var5) throws NativeException;

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        System.load("/QSYS.LIB/QYJSPART.SRVPGM");
    }
}

