/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class QSYSPermission
extends UserPermission {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;

    public QSYSPermission(String string) {
        super(string);
        this.dataAuthority_ = "*EXCLUDE";
        this.objectAuthority_ = 1;
        this.authorities_ = new boolean[10];
        for (int i = 0; i < 10; ++i) {
            this.authorities_[i] = false;
        }
    }

    static String adjustLength(String string, int n) {
        int n2;
        if (string == null) {
            string = "";
        }
        if ((n2 = string.length()) == n) {
            return string;
        }
        if (n2 < n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = n2; i < n; ++i) {
                stringBuffer.append(' ');
            }
            return stringBuffer.toString();
        }
        return string.substring(0, n);
    }

    String getAuthorities(boolean bl) {
        String string = "";
        if (this.isManagement()) {
            string = string + "*OBJMGT ";
        }
        if (this.isExistence()) {
            string = string + "*OBJEXIST ";
        }
        if (this.isAlter()) {
            string = string + "*OBJALTER ";
        }
        if (this.isReference()) {
            string = string + "*OBJREF ";
        }
        if (this.isOperational()) {
            string = string + "*OBJOPR ";
        }
        if (this.isAdd()) {
            string = string + "*ADD ";
        }
        if (this.isDelete()) {
            string = string + "*DLT ";
        }
        if (this.isRead()) {
            string = string + "*READ ";
        }
        if (this.isUpdate()) {
            string = string + "*UPD ";
        }
        if (this.isExecute()) {
            string = string + "*EXECUTE ";
        }
        if (bl && this.isAuthorizationListManagement()) {
            string = string + "*AUTLMGT";
        }
        if (string.equals("")) {
            string = "*EXCLUDE";
        }
        return string;
    }

    public String getObjectAuthority() {
        this.parseBasic();
        if (this.isFromAuthorizationList()) {
            return "*AUTL";
        }
        switch (this.objectAuthority_) {
            case 0: {
                return "*ALL";
            }
            case 1: {
                return "*EXCLUDE";
            }
            case 2: {
                return "*USE";
            }
            case 3: {
                return "*CHANGE";
            }
        }
        return "USER DEFINED";
    }

    public static boolean hasObjectAuthorities(AS400 aS400, String string, String string2, String[] stringArray) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("userProfileName");
        }
        if (string2 == null) {
            throw new NullPointerException("objectPath");
        }
        if (stringArray == null) {
            throw new NullPointerException("authorityList");
        }
        if (stringArray.length == 0) {
            Trace.log(2, "No authorities were specified.");
            throw new ExtendedIllegalArgumentException("authorityList", 1);
        }
        boolean bl = true;
        String string3 = "/QSYS.LIB/QSYCUSRA.PGM";
        String string4 = QSYSPermission.adjustLength(string, 10);
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string2);
        String string5 = "*" + QSYSPermission.adjustLength(qSYSObjectPathName.getObjectType(), 9);
        String string6 = QSYSPermission.adjustLength(qSYSObjectPathName.getObjectName(), 10) + QSYSPermission.adjustLength(qSYSObjectPathName.getLibraryName(), 10);
        String string7 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string7 = string7 + QSYSPermission.adjustLength(stringArray[i], 10);
        }
        try {
            ProgramCall programCall = new ProgramCall(aS400);
            ProgramParameter[] programParameterArray = new ProgramParameter[8];
            programParameterArray[0] = new ProgramParameter(1);
            programParameterArray[0].setParameterType(2);
            programParameterArray[1] = new ProgramParameter(CharConverter.stringToByteArray(aS400, string4));
            programParameterArray[2] = new ProgramParameter(CharConverter.stringToByteArray(aS400, string6));
            programParameterArray[3] = new ProgramParameter(CharConverter.stringToByteArray(aS400, string5));
            programParameterArray[4] = new ProgramParameter(CharConverter.stringToByteArray(aS400, string7));
            programParameterArray[5] = new ProgramParameter(BinaryConverter.intToByteArray(stringArray.length));
            programParameterArray[6] = new ProgramParameter(BinaryConverter.intToByteArray(1));
            byte[] byArray = new byte[16];
            System.arraycopy(BinaryConverter.intToByteArray(16), 0, byArray, 0, 4);
            programParameterArray[7] = new ProgramParameter(byArray, 16);
            programParameterArray[7].setParameterType(2);
            programCall.setProgram(string3, programParameterArray);
            if (!programCall.run()) {
                AS400Message[] aS400MessageArray = programCall.getMessageList();
                throw new AS400Exception(aS400MessageArray);
            }
            byte[] byArray2 = programParameterArray[7].getOutputData();
            if (BinaryConverter.byteArrayToInt(byArray2, 4) > 0) {
                byte[] byArray3 = new byte[7];
                System.arraycopy(byArray2, 8, byArray3, 0, 7);
                String string8 = CharConverter.byteArrayToString(aS400, byArray3);
                Trace.log(2, "Error code from QSYCUSRA: " + string8);
                throw new AS400Exception(new AS400Message(string8, ""));
            }
            String string9 = CharConverter.byteArrayToString(aS400, programParameterArray[0].getOutputData());
            if (!string9.startsWith("Y")) {
                bl = false;
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException.toString());
        }
        return bl;
    }

    public boolean isAdd() {
        return this.authorities_[6];
    }

    public boolean isAlter() {
        return this.authorities_[3];
    }

    public boolean isDelete() {
        return this.authorities_[8];
    }

    public boolean isExecute() {
        return this.authorities_[9];
    }

    public boolean isExistence() {
        return this.authorities_[2];
    }

    public boolean isManagement() {
        return this.authorities_[1];
    }

    public boolean isOperational() {
        return this.authorities_[0];
    }

    public boolean isRead() {
        return this.authorities_[5];
    }

    public boolean isReference() {
        return this.authorities_[4];
    }

    public boolean isUpdate() {
        return this.authorities_[7];
    }

    private synchronized void parseBasic() {
        for (int i = 0; i < 4; ++i) {
            boolean bl = true;
            for (int j = 0; j < 10; ++j) {
                if (this.authorities_[j] == basicAutMapping[i][j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.objectAuthority_ = i;
            return;
        }
        this.objectAuthority_ = -1;
    }

    public synchronized void setAdd(boolean bl) {
        this.changeAuthority();
        this.authorities_[6] = bl;
    }

    public synchronized void setAlter(boolean bl) {
        this.changeAuthority();
        this.authorities_[3] = bl;
    }

    public synchronized void setDelete(boolean bl) {
        this.changeAuthority();
        this.authorities_[8] = bl;
    }

    public synchronized void setExecute(boolean bl) {
        this.changeAuthority();
        this.authorities_[9] = bl;
    }

    public synchronized void setExistence(boolean bl) {
        this.changeAuthority();
        this.authorities_[2] = bl;
    }

    public synchronized void setManagement(boolean bl) {
        this.changeAuthority();
        this.authorities_[1] = bl;
    }

    public synchronized void setObjectAuthority(String string) {
        if (string == null) {
            throw new NullPointerException("authority");
        }
        String string2 = string.trim().toUpperCase();
        this.changeAuthority();
        if (this.getObjectAuthority().equals(string2)) {
            return;
        }
        if (string2.equals("*ALL")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[0][i];
            }
            this.objectAuthority_ = 0;
        } else if (string2.equals("*EXCLUDE")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[1][i];
            }
            this.objectAuthority_ = 1;
        } else if (string2.equals("*USE")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[2][i];
            }
            this.objectAuthority_ = 2;
        } else if (string2.equals("*CHANGE")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[3][i];
            }
            this.objectAuthority_ = 3;
        } else if (string2.equals("*AUTL")) {
            this.setFromAuthorizationList(true);
        } else {
            Trace.log(2, "Invalid object authority was specified: " + string);
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
    }

    public synchronized void setOperational(boolean bl) {
        this.changeAuthority();
        this.authorities_[0] = bl;
    }

    public synchronized void setRead(boolean bl) {
        this.changeAuthority();
        this.authorities_[5] = bl;
    }

    public synchronized void setReference(boolean bl) {
        this.changeAuthority();
        this.authorities_[4] = bl;
    }

    public synchronized void setUpdate(boolean bl) {
        this.changeAuthority();
        this.authorities_[7] = bl;
    }
}

