/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProxyFactoryImpl;
import com.ibm.as400.access.ProxyReturnValue;
import com.ibm.as400.access.PxAcceptRepCV;
import com.ibm.as400.access.PxBooleanParm;
import com.ibm.as400.access.PxByteParm;
import com.ibm.as400.access.PxCharParm;
import com.ibm.as400.access.PxClassParm;
import com.ibm.as400.access.PxClientConnectionAdapter;
import com.ibm.as400.access.PxConnectReqCV;
import com.ibm.as400.access.PxConstructorReqCV;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxDoubleParm;
import com.ibm.as400.access.PxEventRepCV;
import com.ibm.as400.access.PxEventSupport;
import com.ibm.as400.access.PxExceptionRepCV;
import com.ibm.as400.access.PxFinalizeReqCV;
import com.ibm.as400.access.PxFloatParm;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxListenerReqCV;
import com.ibm.as400.access.PxLongParm;
import com.ibm.as400.access.PxMethodReqCV;
import com.ibm.as400.access.PxNullParm;
import com.ibm.as400.access.PxPxObjectParm;
import com.ibm.as400.access.PxRejectRepCV;
import com.ibm.as400.access.PxReqCV;
import com.ibm.as400.access.PxReturnRepCV;
import com.ibm.as400.access.PxSerializedObjectParm;
import com.ibm.as400.access.PxShortParm;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.PxToolboxObjectParm;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.StoppableThread;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;

class ProxyClientConnection
extends PxClientConnectionAdapter {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String locale_ = Locale.getDefault().toString();
    private static final Class[] noArgumentClasses_ = new Class[0];
    private static final Object[] noArguments_ = new Object[0];
    private int connectAttempts_ = 0;
    private PxEventSupport eventSupport_;
    private Vector pxList_ = new Vector();
    private SecondaryFinalizerThread_ secondaryFinalizerThread_;

    public ProxyClientConnection(String string, SSLOptions sSLOptions) {
        super(string, sSLOptions);
        this.connect();
    }

    public void addListener(long l, EventListener eventListener, String string) {
        if (this.eventSupport_.addListener(l, eventListener)) {
            PxListenerReqCV pxListenerReqCV = new PxListenerReqCV(l, 1, string);
            this.send(pxListenerReqCV);
        }
    }

    public long callConstructor(String string) throws InvocationTargetException {
        return this.callConstructor(string, true);
    }

    public long callConstructor(String string, boolean bl) throws InvocationTargetException {
        PxConstructorReqCV pxConstructorReqCV = new PxConstructorReqCV(string, bl);
        long l = ((ProxyReturnValue)this.sendAndReceive(pxConstructorReqCV)).getReturnValuePxId();
        this.pxList_.addElement(new Long(l));
        return l;
    }

    public ProxyFactoryImpl callFactoryMethod(long l, String string, ProxyFactoryImpl proxyFactoryImpl) throws InvocationTargetException {
        return this.callFactoryMethod(l, string, noArgumentClasses_, noArguments_, proxyFactoryImpl);
    }

    public ProxyFactoryImpl callFactoryMethod(long l, String string, Class[] classArray, Object[] objectArray, ProxyFactoryImpl proxyFactoryImpl) throws InvocationTargetException {
        PxMethodReqCV pxMethodReqCV = new PxMethodReqCV(l, string, classArray, objectArray, null, false, true);
        long l2 = ((ProxyReturnValue)this.sendAndReceive(pxMethodReqCV)).getReturnValuePxId();
        if (l2 >= 0L) {
            proxyFactoryImpl.initialize(l2, this);
            this.pxList_.addElement(new Long(l2));
            return proxyFactoryImpl;
        }
        return null;
    }

    public void callFinalize(long l) throws InvocationTargetException {
        Long l2 = new Long(l);
        if (this.pxList_.contains(l2)) {
            this.eventSupport_.removeAll(l);
            PxFinalizeReqCV pxFinalizeReqCV = new PxFinalizeReqCV(l);
            this.secondaryFinalizerThread_.addRequest(pxFinalizeReqCV);
            this.pxList_.removeElement(l2);
        }
    }

    public ProxyReturnValue callMethod(long l, String string) throws InvocationTargetException {
        return this.callMethod(l, string, noArgumentClasses_, noArguments_, false);
    }

    public ProxyReturnValue callMethod(long l, String string, Class[] classArray, Object[] objectArray) throws InvocationTargetException {
        return this.callMethod(l, string, classArray, objectArray, false);
    }

    public ProxyReturnValue callMethod(long l, String string, Class[] classArray, Object[] objectArray, boolean bl) throws InvocationTargetException {
        PxMethodReqCV pxMethodReqCV = new PxMethodReqCV(l, string, classArray, objectArray, null, bl, false);
        return (ProxyReturnValue)this.sendAndReceive(pxMethodReqCV);
    }

    public ProxyReturnValue callMethod(long l, String string, Class[] classArray, Object[] objectArray, boolean[] blArray, boolean bl) throws InvocationTargetException {
        PxMethodReqCV pxMethodReqCV = new PxMethodReqCV(l, string, classArray, objectArray, blArray, bl, false);
        return (ProxyReturnValue)this.sendAndReceive(pxMethodReqCV);
    }

    public boolean callMethodReturnsBoolean(long l, String string) throws InvocationTargetException {
        return this.callMethod(l, string, noArgumentClasses_, noArguments_, false).getReturnValueBoolean();
    }

    public int callMethodReturnsInt(long l, String string) throws InvocationTargetException {
        return this.callMethod(l, string, noArgumentClasses_, noArguments_, false).getReturnValueInt();
    }

    public Object callMethodReturnsObject(long l, String string) throws InvocationTargetException {
        return this.callMethod(l, string, noArgumentClasses_, noArguments_, false).getReturnValue();
    }

    public void close() {
        super.close();
        this.secondaryFinalizerThread_.stopSafely();
    }

    public void connect() {
        PxConnectReqCV pxConnectReqCV = this.tunnel_ ? new PxConnectReqCV("mod4", this.connectAttempts_++, locale_, 11015) : new PxConnectReqCV("mod4", this.connectAttempts_++, locale_, 11010);
        try {
            this.sendAndReceive(pxConnectReqCV);
        }
        catch (InvocationTargetException invocationTargetException) {
            ProxyClientConnection.rethrow(invocationTargetException);
        }
    }

    protected void finalize() throws Throwable {
        Object[] objectArray = new Long[this.pxList_.size()];
        this.pxList_.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            long l = (Long)objectArray[i];
            this.callFinalize(l);
        }
        super.finalize();
    }

    public void open(String string) {
        super.open(string);
        PxDSFactory pxDSFactory = this.getFactory();
        pxDSFactory.register(new PxByteParm());
        pxDSFactory.register(new PxShortParm());
        pxDSFactory.register(new PxIntParm());
        pxDSFactory.register(new PxLongParm());
        pxDSFactory.register(new PxFloatParm());
        pxDSFactory.register(new PxDoubleParm());
        pxDSFactory.register(new PxBooleanParm());
        pxDSFactory.register(new PxCharParm());
        pxDSFactory.register(new PxStringParm());
        pxDSFactory.register(new PxPxObjectParm());
        pxDSFactory.register(new PxSerializedObjectParm());
        pxDSFactory.register(new PxToolboxObjectParm());
        pxDSFactory.register(new PxNullParm());
        pxDSFactory.register(new PxClassParm());
        pxDSFactory.register(new PxAcceptRepCV());
        pxDSFactory.register(new PxRejectRepCV(this));
        pxDSFactory.register(new PxReturnRepCV());
        pxDSFactory.register(new PxExceptionRepCV());
        this.eventSupport_ = new PxEventSupport();
        pxDSFactory.register(new PxEventRepCV(this.eventSupport_));
        this.secondaryFinalizerThread_ = new SecondaryFinalizerThread_();
        this.secondaryFinalizerThread_.start();
    }

    public void removeListener(long l, EventListener eventListener, String string) {
        if (this.eventSupport_.removeListener(l, eventListener)) {
            PxListenerReqCV pxListenerReqCV = new PxListenerReqCV(l, 2, string);
            this.send(pxListenerReqCV);
            this.eventSupport_.removeAll(l);
        }
    }

    public static InternalErrorException rethrow(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return new InternalErrorException(10);
    }

    public static InternalErrorException rethrow1(InvocationTargetException invocationTargetException) throws IOException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        return ProxyClientConnection.rethrow(invocationTargetException);
    }

    public static InternalErrorException rethrow2(InvocationTargetException invocationTargetException) throws AS400SecurityException, IOException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof AS400SecurityException) {
            throw (AS400SecurityException)throwable;
        }
        return ProxyClientConnection.rethrow1(invocationTargetException);
    }

    public static InternalErrorException rethrow3(InvocationTargetException invocationTargetException) throws AS400SecurityException, InterruptedException, IOException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof InterruptedException) {
            throw (InterruptedException)throwable;
        }
        return ProxyClientConnection.rethrow2(invocationTargetException);
    }

    public static InternalErrorException rethrow4(InvocationTargetException invocationTargetException) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof ErrorCompletingRequestException) {
            throw (ErrorCompletingRequestException)throwable;
        }
        return ProxyClientConnection.rethrow3(invocationTargetException);
    }

    public static InternalErrorException rethrow4a(InvocationTargetException invocationTargetException) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof AS400Exception) {
            throw (AS400Exception)throwable;
        }
        return ProxyClientConnection.rethrow3(invocationTargetException);
    }

    public static InternalErrorException rethrow5(InvocationTargetException invocationTargetException) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof ObjectDoesNotExistException) {
            throw (ObjectDoesNotExistException)throwable;
        }
        return ProxyClientConnection.rethrow4(invocationTargetException);
    }

    public static InternalErrorException rethrow6(InvocationTargetException invocationTargetException) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof ObjectAlreadyExistsException) {
            throw (ObjectAlreadyExistsException)throwable;
        }
        return ProxyClientConnection.rethrow5(invocationTargetException);
    }

    public static InternalErrorException rethrow6a(InvocationTargetException invocationTargetException) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof RequestNotSupportedException) {
            throw (RequestNotSupportedException)throwable;
        }
        return ProxyClientConnection.rethrow4(invocationTargetException);
    }

    private class SecondaryFinalizerThread_
    extends StoppableThread {
        private Vector requests_;

        public SecondaryFinalizerThread_() {
            super("Proxy client secondary finalizer thread-" + SecondaryFinalizerThread_.newId());
            this.requests_ = new Vector();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRequest(PxReqCV pxReqCV) {
            Vector vector = this.requests_;
            synchronized (vector) {
                this.requests_.addElement(pxReqCV);
                this.requests_.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.canContinue()) {
                Vector vector = this.requests_;
                synchronized (vector) {
                    try {
                        this.requests_.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Enumeration enumeration = this.requests_.elements();
                    while (enumeration.hasMoreElements()) {
                        PxReqCV pxReqCV = (PxReqCV)enumeration.nextElement();
                        ProxyClientConnection.this.send(pxReqCV);
                    }
                    this.requests_.removeAllElements();
                }
            }
        }
    }
}

