/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBColumnDescriptorsDataFormat;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.ToolboxWrapper;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class AS400JDBCResultSetMetaData
extends ToolboxWrapper
implements ResultSetMetaData {
    private static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private static final int SQL_UNSEARCHABLE = 240;
    private static final int SQL_LIKE_ONLY = 241;
    private static final int SQL_ALL_EXCEPT_LIKE = 242;
    private static final int SQL_SEARCHABLE = 243;
    private static final int SQL_READ_ONLY = 240;
    private static final int SQL_WRITE_CAPABLE = 241;
    private static final int SQL_READ_WRITE_UNKNOWN = 242;
    private String catalog_;
    private int concurrency_;
    private String cursorName_;
    private JDRow row_;
    private DBExtendedColumnDescriptors extendedColumnDescriptors_;
    private ConvTable convTable_;

    AS400JDBCResultSetMetaData(String string, int n, String string2, JDRow jDRow, DBExtendedColumnDescriptors dBExtendedColumnDescriptors, ConvTable convTable) {
        this.catalog_ = string;
        this.concurrency_ = n;
        this.cursorName_ = string2;
        this.row_ = jDRow;
        this.extendedColumnDescriptors_ = dBExtendedColumnDescriptors;
        this.convTable_ = convTable;
    }

    private void checkIndex(int n) throws SQLException {
        if (n < 1 || n > this.row_.getFieldCount()) {
            JDError.throwSQLException(this, "07009");
        }
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkIndex(n);
        return this.catalog_;
    }

    public String getColumnClassName(int n) throws SQLException {
        this.checkIndex(n);
        SQLData sQLData = this.row_.getSQLType(n);
        String string = sQLData.getObject().getClass().getName();
        return string;
    }

    public int getColumnCount() throws SQLException {
        return this.row_.getFieldCount();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getDisplaySize();
    }

    public String getColumnLabel(int n) throws SQLException {
        String string;
        DBColumnDescriptorsDataFormat dBColumnDescriptorsDataFormat;
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null && (dBColumnDescriptorsDataFormat = this.extendedColumnDescriptors_.getColumnDescriptors(n, this.convTable_)) != null && (string = dBColumnDescriptorsDataFormat.getColumnLabel(this.convTable_)) != null) {
            return string;
        }
        return this.row_.getFieldName(n);
    }

    public String getColumnName(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getFieldName(n);
    }

    public int getColumnType(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getTypeName();
    }

    public int getPrecision(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getPrecision();
    }

    public int getScale(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getScale();
    }

    public String getSchemaName(int n) throws SQLException {
        DBColumnDescriptorsDataFormat dBColumnDescriptorsDataFormat;
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null && (dBColumnDescriptorsDataFormat = this.extendedColumnDescriptors_.getColumnDescriptors(n)) != null) {
            return dBColumnDescriptorsDataFormat.getBaseTableSchemaName(this.convTable_);
        }
        return "";
    }

    public String getTableName(int n) throws SQLException {
        DBColumnDescriptorsDataFormat dBColumnDescriptorsDataFormat;
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null && (dBColumnDescriptorsDataFormat = this.extendedColumnDescriptors_.getColumnDescriptors(n)) != null) {
            return dBColumnDescriptorsDataFormat.getBaseTableName(this.convTable_);
        }
        return "";
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkIndex(n);
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).isText();
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkIndex(n);
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkIndex(n);
        return false;
    }

    public int isNullable(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.isNullable(n);
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null) {
            return this.extendedColumnDescriptors_.getUpdateable(n) == -16;
        }
        return this.concurrency_ == 1007;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null) {
            return this.extendedColumnDescriptors_.getSearchable(n) != -16;
        }
        return true;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).isSigned();
    }

    public boolean isWritable(int n) throws SQLException {
        return !this.isReadOnly(n);
    }

    public String toString() {
        return this.cursorName_;
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCResultSetMetaData", "java.sql.ResultSetMetaData"};
    }
}

