/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileImpl;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileEvent;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.KeyedFile;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class AS400File
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400File";
    static final long serialVersionUID = 4L;
    public static final String BLANK = "*BLANK";
    public static final int COMMIT_LOCK_LEVEL_ALL = 0;
    public static final int COMMIT_LOCK_LEVEL_CHANGE = 1;
    public static final int COMMIT_LOCK_LEVEL_CURSOR_STABILITY = 2;
    public static final int COMMIT_LOCK_LEVEL_DEFAULT = 4;
    public static final int COMMIT_LOCK_LEVEL_NONE = 3;
    public static final int READ_ALLOW_SHARED_READ_LOCK = 1;
    public static final int READ_ALLOW_SHARED_WRITE_LOCK = 0;
    public static final int READ_EXCLUSIVE_LOCK = 4;
    public static final int READ_ONLY = 0;
    public static final int READ_WRITE = 1;
    public static final String SOURCE_MEMBER_TEXT = "*SRCMBRTXT";
    public static final String TYPE_DATA = "*DATA";
    public static final String TYPE_SOURCE = "*SRC";
    public static final int WRITE_ALLOW_SHARED_READ_LOCK = 3;
    public static final int WRITE_ALLOW_SHARED_WRITE_LOCK = 2;
    public static final int WRITE_EXCLUSIVE_LOCK = 5;
    public static final int WRITE_ONLY = 2;
    transient PropertyChangeSupport changes_;
    transient VetoableChangeSupport vetos_;
    transient Vector fileListeners_;
    transient boolean isOpen_;
    boolean readNoUpdate_ = false;
    boolean ssp_ = false;
    String library_ = "";
    String file_ = "";
    String member_ = "";
    String name_ = "";
    RecordFormat recordFormat_;
    AS400 system_;
    transient AS400FileImpl impl_;

    public AS400File() {
        this.initializeTransient();
    }

    public AS400File(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.setName(string);
        this.system_ = aS400;
    }

    public void addFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        this.fileListeners_.addElement(fileListener);
    }

    public void addPhysicalFileMember(String string, String string2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string.length() > 10) {
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 1);
        }
        if (string2 != null && string2.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription (" + string2 + ")", 1);
        }
        this.chooseImpl();
        this.impl_.doIt("addPhysicalFileMember", new Class[]{String.class, String.class}, new Object[]{string, string2});
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    void checkOpen() {
        if (!this.isOpen_) {
            throw new ExtendedIllegalStateException(3);
        }
    }

    synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.name_ == null || this.name_.length() == 0) {
                throw new ExtendedIllegalStateException("name", 4);
            }
            this.impl_ = (AS400FileImpl)this.system_.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
            this.system_.signon(false);
            this.impl_.doItNoExceptions("setAll", new Class[]{AS400Impl.class, String.class, RecordFormat.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{this.system_.getImpl(), this.name_, this.recordFormat_, new Boolean(this.readNoUpdate_), new Boolean(this instanceof KeyedFile), new Boolean(this.ssp_)});
        }
    }

    public synchronized void close() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isOpen_) {
            try {
                try {
                    this.releaseExplicitLocks();
                }
                catch (AS400SecurityException aS400SecurityException) {
                    // empty catch block
                }
                this.doIt("close");
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                // empty catch block
            }
            this.isOpen_ = false;
            this.fireEvent(0);
        }
    }

    private void doIt(String string) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.impl_.doIt(string, new Class[0], new Object[0]);
    }

    public void commit() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isCommitmentControlStarted()) {
            this.doIt("commit");
        }
    }

    public static void commit(AS400 aS400) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        aS400.signon(false);
        AS400FileImpl aS400FileImpl = (AS400FileImpl)aS400.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
        aS400FileImpl.doIt("commit", new Class[]{AS400Impl.class}, new Object[]{aS400.getImpl()});
    }

    public void create(int n, String string, String string2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (n < 1 || n > 32766) {
            throw new ExtendedIllegalArgumentException("recordLength (" + String.valueOf(n) + ")", 4);
        }
        if (string == null) {
            throw new NullPointerException("fileType");
        }
        if (!string.equalsIgnoreCase(TYPE_DATA) && !string.equalsIgnoreCase(TYPE_SOURCE)) {
            throw new ExtendedIllegalArgumentException("fileType", 2);
        }
        if (string2 != null && string2.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription", 1);
        }
        this.chooseImpl();
        this.impl_.doIt("create", new Class[]{Integer.TYPE, String.class, String.class}, new Object[]{new Integer(n), string, string2});
        RecordFormat recordFormat = this.recordFormat_;
        this.recordFormat_ = new RecordFormat(this.file_);
        if (string.equalsIgnoreCase(TYPE_DATA)) {
            this.recordFormat_.addFieldDescription(new CharacterFieldDescription(new AS400Text(n, this.system_.getCcsid(), this.system_), this.file_));
        } else {
            this.recordFormat_.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 2), "SRCSEQ"));
            this.recordFormat_.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 0), "SRCDAT"));
            this.recordFormat_.addFieldDescription(new CharacterFieldDescription(new AS400Text(n - 12, this.system_.getCcsid(), this.system_), "SRCDTA"));
        }
        this.impl_.doIt("setRecordFormat", new Class[]{RecordFormat.class}, new Object[]{this.recordFormat_});
        this.fireEvent(4);
        this.changes_.firePropertyChange("recordFormat", recordFormat, this.recordFormat_);
    }

    public void create(String string, String string2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (string == null) {
            throw new NullPointerException("ddsSourceFile");
        }
        if (string2 != null && string2.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription", 1);
        }
        this.chooseImpl();
        this.impl_.doIt("create", new Class[]{String.class, String.class}, new Object[]{string, string2});
        this.fireEvent(4);
    }

    public void create(RecordFormat recordFormat, String string) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.create(recordFormat, string, null, null, null, null, false, null, null);
    }

    public void create(RecordFormat recordFormat, String string, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        if (string != null && string.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription (" + string + ")", 1);
        }
        this.chooseImpl();
        this.impl_.doIt("createDDSSourceFile", new Class[]{RecordFormat.class, String.class, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class}, new Object[]{recordFormat, string2, string3, string4, string5, new Boolean(bl), string6, string7});
        this.create("/QSYS.LIB/QTEMP.LIB/JT400DSSRC.FILE/JT400DSSRC.MBR", string);
        RecordFormat recordFormat2 = this.recordFormat_;
        this.recordFormat_ = recordFormat;
        this.impl_.doIt("setRecordFormat", new Class[]{RecordFormat.class}, new Object[]{this.recordFormat_});
        this.fireEvent(4);
        this.changes_.firePropertyChange("recordFormat", recordFormat2, this.recordFormat_);
    }

    public void delete() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        this.chooseImpl();
        this.doIt("delete");
        this.fireEvent(1);
    }

    public void deleteCurrentRecord() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("deleteCurrentRecord");
        this.fireEvent(2);
    }

    public void deleteMember() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        this.chooseImpl();
        this.doIt("deleteMember");
    }

    public void endCommitmentControl() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.chooseImpl();
        this.doIt("endCommitmentControl");
    }

    public static void endCommitmentControl(AS400 aS400) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        aS400.signon(false);
        AS400FileImpl aS400FileImpl = (AS400FileImpl)aS400.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
        aS400FileImpl.doIt("endCommitmentControl", new Class[]{AS400Impl.class}, new Object[]{aS400.getImpl()});
    }

    Record fillInRecord(Record record) {
        if (record != null) {
            record.initializeTextObjects(this.system_);
        }
        return record;
    }

    protected void finalize() throws Throwable {
        if (this.isOpen_) {
            this.doIt("discardReplies");
            this.close();
        }
        super.finalize();
    }

    private void fireEvent(int n) {
        Vector vector = (Vector)this.fileListeners_.clone();
        FileEvent fileEvent = new FileEvent(this, n);
        block7: for (int i = 0; i < vector.size(); ++i) {
            FileListener fileListener = (FileListener)vector.elementAt(i);
            switch (n) {
                case 0: {
                    fileListener.fileClosed(fileEvent);
                    continue block7;
                }
                case 4: {
                    fileListener.fileCreated(fileEvent);
                    continue block7;
                }
                case 1: {
                    fileListener.fileDeleted(fileEvent);
                    continue block7;
                }
                case 2: {
                    fileListener.fileModified(fileEvent);
                    continue block7;
                }
                case 3: {
                    fileListener.fileOpened(fileEvent);
                }
            }
        }
    }

    public int getBlockingFactor() {
        if (!this.isOpen_) {
            return 0;
        }
        return this.impl_.doItInt("getBlockingFactor");
    }

    public int getCommitLockLevel() {
        if (this.impl_ == null) {
            return -1;
        }
        return this.impl_.doItInt("getCommitLockLevel");
    }

    public int[] getExplicitLocks() {
        if (this.impl_ == null) {
            return new int[0];
        }
        return this.impl_.getExplicitLocks();
    }

    public String getFileName() {
        return this.file_;
    }

    public String getMemberName() {
        return this.member_;
    }

    public String getPath() {
        return this.name_;
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    void initializeTransient() {
        this.isOpen_ = false;
        this.fileListeners_ = new Vector();
        this.vetos_ = new VetoableChangeSupport(this);
        this.changes_ = new PropertyChangeSupport(this);
        this.impl_ = null;
    }

    public boolean isCommitmentControlStarted() {
        try {
            this.chooseImpl();
        }
        catch (ExtendedIllegalStateException extendedIllegalStateException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring illegal state on isCommitmentControlStarted().", (Throwable)extendedIllegalStateException);
            }
            return false;
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring security exception on isCommitmentControlStarted().", (Throwable)aS400SecurityException);
            }
            return false;
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring I/O exception on isCommitmentControlStarted().", (Throwable)iOException);
            }
            return false;
        }
        return this.impl_.doItBoolean("isCommitmentControlStarted");
    }

    public static boolean isCommitmentControlStarted(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        try {
            aS400.signon(false);
            AS400FileImpl aS400FileImpl = (AS400FileImpl)aS400.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
            return aS400FileImpl.doItBoolean("isCommitmentControlStarted", new Class[]{AS400Impl.class}, new Object[]{aS400.getImpl()});
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring I/O exception on isCommitmentControlStarted(AS400).", (Throwable)iOException);
            }
            return false;
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring security exception on isCommitmentControlStarted(AS400).", (Throwable)aS400SecurityException);
            }
            return false;
        }
    }

    public boolean isOpen() {
        return this.isOpen_;
    }

    public boolean isReadNoUpdate() {
        if (this.impl_ != null) {
            this.readNoUpdate_ = this.impl_.doItBoolean("isReadNoUpdate");
        }
        return this.readNoUpdate_;
    }

    public boolean isReadOnly() {
        if (this.impl_ == null) {
            return false;
        }
        return this.impl_.doItInt("getOpenType") == 0;
    }

    public boolean isReadWrite() {
        if (this.impl_ == null) {
            return false;
        }
        return this.impl_.doItInt("getOpenType") == 1;
    }

    public boolean isSSPFile() {
        return this.ssp_;
    }

    public boolean isWriteOnly() {
        if (this.impl_ == null) {
            return false;
        }
        return this.impl_.doItInt("getOpenType") == 2;
    }

    public void lock(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (n < 0 || n > 5) {
            throw new ExtendedIllegalArgumentException("lockToObtain", 2);
        }
        this.chooseImpl();
        this.impl_.doIt("lock", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public void open() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.open(1, 1, 4);
    }

    public void open(int n, int n2, int n3) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new ExtendedIllegalArgumentException("openType", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("blockingFactor", 2);
        }
        if (n3 < 0 || n3 > 4) {
            throw new ExtendedIllegalArgumentException("commitLockLevel", 2);
        }
        this.openFile(n, n2, n3, this instanceof KeyedFile);
    }

    synchronized void openFile(int n, int n2, int n3, boolean bl) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n4;
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        this.chooseImpl();
        this.recordFormat_.initializeTextObjects(this.system_);
        if (n != 1) {
            int n5;
            n4 = n2 == 0 ? ((n5 = 2048 / (this.recordFormat_.getNewRecord().getRecordLength() + 16)) > 0 ? n5 : 1) : n2;
            n5 = this.recordFormat_.getNewRecord().getRecordLength() + this.recordFormat_.getNumberOfFields() + this.recordFormat_.getNumberOfKeyFields() + 16;
            n4 = n4 * n5 >= 0x1000000 ? 0x1000000 / n5 : n4;
        } else {
            n4 = 1;
        }
        String[] stringArray = this.impl_.openFile2(n, n4, n3, bl);
        if (stringArray[0] != null) {
            this.library_ = stringArray[0];
        }
        if (stringArray[1] != null) {
            String string = this.member_;
            this.member_ = stringArray[1];
            this.changes_.firePropertyChange("member", string, this.member_);
        }
        this.isOpen_ = true;
        this.fireEvent(3);
    }

    public void positionCursorAfterLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("positionCursorAfterLast");
    }

    public void positionCursorBeforeFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("positionCursorBeforeFirst");
    }

    public void positionCursorToFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("positionCursorToFirst");
    }

    public void positionCursorToLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("positionCursorToLast");
    }

    public void positionCursorToNext() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("positionCursorToNext");
    }

    public void positionCursorToPrevious() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("positionCursorToPrevious");
    }

    public Record read() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        return this.fillInRecord(this.impl_.doItRecord("read", new Class[0], new Object[0]));
    }

    public abstract Record[] readAll() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public Record readFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        return this.fillInRecord(this.impl_.doItRecord("readFirst", new Class[0], new Object[0]));
    }

    public Record readLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        return this.fillInRecord(this.impl_.doItRecord("readLast", new Class[0], new Object[0]));
    }

    public Record readNext() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        return this.fillInRecord(this.impl_.doItRecord("readNext", new Class[0], new Object[0]));
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public Record readPrevious() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        return this.fillInRecord(this.impl_.doItRecord("readPrevious", new Class[0], new Object[0]));
    }

    public void refreshRecordCache() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("refreshRecordCache");
    }

    public void releaseExplicitLocks() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.chooseImpl();
        this.doIt("releaseExplicitLocks");
    }

    public void removeFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        this.fileListeners_.removeElement(fileListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void rollback() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isCommitmentControlStarted()) {
            this.doIt("rollback");
        }
    }

    public static void rollback(AS400 aS400) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        aS400.signon(false);
        AS400FileImpl aS400FileImpl = (AS400FileImpl)aS400.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
        aS400FileImpl.doIt("rollback", new Class[]{AS400Impl.class}, new Object[]{aS400.getImpl()});
    }

    public AS400Message[] runCommand(String string) throws AS400SecurityException, InterruptedException, IOException {
        if (string == null) {
            throw new NullPointerException("command");
        }
        this.chooseImpl();
        return this.impl_.execute(string);
    }

    private void setName(String string) {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        if (!qSYSObjectPathName.getObjectType().equals("FILE") && !qSYSObjectPathName.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(string, 1);
        }
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.file_ = qSYSObjectPathName.getObjectName();
        this.member_ = qSYSObjectPathName.getObjectType().equals("FILE") ? "*FIRST" : (qSYSObjectPathName.getMemberName().equalsIgnoreCase("*FILE") ? this.file_ : qSYSObjectPathName.getMemberName());
        this.name_ = string;
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String string2 = this.name_;
        this.vetos_.fireVetoableChange("path", string2, string);
        this.setName(string);
        if (this.impl_ != null) {
            this.impl_.doItNoExceptions("setPath", new Class[]{String.class}, new Object[]{string});
        }
        this.changes_.firePropertyChange("path", string2, string);
    }

    public void setReadNoUpdate(boolean bl) {
        this.readNoUpdate_ = bl;
        if (this.impl_ != null) {
            this.impl_.doItNoExceptions("setReadNoUpdate", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(bl)});
        }
    }

    public void setRecordFormat() throws AS400Exception, AS400SecurityException, InterruptedException, IOException, PropertyVetoException {
        this.setRecordFormat(0);
    }

    public void setRecordFormat(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException, PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("recordFormat (" + String.valueOf(n) + ") too small", 4);
        }
        this.chooseImpl();
        this.setRecordFormat(this.impl_.doItRecordFormat("setRecordFormat", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}));
    }

    public void setRecordFormat(String string) throws AS400Exception, AS400SecurityException, InterruptedException, IOException, PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("recordFormat");
        }
        this.chooseImpl();
        this.setRecordFormat(this.impl_.doItRecordFormat("setRecordFormat", new Class[]{String.class}, new Object[]{string}));
    }

    public void setRecordFormat(RecordFormat recordFormat) throws PropertyVetoException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        RecordFormat recordFormat2 = this.recordFormat_;
        this.vetos_.fireVetoableChange("recordFormat", recordFormat2, recordFormat);
        this.recordFormat_ = recordFormat;
        if (this.impl_ != null) {
            this.impl_.doItNoExceptions("setRecordFormat", new Class[]{RecordFormat.class}, new Object[]{this.recordFormat_});
        }
        this.changes_.firePropertyChange("recordFormat", recordFormat2, this.recordFormat_);
    }

    public void setSSPFile(boolean bl) {
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException("treatAsSSP", 5);
        }
        this.ssp_ = bl;
        if (this.impl_ != null) {
            this.impl_.doItNoExceptions("setSSPFile", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(bl)});
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.isOpen_ || this.impl_ != null) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.system_;
        this.vetos_.fireVetoableChange("system", aS4002, aS400);
        this.system_ = aS400;
        this.changes_.firePropertyChange("system", aS4002, this.system_);
    }

    public void startCommitmentControl(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (n < 0 || n > 2) {
            throw new ExtendedIllegalArgumentException("commitLockLevel", 2);
        }
        if (this.isCommitmentControlStarted()) {
            throw new ExtendedIllegalStateException(1);
        }
        this.chooseImpl();
        this.impl_.doIt("startCommitmentControl", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public static void startCommitmentControl(AS400 aS400, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (n < 0 || n > 2) {
            throw new ExtendedIllegalArgumentException("commitLockLevel", 2);
        }
        aS400.signon(false);
        AS400FileImpl aS400FileImpl = (AS400FileImpl)aS400.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
        aS400FileImpl.doIt("startCommitmentControl", new Class[]{AS400Impl.class, Integer.TYPE}, new Object[]{aS400.getImpl(), new Integer(n)});
    }

    public void update(Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.impl_.doIt("update", new Class[]{Record.class}, new Object[]{record});
        this.fireEvent(2);
    }

    public void write(Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.write(new Record[]{record});
    }

    public void write(Record[] recordArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (recordArray == null) {
            throw new NullPointerException("records");
        }
        if (recordArray.length == 0) {
            throw new ExtendedIllegalArgumentException("records", 1);
        }
        this.impl_.doIt("write", new Class[]{Record[].class}, new Object[]{recordArray});
        this.fireEvent(2);
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

