/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionEvent;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.CurrentUser;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyImpl;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerVersion;
import com.ibm.as400.access.SignonEvent;
import com.ibm.as400.access.SignonHandler;
import com.ibm.as400.access.SignonInfo;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.TokenManager;
import com.ibm.as400.access.TokenManager2;
import com.ibm.as400.access.ToolboxSignonHandler;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class AS400
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400";
    static final long serialVersionUID = 4L;
    private static final boolean PASSWORD_TRACE = false;
    public static final int FILE = 0;
    public static final int PRINT = 1;
    public static final int COMMAND = 2;
    public static final int DATAQUEUE = 3;
    public static final int DATABASE = 4;
    public static final int RECORDACCESS = 5;
    public static final int CENTRAL = 6;
    public static final int SIGNON = 7;
    public static final int USE_PORT_MAPPER = -1;
    public static final int AUTHENTICATION_SCHEME_PASSWORD = 0;
    public static final int AUTHENTICATION_SCHEME_GSS_TOKEN = 1;
    public static final int AUTHENTICATION_SCHEME_PROFILE_TOKEN = 2;
    public static final int AUTHENTICATION_SCHEME_IDENTITY_TOKEN = 3;
    public static final int GSS_OPTION_MANDATORY = 0;
    public static final int GSS_OPTION_FALLBACK = 1;
    public static final int GSS_OPTION_NONE = 2;
    static boolean onAS400;
    static ServerVersion nativeVRM;
    static Class defaultSignonHandlerClass_;
    static SignonHandler defaultSignonHandler_;
    private static Vector systemList;
    private static Hashtable defaultUsers;
    private static int expirationWarning;
    static Random rng;
    private static int alreadyCheckedForMultipleVersions_;
    private String systemName_ = "";
    private boolean systemNameLocal_ = false;
    private String userId_ = "";
    private transient byte[] bytes_ = null;
    private transient int byteType_ = 0;
    private transient Object gssCredential_ = null;
    private String gssName_ = "";
    int gssOption_ = 1;
    private transient String proxyServer_ = "";
    private transient Object proxyClientConnection_ = null;
    private boolean guiAvailable_ = true;
    private boolean usePasswordCache_ = true;
    private boolean useDefaultUser_ = true;
    private boolean showCheckboxes_ = true;
    private boolean signingOn_ = false;
    SSLOptions useSSLConnection_ = null;
    private boolean mustUseSockets_ = false;
    private boolean mustUseNetSockets_ = false;
    private boolean mustUseSuppliedProfile_ = false;
    private boolean threadUsed_ = true;
    private Locale locale_ = Locale.getDefault();
    private String nlv_ = ExecutionEnvironment.getNlv(Locale.getDefault());
    private SocketProperties socketProperties_ = new SocketProperties();
    private transient int ccsid_ = 0;
    private transient Vector connectionListeners_ = null;
    private transient ConnectionListener dispatcher_ = null;
    transient PropertyChangeSupport propertyChangeListeners_ = null;
    transient VetoableChangeSupport vetoableChangeListeners_ = null;
    transient boolean propertiesFrozen_ = false;
    private transient AS400Impl impl_ = null;
    private transient SignonInfo signonInfo_ = null;
    private String ddmRDB_ = null;
    private transient SignonHandler signonHandler_ = null;
    private transient boolean handlerCanceled_ = false;
    private static int nativeVersion;
    private static final int FINISHED = 0;
    private static final int VALIDATE = 1;
    private static final int PROMPT = 2;
    private static final int MAX_ITERATIONS = 20;
    private static boolean currentUserAvailable;
    private static boolean currentUserTried;

    public AS400() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object.");
        }
        this.construct();
        this.systemNameLocal_ = AS400.resolveSystemNameLocal("");
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public AS400(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + string + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public AS400(String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'userId' is null.");
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            Trace.log(2, "Length of parameter 'userId' is not valid: '" + string2 + "'");
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.userId_ = string2.toUpperCase();
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public AS400(String string, ProfileTokenCredential profileTokenCredential) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object with profile token, system name: '" + string + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        if (profileTokenCredential == null) {
            Trace.log(2, "Parameter 'profileToken' is null.");
            throw new NullPointerException("profileToken");
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.bytes_ = AS400.store(profileTokenCredential.getToken());
        this.byteType_ = 2;
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public AS400(String string, String string2, String string3) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'userId' is null.");
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            Trace.log(2, "Length of parameter 'userId' is not valid: '" + string2 + "'");
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        if (string3 == null) {
            Trace.log(2, "Parameter 'password' is null.");
            throw new NullPointerException("password");
        }
        if (string3.length() > 128) {
            Trace.log(2, "Length of parameter 'password' is not valid: " + string3.length());
            throw new ExtendedIllegalArgumentException("password.length {" + string3.length() + ")", 1);
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.userId_ = string2.toUpperCase();
        this.bytes_ = AS400.store(string3);
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    private AS400(String string, String string2, byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing internal AS400 object, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'userId' is null.");
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            Trace.log(2, "Length of parameter 'userId' is not valid: '" + string2 + "'");
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.userId_ = string2.toUpperCase();
        this.bytes_ = byArray;
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public AS400(String string, String string2, String string3, String string4) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + string + "' user ID: '" + string2 + "' proxy server: '" + string4 + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'userId' is null.");
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            Trace.log(2, "Length of parameter 'userId' is not valid: '" + string2 + "'");
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        if (string3 == null) {
            Trace.log(2, "Parameter 'password' is null.");
            throw new NullPointerException("password");
        }
        if (string3.length() > 128) {
            Trace.log(2, "Length of parameter 'password' is not valid: " + string3.length());
            throw new ExtendedIllegalArgumentException("password.length {" + string3.length() + ")", 1);
        }
        if (string4 == null) {
            Trace.log(2, "Parameter 'proxyServer' is null.");
            throw new NullPointerException("proxyServer");
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.userId_ = string2.toUpperCase();
        this.bytes_ = AS400.store(string3);
        this.proxyServer_ = AS400.resolveProxyServer(string4);
    }

    public AS400(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.construct();
        this.systemName_ = aS400.systemName_;
        this.systemNameLocal_ = aS400.systemNameLocal_;
        this.userId_ = aS400.userId_;
        this.bytes_ = aS400.bytes_;
        this.byteType_ = aS400.byteType_;
        this.gssCredential_ = aS400.gssCredential_;
        this.gssName_ = aS400.gssName_;
        this.gssOption_ = aS400.gssOption_;
        this.proxyServer_ = aS400.proxyServer_;
        this.guiAvailable_ = aS400.guiAvailable_;
        this.usePasswordCache_ = aS400.usePasswordCache_;
        this.useDefaultUser_ = aS400.useDefaultUser_;
        this.showCheckboxes_ = aS400.showCheckboxes_;
        this.mustUseSockets_ = aS400.mustUseSockets_;
        this.mustUseNetSockets_ = aS400.mustUseNetSockets_;
        this.mustUseSuppliedProfile_ = aS400.mustUseSuppliedProfile_;
        this.threadUsed_ = aS400.threadUsed_;
        this.locale_ = aS400.locale_;
        this.nlv_ = aS400.nlv_;
        this.socketProperties_ = aS400.socketProperties_;
        this.ccsid_ = aS400.ccsid_;
        this.ddmRDB_ = aS400.ddmRDB_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding connection listener.");
        }
        if (connectionListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.connectionListeners_ == null) {
                this.connectionListeners_ = new Vector();
                this.dispatcher_ = new ConnectionListener(){

                    public void connected(ConnectionEvent connectionEvent) {
                        AS400.this.fireConnectEvent(connectionEvent, true);
                    }

                    public void disconnected(ConnectionEvent connectionEvent) {
                        AS400.this.fireConnectEvent(connectionEvent, false);
                    }
                };
            }
            if (this.impl_ != null && this.connectionListeners_.isEmpty()) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Enabling connection listener dispatcher.");
                }
                this.impl_.addConnectionListener(this.dispatcher_);
            }
            this.connectionListeners_.addElement(connectionListener);
        }
    }

    public static void addPasswordCacheEntry(String string, String string2, String string3) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        AS400.addPasswordCacheEntry(new AS400(string, string2, string3));
    }

    public static void addPasswordCacheEntry(String string, String string2, String string3, String string4) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + string + "' user ID: '" + string2 + "' proxy server: '" + string4 + "'");
        }
        AS400.addPasswordCacheEntry(new AS400(string, string2, string3, string4));
    }

    static void addPasswordCacheEntry(AS400 aS400) throws AS400SecurityException, IOException {
        aS400.validateSignon();
        AS400.setCacheEntry(aS400.systemName_, aS400.userId_, aS400.bytes_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public boolean arePropertiesFrozen() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if properties are frozen:", this.propertiesFrozen_);
        }
        return this.propertiesFrozen_;
    }

    public boolean authenticate(String string, String string2) throws AS400SecurityException, IOException {
        return this.validateSignon(string, string2);
    }

    private static int getNativeVersion() {
        try {
            if (nativeVersion == -1) {
                nativeVersion = Class.forName("com.ibm.as400.access.NativeVersion").newInstance().hashCode();
            }
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(1, "Not using native optimizations, unexpected exception while loading native version:", (Throwable)exception);
            }
            nativeVersion = 0;
        }
        return nativeVersion;
    }

    boolean canUseNativeOptimizations() {
        if (onAS400 && !this.mustUseSockets_ && this.systemNameLocal_ && this.proxyServer_.length() == 0 && this.byteType_ == 0 && AS400.getNativeVersion() == 2) {
            if (Trace.traceOn_) {
                Trace.log(1, "Using native optimizations.");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String string, String string2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Changing password.");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'oldPassword' is null.");
            throw new NullPointerException("oldPassword");
        }
        if (string.length() > 128) {
            Trace.log(2, "Length of parameter 'oldPassword' is not valid: " + string.length());
            throw new ExtendedIllegalArgumentException("oldPassword.length {" + string.length() + ")", 1);
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'newPassword' is null.");
            throw new NullPointerException("newPassword");
        }
        if (string2.length() > 128) {
            Trace.log(2, "Length of parameter 'newPassword' is not valid: " + string2.length());
            throw new ExtendedIllegalArgumentException("newPassword.length {" + string2.length() + ")", 1);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot change password before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.userId_ = AS400.resolveUserId(this.userId_);
        if (this.userId_.length() == 0) {
            Trace.log(2, "Cannot change password before user ID is set.");
            throw new ExtendedIllegalStateException("userId", 4);
        }
        this.chooseImpl();
        AS400 aS400 = this;
        synchronized (aS400) {
            byte[] byArray = new byte[9];
            rng.nextBytes(byArray);
            byte[] byArray2 = this.impl_.exchangeSeed(byArray);
            this.signonInfo_ = this.impl_.changePassword(this.systemName_, this.systemNameLocal_, this.userId_, AS400.encode(byArray, byArray2, BinaryConverter.charArrayToByteArray(string.toCharArray())), AS400.encode(byArray, byArray2, BinaryConverter.charArrayToByteArray(string2.toCharArray())));
            if (Trace.traceOn_) {
                Trace.log(1, "Password changed successfully.");
            }
            this.bytes_ = AS400.store(string2);
            this.byteType_ = 0;
        }
    }

    private synchronized void chooseImpl() {
        if (this.impl_ == null) {
            this.impl_ = (AS400Impl)this.loadImpl2("com.ibm.as400.access.AS400ImplRemote", "com.ibm.as400.access.AS400ImplProxy");
            if (this.connectionListeners_ != null && !this.connectionListeners_.isEmpty()) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Enabling connection listener dispatcher.");
                }
                this.impl_.addConnectionListener(this.dispatcher_);
            }
        }
        if (!this.propertiesFrozen_) {
            this.impl_.setState(this.useSSLConnection_, this.canUseNativeOptimizations(), this.threadUsed_, this.ccsid_, this.nlv_, this.socketProperties_, this.ddmRDB_, this.mustUseNetSockets_, this.mustUseSuppliedProfile_);
            this.propertiesFrozen_ = true;
        }
    }

    public static void clearPasswordCache() {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing password cache.");
        }
        systemList.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPasswordCache(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing password cache, system name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        string = AS400.resolveSystem(string);
        Vector vector = systemList;
        synchronized (vector) {
            for (int i = systemList.size() - 1; i >= 0; --i) {
                if (!string.equalsIgnoreCase((String)((Object[])systemList.elementAt(i))[0])) continue;
                systemList.removeElementAt(i);
            }
        }
    }

    public void connectService(int n) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Connecting service:", n);
        }
        if (n < 0 || n > 7) {
            Trace.log(2, "Value of parameter 'service' is not valid:", n);
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        this.chooseImpl();
        this.signon(n == 7);
        this.impl_.connect(n);
        if (Trace.traceOn_) {
            Trace.log(1, "Service connected: " + AS400.getServerName(n));
        }
    }

    private void construct() {
        if (onAS400) {
            if (Trace.traceOn_) {
                Trace.log(1, "Running on i5/OS.");
            }
            this.guiAvailable_ = false;
        }
    }

    private static byte[] decode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        int n2 = byArray3.length;
        byte[] byArray4 = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray2[n % 7] ^ byArray3[n]);
        }
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray4[n] - byArray[n % 9]);
        }
        return byArray4;
    }

    public void disconnectAllServices() {
        if (Trace.traceOn_) {
            Trace.log(1, "Disconnecting all services...");
        }
        if (this.impl_ != null) {
            this.chooseImpl();
            this.impl_.disconnect(0);
            this.impl_.disconnect(1);
            this.impl_.disconnect(2);
            this.impl_.disconnect(3);
            this.impl_.disconnect(4);
            this.impl_.disconnect(5);
            this.impl_.disconnect(6);
            this.impl_.disconnect(7);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "All services disconnected.");
        }
    }

    public void disconnectService(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Disconnecting service:", n);
        }
        if (n < 0 || n > 7) {
            Trace.log(2, "Value of parameter 'service' is not valid:", n);
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (this.impl_ == null) {
            return;
        }
        this.chooseImpl();
        this.impl_.disconnect(n);
    }

    private static byte[] encode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        if (byArray3 == null) {
            return null;
        }
        int n2 = byArray3.length;
        byte[] byArray4 = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray3[n] + byArray[n % 9]);
        }
        for (n = 0; n < n2; ++n) {
            byArray4[n] = (byte)(byArray4[n] ^ byArray2[n % 7]);
        }
        return byArray4;
    }

    private void fireConnectEvent(ConnectionEvent connectionEvent, boolean bl) {
        connectionEvent.setSource(this);
        Vector vector = (Vector)this.connectionListeners_.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ConnectionListener connectionListener = (ConnectionListener)vector.elementAt(i);
            if (bl) {
                connectionListener.connected(connectionEvent);
                continue;
            }
            connectionListener.disconnected(connectionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential generateProfileToken(String string, int n, int n2) throws AS400SecurityException, IOException {
        this.connectService(7);
        if (string == null) {
            Trace.log(2, "Parameter 'userIdentity' is null.");
            throw new NullPointerException("userIdentity");
        }
        ProfileTokenCredential profileTokenCredential = new ProfileTokenCredential();
        try {
            profileTokenCredential.setSystem(this);
            profileTokenCredential.setTokenType(n);
            profileTokenCredential.setTimeoutInterval(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
        this.chooseImpl();
        AS400 aS400 = this;
        synchronized (aS400) {
            this.impl_.generateProfileToken(profileTokenCredential, string);
        }
        return profileTokenCredential;
    }

    public static int generateVRM(int n, int n2, int n3) {
        if (n < 0 || n > 65535) {
            Trace.log(2, "Value of parameter 'version' is not valid:", n);
            throw new ExtendedIllegalArgumentException("version (" + n + ")", 4);
        }
        if (n2 < 0 || n2 > 255) {
            Trace.log(2, "Value of parameter 'release' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("release (" + n2 + ")", 4);
        }
        if (n3 < 0 || n3 > 255) {
            Trace.log(2, "Value of parameter 'modification' is not valid:", n3);
            throw new ExtendedIllegalArgumentException("modification (" + n3 + ")", 4);
        }
        return (n << 16) + (n2 << 8) + n3;
    }

    public int getAuthenticationScheme() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting authentication scheme, scheme:", this.byteType_);
        }
        return this.byteType_;
    }

    public int getCcsid() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting CCSID.");
        }
        if (this.ccsid_ == 0) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Retrieving CCSID from system...");
                }
                this.chooseImpl();
                this.signon(false);
                this.ccsid_ = this.signonInfo_.serverCCSID;
            }
            catch (Exception exception) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Taking best guess CCSID:", (Throwable)exception);
                }
                this.ccsid_ = ExecutionEnvironment.getBestGuessAS400Ccsid();
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "CCSID:", this.ccsid_);
        }
        return this.ccsid_;
    }

    private int getDaysToExpiration() {
        if (this.signonInfo_ != null) {
            GregorianCalendar gregorianCalendar = this.signonInfo_.expirationDate;
            GregorianCalendar gregorianCalendar2 = this.signonInfo_.currentSignonDate;
            if (gregorianCalendar != null && gregorianCalendar2 != null) {
                long l = gregorianCalendar.getTime().getTime();
                long l2 = gregorianCalendar2.getTime().getTime();
                int n = (int)((l - l2) / 86400000L + 1L);
                return n;
            }
        }
        return 365;
    }

    public static SignonHandler getDefaultSignonHandler() {
        if (defaultSignonHandler_ != null) {
            return defaultSignonHandler_;
        }
        try {
            return (SignonHandler)defaultSignonHandlerClass_.newInstance();
        }
        catch (Exception exception) {
            Trace.log(2, "Unable to cast specified default sign-on handler to a SignonHandler: " + defaultSignonHandlerClass_.getName(), (Throwable)exception);
            return new ToolboxSignonHandler();
        }
    }

    public String getDDMRDB() {
        return this.ddmRDB_;
    }

    public static String getDefaultUser(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting the default user, system name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        String string2 = (String)defaultUsers.get(AS400.resolveSystem(string));
        if (Trace.traceOn_) {
            Trace.log(1, "Default user: " + string2);
        }
        return string2;
    }

    public String getGSSName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting GSS name: " + this.gssName_);
        }
        return this.gssName_;
    }

    public int getGSSOption() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting GSS option:", this.gssOption_);
        }
        return this.gssOption_;
    }

    AS400Impl getImpl() {
        this.chooseImpl();
        return this.impl_;
    }

    int getJobCcsid() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job CCSID.");
        }
        this.chooseImpl();
        this.signon(false);
        if (Trace.traceOn_) {
            Trace.log(1, "Job CCSID: " + this.signonInfo_.serverCCSID);
        }
        return this.signonInfo_.serverCCSID;
    }

    public String getJobCCSIDEncoding() throws AS400SecurityException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job CCSID encoding.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.serverCCSID;
        String string = this.impl_.ccsidToEncoding(n);
        if (Trace.traceOn_) {
            Trace.log(1, "Job CCSID encoding: " + string);
        }
        return string;
    }

    public Job[] getJobs(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting jobs, service:", n);
        }
        if (n < 0 || n > 7) {
            Trace.log(2, "Value of parameter 'service' is not valid:", n);
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (this.impl_ == null) {
            return new Job[0];
        }
        this.chooseImpl();
        String[] stringArray = this.impl_.getJobs(n);
        Job[] jobArray = new Job[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (Trace.traceOn_) {
                Trace.log(1, "Constructing Job for job: " + stringArray[i]);
            }
            if (stringArray[i] == null || stringArray[i].length() == 0) {
                return new Job[0];
            }
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "/");
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            jobArray[i] = new Job(this, string3, string2, string);
        }
        return jobArray;
    }

    public Locale getLocale() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting locale: " + this.locale_);
        }
        return this.locale_;
    }

    public int getModification() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting modification level.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.version.getModificationLevel();
        if (Trace.traceOn_) {
            Trace.log(1, "Modification level:", n);
        }
        return n;
    }

    public String getNLV() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting NLV: " + this.nlv_);
        }
        return this.nlv_;
    }

    public GregorianCalendar getPasswordExpirationDate() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting password expiration date.");
        }
        this.chooseImpl();
        this.signon(false);
        GregorianCalendar gregorianCalendar = this.signonInfo_.expirationDate;
        if (Trace.traceOn_) {
            Trace.log(1, "Password expiration date: " + gregorianCalendar);
        }
        return gregorianCalendar == null ? null : (GregorianCalendar)gregorianCalendar.clone();
    }

    public static int getPasswordExpirationWarningDays() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting the password expiration warning days:", expirationWarning);
        }
        return expirationWarning;
    }

    public GregorianCalendar getPreviousSignonDate() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting previous signon date.");
        }
        this.chooseImpl();
        this.signon(false);
        GregorianCalendar gregorianCalendar = this.signonInfo_.lastSignonDate;
        if (Trace.traceOn_) {
            Trace.log(1, "Previous signon date: " + gregorianCalendar);
        }
        return gregorianCalendar == null ? null : (GregorianCalendar)gregorianCalendar.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential getProfileToken() throws AS400SecurityException, IOException, InterruptedException {
        this.connectService(7);
        if (this.signonInfo_.profileToken != null) {
            return (ProfileTokenCredential)this.signonInfo_.profileToken;
        }
        if (this.bytes_ == null && this.byteType_ != 1) {
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        ProfileTokenCredential profileTokenCredential = new ProfileTokenCredential();
        try {
            profileTokenCredential.setSystem(this);
            profileTokenCredential.setTokenType(1);
            profileTokenCredential.setTimeoutInterval(3600);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
        byte[] byArray = new byte[9];
        rng.nextBytes(byArray);
        AS400 aS400 = this;
        synchronized (aS400) {
            this.impl_.generateProfileToken(profileTokenCredential, this.userId_, AS400.encode(byArray, this.impl_.exchangeSeed(byArray), AS400.resolve(this.bytes_)), this.byteType_);
        }
        this.signonInfo_.profileToken = profileTokenCredential;
        return profileTokenCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential getProfileToken(int n, int n2) throws AS400SecurityException, IOException, InterruptedException {
        this.connectService(7);
        if (this.bytes_ == null && this.byteType_ != 1) {
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        if (n == 3) {
            Trace.log(2, "Request not supported for renewable token type.");
            throw new AS400SecurityException(37);
        }
        ProfileTokenCredential profileTokenCredential = new ProfileTokenCredential();
        try {
            profileTokenCredential.setSystem(this);
            profileTokenCredential.setTokenType(n);
            profileTokenCredential.setTimeoutInterval(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
        byte[] byArray = new byte[9];
        rng.nextBytes(byArray);
        AS400 aS400 = this;
        synchronized (aS400) {
            this.impl_.generateProfileToken(profileTokenCredential, this.userId_, AS400.encode(byArray, this.impl_.exchangeSeed(byArray), AS400.resolve(this.bytes_)), this.byteType_);
        }
        return profileTokenCredential;
    }

    public ProfileTokenCredential getProfileToken(String string, String string2) throws AS400SecurityException, IOException, InterruptedException {
        return this.getProfileToken(string, string2, 1, 3600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential getProfileToken(String string, String string2, int n, int n2) throws AS400SecurityException, IOException, InterruptedException {
        this.connectService(7);
        if (string == null) {
            Trace.log(2, "Parameter 'userId' is null.");
            throw new NullPointerException("userId");
        }
        if (string.length() > 10) {
            Trace.log(2, "Length of 'userId' parameter is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("userId", 1);
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'password' is null.");
            throw new NullPointerException("password");
        }
        if (string2.length() > 128) {
            Trace.log(2, "Length of 'password' parameter is not valid: " + string2.length());
            throw new ExtendedIllegalArgumentException("password.length {" + string2.length() + ")", 1);
        }
        string = AS400.resolveUserId(string.toUpperCase());
        ProfileTokenCredential profileTokenCredential = new ProfileTokenCredential();
        try {
            profileTokenCredential.setSystem(this);
            profileTokenCredential.setTokenType(n);
            profileTokenCredential.setTimeoutInterval(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
        byte[] byArray = new byte[9];
        rng.nextBytes(byArray);
        AS400 aS400 = this;
        synchronized (aS400) {
            this.impl_.generateProfileToken(profileTokenCredential, string, AS400.encode(byArray, this.impl_.exchangeSeed(byArray), BinaryConverter.charArrayToByteArray(string2.toCharArray())), 0);
        }
        return profileTokenCredential;
    }

    public String getProxyServer() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting proxy server: " + this.proxyServer_);
        }
        return this.proxyServer_;
    }

    public int getRelease() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting release level.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.version.getRelease();
        if (Trace.traceOn_) {
            Trace.log(1, "Release level:", n);
        }
        return n;
    }

    static String getServerName(int n) {
        switch (n) {
            case 0: {
                return "as-file";
            }
            case 1: {
                return "as-netprt";
            }
            case 2: {
                return "as-rmtcmd";
            }
            case 3: {
                return "as-dtaq";
            }
            case 4: {
                return "as-database";
            }
            case 5: {
                return "as-ddm";
            }
            case 6: {
                return "as-central";
            }
            case 7: {
                return "as-signon";
            }
        }
        Trace.log(2, "Value of parameter 'service' is not valid:", n);
        throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
    }

    public int getServicePort(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting service port, service:", n);
        }
        if (n < 0 || n > 7) {
            Trace.log(2, "Value of parameter 'service' is not valid:", n);
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot get service port before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.chooseImpl();
        int n2 = this.impl_.getServicePort(this.systemNameLocal_ ? "localhost" : this.systemName_, n);
        if (Trace.traceOn_) {
            Trace.log(1, "Service port:", n2);
        }
        return n2;
    }

    public GregorianCalendar getSignonDate() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting signon date.");
        }
        this.chooseImpl();
        this.signon(false);
        GregorianCalendar gregorianCalendar = this.signonInfo_.currentSignonDate;
        if (Trace.traceOn_) {
            Trace.log(1, "Signon date: " + gregorianCalendar);
        }
        return gregorianCalendar == null ? null : (GregorianCalendar)gregorianCalendar.clone();
    }

    public SignonHandler getSignonHandler() {
        if (this.signonHandler_ != null) {
            return this.signonHandler_;
        }
        return AS400.getDefaultSignonHandler();
    }

    public SocketProperties getSocketProperties() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting socket properties.");
        }
        SocketProperties socketProperties = new SocketProperties();
        socketProperties.copyValues(this.socketProperties_);
        return socketProperties;
    }

    public String getSystemName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system name: " + this.systemName_ + ", is local:", this.systemNameLocal_);
        }
        return this.systemNameLocal_ ? "localhost" : this.systemName_;
    }

    public String getUserId() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user ID: " + this.userId_);
        }
        this.userId_ = AS400.resolveUserId(this.userId_, this.byteType_, this.mustUseSuppliedProfile_);
        return this.userId_;
    }

    public int getVersion() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting version level.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.version.getVersion();
        if (Trace.traceOn_) {
            Trace.log(1, "Version level:", n);
        }
        return n;
    }

    public int getVRM() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting VRM.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.version.getVersionReleaseModification();
        if (Trace.traceOn_) {
            byte[] byArray = new byte[4];
            BinaryConverter.intToByteArray(n, byArray, 0);
            Trace.log(1, "VRM:", byArray);
        }
        return n;
    }

    public void initializeConverter(int n) throws UnsupportedEncodingException {
        if (Trace.traceOn_) {
            Trace.log(1, "Initializing converter for CCSID:", n);
        }
        this.chooseImpl();
        try {
            this.signon(false);
            this.impl_.newConverter(n);
        }
        catch (Exception exception) {
            Trace.log(4, "Error initializing converter:", (Throwable)exception);
            throw new UnsupportedEncodingException();
        }
    }

    public boolean isConnected() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking for any service connection...");
        }
        if (this.isConnected(0) || this.isConnected(1) || this.isConnected(2) || this.isConnected(3) || this.isConnected(4) || this.isConnected(5) || this.isConnected(6) || this.isConnected(7)) {
            if (Trace.traceOn_) {
                Trace.log(1, "A service is connected.");
            }
            return true;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "No service is connected.");
        }
        return false;
    }

    public boolean isConnected(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking for service connection:", n);
        }
        if (n < 0 || n > 7) {
            Trace.log(2, "Value of parameter 'service' is not valid:", n);
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (this.impl_ == null) {
            return false;
        }
        this.chooseImpl();
        boolean bl = this.impl_.isConnected(n);
        if (Trace.traceOn_) {
            Trace.log(1, "Service connection:", bl);
        }
        return bl;
    }

    public boolean isGuiAvailable() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if GUI is available:", this.guiAvailable_);
        }
        return this.guiAvailable_;
    }

    public boolean isLocal() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if local:", this.systemNameLocal_);
        }
        return this.systemNameLocal_;
    }

    public boolean isMustUseSockets() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use sockets:", this.mustUseSockets_);
        }
        return this.mustUseSockets_;
    }

    public boolean isShowCheckboxes() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if checkboxes are shown:", this.showCheckboxes_);
        }
        return this.showCheckboxes_;
    }

    private static boolean isSystemNameLocal(String string) {
        if (string.equalsIgnoreCase("localhost")) {
            if (Trace.traceOn_) {
                Trace.log(1, "System name is localhost.");
            }
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Comparing local address " + inetAddress + " to " + inetAddressArray[i]);
                }
                if (!inetAddress.equals(inetAddressArray[i])) continue;
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.log(2, "Error retrieving host address information:", (Throwable)unknownHostException);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "System name is not local.");
        }
        return false;
    }

    public boolean isThreadUsed() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if thread is used:", this.threadUsed_);
        }
        return this.threadUsed_;
    }

    public boolean isUseDefaultUser() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if default user is used:", this.useDefaultUser_);
        }
        return this.useDefaultUser_;
    }

    public boolean isUsePasswordCache() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if password cache is used:", this.usePasswordCache_);
        }
        return this.usePasswordCache_;
    }

    static Object loadImpl(String string) {
        if (string.indexOf(46) == -1) {
            string = "com.ibm.as400.access." + string;
        }
        if (Trace.traceOn_ && alreadyCheckedForMultipleVersions_++ < 10) {
            Trace.log(1, "Checking for multiple Toolbox versions.");
            try {
                String string2 = "com/ibm/as400/access/AS400.class";
                String string3 = string.replace('.', '/') + ".class";
                ClassLoader classLoader = Class.forName(CLASSNAME).getClassLoader();
                ClassLoader classLoader2 = Class.forName(string).getClassLoader();
                if (classLoader != null && classLoader2 != null) {
                    URL uRL = classLoader.getResource(string2);
                    URL uRL2 = classLoader2.getResource(string3);
                    if (uRL != null && uRL2 != null) {
                        String string4;
                        String string5 = uRL.getPath();
                        String string6 = uRL2.getPath();
                        Trace.log(1, "Path of AS400 class: " + string5);
                        Trace.log(1, "Path of loaded impl class: " + string6);
                        String string7 = string5.length() <= string2.length() ? "" : string5.substring(0, string5.length() - string2.length() - 1);
                        String string8 = string4 = string6.length() <= string3.length() ? "" : string6.substring(0, string6.length() - string3.length() - 1);
                        if (!string7.equals(string4)) {
                            Trace.log(4, "Toolbox classes found in two different locations: " + string7 + " and " + string4);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Trace.log(1, throwable);
            }
        }
        try {
            return Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.log(2, "Unexpected ClassNotFoundException:", (Throwable)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Trace.log(2, "Unexpected IllegalAccessException:", (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Trace.log(2, "Unexpected InstantiationException:", (Throwable)instantiationException);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Load of implementation failed: " + string);
        }
        return null;
    }

    Object loadImpl(String string, String string2) {
        Object object;
        if (this.canUseNativeOptimizations()) {
            object = AS400.loadImpl(string);
            if (object != null) {
                return object;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Load of native implementation '" + string + "' failed, attempting to load remote implementation.");
            }
        }
        if ((object = AS400.loadImpl(string2)) != null) {
            return object;
        }
        Trace.log(1, "Load of remote implementation '" + string2 + "' failed.");
        throw new ExtendedIllegalStateException(string2, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object loadImpl2(String string, String string2) {
        Object object;
        if (this.proxyServer_.length() > 0) {
            object = this;
            synchronized (object) {
                if (this.proxyClientConnection_ == null) {
                    this.proxyClientConnection_ = new ProxyClientConnection(this.proxyServer_, this.useSSLConnection_);
                }
            }
            object = (ProxyImpl)AS400.loadImpl(string2);
            if (object != null) {
                object.construct((ProxyClientConnection)this.proxyClientConnection_);
                return object;
            }
        }
        if ((object = AS400.loadImpl(string)) != null) {
            return object;
        }
        Trace.log(1, "Load of remote implementation '" + string + "' failed.");
        throw new ExtendedIllegalStateException(string, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object loadImpl3(String string, String string2, String string3) {
        Object object;
        if (this.proxyServer_.length() > 0) {
            object = this;
            synchronized (object) {
                if (this.proxyClientConnection_ == null) {
                    this.proxyClientConnection_ = new ProxyClientConnection(this.proxyServer_, this.useSSLConnection_);
                }
            }
            object = (ProxyImpl)AS400.loadImpl(string3);
            if (object != null) {
                object.construct((ProxyClientConnection)this.proxyClientConnection_);
                return object;
            }
        }
        if (this.canUseNativeOptimizations()) {
            object = AS400.loadImpl(string);
            if (object != null) {
                return object;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Load of native implementation '" + string + "' failed, attempting to load remote implementation.");
            }
        }
        if ((object = AS400.loadImpl(string2)) != null) {
            return object;
        }
        Trace.log(1, "Load of remote implementation '" + string2 + "' failed.");
        throw new ExtendedIllegalStateException(string2, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptSignon() throws AS400SecurityException, IOException {
        if (this.signingOn_) {
            Trace.log(2, "AS400.promptSignon() called while already signing on.  SignonHandler may have called a prohibited method.");
            throw new ExtendedIllegalStateException(16);
        }
        try {
            this.signingOn_ = true;
            boolean bl = this.signonInfo_ != null;
            int n = 1;
            SignonHandler signonHandler = this.getSignonHandler();
            if (!(this.byteType_ != 0 || this.systemName_.length() != 0 && this.userId_.length() != 0 && this.bytes_ != null && signonHandler instanceof ToolboxSignonHandler)) {
                n = 2;
            }
            int n2 = 0;
            boolean bl2 = true;
            do {
                SignonEvent signonEvent;
                ++n2;
                try {
                    SignonEvent signonEvent2;
                    switch (n) {
                        case 1: {
                            if (Trace.traceOn_) {
                                Trace.log(1, "Validate security...");
                            }
                            this.sendSignonRequest();
                            break;
                        }
                        case 2: {
                            if (Trace.traceOn_) {
                                Trace.log(1, "Calling SignonHandler...");
                            }
                            if (!(bl2 = signonHandler.connectionInitiated(signonEvent2 = new SignonEvent(this, bl), this.bytes_ == null))) {
                                Trace.log(1, "User canceled.");
                                this.handlerCanceled_ = true;
                                throw new AS400SecurityException(25);
                            }
                            this.sendSignonRequest();
                            if (!this.isUsePasswordCache() || this.byteType_ != 0) break;
                            if (Trace.traceOn_) {
                                Trace.log(1, "Setting password cache entry from SignonHandler...");
                            }
                            AS400.setCacheEntry(this.systemName_, this.userId_, this.bytes_);
                            break;
                        }
                        default: {
                            Trace.log(2, "Invalid password prompt state:", n);
                            throw new InternalErrorException(8, n);
                        }
                    }
                    if (this.getDaysToExpiration() < expirationWarning && !(bl2 = signonHandler.passwordAboutToExpire(signonEvent2 = new SignonEvent(this, bl), this.getDaysToExpiration()))) {
                        this.handlerCanceled_ = true;
                        throw new AS400SecurityException(25);
                    }
                    n = 0;
                }
                catch (AS400SecurityException aS400SecurityException) {
                    if (this.handlerCanceled_) {
                        throw aS400SecurityException;
                    }
                    Trace.log(2, "Security exception in sign-on:", (Throwable)aS400SecurityException);
                    signonEvent = new SignonEvent(this, bl, aS400SecurityException);
                    switch (aS400SecurityException.getReturnCode()) {
                        case 7: {
                            bl2 = signonHandler.passwordExpired(signonEvent);
                            break;
                        }
                        case 22: {
                            bl2 = signonHandler.passwordMissing(signonEvent);
                            break;
                        }
                        case 8: 
                        case 23: {
                            bl2 = signonHandler.passwordIncorrect(signonEvent);
                            break;
                        }
                        case 10: 
                        case 19: 
                        case 20: {
                            bl2 = signonHandler.passwordLengthIncorrect(signonEvent);
                            break;
                        }
                        case 9: {
                            bl2 = signonHandler.userIdAboutToBeDisabled(signonEvent);
                            break;
                        }
                        case 32: {
                            bl2 = signonHandler.userIdUnknown(signonEvent);
                            break;
                        }
                        case 31: {
                            bl2 = signonHandler.userIdDisabled(signonEvent);
                            break;
                        }
                        default: {
                            signonHandler.exceptionOccurred(signonEvent);
                        }
                    }
                    if (!bl2) {
                        throw aS400SecurityException;
                    }
                    n = 1;
                }
                catch (UnknownHostException unknownHostException) {
                    signonEvent = new SignonEvent(this, bl);
                    bl2 = signonHandler.systemNameUnknown(signonEvent, unknownHostException);
                    if (!bl2) {
                        throw unknownHostException;
                    }
                    n = 1;
                }
            } while (n != 0 && n2 < 20);
            if (n != 0) {
                Trace.log(2, "Possible infinite loop while interacting with SignonHandler.");
                throw new AS400SecurityException(26);
            }
        }
        finally {
            this.signingOn_ = false;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "De-serializing AS400 object.");
        }
        objectInputStream.defaultReadObject();
        this.construct();
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(this.systemName_);
        this.proxyServer_ = AS400.resolveProxyServer("");
        this.ccsid_ = 0;
        this.propertiesFrozen_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing connection listener.");
        }
        if (connectionListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.connectionListeners_ != null) {
                this.connectionListeners_.removeElement(connectionListener);
                if (this.impl_ != null && this.connectionListeners_.isEmpty()) {
                    this.impl_.removeConnectionListener(this.dispatcher_);
                }
            }
        }
    }

    public static void removeDefaultUser(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing the default user, system name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        defaultUsers.remove(AS400.resolveSystem(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePasswordCacheEntry(String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing password cache entry, system name: " + string + " user ID: " + string2);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'userId' is null.");
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            Trace.log(2, "Length of 'userId' parameter is not valid: '" + string2 + "'");
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        string = AS400.resolveSystem(string);
        string2 = AS400.resolveUserId(string2.toUpperCase());
        Vector vector = systemList;
        synchronized (vector) {
            for (int i = systemList.size() - 1; i >= 0; --i) {
                Object[] objectArray = (Object[])systemList.elementAt(i);
                if (!string.equalsIgnoreCase((String)objectArray[0]) || !string2.equals(objectArray[1])) continue;
                systemList.removeElementAt(i);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public synchronized void resetAllServices() {
        if (Trace.traceOn_) {
            Trace.log(1, "Resetting all services.");
        }
        this.disconnectAllServices();
        this.signonInfo_ = null;
        this.propertiesFrozen_ = false;
        this.ccsid_ = 0;
    }

    private static byte[] resolve(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[9];
        System.arraycopy(byArray, 0, byArray2, 0, 9);
        byte[] byArray3 = new byte[7];
        System.arraycopy(byArray, 9, byArray3, 0, 7);
        byte[] byArray4 = new byte[byArray.length - 16];
        System.arraycopy(byArray, 16, byArray4, 0, byArray.length - 16);
        return AS400.decode(byArray2, byArray3, byArray4);
    }

    private static String resolveProxyServer(String string) {
        if (string.length() == 0 && (string = SystemProperties.getProperty("com.ibm.as400.access.AS400.proxyServer")) == null) {
            return "";
        }
        return string;
    }

    static String resolveSystem(String string) {
        if (onAS400) {
            if (string.length() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Resolving initial system name to localhost.");
                }
                return "localhost";
            }
            if (AS400.isSystemNameLocal(string)) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Resolving system name to localhost.");
                }
                return "localhost";
            }
        }
        return string;
    }

    static boolean resolveSystemNameLocal(String string) {
        return onAS400 && (string.length() == 0 || AS400.isSystemNameLocal(string));
    }

    static String resolveUserId(String string) {
        return AS400.resolveUserId(string, 0, false);
    }

    static boolean currentUserAvailable() {
        if (!currentUserTried) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.ibm.as400.access.CurrentUser");
            }
            catch (Throwable throwable) {
                if (Trace.traceOn_) {
                    Trace.log(1, "CurrentUser class is not available:", throwable);
                }
                currentUserAvailable = false;
            }
            currentUserTried = true;
        }
        return currentUserAvailable;
    }

    static String resolveUserId(String string, int n, boolean bl) {
        if (onAS400 && !bl && AS400.currentUserAvailable()) {
            boolean bl2 = false;
            if (string.length() == 0 && n == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Resolving initial user ID.");
                }
                bl2 = true;
            }
            if (string.equals("*CURRENT")) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Replacing *CURRENT as user ID.");
                }
                bl2 = true;
            }
            if (bl2) {
                String string2 = CurrentUser.getUserID(nativeVRM.getVersionReleaseModification());
                if (Trace.traceOn_) {
                    Trace.log(1, "Current user ID: " + string2);
                }
                if (string2 != null) {
                    return string2;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "Current user ID information not available, user ID: '" + string + "'");
                }
            }
        }
        if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] >= '0' && cArray[i] <= '9') continue;
                if (Trace.traceOn_) {
                    Trace.log(1, "User ID: '" + string + "'");
                }
                return string;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Prepending Q to numeric user ID.");
            }
            string = "Q" + string;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "User ID: '" + string + "'");
        }
        return string;
    }

    private void sendSignonRequest() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Signing-on without prompting...");
        }
        if (this.bytes_ == null && !AS400.userIdMatchesLocal(this.userId_, this.mustUseSuppliedProfile_)) {
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        byte[] byArray = new byte[9];
        rng.nextBytes(byArray);
        byte[] byArray2 = this.impl_.exchangeSeed(byArray);
        if (this.byteType_ == 1) {
            this.signonInfo_ = this.impl_.signon(this.systemName_, this.systemNameLocal_, this.userId_, this.bytes_, this.byteType_, this.gssName_, this.gssOption_);
            if (this.gssCredential_ != null) {
                ((AS400ImplRemote)this.impl_).setGSSCredential(this.gssCredential_);
            }
            this.bytes_ = null;
        } else {
            this.signonInfo_ = this.impl_.signon(this.systemName_, this.systemNameLocal_, this.userId_, AS400.encode(byArray, byArray2, AS400.resolve(this.bytes_)), this.byteType_, this.gssName_, this.gssOption_);
        }
        if (this.userId_.length() == 0) {
            this.userId_ = this.signonInfo_.userId;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Sign-on completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentityToken(byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting identity token.");
        }
        if (byArray == null) {
            Trace.log(2, "Parameter 'identityToken' is null.");
            throw new NullPointerException("identityToken");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.bytes_ = AS400.store(byArray);
            this.byteType_ = 3;
            this.signonInfo_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCacheEntry(String string, String string2, byte[] byArray) {
        Vector vector = systemList;
        synchronized (vector) {
            for (int i = systemList.size() - 1; i >= 0; --i) {
                Object[] objectArray = (Object[])systemList.elementAt(i);
                if (!string.equalsIgnoreCase((String)objectArray[0]) || !string2.equals(objectArray[1])) continue;
                if (Trace.traceOn_) {
                    Trace.log(1, "Adding password cache entry, removing previous entry.");
                }
                systemList.removeElementAt(i);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Adding password cache entry.");
            }
            systemList.addElement(new Object[]{string, string2, byArray});
        }
    }

    public void setCcsid(int n) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting CCSID:", n);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set CCSID after connection has been made.");
            throw new ExtendedIllegalStateException("ccsid", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.ccsid_ = n;
        } else {
            Integer n2 = new Integer(this.ccsid_);
            Integer n3 = new Integer(n);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("ccsid", n2, n3);
            }
            this.ccsid_ = n;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("ccsid", n2, n3);
            }
        }
    }

    public void setDDMRDB(String string) {
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set RDB name after connection has been made.");
            throw new ExtendedIllegalStateException("ddmRDB", 5);
        }
        if (string.length() > 18) {
            throw new ExtendedIllegalArgumentException("ddmRDB", 1);
        }
        if (this.isConnected(5)) {
            throw new ExtendedIllegalStateException("ddmRDB", 4);
        }
        this.ddmRDB_ = string == null ? null : string.toUpperCase();
    }

    public static void setDefaultSignonHandler(SignonHandler signonHandler) {
        if (Trace.traceOn_) {
            if (signonHandler == null) {
                Trace.log(1, "Setting the default sign-on handler to null.");
            } else if (defaultSignonHandler_ != null) {
                Trace.log(1, "Replacing default sign-on handler, formerly an instance of " + defaultSignonHandler_.getClass().getName());
            }
        }
        defaultSignonHandler_ = signonHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDefaultUser(String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting the default user, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'userId' is null.");
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            Trace.log(2, "Length of 'userId' parameter is not valid: '" + string2 + "'");
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        string = AS400.resolveSystem(string);
        string2 = AS400.resolveUserId(string2.toUpperCase());
        Hashtable hashtable = defaultUsers;
        synchronized (hashtable) {
            if (defaultUsers.get(string) == null) {
                defaultUsers.put(string, string2);
                return true;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(4, "Default user already set, set default user failed.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGSSCredential(Object object) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS credential: '" + object + "'");
        }
        if (object == null) {
            Trace.log(2, "Parameter 'gssCredential' is null.");
            throw new NullPointerException("gssCredential");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.gssCredential_ = object;
            this.gssName_ = "";
            this.bytes_ = null;
            this.byteType_ = 1;
        }
    }

    public void setGSSOption(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS option:", n);
        }
        if (n < 0 || n > 2) {
            Trace.log(2, "Parameter 'gssOption' is not valid.");
            throw new ExtendedIllegalArgumentException("gssOption (" + n + ")", 2);
        }
        this.gssOption_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGSSName(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS name: '" + string + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'gssName' is null.");
            throw new NullPointerException("gssName");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.gssName_ = string;
            this.gssCredential_ = null;
            this.bytes_ = null;
            this.byteType_ = 1;
        }
    }

    public void setGuiAvailable(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GUI available:", bl);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.guiAvailable_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.guiAvailable_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("guiAvailable", bl2, bl3);
            }
            this.guiAvailable_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("guiAvailable", bl2, bl3);
            }
        }
    }

    public void setLocale(Locale locale) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting locale: " + locale);
        }
        if (locale == null) {
            Trace.log(2, "Parameter 'locale' is null.");
            throw new NullPointerException("locale");
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set locale after connection has been made.");
            throw new ExtendedIllegalStateException("locale", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.locale_ = locale;
            this.nlv_ = ExecutionEnvironment.getNlv(this.locale_);
        } else {
            Locale locale2 = this.locale_;
            Locale locale3 = locale;
            this.locale_ = locale;
            this.nlv_ = ExecutionEnvironment.getNlv(this.locale_);
            this.propertyChangeListeners_.firePropertyChange("locale", locale2, locale3);
        }
    }

    public void setLocale(Locale locale, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting locale: " + locale + ", nlv: " + this.nlv_);
        }
        if (locale == null) {
            Trace.log(2, "Parameter 'locale' is null.");
            throw new NullPointerException("locale");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'nlv' is null.");
            throw new NullPointerException("nlv");
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set locale after connection has been made.");
            throw new ExtendedIllegalStateException("locale", 5);
        }
        this.locale_ = locale;
        this.nlv_ = string;
    }

    public void setMustUseSockets(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting must use sockets:", bl);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set must use sockets after connection has been made.");
            throw new ExtendedIllegalStateException("mustUseSockets", 5);
        }
        this.mustUseSockets_ = bl;
    }

    public boolean isMustUseNetSockets() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use net sockets:", this.mustUseNetSockets_);
        }
        return this.mustUseNetSockets_;
    }

    public void setMustUseNetSockets(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting must use net sockets:", bl);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set must use net sockets after connection has been made.");
            throw new ExtendedIllegalStateException("mustUseNetSockets", 5);
        }
        this.mustUseNetSockets_ = bl;
    }

    public boolean isMustUseSuppliedProfile() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use supplied profile:", this.mustUseSuppliedProfile_);
        }
        return this.mustUseSuppliedProfile_;
    }

    public void setMustUseSuppliedProfile(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting must use supplied profile:", bl);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set must use supplied profile after connection has been made.");
            throw new ExtendedIllegalStateException("mustUseSuppliedProfile", 5);
        }
        this.mustUseSuppliedProfile_ = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting password.");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'password' is null.");
            throw new NullPointerException("password");
        }
        if (string.length() > 128) {
            Trace.log(2, "Length of 'password' parameter is not valid: " + string.length());
            throw new ExtendedIllegalArgumentException("password.length {" + string.length() + ")", 1);
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.bytes_ = AS400.store(string);
            this.byteType_ = 0;
            this.signonInfo_ = null;
        }
    }

    public static void setPasswordExpirationWarningDays(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting the password expiration warning days:", n);
        }
        expirationWarning = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfileToken(ProfileTokenCredential profileTokenCredential) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting profile token.");
        }
        if (profileTokenCredential == null) {
            Trace.log(2, "Parameter 'profileToken' is null.");
            throw new NullPointerException("profileToken");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.bytes_ = AS400.store(profileTokenCredential.getToken());
            this.byteType_ = 2;
            this.signonInfo_ = null;
        }
    }

    public void setProxyServer(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting proxy server: " + string);
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set proxy server after connection has been made.");
            throw new ExtendedIllegalStateException("proxyServer", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.proxyServer_ = AS400.resolveProxyServer(string);
        } else {
            String string2 = this.proxyServer_;
            String string3 = AS400.resolveProxyServer(string);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("proxyServer", string2, string3);
            }
            this.proxyServer_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("proxyServer", string2, string3);
            }
        }
    }

    public void setServicePort(int n, int n2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting service port, service " + n + ", port " + n2);
        }
        if (n < 0 || n > 7) {
            Trace.log(2, "Value of parameter 'service' is not valid:", n);
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (n2 < -1) {
            Trace.log(2, "Value of parameter 'port' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("port (" + n2 + ")", 2);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot set service port before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.chooseImpl();
        this.impl_.setServicePort(this.systemNameLocal_ ? "localhost" : this.systemName_, n, n2);
    }

    public void setServicePortsToDefault() {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting service ports to default.");
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot set service port to default before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.chooseImpl();
        this.impl_.setServicePortsToDefault(this.systemNameLocal_ ? "localhost" : this.systemName_);
    }

    public void setShowCheckboxes(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting show checkboxes:", bl);
        }
        this.showCheckboxes_ = bl;
    }

    public void setSignonHandler(SignonHandler signonHandler) {
        if (Trace.traceOn_) {
            if (signonHandler == null) {
                Trace.log(1, "Setting the sign-on handler to null.");
            }
            if (this.signonHandler_ != null) {
                Trace.log(1, "Sign-on handler was formerly an instance of " + this.signonHandler_.getClass().getName());
            }
        }
        this.signonHandler_ = signonHandler;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting socket properties: " + socketProperties);
        }
        if (socketProperties == null) {
            Trace.log(2, "Parameter 'socketProperties' is null.");
            throw new NullPointerException("socketProperties");
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set socket properties after connection has been made.");
            throw new ExtendedIllegalStateException("socketProperties", 5);
        }
        this.socketProperties_.copyValues(socketProperties);
    }

    public void setSystemName(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'systemName' is null.");
            throw new NullPointerException("systemName");
        }
        if (string.equals(this.systemName_)) {
            return;
        }
        if (this.propertiesFrozen_ && (this.systemNameLocal_ || this.systemName_.length() != 0)) {
            Trace.log(2, "Cannot set system name after connection has been made.");
            throw new ExtendedIllegalStateException("systemName", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.systemName_ = string;
            this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        } else {
            String string2 = this.systemName_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("systemName", string2, string3);
            }
            this.systemName_ = string;
            this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("systemName", string2, string3);
            }
        }
    }

    public void setThreadUsed(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting thread used:", bl);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set thread used after connection has been made.");
            throw new ExtendedIllegalStateException("threadUsed", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.threadUsed_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.threadUsed_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("threadUsed", bl2, bl3);
            }
            this.threadUsed_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("threadUsed", bl2, bl3);
            }
        }
    }

    public void setUseDefaultUser(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting use default user:", bl);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.useDefaultUser_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.useDefaultUser_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("useDefaultUser", bl2, bl3);
            }
            this.useDefaultUser_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("useDefaultUser", bl2, bl3);
            }
        }
    }

    public void setUsePasswordCache(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting use password cache:", bl);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.usePasswordCache_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.usePasswordCache_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("usePasswordCache", bl2, bl3);
            }
            this.usePasswordCache_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("usePasswordCache", bl2, bl3);
            }
        }
    }

    public void setUserId(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user ID: '" + string + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'userId' is null.");
            throw new NullPointerException("userId");
        }
        if (string.equals(this.userId_)) {
            return;
        }
        if (string.length() > 10) {
            Trace.log(2, "Length of 'userId' parameter is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("userId (" + string + ")", 1);
        }
        if (this.signonInfo_ != null) {
            Trace.log(2, "Cannot set user ID after connection has been made.");
            throw new ExtendedIllegalStateException("userId", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.userId_ = string.toUpperCase();
        } else {
            String string2 = this.userId_;
            String string3 = string.toUpperCase();
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("userId", string2, string3);
            }
            this.userId_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("userId", string2, string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void signon(boolean bl) throws AS400SecurityException, IOException {
        if (this.signonInfo_ == null) {
            block12: {
                this.chooseImpl();
                this.userId_ = AS400.resolveUserId(this.userId_, this.byteType_, this.mustUseSuppliedProfile_);
                if (this.systemName_.length() != 0) {
                    Object object;
                    if (this.userId_.length() == 0 && this.useDefaultUser_ && (object = AS400.getDefaultUser(this.systemName_)) != null) {
                        this.userId_ = object;
                    }
                    if (this.userId_.length() != 0 && this.bytes_ == null && this.usePasswordCache_) {
                        object = systemList;
                        synchronized (object) {
                            for (int i = systemList.size() - 1; i >= 0; --i) {
                                Object[] objectArray = (Object[])systemList.elementAt(i);
                                if (!this.systemName_.equalsIgnoreCase((String)objectArray[0]) || !this.userId_.equals(objectArray[1])) continue;
                                this.bytes_ = (byte[])objectArray[2];
                            }
                        }
                    }
                }
                try {
                    if (this.systemName_.length() != 0 && this.proxyServer_.length() == 0 && this.bytes_ == null && (this.byteType_ == 1 || this.gssOption_ != 2)) {
                        this.bytes_ = this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, this.gssName_) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                        this.byteType_ = 1;
                    }
                }
                catch (Throwable throwable) {
                    Trace.log(2, "Error retrieving GSSToken:", throwable);
                    if (this.byteType_ != 1 && this.gssOption_ != 0) break block12;
                    throw new AS400SecurityException(62);
                }
            }
            this.promptSignon();
            if (!bl) {
                this.impl_.disconnect(7);
            }
        }
    }

    private static byte[] store(byte[] byArray) {
        byte[] byArray2 = new byte[9];
        rng.nextBytes(byArray2);
        byte[] byArray3 = new byte[7];
        rng.nextBytes(byArray3);
        byte[] byArray4 = AS400.encode(byArray2, byArray3, byArray);
        byte[] byArray5 = new byte[byArray4.length + 16];
        System.arraycopy(byArray2, 0, byArray5, 0, 9);
        System.arraycopy(byArray3, 0, byArray5, 9, 7);
        System.arraycopy(byArray4, 0, byArray5, 16, byArray4.length);
        return byArray5;
    }

    private static byte[] store(String string) {
        if (onAS400 && (string.equalsIgnoreCase("*CURRENT") || string.equals(""))) {
            return null;
        }
        byte[] byArray = new byte[9];
        rng.nextBytes(byArray);
        byte[] byArray2 = new byte[7];
        rng.nextBytes(byArray2);
        byte[] byArray3 = AS400.encode(byArray, byArray2, BinaryConverter.charArrayToByteArray(string.toCharArray()));
        byte[] byArray4 = new byte[byArray3.length + 16];
        System.arraycopy(byArray, 0, byArray4, 0, 9);
        System.arraycopy(byArray2, 0, byArray4, 9, 7);
        System.arraycopy(byArray3, 0, byArray4, 16, byArray3.length);
        return byArray4;
    }

    public String toString() {
        return "AS400 (system name: '" + this.systemName_ + "' user ID: '" + this.userId_ + "'):" + super.toString();
    }

    private static boolean userIdMatchesLocal(String string, boolean bl) {
        if (onAS400 && !bl && AS400.currentUserAvailable()) {
            String string2 = CurrentUser.getUserID(nativeVRM.getVersionReleaseModification());
            if (string2 == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Current user ID information not available.");
                }
                return false;
            }
            return string.equals(string2);
        }
        return false;
    }

    public boolean validateSignon() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Validating Signon.");
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot validate signon before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.userId_ = AS400.resolveUserId(this.userId_);
        if (this.userId_.length() == 0) {
            Trace.log(2, "Cannot validate signon before user ID is set.");
            throw new ExtendedIllegalStateException("userId", 4);
        }
        return this.validateSignon(this.userId_, this.bytes_);
    }

    public boolean validateSignon(String string) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Validating Signon, with password.");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'password' is null.");
            throw new NullPointerException("password");
        }
        if (string.length() > 128) {
            Trace.log(2, "Length of 'password' parameter is not valid: " + string.length());
            throw new ExtendedIllegalArgumentException("password.length {" + string.length() + ")", 1);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot validate signon before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.userId_ = AS400.resolveUserId(this.userId_);
        if (this.userId_.length() == 0) {
            Trace.log(2, "Cannot validate signon before user ID is set.");
            throw new ExtendedIllegalStateException("userId", 4);
        }
        return this.validateSignon(this.userId_, AS400.store(string));
    }

    public boolean validateSignon(String string, String string2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Validating signon, user ID: '" + string + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'userId' is null.");
            throw new NullPointerException("userId");
        }
        if (string.length() > 10) {
            Trace.log(2, "Length of 'userId' parameter is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("userId (" + string + ")", 1);
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'password' is null.");
            throw new NullPointerException("password");
        }
        if (string2.length() > 128) {
            Trace.log(2, "Length of 'password' parameter is not valid: " + string2.length());
            throw new ExtendedIllegalArgumentException("password.length {" + string2.length() + ")", 1);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot validate signon before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        return this.validateSignon(string.toUpperCase(), AS400.store(string2));
    }

    private boolean validateSignon(String string, byte[] byArray) throws AS400SecurityException, IOException {
        AS400 aS400 = new AS400(this.systemName_, string, byArray);
        aS400.proxyServer_ = this.proxyServer_;
        aS400.guiAvailable_ = false;
        aS400.usePasswordCache_ = false;
        aS400.useDefaultUser_ = false;
        aS400.useSSLConnection_ = this.useSSLConnection_;
        aS400.mustUseSockets_ = true;
        aS400.mustUseNetSockets_ = this.mustUseNetSockets_;
        aS400.mustUseSuppliedProfile_ = this.mustUseSuppliedProfile_;
        aS400.socketProperties_ = this.socketProperties_;
        aS400.signon(false);
        return true;
    }

    static {
        String string;
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        onAS400 = false;
        nativeVRM = null;
        defaultSignonHandlerClass_ = ToolboxSignonHandler.class;
        try {
            string = System.getProperty("os.name");
            if (Trace.traceOn_) {
                Trace.log(1, "Detected os.name: " + string);
            }
            if (string != null && string.equalsIgnoreCase("OS/400")) {
                char[] cArray;
                String string2 = System.getProperty("os.version");
                if (Trace.traceOn_) {
                    Trace.log(1, "Detected os.version: " + string2);
                }
                if (string2 != null && (cArray = string2.toCharArray()).length == 6) {
                    int n = ((cArray[1] & 0xF) << 16) + ((cArray[3] & 0xF) << 8) + (cArray[5] & 0xF);
                    nativeVRM = new ServerVersion(n);
                }
                onAS400 = true;
            }
        }
        catch (SecurityException securityException) {
            Trace.log(4, "Error retrieving os.name:", (Throwable)securityException);
        }
        string = SystemProperties.getProperty("com.ibm.as400.access.AS400.signonHandler");
        if (string != null) {
            try {
                defaultSignonHandlerClass_ = Class.forName(string);
            }
            catch (Exception exception) {
                Trace.log(4, "Error retrieving default sign-on handler (specified by property): ", (Throwable)exception);
                defaultSignonHandlerClass_ = ToolboxSignonHandler.class;
            }
        }
        systemList = new Vector();
        defaultUsers = new Hashtable();
        expirationWarning = 7;
        rng = new Random();
        alreadyCheckedForMultipleVersions_ = 0;
        nativeVersion = -1;
        currentUserAvailable = true;
        currentUserTried = false;
    }
}

