/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class AS400ToolboxInstaller {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private static final int INSTALL = 0;
    private static final int UNINSTALL = 1;
    private static final int COMPARE = 2;
    private static boolean isPrompt_ = false;
    private static Vector classpathAdditions_ = new Vector();
    private static Vector classpathRemovals_ = new Vector();
    private static Vector unexpandedFiles_ = new Vector();
    private static final int NOT_IN_CLASSPATH = 0;
    private static final int IN_CLASSPATH = 1;
    private static final int UNKNOWN_CLASSPATH = 2;
    private static final int NO_CHANGE = 0;
    private static final int SERVER_HAS_NEW_PTF = 1;
    private static final int SERVER_HAS_NEW_RELEASE = 2;
    private static byte[] data_ = new byte[2560];
    private static ResourceBundle resources_;
    private static boolean changeSlash_;

    private AS400ToolboxInstaller() {
    }

    private static String addTrailingSeparator(String string) {
        if (!(string.length() > 0 && string.substring(string.length() - 1).equals(File.separator) || string.length() <= 0)) {
            string = string + File.separator;
        }
        return string;
    }

    private static int classpathContains(String string) {
        try {
            String string2 = System.getProperty("path.separator");
            String string3 = string2 + System.getProperty("java.class.path") + string2;
            string3 = string3.toUpperCase();
            string = string.toUpperCase();
            if (string3.lastIndexOf(string2 + string + string2) != -1) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            return 2;
        }
    }

    private static int comparePackageFiles(String string, String string2) {
        int n = 0;
        boolean bl = true;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\n\r");
            String string3 = stringTokenizer.nextToken().toUpperCase();
            String string4 = stringTokenizer2.nextToken().toUpperCase();
            if (string3.charAt(0) == 'V' && string4.charAt(0) == 'V' && string3.charAt(2) == 'R' && string4.charAt(2) == 'R' && string3.charAt(4) == 'M' && string4.charAt(4) == 'M') {
                if (string3.charAt(1) > string4.charAt(1)) {
                    n = 2;
                    bl = false;
                } else if (string3.charAt(1) < string4.charAt(1)) {
                    bl = false;
                } else if (string3.charAt(3) > string4.charAt(3)) {
                    n = 2;
                    bl = false;
                } else if (string3.charAt(3) < string4.charAt(3)) {
                    bl = false;
                } else if (string3.charAt(5) > string4.charAt(5)) {
                    n = 2;
                    bl = false;
                } else if (string3.charAt(5) < string4.charAt(5)) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl && string.length() > string2.length()) {
            n = 1;
        }
        return n;
    }

    private static void copyFile(String string, URL uRL) throws IOException {
        Object object;
        InputStream inputStream = uRL.openStream();
        if (!(new File(string).getParent() == null || ((File)(object = new File(new File(string).getParent()))).exists() || ((File)object).mkdirs() || ((File)object).isDirectory())) {
            throw new IOException("CANNOT_CREATE_DIRECTORY");
        }
        object = new FileOutputStream(string);
        int n = inputStream.read(data_);
        while (n != -1) {
            ((FileOutputStream)object).write(data_, 0, n);
            n = inputStream.read(data_);
        }
        inputStream.close();
        ((FileOutputStream)object).close();
    }

    private static Vector getAllPackageNames(String string) throws IOException {
        String string2 = AS400ToolboxInstaller.readFile(new FileInputStream(string + "JT400.PKG"));
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    private static Vector getAllPackageNames(URL uRL) throws IOException {
        String string = AS400ToolboxInstaller.readFile(new URL(uRL.toExternalForm() + "JT400.PKG"));
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    public static Vector getClasspathAdditions() {
        return classpathAdditions_;
    }

    public static Vector getClasspathRemovals() {
        return classpathRemovals_;
    }

    private static ResourceBundle getMRIResource() {
        if (resources_ == null) {
            resources_ = ResourceBundle.getBundle("utilities.INMRI");
        }
        return resources_;
    }

    public static Vector getUnexpandedFiles() {
        return unexpandedFiles_;
    }

    public static boolean install(String string, String string2, URL uRL) throws IOException {
        String string3;
        String string4;
        String string5;
        Object object;
        String string6;
        StringBuffer stringBuffer;
        String string7;
        block33: {
            if (string == null) {
                throw new NullPointerException("packageName");
            }
            if (string2 == null) {
                throw new NullPointerException("targetPath");
            }
            if (uRL == null) {
                throw new NullPointerException("source");
            }
            if (string.equalsIgnoreCase("*ALL")) {
                Vector vector = AS400ToolboxInstaller.getAllPackageNames(uRL);
                boolean bl = false;
                Vector vector2 = new Vector();
                Vector vector3 = new Vector();
                Vector vector4 = new Vector();
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    bl = AS400ToolboxInstaller.install((String)vector.elementAt(i), string2, uRL) || bl;
                    for (n2 = 0; n2 < classpathRemovals_.size(); ++n2) {
                        if (vector3.contains(classpathRemovals_.elementAt(n2))) continue;
                        vector3.addElement(classpathRemovals_.elementAt(n2));
                    }
                    for (n2 = 0; n2 < classpathAdditions_.size(); ++n2) {
                        if (vector2.contains(classpathAdditions_.elementAt(n2))) continue;
                        vector2.addElement(classpathAdditions_.elementAt(n2));
                    }
                    for (n2 = 0; n2 < unexpandedFiles_.size(); ++n2) {
                        if (vector4.contains(unexpandedFiles_.elementAt(n2))) continue;
                        vector4.addElement(unexpandedFiles_.elementAt(n2));
                    }
                }
                classpathAdditions_ = vector2;
                classpathRemovals_ = vector3;
                unexpandedFiles_ = vector4;
                return bl;
            }
            classpathAdditions_.removeAllElements();
            classpathRemovals_.removeAllElements();
            unexpandedFiles_.removeAllElements();
            string2 = AS400ToolboxInstaller.addTrailingSeparator(string2);
            StringBuffer stringBuffer2 = new StringBuffer(uRL.toExternalForm());
            stringBuffer2.append(string);
            stringBuffer2.append(".LVL");
            string7 = AS400ToolboxInstaller.readFile(new URL(stringBuffer2.toString()));
            stringBuffer = new StringBuffer(string2);
            stringBuffer.append(string);
            stringBuffer.append(".LVL");
            string6 = "";
            try {
                string6 = AS400ToolboxInstaller.readFile(new FileInputStream(stringBuffer.toString()));
            }
            catch (Exception exception) {
                string6 = "";
                if (string2.length() <= 1 || ((File)(object = new File(string2.substring(0, string2.length() - 1)))).exists() && ((File)object).isDirectory() || ((File)object).mkdirs() || ((File)object).isDirectory()) break block33;
                throw new IOException("(" + ((File)object).toString() + ") " + AS400ToolboxInstaller.getMRIResource().getString("EXC_CANNOT_CREATE_DIRECTORY"));
            }
        }
        int n = AS400ToolboxInstaller.comparePackageFiles(string7, string6);
        if (n == 0) {
            return false;
        }
        object = new StringTokenizer(string7);
        StringTokenizer stringTokenizer = new StringTokenizer(string6);
        if (n == 1) {
            while (stringTokenizer.hasMoreTokens()) {
                ((StringTokenizer)object).nextToken();
                stringTokenizer.nextToken();
            }
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            StringBuffer stringBuffer3 = new StringBuffer(uRL.toExternalForm());
            stringBuffer3.append(((StringTokenizer)object).nextToken());
            stringBuffer3.append(".LST");
            String string8 = AS400ToolboxInstaller.readFile(new URL(stringBuffer3.toString()));
            StringTokenizer stringTokenizer2 = new StringTokenizer(string8, "\n\r");
            while (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
                string4 = string5.substring(0, 8).trim();
                if (!string4.equalsIgnoreCase(string)) continue;
                String string9 = string5.substring(9, 13);
                string3 = string5.length() > 19 ? string5.substring(19) : "";
                if (string9.equalsIgnoreCase("PADD") || string9.equalsIgnoreCase("PRMV")) {
                    if (string3.length() <= 0) continue;
                    hashtable2.put(string3, string5);
                    continue;
                }
                String string10 = (String)hashtable.get(string3);
                if (string10 != null) {
                    String string11 = string10.substring(9, 13);
                    if (string9.equalsIgnoreCase("RMV ")) {
                        hashtable.put(string3, string5);
                        continue;
                    }
                    if (string11.equalsIgnoreCase("ADD ")) continue;
                    if (string9.equalsIgnoreCase("ADD ")) {
                        StringBuffer stringBuffer4 = new StringBuffer(string5);
                        stringBuffer4.setCharAt(9, 'U');
                        stringBuffer4.setCharAt(10, 'P');
                        stringBuffer4.setCharAt(11, 'D');
                        stringBuffer4.setCharAt(12, ' ');
                        hashtable.put(string3, stringBuffer4.toString());
                        continue;
                    }
                    hashtable.put(string3, string5);
                    continue;
                }
                hashtable.put(string3, string5);
            }
        }
        AS400ToolboxInstaller.copyFile(string2.toString() + "JT400.PKG", new URL(uRL.toExternalForm() + "JT400.PKG"));
        AS400ToolboxInstaller.copyFile(string2.toString() + string + ".LST", new URL(uRL.toExternalForm() + string + ".LST"));
        Object object2 = hashtable.elements();
        while (object2.hasMoreElements()) {
            string5 = (String)object2.nextElement();
            String string12 = string3 = string5.substring(19);
            if (changeSlash_) {
                string3 = string3.replace('/', '\\');
            }
            if (string5.substring(9, 13).equalsIgnoreCase("RMV ")) {
                try {
                    File file = new File(string2.toString() + string3);
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string5.charAt(15) != 'Y') continue;
                string4 = string2.toString() + string3;
                if (AS400ToolboxInstaller.classpathContains(string4 = new File(string4).getAbsolutePath()) == 0) continue;
                classpathRemovals_.addElement(string4);
                continue;
            }
            if (!string5.substring(9, 13).equalsIgnoreCase("ADD ") && !string5.substring(9, 13).equalsIgnoreCase("UPD ") && !string5.substring(9, 13).equalsIgnoreCase("OADD")) continue;
            boolean bl = false;
            try {
                AS400ToolboxInstaller.copyFile(string2.toString() + string3, new URL(uRL.toExternalForm() + string12));
            }
            catch (IOException iOException) {
                if (string5.substring(9, 13).equalsIgnoreCase("OADD") || string3.length() > 11 && string3.substring(string3.length() - 11).equalsIgnoreCase(".properties")) {
                    bl = true;
                }
                throw iOException;
            }
            if (bl) continue;
            if (string5.charAt(14) == 'Y') {
                string4 = string2.toString() + string3;
                string4 = new File(string4).getAbsolutePath();
                unexpandedFiles_.addElement(string4);
            }
            if (!string5.substring(9, 13).equalsIgnoreCase("ADD ") && !string5.substring(9, 13).equalsIgnoreCase("OADD") || string5.charAt(15) != 'Y') continue;
            string4 = string2.toString() + string3;
            if (AS400ToolboxInstaller.classpathContains(string4 = new File(string4).getAbsolutePath()) == 1) continue;
            classpathAdditions_.addElement(string4);
        }
        object2 = hashtable2.elements();
        while (object2.hasMoreElements()) {
            string5 = (String)object2.nextElement();
            string3 = string5.length() > 19 ? string5.substring(19) : "";
            string3 = string5.substring(19).trim();
            if (changeSlash_) {
                string3 = string3.replace('/', '\\');
            }
            if (string3.length() > 0) {
                string4 = string2.toString() + string3;
                string4 = new File(string4).getAbsolutePath();
            } else {
                string4 = string2.length() > 1 ? string2.substring(0, string2.length() - 1) : "";
                string4 = new File(string4).getAbsolutePath();
            }
            if (string5.substring(9, 13).equalsIgnoreCase("PADD")) {
                if (AS400ToolboxInstaller.classpathContains(string4) == 1) continue;
                classpathAdditions_.addElement(string4);
                continue;
            }
            if (AS400ToolboxInstaller.classpathContains(string4) == 0) continue;
            classpathRemovals_.addElement(string4);
        }
        object2 = new FileOutputStream(stringBuffer.toString());
        boolean bl = false;
        byte[] byArray = string7.getBytes();
        ((FileOutputStream)object2).write(byArray, 0, byArray.length);
        ((FileOutputStream)object2).close();
        return true;
    }

    public static boolean isInstalled(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("packageName");
        }
        if (string2 == null) {
            throw new NullPointerException("targetPath");
        }
        string2 = AS400ToolboxInstaller.addTrailingSeparator(string2);
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(string);
        stringBuffer.append(".LVL");
        File file = new File(stringBuffer.toString());
        return file.exists();
    }

    public static boolean isUpdateNeeded(String string, String string2, URL uRL) throws IOException {
        if (string == null) {
            throw new NullPointerException("packageName");
        }
        if (string2 == null) {
            throw new NullPointerException("targetPath");
        }
        if (uRL == null) {
            throw new NullPointerException("source");
        }
        if (string.equalsIgnoreCase("*ALL")) {
            Vector vector = AS400ToolboxInstaller.getAllPackageNames(uRL);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                if (!AS400ToolboxInstaller.isUpdateNeeded((String)vector.elementAt(i), string2, uRL)) continue;
                return true;
            }
            return false;
        }
        string2 = AS400ToolboxInstaller.addTrailingSeparator(string2);
        StringBuffer stringBuffer = new StringBuffer(uRL.toExternalForm());
        stringBuffer.append(string);
        stringBuffer.append(".LVL");
        String string3 = AS400ToolboxInstaller.readFile(new URL(stringBuffer.toString()));
        StringBuffer stringBuffer2 = new StringBuffer(string2);
        stringBuffer2.append(string);
        stringBuffer2.append(".LVL");
        String string4 = "";
        try {
            string4 = AS400ToolboxInstaller.readFile(new FileInputStream(stringBuffer2.toString()));
        }
        catch (Exception exception) {
            string4 = "";
        }
        return AS400ToolboxInstaller.comparePackageFiles(string3, string4) != 0;
    }

    public static void main(String[] stringArray) {
        Vector vector = null;
        String string = null;
        String string2 = null;
        Integer n = null;
        String string3 = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Hashtable hashtable = AS400ToolboxInstaller.parseArgs(stringArray);
        if (hashtable != null) {
            vector = (Vector)hashtable.get("packages");
            string = (String)hashtable.get("target");
            n = (Integer)hashtable.get("isinstall");
            string2 = hashtable.containsKey("source") ? (String)hashtable.get("source") : null;
            string3 = (String)vector.firstElement();
            URL uRL = null;
            try {
                if (string2 != null) {
                    boolean bl = false;
                    if (string2.length() < 5) {
                        bl = true;
                    } else if (!string2.toLowerCase().startsWith("http") && !string2.toLowerCase().startsWith("file")) {
                        bl = true;
                    }
                    if (bl) {
                        string2 = "http://" + string2 + "/QIBM/ProdData/HTTP/Public/jt400/";
                    } else if (string2.toLowerCase().startsWith("file")) {
                        string2 = AS400ToolboxInstaller.addTrailingSeparator(string2);
                    }
                    uRL = new URL(string2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_NOT_VALID_URL") + " " + string2);
                AS400ToolboxInstaller.printUsage(System.out);
                System.exit(0);
            }
            if (n == 0) {
                Enumeration enumeration;
                Object object;
                try {
                    if (string3.equalsIgnoreCase("*all") && vector.size() == 1) {
                        String string4;
                        object = AS400ToolboxInstaller.getAllPackageNames(uRL);
                        if (!isPrompt_) {
                            AS400ToolboxInstaller.install(string3, string, uRL);
                            enumeration = ((Vector)object).elements();
                            while (enumeration.hasMoreElements()) {
                                string4 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_INSTALLED");
                                string4 = AS400ToolboxInstaller.substitute(string4, (String)enumeration.nextElement());
                                System.out.println(string4);
                            }
                        } else {
                            enumeration = ((Vector)object).elements();
                            while (enumeration.hasMoreElements()) {
                                String string5;
                                string4 = (String)enumeration.nextElement();
                                if (AS400ToolboxInstaller.isInstalled(string4, string)) {
                                    if (AS400ToolboxInstaller.isUpdateNeeded(string4, string, uRL)) {
                                        string5 = AS400ToolboxInstaller.getMRIResource().getString("PROMPT_IF_REPLACE_ONE");
                                        if (!AS400ToolboxInstaller.prompt(string5, string4)) continue;
                                        AS400ToolboxInstaller.install(string4, string, uRL);
                                        continue;
                                    }
                                    string5 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NOT_NEED_UPDATED");
                                    string5 = AS400ToolboxInstaller.substitute(string5, string4);
                                    System.out.println(string5);
                                    continue;
                                }
                                string5 = AS400ToolboxInstaller.getMRIResource().getString("PROMPT_IF_REPLACE_TWO");
                                if (!AS400ToolboxInstaller.prompt(string5, string4)) continue;
                                AS400ToolboxInstaller.install(string4, string, uRL);
                            }
                        }
                    } else {
                        object = vector.elements();
                        while (object.hasMoreElements()) {
                            int n2;
                            String string6;
                            enumeration = (String)object.nextElement();
                            if (!isPrompt_) {
                                AS400ToolboxInstaller.install(enumeration, string, uRL);
                                string6 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_INSTALLED");
                                string6 = AS400ToolboxInstaller.substitute(string6, enumeration);
                                System.out.println(string6);
                            } else if (AS400ToolboxInstaller.isInstalled(enumeration, string)) {
                                if (AS400ToolboxInstaller.isUpdateNeeded(enumeration, string, uRL)) {
                                    string6 = AS400ToolboxInstaller.getMRIResource().getString("PROMPT_IF_REPLACE_ONE");
                                    if (AS400ToolboxInstaller.prompt(string6, enumeration)) {
                                        AS400ToolboxInstaller.install(enumeration, string, uRL);
                                    }
                                } else {
                                    string6 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NOT_NEED_UPDATED");
                                    string6 = AS400ToolboxInstaller.substitute(string6, enumeration);
                                    System.out.println(string6);
                                }
                            } else {
                                string6 = AS400ToolboxInstaller.getMRIResource().getString("PROMPT_IF_REPLACE_TWO");
                                if (AS400ToolboxInstaller.prompt(string6, enumeration)) {
                                    AS400ToolboxInstaller.install(enumeration, string, uRL);
                                }
                            }
                            if (vector3 == null) {
                                vector3 = new Vector();
                            }
                            for (n2 = 0; n2 < classpathAdditions_.size(); ++n2) {
                                if (vector3.contains(classpathAdditions_.elementAt(n2))) continue;
                                vector3.addElement(classpathAdditions_.elementAt(n2));
                            }
                            if (vector4 == null) {
                                vector4 = new Vector();
                            }
                            for (n2 = 0; n2 < classpathRemovals_.size(); ++n2) {
                                if (vector4.contains(classpathRemovals_.elementAt(n2))) continue;
                                vector4.addElement(classpathRemovals_.elementAt(n2));
                            }
                            if (vector2 == null) {
                                vector2 = new Vector();
                            }
                            for (n2 = 0; n2 < unexpandedFiles_.size(); ++n2) {
                                if (vector2.contains(unexpandedFiles_.elementAt(n2))) continue;
                                vector2.addElement(unexpandedFiles_.elementAt(n2));
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    System.out.println(iOException.toString());
                }
                if (vector2 == null) {
                    vector2 = AS400ToolboxInstaller.getUnexpandedFiles();
                }
                if (!vector2.isEmpty()) {
                    object = "";
                    enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (String)object + "    " + (String)enumeration.nextElement() + "\n";
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("RESULT_UNEXPANDED_FILES").trim() + "\n " + (String)object);
                }
                if (vector3 == null) {
                    vector3 = AS400ToolboxInstaller.getClasspathAdditions();
                }
                if (!vector3.isEmpty()) {
                    object = "";
                    enumeration = vector3.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (String)object + "    " + (String)enumeration.nextElement() + "\n";
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("RESULT_ADD_CLASSPATHS") + "\n" + (String)object);
                }
                if (vector4 == null) {
                    vector4 = AS400ToolboxInstaller.getClasspathRemovals();
                }
                if (!vector4.isEmpty()) {
                    object = "";
                    enumeration = vector4.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (String)object + "    " + (String)enumeration.nextElement() + "\n";
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("RESULT_REMOVE_CLASSPATHS").trim() + "\n" + (String)object);
                }
            } else if (n == 1) {
                Enumeration<String> enumeration;
                Object object;
                block69: {
                    try {
                        Object object2;
                        if (string3.equalsIgnoreCase("*all") && vector.size() == 1) {
                            Object object3;
                            String string7;
                            object = null;
                            enumeration = new Vector();
                            try {
                                object = AS400ToolboxInstaller.getAllPackageNames(AS400ToolboxInstaller.addTrailingSeparator(string));
                                object2 = ((Vector)object).elements();
                                while (object2.hasMoreElements()) {
                                    string7 = (String)object2.nextElement();
                                    object3 = new File(AS400ToolboxInstaller.addTrailingSeparator(string) + string7 + ".LVL");
                                    if (!((File)object3).exists()) continue;
                                    ((Vector)((Object)enumeration)).addElement(string7);
                                }
                                object = enumeration;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("EXC_NO_PACKAGES_INSTALLED"));
                                System.exit(0);
                            }
                            AS400ToolboxInstaller.unInstall((String)vector.firstElement(), string);
                            object2 = ((Vector)object).elements();
                            while (object2.hasMoreElements()) {
                                string7 = (String)object2.nextElement();
                                object3 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_UNINSTALLED");
                                object3 = AS400ToolboxInstaller.substitute((String)object3, string7);
                                System.out.println((String)object3);
                            }
                            break block69;
                        }
                        object = vector.elements();
                        while (object.hasMoreElements()) {
                            enumeration = (String)object.nextElement();
                            AS400ToolboxInstaller.unInstall(enumeration, string);
                            if (vector4 == null) {
                                vector4 = new Vector();
                            }
                            for (int i = 0; i < classpathRemovals_.size(); ++i) {
                                if (vector4.contains(classpathRemovals_.elementAt(i))) continue;
                                vector4.addElement(classpathRemovals_.elementAt(i));
                            }
                            object2 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_UNINSTALLED");
                            object2 = AS400ToolboxInstaller.substitute(object2, enumeration);
                            System.out.println((String)object2);
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException.toString());
                    }
                }
                if (vector4 == null) {
                    vector4 = AS400ToolboxInstaller.getClasspathRemovals();
                }
                if (!vector4.isEmpty()) {
                    object = "";
                    enumeration = vector4.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (String)object + "    " + (String)enumeration.nextElement() + "\n";
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("RESULT_REMOVE_CLASSPATHS").trim() + "\n" + object);
                }
            } else {
                try {
                    if (string3.equalsIgnoreCase("*all") && vector.size() == 1) {
                        Vector vector5 = AS400ToolboxInstaller.getAllPackageNames(uRL);
                        Enumeration enumeration = vector5.elements();
                        while (enumeration.hasMoreElements()) {
                            String string8;
                            String string9 = (String)enumeration.nextElement();
                            if (AS400ToolboxInstaller.isUpdateNeeded(string9, string, uRL)) {
                                string8 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NEEDS_UPDATED");
                                string8 = AS400ToolboxInstaller.substitute(string8, string9);
                                System.out.println(string8);
                                continue;
                            }
                            string8 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NOT_NEED_UPDATED");
                            string8 = AS400ToolboxInstaller.substitute(string8, string9);
                            System.out.println(string8);
                        }
                    } else {
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            String string10;
                            String string11 = (String)enumeration.nextElement();
                            if (AS400ToolboxInstaller.isUpdateNeeded(string11, string, uRL)) {
                                string10 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NEEDS_UPDATED");
                                string10 = AS400ToolboxInstaller.substitute(string10, string11);
                                System.out.println(string10);
                                continue;
                            }
                            string10 = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NOT_NEED_UPDATED");
                            string10 = AS400ToolboxInstaller.substitute(string10, string11);
                            System.out.println(string10);
                        }
                    }
                }
                catch (IOException iOException) {
                    System.out.println(iOException.toString());
                }
            }
        }
        System.exit(0);
    }

    private static void printUsage(PrintStream printStream) {
        String string = "  ";
        String string2 = AS400ToolboxInstaller.getMRIResource().getString("HELP02");
        string2 = string2.trim();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string2.length() + 1; ++i) {
            stringBuffer.append(" ");
        }
        String string3 = stringBuffer.toString();
        printStream.println("");
        printStream.println(AS400ToolboxInstaller.getMRIResource().getString("HELP01"));
        printStream.println(string + string2 + " " + AS400ToolboxInstaller.getMRIResource().getString("HELP03"));
        printStream.println(string + string3 + AS400ToolboxInstaller.getMRIResource().getString("HELP04"));
        printStream.println(string + string3 + AS400ToolboxInstaller.getMRIResource().getString("HELP05"));
        printStream.println(string + string3 + AS400ToolboxInstaller.getMRIResource().getString("HELP06"));
        printStream.println(string + string3 + AS400ToolboxInstaller.getMRIResource().getString("HELP07"));
        printStream.println(string + string3 + AS400ToolboxInstaller.getMRIResource().getString("HELP08"));
        printStream.println(string + string3 + AS400ToolboxInstaller.getMRIResource().getString("HELP09"));
        printStream.println(string + string3 + AS400ToolboxInstaller.getMRIResource().getString("HELP10"));
        printStream.println(string + AS400ToolboxInstaller.getMRIResource().getString("HELP11"));
        printStream.println(string + string + AS400ToolboxInstaller.getMRIResource().getString("HELP12"));
        printStream.println(string + AS400ToolboxInstaller.getMRIResource().getString("HELP13"));
        printStream.println(string + string + AS400ToolboxInstaller.getMRIResource().getString("HELP14"));
        printStream.println(string + AS400ToolboxInstaller.getMRIResource().getString("HELP15"));
        printStream.println(string + string + AS400ToolboxInstaller.getMRIResource().getString("HELP16"));
        printStream.println("");
        printStream.println(string + AS400ToolboxInstaller.getMRIResource().getString("HELP17"));
        printStream.println(string + AS400ToolboxInstaller.getMRIResource().getString("HELP18"));
        printStream.println(string + AS400ToolboxInstaller.getMRIResource().getString("HELP19"));
        printStream.println(AS400ToolboxInstaller.getMRIResource().getString("HELP20"));
        printStream.println(string + AS400ToolboxInstaller.getMRIResource().getString("HELP21"));
    }

    private static Hashtable parseArgs(String[] stringArray) {
        boolean bl = true;
        String string = ",";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        AS400ToolboxInstaller.getMRIResource();
        if (stringArray.length == 0) {
            AS400ToolboxInstaller.printUsage(System.out);
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '-') {
                if (stringArray[i].equalsIgnoreCase("-p") || stringArray[i].equalsIgnoreCase("-package")) {
                    if (hashtable.containsKey("packages")) {
                        System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + stringArray[i]);
                        bl = false;
                        continue;
                    }
                    Vector<String> vector = new Vector<String>();
                    if (i < stringArray.length - 1 && stringArray[i + 1].charAt(0) != '-') {
                        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i + 1], string);
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            vector.addElement(string2);
                        }
                        hashtable.put("packages", vector);
                        continue;
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION_VALUE").trim() + " " + stringArray[i]);
                    bl = false;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-s") || stringArray[i].equalsIgnoreCase("-source")) {
                    if (hashtable.containsKey("source")) {
                        System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + stringArray[i]);
                        bl = false;
                        continue;
                    }
                    if (i < stringArray.length - 1 && stringArray[i + 1].charAt(0) != '-') {
                        hashtable.put("source", stringArray[i + 1]);
                        continue;
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION_VALUE").trim() + " " + stringArray[i]);
                    bl = false;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-t") || stringArray[i].equalsIgnoreCase("-target")) {
                    if (hashtable.containsKey("target")) {
                        System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + stringArray[i]);
                        bl = false;
                        continue;
                    }
                    if (i < stringArray.length - 1 && stringArray[i + 1].charAt(0) != '-') {
                        hashtable.put("target", stringArray[i + 1]);
                        continue;
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION_VALUE").trim() + " " + stringArray[i]);
                    bl = false;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-i") || stringArray[i].equalsIgnoreCase("-install")) {
                    if (hashtable.containsKey("isinstall")) {
                        if ((Integer)hashtable.get("isinstall") == 0) {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + stringArray[i]);
                        } else {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_OPTION_NOT_COMPATIBLE").trim() + " " + stringArray[i]);
                        }
                        bl = false;
                        continue;
                    }
                    hashtable.put("isinstall", new Integer(0));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-u") || stringArray[i].equalsIgnoreCase("-uninstall")) {
                    if (hashtable.containsKey("isinstall")) {
                        if ((Integer)hashtable.get("isinstall") == 1) {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + stringArray[i]);
                        } else {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_OPTION_NOT_COMPATIBLE").trim() + " " + stringArray[i]);
                        }
                        bl = false;
                        continue;
                    }
                    hashtable.put("isinstall", new Integer(1));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-c") || stringArray[i].equalsIgnoreCase("-compare")) {
                    if (hashtable.containsKey("isinstall")) {
                        if ((Integer)hashtable.get("isinstall") == 2) {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + stringArray[i]);
                        } else {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_OPTION_NOT_COMPATIBLE").trim() + " " + stringArray[i]);
                        }
                        bl = false;
                        continue;
                    }
                    hashtable.put("isinstall", new Integer(2));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-pr") || stringArray[i].equalsIgnoreCase("-prompt")) {
                    if (isPrompt_) {
                        System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + stringArray[i]);
                        bl = false;
                        continue;
                    }
                    isPrompt_ = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-?") || stringArray[i].equalsIgnoreCase("-help") || stringArray[i].equalsIgnoreCase("-h")) {
                    hashtable = null;
                    AS400ToolboxInstaller.printUsage(System.out);
                    return hashtable;
                }
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_UNEXPECTED_OPTION").trim() + " " + stringArray[i]);
                bl = false;
                continue;
            }
            if (i == 0) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_INVALID_ARGUMENT") + " " + stringArray[i]);
                bl = false;
                continue;
            }
            if (stringArray[i - 1].equalsIgnoreCase("-package") || stringArray[i - 1].equalsIgnoreCase("-p") || stringArray[i - 1].equalsIgnoreCase("-source") || stringArray[i - 1].equalsIgnoreCase("-s") || stringArray[i - 1].equalsIgnoreCase("-target") || stringArray[i - 1].equalsIgnoreCase("-t")) continue;
            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_INVALID_ARGUMENT") + " " + stringArray[i]);
            bl = false;
        }
        if (!bl) {
            AS400ToolboxInstaller.printUsage(System.out);
            hashtable = null;
            return null;
        }
        if (!hashtable.containsKey("isinstall")) {
            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_NO_I_U_C"));
            bl = false;
        } else if ((Integer)hashtable.get("isinstall") == 0 || (Integer)hashtable.get("isinstall") == 2) {
            if (!hashtable.containsKey("source")) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION").trim() + " " + "-s");
                bl = false;
            }
            if (!hashtable.containsKey("target")) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION").trim() + " " + "-t");
                bl = false;
            }
            if (!hashtable.containsKey("packages")) {
                Vector<String> vector = new Vector<String>();
                vector.addElement("*ALL");
                hashtable.put("packages", vector);
            }
        } else {
            if (hashtable.containsKey("source")) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("WARNING_SOURCE_URL_NOT_USED"));
            }
            if (!hashtable.containsKey("target")) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION").trim() + " " + "-t");
                bl = false;
            }
            if (!hashtable.containsKey("packages")) {
                Vector<String> vector = new Vector<String>();
                vector.addElement("*ALL");
                hashtable.put("packages", vector);
            }
        }
        if (!bl) {
            AS400ToolboxInstaller.printUsage(System.out);
            hashtable = null;
        }
        return hashtable;
    }

    private static boolean prompt(String string, String string2) {
        boolean bl;
        block3: {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            bl = false;
            String string3 = AS400ToolboxInstaller.substitute(string, string2);
            try {
                String string4;
                do {
                    System.out.print(string3);
                    string4 = bufferedReader.readLine();
                    if (!string4.equalsIgnoreCase("y") && !string4.equals("1")) continue;
                    bl = true;
                    break block3;
                } while (!string4.equalsIgnoreCase("n") && !string4.equals("0"));
                bl = false;
            }
            catch (Exception exception) {
                System.out.println("\n" + AS400ToolboxInstaller.getMRIResource().getString("EXC_INSTALLATION_ABORTED"));
            }
        }
        return bl;
    }

    static String substitute(String string, String string2) {
        String string3 = string;
        String string4 = "&0";
        int n = string3.indexOf(string4);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3.substring(0, n));
            stringBuffer.append(string2);
            stringBuffer.append(string3.substring(n + string4.length()));
            string3 = stringBuffer.toString();
        }
        return string3;
    }

    private static String readFile(FileInputStream fileInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = fileInputStream.read(data_);
        while (n != -1) {
            stringBuffer.append(new String(data_, 0, n));
            n = fileInputStream.read(data_);
        }
        fileInputStream.close();
        return stringBuffer.toString();
    }

    private static String readFile(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        String string = "";
        int n = inputStream.read(data_);
        while (n != -1) {
            string = string + new String(data_, 0, n);
            n = inputStream.read(data_);
        }
        inputStream.close();
        return string;
    }

    public static Vector unInstall(String string, String string2) throws IOException {
        String string3;
        if (string == null) {
            throw new NullPointerException("packageName");
        }
        if (string2 == null) {
            throw new NullPointerException("targetPath");
        }
        string2 = AS400ToolboxInstaller.addTrailingSeparator(string2);
        if (string.equalsIgnoreCase("*ALL")) {
            Vector vector;
            try {
                vector = AS400ToolboxInstaller.getAllPackageNames(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException(AS400ToolboxInstaller.getMRIResource().getString("EXC_NO_PACKAGES_INSTALLED"));
            }
            boolean bl = false;
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                try {
                    vector3 = AS400ToolboxInstaller.unInstall((String)vector.elementAt(i), string2);
                    bl = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (n2 = 0; n2 < vector3.size(); ++n2) {
                    vector2.addElement(vector3.elementAt(n2));
                }
                for (n2 = 0; n2 < classpathRemovals_.size(); ++n2) {
                    if (vector4.contains(classpathRemovals_.elementAt(n2))) continue;
                    vector4.addElement(classpathRemovals_.elementAt(n2));
                }
            }
            if (!bl) {
                throw new IOException(AS400ToolboxInstaller.getMRIResource().getString("EXC_NO_PACKAGES_INSTALLED"));
            }
            classpathRemovals_ = vector4;
            File file = new File(string2 + "JT400.PKG");
            if (file.exists() && !file.delete()) {
                vector2.addElement(file.getAbsolutePath());
            }
            if (string2.length() > 1) {
                file = new File(string2.substring(0, string2.length() - 1));
                file.delete();
            }
            return vector2;
        }
        classpathAdditions_.removeAllElements();
        classpathRemovals_.removeAllElements();
        unexpandedFiles_.removeAllElements();
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(string);
        stringBuffer.append(".LST");
        String string4 = "";
        try {
            string4 = AS400ToolboxInstaller.readFile(new FileInputStream(stringBuffer.toString()));
        }
        catch (IOException iOException) {
            throw new IOException("(" + string + ") " + AS400ToolboxInstaller.getMRIResource().getString("EXC_PACKAGE_NOT_INSTALLED"));
        }
        File file = new File(string2 + string + ".LVL");
        if (file.exists() && !file.delete()) {
            vector.addElement(file.getAbsolutePath());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n\r");
        Vector<String> vector5 = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (changeSlash_) {
                string5 = string5.replace('/', '\\');
            }
            if ((file = new File(string2 + string5)).exists() && !file.delete()) {
                vector.addElement(file.getAbsolutePath());
            }
            String string6 = string5.substring(string5.lastIndexOf(46) + 1).toUpperCase();
            string3 = new File(string2 + string5).getAbsolutePath();
            if ((string6.equalsIgnoreCase("JAR") || string6.equalsIgnoreCase("ZIP")) && AS400ToolboxInstaller.classpathContains(string3) != 0 && !classpathRemovals_.contains(string3)) {
                classpathRemovals_.addElement(string3);
            }
            if ((string3 = file.getParent()) == null || vector5.contains(string3)) continue;
            vector5.addElement(string3);
        }
        if (string2.length() > 1) {
            string3 = string2.substring(0, string2.length() - 1);
            if (AS400ToolboxInstaller.classpathContains(string3 = new File(string3).getAbsolutePath()) != 0 && !classpathRemovals_.contains(string3)) {
                classpathRemovals_.addElement(string3);
            }
        }
        if (vector.size() == 0 && !(file = new File(stringBuffer.toString())).delete()) {
            vector.addElement(file.getAbsolutePath());
        }
        int n = vector5.size();
        string3 = string2.length() > 1 ? string2.substring(0, string2.length() - 1) : "";
        block10: for (int i = 0; i < n; ++i) {
            String string7 = (String)vector5.elementAt(i);
            file = new File(string7);
            while (!file.toString().equalsIgnoreCase(string3)) {
                file.delete();
                if (AS400ToolboxInstaller.classpathContains(string7) != 0 && !classpathRemovals_.contains(string7)) {
                    classpathRemovals_.addElement(string7);
                }
                if (file.getParent() == null) continue block10;
                file = new File(file.getParent());
            }
        }
        if (string2.length() > 1) {
            file = new File(string2.substring(0, string2.length() - 1));
            file.delete();
        }
        return vector;
    }

    static {
        changeSlash_ = !File.separator.equals("/");
    }
}

