/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

class SQLMetaDataTableModel
extends AbstractTableModel
implements Cloneable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static int NUM_COLUMNS_ = 6;
    public static int FIELD_NAME_ = 0;
    public static int FIELD_TYPE_ = 1;
    public static int FIELD_LENGTH_ = 2;
    public static int FIELD_DECIMALS_ = 3;
    public static int FIELD_NULLS_ = 4;
    public static int FIELD_DESC_ = 5;
    private transient Connection connection_ = null;
    private String[] tables_ = null;
    private transient String[][] data_ = new String[0][NUM_COLUMNS_];
    private transient int[] types_ = new int[0];
    private transient int numRows_ = 0;
    private transient boolean error_;
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);

    public SQLMetaDataTableModel(Connection connection, String[] stringArray) {
        this.connection_ = connection;
        this.tables_ = stringArray;
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.addWorkingListener(workingListener);
    }

    public synchronized Object clone() {
        SQLMetaDataTableModel sQLMetaDataTableModel = new SQLMetaDataTableModel(this.connection_, this.tables_);
        sQLMetaDataTableModel.data_ = new String[this.data_.length][NUM_COLUMNS_];
        System.arraycopy(this.data_, 0, sQLMetaDataTableModel.data_, 0, this.data_.length);
        sQLMetaDataTableModel.numRows_ = this.numRows_;
        sQLMetaDataTableModel.types_ = new int[this.types_.length];
        System.arraycopy(this.types_, 0, sQLMetaDataTableModel.types_, 0, this.types_.length);
        return sQLMetaDataTableModel;
    }

    public int getColumnCount() {
        return NUM_COLUMNS_;
    }

    public synchronized int getRowCount() {
        return this.numRows_;
    }

    synchronized int getSQLType(int n) {
        return this.types_[n];
    }

    public String[] getTables() {
        return this.tables_;
    }

    public synchronized Object getValueAt(int n, int n2) {
        this.error_ = false;
        return this.data_[n][n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Serializable serializable = this;
        synchronized (serializable) {
            this.data_ = new String[0][0];
            this.types_ = new int[0];
            this.numRows_ = 0;
        }
        serializable = new TableModelEvent(this, -1);
        this.fireTableChanged((TableModelEvent)serializable);
        Trace.log(1, "Starting load, changed number of rows to:", this.numRows_);
        if (this.tables_ == null || this.tables_.length == 0 || this.connection_ == null) {
            return;
        }
        SQLMetaDataTableModel sQLMetaDataTableModel = this;
        synchronized (sQLMetaDataTableModel) {
            this.workingListeners_.fireStartWorking();
            int n = 50;
            ResultSet resultSet = null;
            try {
                DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                this.data_ = new String[n][NUM_COLUMNS_];
                this.types_ = new int[n];
                for (int i = 0; i < this.tables_.length; ++i) {
                    String[][] stringArray;
                    int n2 = this.tables_[i].indexOf(".");
                    if (n2 == -1) {
                        stringArray = new Exception(ResourceLoader.getText("EXC_TABLE_SPEC_NOT_VALID"));
                        this.errorListeners_.fireError((Exception)stringArray);
                        continue;
                    }
                    String string = this.tables_[i].substring(0, n2);
                    String string2 = this.tables_[i].substring(n2 + 1);
                    String string3 = this.tables_.length > 1 ? string2 + "." : "";
                    resultSet = databaseMetaData.getColumns(null, string, string2, null);
                    while (resultSet.next()) {
                        int n3 = this.numRows_;
                        if (n3 >= this.data_.length) {
                            stringArray = new String[this.data_.length + n][NUM_COLUMNS_];
                            System.arraycopy(this.data_, 0, stringArray, 0, this.data_.length);
                            this.data_ = stringArray;
                            int[] nArray = new int[this.types_.length + n];
                            System.arraycopy(this.types_, 0, nArray, 0, this.types_.length);
                            this.types_ = nArray;
                        }
                        this.types_[n3] = resultSet.getInt(5);
                        this.data_[n3][SQLMetaDataTableModel.FIELD_NAME_] = string3 + resultSet.getString(4).trim();
                        this.data_[n3][SQLMetaDataTableModel.FIELD_TYPE_] = resultSet.getString(6);
                        switch (this.types_[n3]) {
                            case 5: {
                                this.data_[n3][SQLMetaDataTableModel.FIELD_LENGTH_] = "5";
                                break;
                            }
                            case 4: {
                                this.data_[n3][SQLMetaDataTableModel.FIELD_LENGTH_] = "10";
                                break;
                            }
                            case 92: {
                                this.data_[n3][SQLMetaDataTableModel.FIELD_LENGTH_] = "8";
                                break;
                            }
                            case 93: {
                                if (resultSet.getInt(7) != 10) break;
                                this.data_[n3][SQLMetaDataTableModel.FIELD_LENGTH_] = "23";
                                break;
                            }
                            case 91: {
                                this.data_[n3][SQLMetaDataTableModel.FIELD_LENGTH_] = "10";
                                break;
                            }
                            case 8: {
                                if (resultSet.getInt(7) == 4) {
                                    this.data_[n3][SQLMetaDataTableModel.FIELD_LENGTH_] = "7";
                                    break;
                                }
                                this.data_[n3][SQLMetaDataTableModel.FIELD_LENGTH_] = "15";
                                break;
                            }
                            default: {
                                this.data_[n3][SQLMetaDataTableModel.FIELD_LENGTH_] = resultSet.getString(7);
                            }
                        }
                        this.data_[n3][SQLMetaDataTableModel.FIELD_DECIMALS_] = resultSet.getString(9);
                        this.data_[n3][SQLMetaDataTableModel.FIELD_NULLS_] = resultSet.getString(18);
                        this.data_[n3][SQLMetaDataTableModel.FIELD_DESC_] = resultSet.getString(12);
                        ++this.numRows_;
                    }
                }
            }
            catch (SQLException sQLException) {
                this.data_ = new String[0][0];
                this.types_ = new int[0];
                this.numRows_ = 0;
                this.errorListeners_.fireError(sQLException);
                this.error_ = true;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        this.errorListeners_.fireError(sQLException);
                    }
                }
            }
        }
        serializable = new TableModelEvent(this, -1);
        this.fireTableChanged((TableModelEvent)serializable);
        Trace.log(1, "Did load, changed number of rows to:", this.numRows_);
        this.workingListeners_.fireStopWorking();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.connection_ = null;
        this.data_ = new String[0][NUM_COLUMNS_];
        this.types_ = new int[0];
        this.numRows_ = 0;
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(int n) {
        SQLMetaDataTableModel sQLMetaDataTableModel = this;
        synchronized (sQLMetaDataTableModel) {
            Trace.log(1, "Removing row ", n);
            String[][] stringArray = new String[this.data_.length - 1][NUM_COLUMNS_];
            int[] nArray = new int[this.types_.length - 1];
            if (n == 0) {
                System.arraycopy(this.data_, 1, stringArray, 0, stringArray.length);
                System.arraycopy(this.types_, 1, nArray, 0, nArray.length);
            } else if (n == this.data_.length - 1) {
                System.arraycopy(this.data_, 0, stringArray, 0, stringArray.length);
                System.arraycopy(this.types_, 0, nArray, 0, nArray.length);
            } else {
                System.arraycopy(this.data_, 0, stringArray, 0, n);
                System.arraycopy(this.data_, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.types_, 0, nArray, 0, n);
                System.arraycopy(this.types_, n + 1, nArray, n, nArray.length - n);
            }
            this.data_ = stringArray;
            --this.numRows_;
        }
        this.fireTableRowsDeleted(n, n);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.removeWorkingListener(workingListener);
    }

    public void setTables(String[] stringArray) {
        this.tables_ = stringArray;
    }

    public void setConnection(Connection connection) {
        this.connection_ = connection;
    }
}

